/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.roundedImageView;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.Checkable;
import androidx.annotation.CallSuper;
import androidx.annotation.ColorInt;
import androidx.appcompat.widget.AppCompatImageView;
import com.getstream.sdk.chat.R;
import java.util.Locale;

public class CircularImageView
extends AppCompatImageView
implements Checkable {
    private static final String TAG = CircularImageView.class.getSimpleName();
    private static final int DEFAULT_BORDER_COLOR = -1;
    private static final int DEFAULT_BACKGROUND_COLOR = -2236963;
    private static final int DEFAULT_TEXT_COLOR = -16777216;
    private static final int DEFAULT_CHECKED_BACKGROUND_COLOR = -4473925;
    private static final int DEFAULT_CHECK_STROKE_COLOR = -1;
    private static final int DEFAULT_SHADOW_COLOR = -10066330;
    private static final float DEFAULT_CHECK_STROKE_WIDTH_IN_DP = 3.0f;
    private static final float DEFAULT_SHADOW_RADIUS = 0.0f;
    private Paint mBitmapPaint;
    private Paint mBorderPaint;
    private Paint mBackgroundPaint;
    private Paint mCheckMarkPaint;
    private Paint mCheckedBackgroundPaint;
    private Paint mTextPaint;
    private int mWidth;
    private int mHeight;
    private int mRadius;
    private float mShadowRadius;
    private int mLongStrokeHeight;
    private Path mPath = new Path();
    private int mBorderWidth;
    private int mBorderColor;
    private int mBackgroundColor;
    private int mCheckedBackgroundColor;
    private int mShadowColor;
    private int mTextColor;
    private int mAlpha = 255;
    private String mText;
    private int mTextSize;
    private boolean mChecked;
    private boolean mAllowCheckStateAnimation = true;
    private boolean mAllowCheckStateShadow = false;

    public CircularImageView(Context context) {
        this(context, null, 0);
    }

    public CircularImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CircularImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray t = null;
        if (null != attrs) {
            t = context.getTheme().obtainStyledAttributes(attrs, R.styleable.Stream_CircularImageView, 0, 0);
        }
        this.mBorderColor = -1;
        this.mBackgroundColor = -2236963;
        this.mCheckedBackgroundColor = -4473925;
        this.mShadowRadius = 0.0f;
        this.mShadowColor = -10066330;
        if (null != t) {
            this.mBorderWidth = t.getDimensionPixelSize(R.styleable.Stream_CircularImageView_stream_ci_borderWidth, 0);
            this.mBorderColor = t.getColor(R.styleable.Stream_CircularImageView_stream_ci_borderColor, -1);
            this.mBackgroundColor = t.getColor(R.styleable.Stream_CircularImageView_stream_ci_placeholderBackgroundColor, -2236963);
            this.mText = t.getString(R.styleable.Stream_CircularImageView_stream_ci_placeholderText);
            this.mTextColor = t.getColor(R.styleable.Stream_CircularImageView_stream_ci_placeholderTextColor, -16777216);
            this.mTextSize = t.getDimensionPixelSize(R.styleable.Stream_CircularImageView_stream_ci_placeholderTextSize, 0);
            this.mChecked = t.getBoolean(R.styleable.Stream_CircularImageView_stream_ci_checked, false);
            this.mCheckedBackgroundColor = t.getColor(R.styleable.Stream_CircularImageView_stream_ci_checkedStateBackgroundColor, -4473925);
            this.mShadowRadius = Math.max(t.getFloat(R.styleable.Stream_CircularImageView_stream_ci_shadowRadius, 0.0f), 0.0f);
            this.mShadowColor = t.getColor(R.styleable.Stream_CircularImageView_stream_ci_shadowColor, -10066330);
            t.recycle();
        }
        this.mBitmapPaint = new Paint(1);
        this.setBorderInternal(this.mBorderWidth, this.mBorderColor, false);
        this.setPlaceholderTextInternal(this.mText, this.mTextColor, this.mTextSize, 0, false);
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setAntiAlias(true);
        this.mBackgroundPaint.setColor(this.mBackgroundColor);
        this.mBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mCheckedBackgroundPaint = new Paint(1);
        this.mCheckedBackgroundPaint.setColor(this.mCheckedBackgroundColor);
        this.mCheckedBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mCheckMarkPaint = this.getCheckMarkPaint();
        this.setShadowInternal(this.mShadowRadius, this.mShadowColor, false);
    }

    private void setBorderInternal(int rawSize, @ColorInt int color2, boolean invalidate) {
        this.mBorderWidth = rawSize;
        this.mBorderColor = color2;
        if (null == this.mBorderPaint) {
            this.mBorderPaint = new Paint();
            this.mBorderPaint.setAntiAlias(true);
            this.mBorderPaint.setStyle(Paint.Style.FILL);
        }
        if (null != this.mBorderPaint) {
            this.mBorderPaint.setColor(this.mBorderColor);
            this.mBorderPaint.setStrokeWidth((float)Math.max(0, this.mBorderWidth));
        }
        if (invalidate) {
            this.invalidate();
        }
    }

    private void setShadowInternal(float radius, @ColorInt int color2, boolean invalidate) {
        this.mShadowRadius = radius;
        this.mShadowColor = color2;
        this.mBorderPaint.clearShadowLayer();
        this.mCheckedBackgroundPaint.clearShadowLayer();
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, this.mBorderPaint);
            this.setLayerType(1, this.mCheckedBackgroundPaint);
        }
        this.mBorderPaint.setShadowLayer(this.mShadowRadius, 0.0f, this.mShadowRadius / 2.0f, this.mShadowColor);
        if (this.mAllowCheckStateShadow) {
            this.mCheckedBackgroundPaint.setShadowLayer(this.mShadowRadius, 0.0f, this.mShadowRadius / 2.0f, this.mShadowColor);
        }
        if (invalidate) {
            this.invalidate();
        }
    }

    private void setPlaceholderTextInternal(String text, @ColorInt int color2, int textSize, int style, boolean invalidate) {
        this.mText = this.formatPlaceholderText(text);
        this.mTextColor = color2;
        this.mTextSize = textSize;
        if (null == this.mTextPaint && textSize > 0 && !TextUtils.isEmpty((CharSequence)this.mText)) {
            this.mTextPaint = this.getTextPaint();
        }
        if (null != this.mTextPaint) {
            this.mTextPaint.setColor(color2);
            this.mTextPaint.setTextSize((float)textSize);
            if (0 != style) {
                Typeface typeface_ = Typeface.create((Typeface)Typeface.DEFAULT, (int)style);
                this.mTextPaint.setTypeface(typeface_);
            }
        }
        if (invalidate) {
            this.invalidate();
        }
    }

    private void setPlaceholderTextInternal(String text, @ColorInt int color2, int textSize, Typeface typeface, boolean invalidate) {
        this.mText = this.formatPlaceholderText(text);
        this.mTextColor = color2;
        this.mTextSize = textSize;
        if (null == this.mTextPaint && textSize > 0 && !TextUtils.isEmpty((CharSequence)this.mText)) {
            this.mTextPaint = this.getTextPaint();
        }
        if (null != this.mTextPaint) {
            this.mTextPaint.setColor(color2);
            this.mTextPaint.setTextSize((float)textSize);
            if (null != typeface) {
                this.mTextPaint.setTypeface(typeface);
            }
        }
        if (invalidate) {
            this.invalidate();
        }
    }

    @CallSuper
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mWidth = w;
        this.mHeight = h;
        this.mLongStrokeHeight = this.mRadius = Math.min(w, h) / 2;
        if (null != this.mBitmapPaint) {
            this.updateBitmapShader();
        }
    }

    @CallSuper
    public void invalidate() {
        super.invalidate();
        if (null != this.mBitmapPaint) {
            this.updateBitmapShader();
        }
    }

    public void setColorFilter(ColorFilter cf) {
        if (null != this.mBitmapPaint) {
            this.mBitmapPaint.setColorFilter(cf);
        }
    }

    public int getImageAlpha() {
        return this.mAlpha;
    }

    public void setImageAlpha(int alpha) {
        if (this.mAlpha != (alpha &= 0xFF)) {
            this.mAlpha = alpha;
            if (null != this.mBitmapPaint) {
                this.mBitmapPaint.setAlpha(alpha);
            }
            if (null != this.mBorderPaint) {
                this.mBorderPaint.setAlpha(alpha);
            }
            if (null != this.mBackgroundPaint) {
                this.mBackgroundPaint.setAlpha(alpha);
            }
            if (null != this.mCheckMarkPaint) {
                this.mCheckMarkPaint.setAlpha(alpha);
            }
            if (null != this.mCheckedBackgroundPaint) {
                this.mCheckedBackgroundPaint.setAlpha(alpha);
            }
            if (null != this.mTextPaint) {
                this.mTextPaint.setAlpha(alpha);
            }
            this.invalidate();
        }
    }

    public final void setBorderWidth(int unit, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Border width cannot be less than zero.");
        }
        int scaledSize = (int)TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.setBorderInternal(scaledSize, this.mBorderColor, true);
    }

    public final void setBorderColor(@ColorInt int color2) {
        if (color2 != this.mBorderColor) {
            this.setBorderInternal(this.mBorderWidth, color2, true);
        }
    }

    public final void setCheckedStateBackgroundColor(@ColorInt int backgroundColor) {
        if (backgroundColor != this.mCheckedBackgroundColor && null != this.mCheckedBackgroundPaint) {
            this.mCheckedBackgroundPaint.setColor(backgroundColor);
            if (this.isChecked()) {
                this.invalidate();
            }
        }
        this.mCheckedBackgroundColor = backgroundColor;
    }

    public final void setPlaceholder(String text) {
        if (!text.equalsIgnoreCase(this.mText)) {
            this.setPlaceholderTextInternal(text, this.mTextColor, this.mTextSize, 0, true);
        }
    }

    public final void setPlaceholderTextSize(int unit, int size, int style) {
        if (size < 0) {
            throw new IllegalArgumentException("Text size cannot be less than zero.");
        }
        int scaledSize = (int)TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.setPlaceholderTextInternal(this.mText, this.mTextColor, scaledSize, style, true);
    }

    public final void setPlaceholderTextSize(int unit, int size, Typeface typeface) {
        if (size < 0) {
            throw new IllegalArgumentException("Text size cannot be less than zero.");
        }
        int scaledSize = (int)TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.setPlaceholderTextInternal(this.mText, this.mTextColor, scaledSize, typeface, true);
    }

    public final void setPlaceholder(String text, @ColorInt int backgroundColor, @ColorInt int textColor) {
        boolean invalidate = false;
        if (backgroundColor != this.mBackgroundColor) {
            this.mBackgroundColor = backgroundColor;
            if (null != this.mBackgroundPaint) {
                this.mBackgroundPaint.setColor(backgroundColor);
                invalidate = true;
            }
        }
        if (text == null || this.mText == null || !text.equalsIgnoreCase(this.mText) || backgroundColor != this.mBackgroundColor || textColor != this.mTextColor) {
            this.setPlaceholderTextInternal(text, textColor, this.mTextSize, 0, false);
            invalidate = true;
        }
        if (invalidate) {
            this.invalidate();
        }
    }

    public final void allowCheckStateAnimation(boolean allowAnimation) {
        this.mAllowCheckStateAnimation = allowAnimation;
    }

    public void setShadowRadius(float radius) {
        if (radius < 0.0f) {
            throw new IllegalArgumentException("Shadow radius cannot be less than zero.");
        }
        if (radius != this.mShadowRadius) {
            this.setShadowInternal(radius, this.mShadowColor, true);
        }
    }

    public void setShadowColor(@ColorInt int color2) {
        if (color2 != this.mShadowColor) {
            this.setShadowInternal(this.mShadowRadius, color2, true);
        }
    }

    public void allowCheckStateShadow(boolean allow) {
        if (allow != this.mAllowCheckStateShadow) {
            this.mAllowCheckStateShadow = allow;
            this.setShadowInternal(this.mShadowRadius, this.mShadowColor, true);
        }
    }

    protected String formatPlaceholderText(String text) {
        int length;
        String formattedText = null != text ? text.trim() : null;
        int n = length = null != formattedText ? formattedText.length() : 0;
        if (length > 0) {
            return formattedText.substring(0, Math.min(2, length)).toUpperCase(Locale.getDefault());
        }
        return null;
    }

    protected boolean shouldDrawBorder() {
        return true;
    }

    protected Paint getTextPaint() {
        Paint textPaint = new Paint(1);
        textPaint.setStyle(Paint.Style.FILL);
        textPaint.setTypeface(Typeface.DEFAULT);
        textPaint.setTextAlign(Paint.Align.CENTER);
        return textPaint;
    }

    protected Paint getCheckMarkPaint() {
        Paint paint = new Paint(1);
        paint.setColor(-1);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth((float)this.getCheckMarkStrokeWidthInPixels());
        return paint;
    }

    protected int getCheckMarkStrokeWidthInPixels() {
        return (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    protected void onDraw(Canvas canvas) {
        int x = this.mWidth / 2;
        int y = this.mHeight / 2;
        if (this.mChecked) {
            this.drawCheckedState(canvas, this.mWidth, this.mHeight);
        } else {
            int borderWidth;
            boolean drawBorder = this.shouldDrawBorder();
            int n = borderWidth = drawBorder ? this.mBorderWidth : 0;
            if (null != this.mBorderPaint) {
                canvas.drawCircle((float)x, (float)y, (float)this.mRadius - (this.mShadowRadius * 1.5f + 1.0f), this.mBorderPaint);
            }
            int offset = borderWidth > 0 ? borderWidth : 0;
            offset = (int)((float)offset + this.mShadowRadius * 1.5f);
            if (null != this.getDrawable()) {
                canvas.drawCircle((float)x, (float)y, (float)(this.mRadius - offset), this.mBitmapPaint);
            } else {
                canvas.drawCircle((float)x, (float)y, (float)(this.mRadius - offset), this.mBackgroundPaint);
                if (null != this.mTextPaint && !TextUtils.isEmpty((CharSequence)this.mText)) {
                    int ty = (int)(((float)this.mHeight - (this.mTextPaint.ascent() + this.mTextPaint.descent())) * 0.5f);
                    canvas.drawText(this.mText, (float)x, (float)ty, this.mTextPaint);
                }
            }
        }
    }

    protected void drawCheckedState(Canvas canvas, int w, int h) {
        int x = w / 2;
        int y = h / 2;
        canvas.drawCircle((float)x, (float)y, (float)this.mRadius - this.mShadowRadius * 1.5f, this.mCheckedBackgroundPaint);
        canvas.save();
        int shortStrokeHeight = (int)((float)this.mLongStrokeHeight * 0.4f);
        int halfH = (int)((float)this.mLongStrokeHeight * 0.5f);
        int offset = (int)((float)shortStrokeHeight * 0.3f);
        int sx = x + offset;
        int sy = y - offset;
        this.mPath.reset();
        this.mPath.moveTo((float)sx, (float)(sy - halfH));
        this.mPath.lineTo((float)sx, (float)(sy + halfH));
        this.mPath.moveTo((float)sx + (float)this.getCheckMarkStrokeWidthInPixels() * 0.5f, (float)(sy + halfH));
        this.mPath.lineTo((float)(sx - shortStrokeHeight), (float)(sy + halfH));
        canvas.rotate(45.0f, (float)x, (float)y);
        canvas.drawPath(this.mPath, this.mCheckMarkPaint);
        canvas.restore();
    }

    private void updateBitmapShader() {
        Drawable drawable2 = this.getDrawable();
        Bitmap bitmap = null;
        if (null != drawable2 && drawable2 instanceof BitmapDrawable) {
            bitmap = ((BitmapDrawable)drawable2).getBitmap();
        }
        if (null == bitmap) {
            this.mBitmapPaint.setShader(null);
            return;
        }
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        float x = 0.0f;
        float y = 0.0f;
        int diameter = this.mRadius * 2;
        int borderWidth = this.shouldDrawBorder() ? this.mBorderWidth : 0;
        int offset = borderWidth > 0 ? borderWidth * 2 : 0;
        offset = (int)((float)offset + this.mShadowRadius * 1.5f);
        float scale = (float)(diameter - offset) / (float)Math.min(bitmapHeight, bitmapWidth);
        x = ((float)this.mWidth - (float)bitmapWidth * scale) * 0.5f;
        y = ((float)this.mHeight - (float)bitmapHeight * scale) * 0.5f;
        Matrix matrix = new Matrix();
        matrix.setScale(scale, scale);
        matrix.postTranslate((float)Math.round(x), (float)Math.round(y));
        BitmapShader shader = new BitmapShader(bitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        shader.setLocalMatrix(matrix);
        this.mBitmapPaint.setShader((Shader)shader);
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void setChecked(final boolean checked) {
        if (this.mChecked == checked) {
            return;
        }
        if (this.mAllowCheckStateAnimation) {
            int duration = 150;
            DecelerateInterpolator interpolator = new DecelerateInterpolator();
            ObjectAnimator animation = ObjectAnimator.ofFloat((Object)((Object)this), (String)"scaleX", (float[])new float[]{1.0f, 0.0f});
            animation.setDuration(150L);
            animation.setInterpolator((TimeInterpolator)interpolator);
            animation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter((Interpolator)interpolator){
                final /* synthetic */ Interpolator val$interpolator;
                {
                    this.val$interpolator = interpolator;
                }

                public void onAnimationEnd(Animator animation) {
                    CircularImageView.this.mChecked = checked;
                    CircularImageView.this.invalidate();
                    ObjectAnimator reverse = ObjectAnimator.ofFloat((Object)((Object)CircularImageView.this), (String)"scaleX", (float[])new float[]{0.0f, 1.0f});
                    reverse.setDuration(150L);
                    reverse.setInterpolator((TimeInterpolator)this.val$interpolator);
                    reverse.start();
                }
            });
            animation.start();
        } else {
            this.mChecked = checked;
            this.invalidate();
        }
    }

    public void toggle() {
        this.setChecked(!this.mChecked);
    }
}

