/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.attachment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.AttachmentListItem;
import com.getstream.sdk.chat.adapter.FileAttachmentSelectedAdapter;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.viewholder.attachment.BaseAttachmentViewHolder;
import com.getstream.sdk.chat.databinding.StreamItemAttachMediaBinding;
import com.getstream.sdk.chat.databinding.StreamItemAttachmentBinding;
import com.getstream.sdk.chat.images.ViewExtensionsKt;
import com.getstream.sdk.chat.model.AttachmentMetaData;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.view.MessageListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020\u0018H\u0002J\b\u0010!\u001a\u00020\u0018H\u0002J\b\u0010\"\u001a\u00020\u0018H\u0002J\b\u0010#\u001a\u00020\u0018H\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/attachment/AttachmentViewHolder;", "Lcom/getstream/sdk/chat/adapter/viewholder/attachment/BaseAttachmentViewHolder;", "parent", "Landroid/view/ViewGroup;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "bubbleHelper", "Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;", "messageItem", "Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;", "clickListener", "Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;", "longClickListener", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;", "longClickListenerView", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListenerView;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemAttachmentBinding;", "(Landroid/view/ViewGroup;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListenerView;Lcom/getstream/sdk/chat/databinding/StreamItemAttachmentBinding;)V", "attachment", "Lio/getstream/chat/android/client/models/Attachment;", "mediaBinding", "Lcom/getstream/sdk/chat/databinding/StreamItemAttachMediaBinding;", "applyStyle", "", "bind", "attachmentListItem", "Lcom/getstream/sdk/chat/adapter/AttachmentListItem;", "configAttachViewBackground", "view", "Landroid/view/View;", "configAttachment", "configClickListeners", "configFileAttach", "configImageThumbBackground", "configMediaAttach", "stream-chat-android_release"})
public final class AttachmentViewHolder
extends BaseAttachmentViewHolder {
    @NotNull
    private final MessageListViewStyle style;
    @NotNull
    private final MessageListView.BubbleHelper bubbleHelper;
    @NotNull
    private final MessageListItem.MessageItem messageItem;
    @NotNull
    private final MessageListView.AttachmentClickListener clickListener;
    @Nullable
    private final MessageListView.MessageLongClickListener longClickListener;
    @Nullable
    private final MessageListView.MessageLongClickListenerView longClickListenerView;
    @NotNull
    private final StreamItemAttachmentBinding binding;
    @NotNull
    private final StreamItemAttachMediaBinding mediaBinding;
    private Attachment attachment;

    public AttachmentViewHolder(@NotNull ViewGroup parent, @NotNull MessageListViewStyle style, @NotNull MessageListView.BubbleHelper bubbleHelper, @NotNull MessageListItem.MessageItem messageItem, @NotNull MessageListView.AttachmentClickListener clickListener2, @Nullable MessageListView.MessageLongClickListener longClickListener, @Nullable MessageListView.MessageLongClickListenerView longClickListenerView, @NotNull StreamItemAttachmentBinding binding) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)bubbleHelper, (String)"bubbleHelper");
        Intrinsics.checkNotNullParameter((Object)messageItem, (String)"messageItem");
        Intrinsics.checkNotNullParameter((Object)clickListener2, (String)"clickListener");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Object object = binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.root");
        super((View)object);
        this.style = style;
        this.bubbleHelper = bubbleHelper;
        this.messageItem = messageItem;
        this.clickListener = clickListener2;
        this.longClickListener = longClickListener;
        this.longClickListenerView = longClickListenerView;
        this.binding = binding;
        object = this.binding.clAttachmentMedia;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.clAttachmentMedia");
        this.mediaBinding = object;
        this.mediaBinding.tvMediaDes.setMaxLines(this.style.getAttachmentPreviewMaxLines());
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ AttachmentViewHolder(ViewGroup viewGroup, MessageListViewStyle messageListViewStyle, MessageListView.BubbleHelper bubbleHelper, MessageListItem.MessageItem messageItem, MessageListView.AttachmentClickListener attachmentClickListener2, MessageListView.MessageLongClickListener messageLongClickListener2, MessageListView.MessageLongClickListenerView messageLongClickListenerView, StreamItemAttachmentBinding streamItemAttachmentBinding, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            messageLongClickListener2 = null;
        }
        if ((n & 0x40) != 0) {
            messageLongClickListenerView = null;
        }
        if ((n & 0x80) != 0) {
            void $this$inflater$iv;
            ViewGroup viewGroup2 = viewGroup;
            boolean $i$f$getInflater = false;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)$this$inflater$iv.getContext());
            Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"from(context)");
            StreamItemAttachmentBinding streamItemAttachmentBinding2 = StreamItemAttachmentBinding.inflate(layoutInflater, viewGroup, false);
            Intrinsics.checkNotNullExpressionValue((Object)streamItemAttachmentBinding2, (String)"class AttachmentViewHolder(\n    parent: ViewGroup,\n    private val style: MessageListViewStyle,\n    private val bubbleHelper: BubbleHelper,\n    private val messageItem: MessageItem,\n    private val clickListener: AttachmentClickListener,\n    private val longClickListener: MessageLongClickListener? = null,\n    private val longClickListenerView: MessageListView.MessageLongClickListenerView? = null,\n    private val binding: StreamItemAttachmentBinding =\n        StreamItemAttachmentBinding.inflate(parent.inflater, parent, false),\n) : BaseAttachmentViewHolder(binding.root) {\n\n    private val mediaBinding: StreamItemAttachMediaBinding = binding.clAttachmentMedia\n\n    private lateinit var attachment: Attachment\n\n    init {\n        mediaBinding.tvMediaDes.maxLines = style.attachmentPreviewMaxLines\n    }\n\n    override fun bind(attachmentListItem: AttachmentListItem) {\n        attachment = attachmentListItem.attachment\n\n        applyStyle()\n        configAttachment()\n    }\n\n    private fun applyStyle() {\n        if (messageItem.isMine) {\n            style.attachmentTitleTextMine.apply(mediaBinding.tvMediaTitle)\n            style.attachmentDescriptionTextMine.apply(mediaBinding.tvMediaDes)\n        } else {\n            style.attachmentTitleTextTheirs.apply(mediaBinding.tvMediaTitle)\n            style.attachmentDescriptionTextTheirs.apply(mediaBinding.tvMediaDes)\n        }\n    }\n\n    private fun configAttachment() {\n        var hasFile = false\n        var hasMedia = false\n        for (attachment in messageItem.message.attachments) {\n            if (attachment.type != null) {\n                if (attachment.type == ModelType.attach_file) {\n                    hasFile = true\n                } else {\n                    hasMedia = true\n                }\n            }\n        }\n\n        if (hasMedia) {\n            mediaBinding.root.isVisible = true\n            configMediaAttach()\n        } else {\n            mediaBinding.root.isVisible = false\n        }\n\n        if (hasFile) {\n            binding.lvAttachmentFile.isVisible = true\n            configFileAttach()\n        } else {\n            binding.lvAttachmentFile.isVisible = false\n        }\n\n        if (!hasMedia && !hasFile) {\n            mediaBinding.ivMediaThumb.isVisible = false\n\n            if (!attachment.title.isNullOrEmpty()) {\n                mediaBinding.root.isVisible = true\n                mediaBinding.tvMediaTitle.isVisible = true\n                mediaBinding.tvMediaTitle.text = attachment.title\n            } else {\n                mediaBinding.tvMediaTitle.isVisible = false\n            }\n\n            if (!attachment.text.isNullOrEmpty()) {\n                mediaBinding.root.isVisible = true\n                mediaBinding.tvMediaDes.isVisible = true\n                mediaBinding.tvMediaDes.text = attachment.text\n            } else {\n                mediaBinding.tvMediaDes.isVisible = false\n            }\n        }\n    }\n\n    private fun configMediaAttach() {\n        val firstAttachment = messageItem.message.attachments.first { it.type != ModelType.attach_file }\n        val type = firstAttachment.type\n        var attachUrl = firstAttachment.imageUrl\n        if (type != null) {\n            if (ModelType.attach_image == type) {\n                attachUrl = firstAttachment.imageUrl\n            } else if (ModelType.attach_giphy == type) {\n                attachUrl = firstAttachment.thumbUrl\n            } else if (ModelType.attach_video == type) {\n                attachUrl = firstAttachment.thumbUrl\n            } else {\n                if (attachUrl == null) attachUrl = firstAttachment.image\n            }\n        }\n\n        if (attachUrl.isNullOrEmpty()) {\n            mediaBinding.root.isVisible = false\n            return\n        }\n        mediaBinding.root.isVisible = true\n\n        configAttachViewBackground(mediaBinding.root)\n        configImageThumbBackground()\n        configClickListeners()\n\n        if (!attachUrl.contains(\"https:\")) {\n            attachUrl = \"https:$attachUrl\"\n        }\n\n        mediaBinding.ivMediaThumb.load(\n            data = ChatUI.instance().urlSigner.signImageUrl(attachUrl)\n        )\n\n        if (messageItem.message.type != ModelType.message_ephemeral) {\n            mediaBinding.tvMediaTitle.text = firstAttachment.title\n        }\n        mediaBinding.tvMediaDes.text = firstAttachment.text\n\n        mediaBinding.tvMediaDes.isVisible = !firstAttachment.text.isNullOrEmpty()\n        mediaBinding.tvMediaTitle.isVisible = !firstAttachment.title.isNullOrEmpty()\n        mediaBinding.tvMediaPlay.isVisible = type == ModelType.attach_video\n    }\n\n    private fun configAttachViewBackground(view: View) {\n        val messageBubbleDrawableRes = style.getMessageBubbleDrawable(messageItem.isMine)\n        if (messageBubbleDrawableRes != -1) {\n            view.background = context.getDrawable(messageBubbleDrawableRes)\n        }\n    }\n\n    private fun configImageThumbBackground() {\n        var background = bubbleHelper.getDrawableForAttachment(\n            messageItem.message,\n            messageItem.isMine,\n            messageItem.positions,\n            attachment\n        )\n        mediaBinding.ivMediaThumb.setShape(context, background)\n\n        if (mediaBinding.tvMediaDes.isVisible || mediaBinding.tvMediaTitle.isVisible) {\n            background = bubbleHelper.getDrawableForAttachmentDescription(\n                messageItem.message,\n                messageItem.isMine,\n                messageItem.positions\n            )\n            mediaBinding.clDes.background = background\n        }\n    }\n\n    private fun configClickListeners() {\n        mediaBinding.root.setOnClickListener {\n            clickListener.onAttachmentClick(messageItem.message, attachment)\n        }\n        mediaBinding.root.setOnLongClickListener {\n            if (longClickListenerView != null) {\n                longClickListenerView.onMessageLongClick2(messageItem.message, itemView)\n            } else {\n                longClickListener?.onMessageLongClick(messageItem.message)\n            }\n            true\n        }\n    }\n\n    private fun configFileAttach() {\n        configAttachViewBackground(binding.lvAttachmentFile)\n\n        val attachments = messageItem.message.attachments.filter { it.type == ModelType.attach_file }\n        binding.lvAttachmentFile.adapter = FileAttachmentSelectedAdapter(\n            attachments.map { AttachmentMetaData(it) },\n            false\n        )\n        binding.lvAttachmentFile.onItemClickListener = OnItemClickListener { _, _, _, _ ->\n            clickListener.onAttachmentClick(messageItem.message, attachment)\n        }\n        binding.lvAttachmentFile.onItemLongClickListener = OnItemLongClickListener { _, _, _, _ ->\n            if (longClickListenerView != null) {\n                longClickListenerView.onMessageLongClick2(messageItem.message, itemView)\n            } else {\n                longClickListener?.onMessageLongClick(messageItem.message)\n            }\n\n            true\n        }\n\n        binding.lvAttachmentFile.updateLayoutParams<ConstraintLayout.LayoutParams> {\n            val fileHeight = context.resources.getDimension(R.dimen.stream_attach_file_height)\n            height = fileHeight.toInt() * attachments.size\n        }\n    }\n}");
            streamItemAttachmentBinding = streamItemAttachmentBinding2;
        }
        this(viewGroup, messageListViewStyle, bubbleHelper, messageItem, attachmentClickListener2, messageLongClickListener2, messageLongClickListenerView, streamItemAttachmentBinding);
    }

    @Override
    public void bind(@NotNull AttachmentListItem attachmentListItem) {
        Intrinsics.checkNotNullParameter((Object)attachmentListItem, (String)"attachmentListItem");
        this.attachment = attachmentListItem.getAttachment();
        this.applyStyle();
        this.configAttachment();
    }

    private final void applyStyle() {
        if (this.messageItem.isMine()) {
            TextStyle textStyle = this.style.getAttachmentTitleTextMine();
            TextView textView = this.mediaBinding.tvMediaTitle;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"mediaBinding.tvMediaTitle");
            textStyle.apply(textView);
            TextStyle textStyle2 = this.style.getAttachmentDescriptionTextMine();
            textView = this.mediaBinding.tvMediaDes;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"mediaBinding.tvMediaDes");
            textStyle2.apply(textView);
        } else {
            TextStyle textStyle = this.style.getAttachmentTitleTextTheirs();
            TextView textView = this.mediaBinding.tvMediaTitle;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"mediaBinding.tvMediaTitle");
            textStyle.apply(textView);
            TextStyle textStyle3 = this.style.getAttachmentDescriptionTextTheirs();
            textView = this.mediaBinding.tvMediaDes;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"mediaBinding.tvMediaDes");
            textStyle3.apply(textView);
        }
    }

    private final void configAttachment() {
        Object $this$isVisible$iv;
        boolean $i$f$setVisible;
        boolean value$iv;
        boolean hasFile = false;
        boolean hasMedia = false;
        for (Attachment attachment : this.messageItem.getMessage().getAttachments()) {
            if (attachment.getType() == null) continue;
            if (Intrinsics.areEqual((Object)attachment.getType(), (Object)"file")) {
                hasFile = true;
                continue;
            }
            hasMedia = true;
        }
        if (hasMedia) {
            ConstraintLayout constraintLayout = this.mediaBinding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"mediaBinding.root");
            constraintLayout = (View)constraintLayout;
            value$iv = true;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(0);
            this.configMediaAttach();
        } else {
            $this$isVisible$iv = this.mediaBinding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.root");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = false;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
        }
        if (hasFile) {
            $this$isVisible$iv = this.binding.lvAttachmentFile;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.lvAttachmentFile");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = true;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(0);
            this.configFileAttach();
        } else {
            $this$isVisible$iv = this.binding.lvAttachmentFile;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.lvAttachmentFile");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = false;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
        }
        if (!hasMedia && !hasFile) {
            $this$isVisible$iv = this.mediaBinding.ivMediaThumb;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.ivMediaThumb");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = false;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
            $this$isVisible$iv = this.attachment;
            if ($this$isVisible$iv == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                throw null;
            }
            $this$isVisible$iv = $this$isVisible$iv.getTitle();
            value$iv = false;
            $i$f$setVisible = false;
            if (!($this$isVisible$iv == null || $this$isVisible$iv.length() == 0)) {
                $this$isVisible$iv = this.mediaBinding.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.root");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = true;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                $this$isVisible$iv = this.mediaBinding.tvMediaTitle;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaTitle");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = true;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                $this$isVisible$iv = this.attachment;
                if ($this$isVisible$iv == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                    throw null;
                }
                this.mediaBinding.tvMediaTitle.setText((CharSequence)$this$isVisible$iv.getTitle());
            } else {
                $this$isVisible$iv = this.mediaBinding.tvMediaTitle;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaTitle");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = false;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(8);
            }
            $this$isVisible$iv = this.attachment;
            if ($this$isVisible$iv == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                throw null;
            }
            $this$isVisible$iv = $this$isVisible$iv.getText();
            value$iv = false;
            $i$f$setVisible = false;
            if (!($this$isVisible$iv == null || $this$isVisible$iv.length() == 0)) {
                $this$isVisible$iv = this.mediaBinding.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.root");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = true;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                $this$isVisible$iv = this.mediaBinding.tvMediaDes;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaDes");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = true;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                $this$isVisible$iv = this.attachment;
                if ($this$isVisible$iv == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                    throw null;
                }
                this.mediaBinding.tvMediaDes.setText((CharSequence)$this$isVisible$iv.getText());
            } else {
                $this$isVisible$iv = this.mediaBinding.tvMediaDes;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaDes");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = false;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(8);
            }
        }
    }

    private final void configMediaAttach() {
        ConstraintLayout $this$isVisible$iv;
        boolean $i$f$setVisible;
        boolean value$iv;
        Object element$iv22;
        block12: {
            Iterable $this$first$iv = this.messageItem.getMessage().getAttachments();
            boolean $i$f$first = false;
            for (Object element$iv22 : $this$first$iv) {
                Attachment it = (Attachment)element$iv22;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getType(), (Object)"file"))) continue;
                break block12;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Attachment firstAttachment = (Attachment)element$iv22;
        String type = firstAttachment.getType();
        String attachUrl = firstAttachment.getImageUrl();
        if (type != null) {
            if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                attachUrl = firstAttachment.getImageUrl();
            } else if (Intrinsics.areEqual((Object)"giphy", (Object)type)) {
                attachUrl = firstAttachment.getThumbUrl();
            } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
                attachUrl = firstAttachment.getThumbUrl();
            } else if (attachUrl == null) {
                attachUrl = firstAttachment.getImage();
            }
        }
        Object object = attachUrl;
        boolean element$iv22 = false;
        boolean it = false;
        if (object == null || object.length() == 0) {
            object = this.mediaBinding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mediaBinding.root");
            object = (View)object;
            value$iv = false;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
            return;
        }
        $this$isVisible$iv = this.mediaBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.root");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = true;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        $this$isVisible$iv = this.mediaBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.root");
        this.configAttachViewBackground((View)$this$isVisible$iv);
        this.configImageThumbBackground();
        this.configClickListeners();
        if (!StringsKt.contains$default((CharSequence)attachUrl, (CharSequence)"https:", (boolean)false, (int)2, null)) {
            attachUrl = Intrinsics.stringPlus((String)"https:", (Object)attachUrl);
        }
        $this$isVisible$iv = this.mediaBinding.ivMediaThumb;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.ivMediaThumb");
        ViewExtensionsKt.load$default((ImageView)((ImageView)$this$isVisible$iv), (Object)ChatUI.Companion.instance().getUrlSigner().signImageUrl(attachUrl), null, null, null, null, (int)30, null);
        if (!Intrinsics.areEqual((Object)this.messageItem.getMessage().getType(), (Object)"ephemeral")) {
            this.mediaBinding.tvMediaTitle.setText((CharSequence)firstAttachment.getTitle());
        }
        this.mediaBinding.tvMediaDes.setText((CharSequence)firstAttachment.getText());
        $this$isVisible$iv = this.mediaBinding.tvMediaDes;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaDes");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        CharSequence value$iv32 = firstAttachment.getText();
        $i$f$setVisible = false;
        boolean bl = false;
        boolean value$iv32 = !(value$iv32 == null || value$iv32.length() == 0);
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv32 ? 0 : 8);
        $this$isVisible$iv = this.mediaBinding.tvMediaTitle;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaTitle");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        CharSequence value$iv42 = firstAttachment.getTitle();
        $i$f$setVisible = false;
        bl = false;
        boolean value$iv42 = !(value$iv42 == null || value$iv42.length() == 0);
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv42 ? 0 : 8);
        $this$isVisible$iv = this.mediaBinding.tvMediaPlay;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaPlay");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv42 = Intrinsics.areEqual((Object)type, (Object)"video");
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv42 ? 0 : 8);
    }

    private final void configAttachViewBackground(View view) {
        int messageBubbleDrawableRes = this.style.getMessageBubbleDrawable(this.messageItem.isMine());
        if (messageBubbleDrawableRes != -1) {
            view.setBackground(this.getContext().getDrawable(messageBubbleDrawableRes));
        }
    }

    private final void configImageThumbBackground() {
        block5: {
            Drawable background;
            block4: {
                Attachment attachment = this.attachment;
                if (attachment == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                    throw null;
                }
                background = this.bubbleHelper.getDrawableForAttachment(this.messageItem.getMessage(), this.messageItem.isMine(), this.messageItem.getPositions(), attachment);
                this.mediaBinding.ivMediaThumb.setShape(this.getContext(), background);
                attachment = this.mediaBinding.tvMediaDes;
                Intrinsics.checkNotNullExpressionValue((Object)attachment, (String)"mediaBinding.tvMediaDes");
                View $this$isVisible$iv = (View)attachment;
                boolean $i$f$isVisible = false;
                if ($this$isVisible$iv.getVisibility() == 0) break block4;
                $this$isVisible$iv = this.mediaBinding.tvMediaTitle;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaTitle");
                $i$f$isVisible = false;
                if (!($this$isVisible$iv.getVisibility() == 0)) break block5;
            }
            background = this.bubbleHelper.getDrawableForAttachmentDescription(this.messageItem.getMessage(), this.messageItem.isMine(), this.messageItem.getPositions());
            this.mediaBinding.clDes.setBackground(background);
        }
    }

    private final void configClickListeners() {
        this.mediaBinding.getRoot().setOnClickListener(arg_0 -> AttachmentViewHolder.configClickListeners$lambda-1(this, arg_0));
        this.mediaBinding.getRoot().setOnLongClickListener(arg_0 -> AttachmentViewHolder.configClickListeners$lambda-2(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void configFileAttach() {
        Collection<AttachmentMetaData> collection;
        void $this$mapTo$iv$iv;
        ListView $this$map$iv;
        Attachment it;
        void $this$filterTo$iv$iv;
        ListView listView = this.binding.lvAttachmentFile;
        Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"binding.lvAttachmentFile");
        this.configAttachViewBackground((View)listView);
        Iterable $this$filter$iv = this.messageItem.getMessage().getAttachments();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Attachment)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"file")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List attachments2 = (List)destination$iv$iv;
        $this$filter$iv = attachments2;
        ListView listView2 = this.binding.lvAttachmentFile;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Attachment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            AttachmentMetaData attachmentMetaData = new AttachmentMetaData(it);
            collection.add(attachmentMetaData);
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        Function1 function1 = null;
        boolean bl = false;
        List list = collection;
        listView2.setAdapter((ListAdapter)new FileAttachmentSelectedAdapter(list, bl, function1, n, defaultConstructorMarker));
        this.binding.lvAttachmentFile.setOnItemClickListener((arg_0, arg_1, arg_2, arg_3) -> AttachmentViewHolder.configFileAttach$lambda-5(this, arg_0, arg_1, arg_2, arg_3));
        this.binding.lvAttachmentFile.setOnItemLongClickListener((arg_0, arg_1, arg_2, arg_3) -> AttachmentViewHolder.configFileAttach$lambda-6(this, arg_0, arg_1, arg_2, arg_3));
        $this$map$iv = this.binding.lvAttachmentFile;
        Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"binding.lvAttachmentFile");
        View $this$updateLayoutParams$iv = (View)$this$map$iv;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams);
        ConstraintLayout.LayoutParams $this$configFileAttach_u24lambda_u2d7 = (ConstraintLayout.LayoutParams)params$iv;
        boolean bl2 = false;
        float fileHeight = this.getContext().getResources().getDimension(R.dimen.stream_attach_file_height);
        $this$configFileAttach_u24lambda_u2d7.height = (int)fileHeight * attachments2.size();
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
    }

    private static final void configClickListeners$lambda-1(AttachmentViewHolder this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Attachment attachment = this$0.attachment;
        if (attachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            throw null;
        }
        this$0.clickListener.onAttachmentClick(this$0.messageItem.getMessage(), attachment);
    }

    private static final boolean configClickListeners$lambda-2(AttachmentViewHolder this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.longClickListenerView != null) {
            MessageListView.MessageLongClickListenerView messageLongClickListenerView = this$0.longClickListenerView;
            Message message = this$0.messageItem.getMessage();
            View view = this$0.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
            messageLongClickListenerView.onMessageLongClick2(message, view);
        } else {
            MessageListView.MessageLongClickListener messageLongClickListener2 = this$0.longClickListener;
            if (messageLongClickListener2 != null) {
                messageLongClickListener2.onMessageLongClick(this$0.messageItem.getMessage());
            }
        }
        return true;
    }

    private static final void configFileAttach$lambda-5(AttachmentViewHolder this$0, AdapterView $noName_0, View $noName_1, int $noName_2, long $noName_3) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Attachment attachment = this$0.attachment;
        if (attachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            throw null;
        }
        this$0.clickListener.onAttachmentClick(this$0.messageItem.getMessage(), attachment);
    }

    private static final boolean configFileAttach$lambda-6(AttachmentViewHolder this$0, AdapterView $noName_0, View $noName_1, int $noName_2, long $noName_3) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.longClickListenerView != null) {
            MessageListView.MessageLongClickListenerView messageLongClickListenerView = this$0.longClickListenerView;
            Message message = this$0.messageItem.getMessage();
            View view = this$0.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
            messageLongClickListenerView.onMessageLongClick2(message, view);
        } else {
            MessageListView.MessageLongClickListener messageLongClickListener2 = this$0.longClickListener;
            if (messageLongClickListener2 != null) {
                messageLongClickListener2.onMessageLongClick(this$0.messageItem.getMessage());
            }
        }
        return true;
    }
}

