/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.attachment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.getstream.sdk.chat.adapter.AttachmentListItem;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.viewholder.attachment.BaseAttachmentViewHolder;
import com.getstream.sdk.chat.databinding.StreamItemAttachmentFileBinding;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.utils.UiUtils;
import com.getstream.sdk.chat.view.MessageListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0016H\u0002J\b\u0010\u001b\u001a\u00020\u0016H\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/attachment/AttachmentViewHolderFile;", "Lcom/getstream/sdk/chat/adapter/viewholder/attachment/BaseAttachmentViewHolder;", "parent", "Landroid/view/ViewGroup;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "bubbleHelper", "Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;", "messageItem", "Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;", "clickListener", "Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;", "longClickListener", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;", "longClickListenerView", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListenerView;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemAttachmentFileBinding;", "(Landroid/view/ViewGroup;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListenerView;Lcom/getstream/sdk/chat/databinding/StreamItemAttachmentFileBinding;)V", "attachment", "Lio/getstream/chat/android/client/models/Attachment;", "applyStyle", "", "bind", "attachmentListItem", "Lcom/getstream/sdk/chat/adapter/AttachmentListItem;", "configAttachment", "configClickListeners", "stream-chat-android_release"})
public final class AttachmentViewHolderFile
extends BaseAttachmentViewHolder {
    @NotNull
    private final MessageListViewStyle style;
    @NotNull
    private final MessageListView.BubbleHelper bubbleHelper;
    @NotNull
    private final MessageListItem.MessageItem messageItem;
    @NotNull
    private final MessageListView.AttachmentClickListener clickListener;
    @Nullable
    private final MessageListView.MessageLongClickListener longClickListener;
    @Nullable
    private final MessageListView.MessageLongClickListenerView longClickListenerView;
    @NotNull
    private final StreamItemAttachmentFileBinding binding;
    private Attachment attachment;

    public AttachmentViewHolderFile(@NotNull ViewGroup parent, @NotNull MessageListViewStyle style, @NotNull MessageListView.BubbleHelper bubbleHelper, @NotNull MessageListItem.MessageItem messageItem, @NotNull MessageListView.AttachmentClickListener clickListener2, @Nullable MessageListView.MessageLongClickListener longClickListener, @Nullable MessageListView.MessageLongClickListenerView longClickListenerView, @NotNull StreamItemAttachmentFileBinding binding) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)bubbleHelper, (String)"bubbleHelper");
        Intrinsics.checkNotNullParameter((Object)messageItem, (String)"messageItem");
        Intrinsics.checkNotNullParameter((Object)clickListener2, (String)"clickListener");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        ConstraintLayout constraintLayout = binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
        super((View)constraintLayout);
        this.style = style;
        this.bubbleHelper = bubbleHelper;
        this.messageItem = messageItem;
        this.clickListener = clickListener2;
        this.longClickListener = longClickListener;
        this.longClickListenerView = longClickListenerView;
        this.binding = binding;
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ AttachmentViewHolderFile(ViewGroup viewGroup, MessageListViewStyle messageListViewStyle, MessageListView.BubbleHelper bubbleHelper, MessageListItem.MessageItem messageItem, MessageListView.AttachmentClickListener attachmentClickListener2, MessageListView.MessageLongClickListener messageLongClickListener2, MessageListView.MessageLongClickListenerView messageLongClickListenerView, StreamItemAttachmentFileBinding streamItemAttachmentFileBinding, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            messageLongClickListenerView = null;
        }
        if ((n & 0x80) != 0) {
            void $this$inflater$iv;
            ViewGroup viewGroup2 = viewGroup;
            boolean $i$f$getInflater = false;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)$this$inflater$iv.getContext());
            Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"from(context)");
            StreamItemAttachmentFileBinding streamItemAttachmentFileBinding2 = StreamItemAttachmentFileBinding.inflate(layoutInflater, viewGroup, false);
            Intrinsics.checkNotNullExpressionValue((Object)streamItemAttachmentFileBinding2, (String)"class AttachmentViewHolderFile(\n    parent: ViewGroup,\n    private val style: MessageListViewStyle,\n    private val bubbleHelper: BubbleHelper,\n    private val messageItem: MessageItem,\n    private val clickListener: AttachmentClickListener,\n    private val longClickListener: MessageLongClickListener?,\n    private val longClickListenerView: MessageLongClickListenerView? = null,\n    private val binding: StreamItemAttachmentFileBinding =\n        StreamItemAttachmentFileBinding.inflate(parent.inflater, parent, false)\n) : BaseAttachmentViewHolder(binding.root) {\n\n    private lateinit var attachment: Attachment\n\n    override fun bind(attachmentListItem: AttachmentListItem) {\n        attachment = attachmentListItem.attachment\n\n        applyStyle()\n        configAttachment()\n        configClickListeners()\n    }\n\n    private fun applyStyle() {\n        if (messageItem.isMine) {\n            style.attachmentTitleTextMine.apply(binding.tvFileTitle)\n            style.attachmentFileSizeTextMine.apply(binding.tvFileSize)\n        } else {\n            style.attachmentTitleTextTheirs.apply(binding.tvFileTitle)\n            style.attachmentFileSizeTextTheirs.apply(binding.tvFileSize)\n        }\n    }\n\n    private fun configAttachment() {\n        binding.tvFileSize.text = UiUtils.getFileSizeHumanized(attachment.fileSize)\n        binding.ivFileThumb.setImageResource(UiUtils.getIcon(attachment.mimeType))\n        binding.tvFileTitle.text = attachment.title\n\n        val background = bubbleHelper.getDrawableForAttachment(\n            messageItem.message,\n            messageItem.isMine,\n            messageItem.positions,\n            attachment\n        )\n        binding.attachmentview.background = background\n    }\n\n    private fun configClickListeners() {\n        binding.attachmentview.setOnClickListener {\n            clickListener.onAttachmentClick(\n                messageItem.message,\n                attachment\n            )\n        }\n        binding.attachmentview.setOnLongClickListener {\n            if (longClickListenerView != null) {\n                longClickListenerView.onMessageLongClick2(messageItem.message, itemView)\n            } else {\n                longClickListener?.onMessageLongClick(messageItem.message)\n            }\n\n            true\n        }\n    }\n}");
            streamItemAttachmentFileBinding = streamItemAttachmentFileBinding2;
        }
        this(viewGroup, messageListViewStyle, bubbleHelper, messageItem, attachmentClickListener2, messageLongClickListener2, messageLongClickListenerView, streamItemAttachmentFileBinding);
    }

    @Override
    public void bind(@NotNull AttachmentListItem attachmentListItem) {
        Intrinsics.checkNotNullParameter((Object)attachmentListItem, (String)"attachmentListItem");
        this.attachment = attachmentListItem.getAttachment();
        this.applyStyle();
        this.configAttachment();
        this.configClickListeners();
    }

    private final void applyStyle() {
        if (this.messageItem.isMine()) {
            TextStyle textStyle = this.style.getAttachmentTitleTextMine();
            TextView textView = this.binding.tvFileTitle;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvFileTitle");
            textStyle.apply(textView);
            TextStyle textStyle2 = this.style.getAttachmentFileSizeTextMine();
            textView = this.binding.tvFileSize;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvFileSize");
            textStyle2.apply(textView);
        } else {
            TextStyle textStyle = this.style.getAttachmentTitleTextTheirs();
            TextView textView = this.binding.tvFileTitle;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvFileTitle");
            textStyle.apply(textView);
            TextStyle textStyle3 = this.style.getAttachmentFileSizeTextTheirs();
            textView = this.binding.tvFileSize;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvFileSize");
            textStyle3.apply(textView);
        }
    }

    private final void configAttachment() {
        Attachment attachment = this.attachment;
        if (attachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            throw null;
        }
        this.binding.tvFileSize.setText((CharSequence)UiUtils.INSTANCE.getFileSizeHumanized(attachment.getFileSize()));
        attachment = this.attachment;
        if (attachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            throw null;
        }
        this.binding.ivFileThumb.setImageResource(UiUtils.INSTANCE.getIcon(attachment.getMimeType()));
        attachment = this.attachment;
        if (attachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            throw null;
        }
        this.binding.tvFileTitle.setText((CharSequence)attachment.getTitle());
        Attachment attachment2 = this.attachment;
        if (attachment2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            throw null;
        }
        Drawable background = this.bubbleHelper.getDrawableForAttachment(this.messageItem.getMessage(), this.messageItem.isMine(), this.messageItem.getPositions(), attachment2);
        this.binding.attachmentview.setBackground(background);
    }

    private final void configClickListeners() {
        this.binding.attachmentview.setOnClickListener(arg_0 -> AttachmentViewHolderFile.configClickListeners$lambda-0(this, arg_0));
        this.binding.attachmentview.setOnLongClickListener(arg_0 -> AttachmentViewHolderFile.configClickListeners$lambda-1(this, arg_0));
    }

    private static final void configClickListeners$lambda-0(AttachmentViewHolderFile this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Attachment attachment = this$0.attachment;
        if (attachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            throw null;
        }
        this$0.clickListener.onAttachmentClick(this$0.messageItem.getMessage(), attachment);
    }

    private static final boolean configClickListeners$lambda-1(AttachmentViewHolderFile this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.longClickListenerView != null) {
            MessageListView.MessageLongClickListenerView messageLongClickListenerView = this$0.longClickListenerView;
            Message message = this$0.messageItem.getMessage();
            View view = this$0.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
            messageLongClickListenerView.onMessageLongClick2(message, view);
        } else {
            MessageListView.MessageLongClickListener messageLongClickListener2 = this$0.longClickListener;
            if (messageLongClickListener2 != null) {
                messageLongClickListener2.onMessageLongClick(this$0.messageItem.getMessage());
            }
        }
        return true;
    }
}

