/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.attachment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.AttachmentListItem;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.viewholder.attachment.BaseAttachmentViewHolder;
import com.getstream.sdk.chat.databinding.StreamItemAttachMediaBinding;
import com.getstream.sdk.chat.enums.GiphyAction;
import com.getstream.sdk.chat.images.ViewExtensionsKt;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.utils.Utils;
import com.getstream.sdk.chat.view.MessageListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Message;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.defaults.drawabletoolbox.DrawableBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0018H\u0002J\b\u0010\u001d\u001a\u00020\u0018H\u0002J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/attachment/AttachmentViewHolderMedia;", "Lcom/getstream/sdk/chat/adapter/viewholder/attachment/BaseAttachmentViewHolder;", "parent", "Landroid/view/ViewGroup;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "bubbleHelper", "Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;", "messageItem", "Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;", "giphySendListener", "Lcom/getstream/sdk/chat/view/MessageListView$GiphySendListener;", "clickListener", "Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;", "longClickListener", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;", "longClickListenerView", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListenerView;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemAttachMediaBinding;", "(Landroid/view/ViewGroup;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;Lcom/getstream/sdk/chat/view/MessageListView$GiphySendListener;Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListenerView;Lcom/getstream/sdk/chat/databinding/StreamItemAttachMediaBinding;)V", "attachment", "Lio/getstream/chat/android/client/models/Attachment;", "applyStyle", "", "bind", "attachmentListItem", "Lcom/getstream/sdk/chat/adapter/AttachmentListItem;", "configActions", "configClickListeners", "configGiphyAction", "configImageThumbBackground", "configMediaAttach", "enableSendGiphyButtons", "isEnable", "", "stream-chat-android_release"})
public final class AttachmentViewHolderMedia
extends BaseAttachmentViewHolder {
    @NotNull
    private final MessageListViewStyle style;
    @NotNull
    private final MessageListView.BubbleHelper bubbleHelper;
    @NotNull
    private final MessageListItem.MessageItem messageItem;
    @NotNull
    private final MessageListView.GiphySendListener giphySendListener;
    @NotNull
    private final MessageListView.AttachmentClickListener clickListener;
    @Nullable
    private final MessageListView.MessageLongClickListener longClickListener;
    @Nullable
    private final MessageListView.MessageLongClickListenerView longClickListenerView;
    @NotNull
    private final StreamItemAttachMediaBinding binding;
    private Attachment attachment;

    public AttachmentViewHolderMedia(@NotNull ViewGroup parent, @NotNull MessageListViewStyle style, @NotNull MessageListView.BubbleHelper bubbleHelper, @NotNull MessageListItem.MessageItem messageItem, @NotNull MessageListView.GiphySendListener giphySendListener2, @NotNull MessageListView.AttachmentClickListener clickListener2, @Nullable MessageListView.MessageLongClickListener longClickListener, @Nullable MessageListView.MessageLongClickListenerView longClickListenerView, @NotNull StreamItemAttachMediaBinding binding) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)bubbleHelper, (String)"bubbleHelper");
        Intrinsics.checkNotNullParameter((Object)messageItem, (String)"messageItem");
        Intrinsics.checkNotNullParameter((Object)giphySendListener2, (String)"giphySendListener");
        Intrinsics.checkNotNullParameter((Object)clickListener2, (String)"clickListener");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        ConstraintLayout constraintLayout = binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
        super((View)constraintLayout);
        this.style = style;
        this.bubbleHelper = bubbleHelper;
        this.messageItem = messageItem;
        this.giphySendListener = giphySendListener2;
        this.clickListener = clickListener2;
        this.longClickListener = longClickListener;
        this.longClickListenerView = longClickListenerView;
        this.binding = binding;
        this.binding.tvMediaDes.setMaxLines(this.style.getAttachmentPreviewMaxLines());
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ AttachmentViewHolderMedia(ViewGroup viewGroup, MessageListViewStyle messageListViewStyle, MessageListView.BubbleHelper bubbleHelper, MessageListItem.MessageItem messageItem, MessageListView.GiphySendListener giphySendListener2, MessageListView.AttachmentClickListener attachmentClickListener2, MessageListView.MessageLongClickListener messageLongClickListener2, MessageListView.MessageLongClickListenerView messageLongClickListenerView, StreamItemAttachMediaBinding streamItemAttachMediaBinding, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            messageLongClickListener2 = null;
        }
        if ((n & 0x80) != 0) {
            messageLongClickListenerView = null;
        }
        if ((n & 0x100) != 0) {
            void $this$inflater$iv;
            ViewGroup viewGroup2 = viewGroup;
            boolean $i$f$getInflater = false;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)$this$inflater$iv.getContext());
            Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"from(context)");
            StreamItemAttachMediaBinding streamItemAttachMediaBinding2 = StreamItemAttachMediaBinding.inflate(layoutInflater, viewGroup, false);
            Intrinsics.checkNotNullExpressionValue((Object)streamItemAttachMediaBinding2, (String)"class AttachmentViewHolderMedia(\n    parent: ViewGroup,\n    private val style: MessageListViewStyle,\n    private val bubbleHelper: BubbleHelper,\n    private val messageItem: MessageItem,\n    private val giphySendListener: GiphySendListener,\n    private val clickListener: AttachmentClickListener,\n    private val longClickListener: MessageLongClickListener? = null,\n    private val longClickListenerView: MessageLongClickListenerView? = null,\n    private val binding: StreamItemAttachMediaBinding =\n        StreamItemAttachMediaBinding.inflate(parent.inflater, parent, false),\n) : BaseAttachmentViewHolder(binding.root) {\n\n    private lateinit var attachment: Attachment\n\n    init {\n        binding.tvMediaDes.maxLines = style.attachmentPreviewMaxLines\n    }\n\n    override fun bind(attachmentListItem: AttachmentListItem) {\n        attachment = attachmentListItem.attachment\n\n        applyStyle()\n        configMediaAttach()\n        configActions()\n        configClickListeners()\n    }\n\n    private fun applyStyle() {\n        if (messageItem.isMine) {\n            style.attachmentTitleTextMine.apply(binding.tvMediaTitle)\n            style.attachmentDescriptionTextMine.apply(binding.tvMediaDes)\n        } else {\n            style.attachmentTitleTextTheirs.apply(binding.tvMediaTitle)\n            style.attachmentDescriptionTextTheirs.apply(binding.tvMediaDes)\n        }\n    }\n\n    private fun configMediaAttach() {\n        val type = attachment.type\n        configImageThumbBackground()\n\n        val thumbUrl = attachment.thumbUrl\n        val imageUrl = if (thumbUrl.isNullOrEmpty()) attachment.imageUrl else thumbUrl\n\n        binding.ivMediaThumb.load(\n            data = imageUrl,\n            placeholderResId = R.drawable.stream_placeholder,\n            onStart = { binding.progressBar.isVisible = true },\n            onComplete = { binding.progressBar.isVisible = false },\n        )\n\n        if (messageItem.message.type != ModelType.message_ephemeral) {\n            binding.tvMediaTitle.text = attachment.title\n        }\n\n        binding.tvMediaDes.text = attachment.text\n        binding.tvMediaTitle.isVisible = !attachment.title.isNullOrEmpty()\n        binding.tvMediaDes.isVisible = !attachment.text.isNullOrEmpty()\n        binding.tvMediaPlay.isVisible = type == ModelType.attach_video\n        binding.ivCommandLogo.isVisible = type == ModelType.attach_giphy\n\n        if (binding.tvMediaDes.isVisible || binding.tvMediaTitle.isVisible) {\n            val background = bubbleHelper.getDrawableForAttachmentDescription(\n                messageItem.message,\n                messageItem.isMine,\n                messageItem.positions\n            )\n            binding.clDes.background = background\n        }\n    }\n\n    private fun configImageThumbBackground() {\n        val background = bubbleHelper.getDrawableForAttachment(\n            messageItem.message,\n            messageItem.isMine,\n            messageItem.positions,\n            attachment\n        )\n        binding.ivMediaThumb.setShape(context, background)\n    }\n\n    private fun configActions() {\n        if (messageItem.message.type == ModelType.message_ephemeral && messageItem.message.command == ModelType.attach_giphy) {\n            configGiphyAction()\n        } else {\n            binding.clAction.visibility = View.GONE\n        }\n    }\n\n    private fun configGiphyAction() {\n        binding.clAction.visibility = View.VISIBLE\n        binding.tvActionSend.background = DrawableBuilder()\n            .rectangle()\n            .rounded()\n            .strokeColor(Color.WHITE)\n            .strokeWidth(Utils.dpToPx(2))\n            .solidColor(ContextCompat.getColor(context, R.color.stream_input_message_send_button))\n            .solidColorPressed(Color.LTGRAY)\n            .build()\n        binding.tvActionShuffle.background = DrawableBuilder()\n            .rectangle()\n            .rounded()\n            .strokeColor(ContextCompat.getColor(context, R.color.stream_message_stroke))\n            .strokeWidth(Utils.dpToPx(2))\n            .solidColor(Color.WHITE)\n            .solidColorPressed(Color.LTGRAY)\n            .build()\n        binding.tvActionCancel.background = DrawableBuilder()\n            .rectangle()\n            .rounded()\n            .strokeColor(ContextCompat.getColor(context, R.color.stream_message_stroke))\n            .strokeWidth(Utils.dpToPx(2))\n            .solidColor(Color.WHITE)\n            .solidColorPressed(Color.LTGRAY)\n            .build()\n        binding.tvActionSend.setOnClickListener {\n            enableSendGiphyButtons(false)\n            giphySendListener.onGiphySend(messageItem.message, GiphyAction.SEND)\n        }\n        binding.tvActionShuffle.setOnClickListener {\n            enableSendGiphyButtons(false)\n            giphySendListener.onGiphySend(messageItem.message, GiphyAction.SHUFFLE)\n        }\n        binding.tvActionCancel.setOnClickListener {\n            giphySendListener.onGiphySend(\n                messageItem.message,\n                GiphyAction.CANCEL\n            )\n        }\n    }\n\n    private fun enableSendGiphyButtons(isEnable: Boolean) {\n        binding.progressBar.isVisible = !isEnable\n        binding.tvActionSend.isEnabled = isEnable\n        binding.tvActionShuffle.isEnabled = isEnable\n        binding.tvActionCancel.isEnabled = isEnable\n    }\n\n    private fun configClickListeners() {\n        binding.ivMediaThumb.setOnClickListener {\n            clickListener.onAttachmentClick(\n                messageItem.message,\n                attachment\n            )\n        }\n        binding.ivMediaThumb.setOnLongClickListener {\n            if (longClickListenerView != null) {\n                longClickListenerView.onMessageLongClick2(messageItem.message, itemView)\n            } else {\n                longClickListener?.onMessageLongClick(messageItem.message)\n            }\n            true\n        }\n    }\n}");
            streamItemAttachMediaBinding = streamItemAttachMediaBinding2;
        }
        this(viewGroup, messageListViewStyle, bubbleHelper, messageItem, giphySendListener2, attachmentClickListener2, messageLongClickListener2, messageLongClickListenerView, streamItemAttachMediaBinding);
    }

    @Override
    public void bind(@NotNull AttachmentListItem attachmentListItem) {
        Intrinsics.checkNotNullParameter((Object)attachmentListItem, (String)"attachmentListItem");
        this.attachment = attachmentListItem.getAttachment();
        this.applyStyle();
        this.configMediaAttach();
        this.configActions();
        this.configClickListeners();
    }

    private final void applyStyle() {
        if (this.messageItem.isMine()) {
            TextStyle textStyle = this.style.getAttachmentTitleTextMine();
            TextView textView = this.binding.tvMediaTitle;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvMediaTitle");
            textStyle.apply(textView);
            TextStyle textStyle2 = this.style.getAttachmentDescriptionTextMine();
            textView = this.binding.tvMediaDes;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvMediaDes");
            textStyle2.apply(textView);
        } else {
            TextStyle textStyle = this.style.getAttachmentTitleTextTheirs();
            TextView textView = this.binding.tvMediaTitle;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvMediaTitle");
            textStyle.apply(textView);
            TextStyle textStyle3 = this.style.getAttachmentDescriptionTextTheirs();
            textView = this.binding.tvMediaDes;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvMediaDes");
            textStyle3.apply(textView);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configMediaAttach() {
        block14: {
            block13: {
                void value$iv322;
                TextView $this$isVisible$iv;
                String string2;
                Attachment attachment = this.attachment;
                if (attachment == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                    throw null;
                }
                String type = attachment.getType();
                this.configImageThumbBackground();
                Attachment attachment2 = this.attachment;
                if (attachment2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                    throw null;
                }
                String thumbUrl = attachment2.getThumbUrl();
                CharSequence charSequence = thumbUrl;
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    charSequence = this.attachment;
                    if (charSequence == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                        throw null;
                    }
                    string2 = charSequence.getImageUrl();
                } else {
                    string2 = thumbUrl;
                }
                String imageUrl = string2;
                charSequence = this.binding.ivMediaThumb;
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"binding.ivMediaThumb");
                ViewExtensionsKt.load$default((ImageView)((ImageView)charSequence), (Object)imageUrl, (Integer)R.drawable.stream_placeholder, null, (Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ AttachmentViewHolderMedia this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$isVisible$iv;
                        ProgressBar progressBar = AttachmentViewHolderMedia.access$getBinding$p((AttachmentViewHolderMedia)this.this$0).progressBar;
                        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.progressBar");
                        progressBar = (View)progressBar;
                        boolean value$iv = true;
                        boolean $i$f$setVisible = false;
                        $this$isVisible$iv.setVisibility(0);
                    }
                }), (Function0)((Function0)new Function0<Unit>(this){
                    final /* synthetic */ AttachmentViewHolderMedia this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        void $this$isVisible$iv;
                        ProgressBar progressBar = AttachmentViewHolderMedia.access$getBinding$p((AttachmentViewHolderMedia)this.this$0).progressBar;
                        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.progressBar");
                        progressBar = (View)progressBar;
                        boolean value$iv = false;
                        boolean $i$f$setVisible = false;
                        $this$isVisible$iv.setVisibility(8);
                    }
                }), (int)4, null);
                if (!Intrinsics.areEqual((Object)this.messageItem.getMessage().getType(), (Object)"ephemeral")) {
                    charSequence = this.attachment;
                    if (charSequence == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                        throw null;
                    }
                    this.binding.tvMediaTitle.setText((CharSequence)charSequence.getTitle());
                }
                if ((charSequence = this.attachment) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                    throw null;
                }
                this.binding.tvMediaDes.setText((CharSequence)charSequence.getText());
                charSequence = this.binding.tvMediaTitle;
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"binding.tvMediaTitle");
                charSequence = (View)charSequence;
                Object object = this.attachment;
                if (object == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                    throw null;
                }
                object = object.getTitle();
                bl2 = false;
                boolean bl3 = false;
                boolean bl4 = !(object == null || object.length() == 0);
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(value$iv322 != false ? 0 : 8);
                $this$isVisible$iv = this.binding.tvMediaDes;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.tvMediaDes");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                Object value$iv322 = this.attachment;
                if (value$iv322 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                    throw null;
                }
                value$iv322 = value$iv322.getText();
                $i$f$setVisible = false;
                bl3 = false;
                boolean value$iv322 = !(value$iv322 == null || value$iv322.length() == 0);
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(value$iv322 ? 0 : 8);
                $this$isVisible$iv = this.binding.tvMediaPlay;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.tvMediaPlay");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv322 = Intrinsics.areEqual((Object)type, (Object)"video");
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(value$iv322 ? 0 : 8);
                $this$isVisible$iv = this.binding.ivCommandLogo;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.ivCommandLogo");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv322 = Intrinsics.areEqual((Object)type, (Object)"giphy");
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(value$iv322 ? 0 : 8);
                $this$isVisible$iv = this.binding.tvMediaDes;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.tvMediaDes");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                boolean $i$f$isVisible = false;
                if ($this$isVisible$iv.getVisibility() == 0) break block13;
                $this$isVisible$iv = this.binding.tvMediaTitle;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.tvMediaTitle");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                $i$f$isVisible = false;
                if (!($this$isVisible$iv.getVisibility() == 0)) break block14;
            }
            Drawable background = this.bubbleHelper.getDrawableForAttachmentDescription(this.messageItem.getMessage(), this.messageItem.isMine(), this.messageItem.getPositions());
            this.binding.clDes.setBackground(background);
        }
    }

    private final void configImageThumbBackground() {
        Attachment attachment = this.attachment;
        if (attachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            throw null;
        }
        Drawable background = this.bubbleHelper.getDrawableForAttachment(this.messageItem.getMessage(), this.messageItem.isMine(), this.messageItem.getPositions(), attachment);
        this.binding.ivMediaThumb.setShape(this.getContext(), background);
    }

    private final void configActions() {
        if (Intrinsics.areEqual((Object)this.messageItem.getMessage().getType(), (Object)"ephemeral") && Intrinsics.areEqual((Object)this.messageItem.getMessage().getCommand(), (Object)"giphy")) {
            this.configGiphyAction();
        } else {
            this.binding.clAction.setVisibility(8);
        }
    }

    private final void configGiphyAction() {
        this.binding.clAction.setVisibility(0);
        this.binding.tvActionSend.setBackground(new DrawableBuilder().rectangle().rounded().strokeColor(-1).strokeWidth(Utils.dpToPx((int)2)).solidColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stream_input_message_send_button)).solidColorPressed(Integer.valueOf(-3355444)).build());
        this.binding.tvActionShuffle.setBackground(new DrawableBuilder().rectangle().rounded().strokeColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stream_message_stroke)).strokeWidth(Utils.dpToPx((int)2)).solidColor(-1).solidColorPressed(Integer.valueOf(-3355444)).build());
        this.binding.tvActionCancel.setBackground(new DrawableBuilder().rectangle().rounded().strokeColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.stream_message_stroke)).strokeWidth(Utils.dpToPx((int)2)).solidColor(-1).solidColorPressed(Integer.valueOf(-3355444)).build());
        this.binding.tvActionSend.setOnClickListener(arg_0 -> AttachmentViewHolderMedia.configGiphyAction$lambda-0(this, arg_0));
        this.binding.tvActionShuffle.setOnClickListener(arg_0 -> AttachmentViewHolderMedia.configGiphyAction$lambda-1(this, arg_0));
        this.binding.tvActionCancel.setOnClickListener(arg_0 -> AttachmentViewHolderMedia.configGiphyAction$lambda-2(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void enableSendGiphyButtons(boolean isEnable) {
        void $this$isVisible$iv;
        ProgressBar progressBar = this.binding.progressBar;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.progressBar");
        progressBar = (View)progressBar;
        boolean value$iv = !isEnable;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        this.binding.tvActionSend.setEnabled(isEnable);
        this.binding.tvActionShuffle.setEnabled(isEnable);
        this.binding.tvActionCancel.setEnabled(isEnable);
    }

    private final void configClickListeners() {
        this.binding.ivMediaThumb.setOnClickListener(arg_0 -> AttachmentViewHolderMedia.configClickListeners$lambda-3(this, arg_0));
        this.binding.ivMediaThumb.setOnLongClickListener(arg_0 -> AttachmentViewHolderMedia.configClickListeners$lambda-4(this, arg_0));
    }

    private static final void configGiphyAction$lambda-0(AttachmentViewHolderMedia this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.enableSendGiphyButtons(false);
        this$0.giphySendListener.onGiphySend(this$0.messageItem.getMessage(), GiphyAction.SEND);
    }

    private static final void configGiphyAction$lambda-1(AttachmentViewHolderMedia this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.enableSendGiphyButtons(false);
        this$0.giphySendListener.onGiphySend(this$0.messageItem.getMessage(), GiphyAction.SHUFFLE);
    }

    private static final void configGiphyAction$lambda-2(AttachmentViewHolderMedia this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.giphySendListener.onGiphySend(this$0.messageItem.getMessage(), GiphyAction.CANCEL);
    }

    private static final void configClickListeners$lambda-3(AttachmentViewHolderMedia this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Attachment attachment = this$0.attachment;
        if (attachment == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            throw null;
        }
        this$0.clickListener.onAttachmentClick(this$0.messageItem.getMessage(), attachment);
    }

    private static final boolean configClickListeners$lambda-4(AttachmentViewHolderMedia this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.longClickListenerView != null) {
            MessageListView.MessageLongClickListenerView messageLongClickListenerView = this$0.longClickListenerView;
            Message message = this$0.messageItem.getMessage();
            View view = this$0.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
            messageLongClickListenerView.onMessageLongClick2(message, view);
        } else {
            MessageListView.MessageLongClickListener messageLongClickListener2 = this$0.longClickListener;
            if (messageLongClickListener2 != null) {
                messageLongClickListener2.onMessageLongClick(this$0.messageItem.getMessage());
            }
        }
        return true;
    }

    public static final /* synthetic */ StreamItemAttachMediaBinding access$getBinding$p(AttachmentViewHolderMedia $this) {
        return $this.binding;
    }
}

