/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils;

import com.getstream.sdk.chat.R;
import java.text.DecimalFormat;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u000f\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\u0014\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/getstream/sdk/chat/utils/UiUtils;", "", "()V", "fileSizeFormat", "Ljava/text/DecimalFormat;", "fileSizeUnits", "", "", "[Ljava/lang/String;", "mimeTypesToIconResMap", "", "", "reactionTypeToSymbolMap", "getFileSizeHumanized", "fileSize", "getIcon", "mimeType", "getReactionTypes", "stream-chat-android_release"})
public final class UiUtils {
    @NotNull
    public static final UiUtils INSTANCE = new UiUtils();
    @NotNull
    private static final DecimalFormat fileSizeFormat = new DecimalFormat("#,##0.#");
    @NotNull
    private static final String[] fileSizeUnits;
    @NotNull
    private static final Map<String, Integer> mimeTypesToIconResMap;
    @NotNull
    private static final Map<String, String> reactionTypeToSymbolMap;

    private UiUtils() {
    }

    public final int getIcon(@Nullable String mimeType) {
        if (mimeType == null) {
            return R.drawable.stream_ic_file;
        }
        Integer n = mimeTypesToIconResMap.get(mimeType);
        return n == null ? (StringsKt.contains$default((CharSequence)mimeType, (CharSequence)"audio", (boolean)false, (int)2, null) ? R.drawable.stream_ic_file_mp3 : (StringsKt.contains$default((CharSequence)mimeType, (CharSequence)"video", (boolean)false, (int)2, null) ? R.drawable.stream_ic_file_mov : R.drawable.stream_ic_file)) : n;
    }

    @JvmStatic
    @NotNull
    public static final Map<String, String> getReactionTypes() {
        return reactionTypeToSymbolMap;
    }

    @NotNull
    public final String getFileSizeHumanized(int fileSize) {
        if (fileSize <= 0) {
            return "0";
        }
        double d = fileSize;
        boolean bl = false;
        double d2 = Math.log10(d);
        d = 1024.0;
        bl = false;
        int digitGroups = (int)(d2 / Math.log10(d));
        double d3 = 1024.0;
        double d4 = digitGroups;
        boolean bl2 = false;
        String size = fileSizeFormat.format((double)fileSize / Math.pow(d3, d4));
        String unit = fileSizeUnits[digitGroups];
        return size + ' ' + unit;
    }

    static {
        String[] stringArray = new String[]{"B", "KB", "MB", "GB", "TB"};
        fileSizeUnits = stringArray;
        stringArray = new Pair[]{TuplesKt.to((Object)"application/pdf", (Object)R.drawable.stream_ic_file_pdf), TuplesKt.to((Object)"text/comma-separated-values", (Object)R.drawable.stream_ic_file_csv), TuplesKt.to((Object)"application/tar", (Object)R.drawable.stream_ic_file_tar), TuplesKt.to((Object)"application/zip", (Object)R.drawable.stream_ic_file_zip), TuplesKt.to((Object)"application/msword", (Object)R.drawable.stream_ic_file_doc), TuplesKt.to((Object)"application/vnd.ms-excel", (Object)R.drawable.stream_ic_file_xls), TuplesKt.to((Object)"application/vnd.ms-powerpoint", (Object)R.drawable.stream_ic_file_ppt), TuplesKt.to((Object)"video/mov", (Object)R.drawable.stream_ic_file_mov), TuplesKt.to((Object)"video/mp4", (Object)R.drawable.stream_ic_file_mov), TuplesKt.to((Object)"audio/m4a", (Object)R.drawable.stream_ic_file_mp3), TuplesKt.to((Object)"audio/mp3", (Object)R.drawable.stream_ic_file_mp3)};
        mimeTypesToIconResMap = MapsKt.mapOf((Pair[])stringArray);
        stringArray = new Pair[]{TuplesKt.to((Object)"like", (Object)"\ud83d\udc4d"), TuplesKt.to((Object)"love", (Object)"\u2764\ufe0f"), TuplesKt.to((Object)"haha", (Object)"\ud83d\ude02"), TuplesKt.to((Object)"wow", (Object)"\ud83d\ude32"), TuplesKt.to((Object)"sad", (Object)"\ud83d\ude41"), TuplesKt.to((Object)"angry", (Object)"\ud83d\ude21")};
        reactionTypeToSymbolMap = MapsKt.mapOf((Pair[])stringArray);
    }
}

