/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.style;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.widget.TextView;
import androidx.annotation.FontRes;
import androidx.core.content.res.ResourcesCompat;
import com.getstream.sdk.chat.style.ChatFonts;
import com.getstream.sdk.chat.style.ChatStyle;
import com.getstream.sdk.chat.style.TextStyle;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\u0012\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\u0012\u001a\u00020\u000eH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/getstream/sdk/chat/style/ChatFontsImpl;", "Lcom/getstream/sdk/chat/style/ChatFonts;", "style", "Lcom/getstream/sdk/chat/style/ChatStyle;", "context", "Landroid/content/Context;", "(Lcom/getstream/sdk/chat/style/ChatStyle;Landroid/content/Context;)V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "pathMap", "", "", "Landroid/graphics/Typeface;", "resourceMap", "", "getFont", "textStyle", "Lcom/getstream/sdk/chat/style/TextStyle;", "fontRes", "fontPath", "safeLoadTypeface", "setDefaultFont", "", "textView", "Landroid/widget/TextView;", "setFont", "stream-chat-android_release"})
public final class ChatFontsImpl
implements ChatFonts {
    @NotNull
    private final ChatStyle style;
    @NotNull
    private final Context context;
    @NotNull
    private final Map<Integer, Typeface> resourceMap;
    @NotNull
    private final Map<String, Typeface> pathMap;
    @NotNull
    private final TaggedLogger logger;

    public ChatFontsImpl(@NotNull ChatStyle style, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.style = style;
        this.context = context;
        this.resourceMap = new HashMap();
        this.pathMap = new HashMap();
        String string2 = ChatFonts.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ChatFonts::class.java.simpleName");
        this.logger = ChatLogger.Companion.get((Object)string2);
    }

    @Override
    public void setFont(@NotNull TextStyle textStyle, @NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        if (textStyle.getFont() != null) {
            textView.setTypeface(textStyle.getFont(), textStyle.getStyle());
        } else {
            this.setDefaultFont(textView, textStyle.getStyle());
        }
    }

    @Override
    @Nullable
    public Typeface getFont(@NotNull TextStyle textStyle) {
        Typeface typeface;
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        if (textStyle.getFontResource() != -1) {
            typeface = this.getFont(textStyle.getFontResource());
        } else {
            CharSequence charSequence = textStyle.getFontAssetsPath();
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string2 = textStyle.getFontAssetsPath();
                Intrinsics.checkNotNull((Object)string2);
                typeface = this.getFont(string2);
            } else {
                typeface = null;
            }
        }
        return typeface;
    }

    private final Typeface getFont(String fontPath) {
        Map<String, Typeface> map = this.pathMap;
        boolean bl = false;
        Map<String, Typeface> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(fontPath)) {
            return this.pathMap.get(fontPath);
        }
        Object object = this.safeLoadTypeface(fontPath);
        if (object == null) {
            return null;
        }
        Typeface typeface = object;
        object = this.pathMap;
        boolean bl3 = false;
        object.put(fontPath, typeface);
        return typeface;
    }

    private final Typeface getFont(@FontRes int fontRes) {
        Map<Integer, Typeface> map = this.resourceMap;
        Integer n = fontRes;
        boolean bl = false;
        Map<Integer, Typeface> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(n)) {
            return this.resourceMap.get(fontRes);
        }
        n = this.safeLoadTypeface(fontRes);
        if (n == null) {
            return null;
        }
        Integer typeface = n;
        this.resourceMap.put(fontRes, (Typeface)typeface);
        return typeface;
    }

    private final void setDefaultFont(TextView textView, int textStyle) {
        if (this.style.hasDefaultFont()) {
            textView.setTypeface(this.getFont(this.style.getDefaultTextStyle()), textStyle);
        } else {
            textView.setTypeface(Typeface.DEFAULT, textStyle);
        }
    }

    private final Typeface safeLoadTypeface(@FontRes int fontRes) {
        Typeface typeface;
        try {
            typeface = ResourcesCompat.getFont((Context)this.context, (int)fontRes);
        }
        catch (Throwable t) {
            this.logger.logE(t);
            typeface = null;
        }
        return typeface;
    }

    private final Typeface safeLoadTypeface(String fontPath) {
        Typeface typeface;
        try {
            typeface = Typeface.createFromAsset((AssetManager)this.context.getAssets(), (String)fontPath);
        }
        catch (Throwable t) {
            this.logger.logE(t);
            typeface = null;
        }
        return typeface;
    }
}

