/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.view.dialog;

import android.app.Dialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.ReactionDialogAdapter;
import com.getstream.sdk.chat.databinding.StreamDialogMessageMoreactionBinding;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.utils.Utils;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import top.defaults.drawabletoolbox.DrawableBuilder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u00b9\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00100\r\u0012!\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00100\r\u0012!\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00100\r\u0012!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0011\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0012\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0006\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/getstream/sdk/chat/view/dialog/MessageMoreActionDialog;", "Landroid/app/Dialog;", "context", "Landroid/content/Context;", "channel", "Lio/getstream/chat/android/client/models/Channel;", "message", "Lio/getstream/chat/android/client/models/Message;", "currentUser", "Lio/getstream/chat/android/client/models/User;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "onMessageEditHandler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "", "onMessageDeleteHandler", "onStartThreadHandler", "onMessageFlagHandler", "(Landroid/content/Context;Lio/getstream/chat/android/client/models/Channel;Lio/getstream/chat/android/client/models/Message;Lio/getstream/chat/android/client/models/User;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "applyButtonsIconTint", "binding", "Lcom/getstream/sdk/chat/databinding/StreamDialogMessageMoreactionBinding;", "applyButtonsTextStyle", "canCopyOnMessage", "", "canReactOnMessage", "canThreadOnMessage", "isMessageNotCreatedByCurrentUser", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "setupMessageActions", "stream-chat-android_release"})
public final class MessageMoreActionDialog
extends Dialog {
    @NotNull
    private final Channel channel;
    @NotNull
    private final Message message;
    @NotNull
    private final User currentUser;
    @NotNull
    private final MessageListViewStyle style;
    @NotNull
    private final Function1<Message, Unit> onMessageEditHandler;
    @NotNull
    private final Function1<Message, Unit> onMessageDeleteHandler;
    @NotNull
    private final Function1<Message, Unit> onStartThreadHandler;
    @NotNull
    private final Function1<Message, Unit> onMessageFlagHandler;

    public MessageMoreActionDialog(@NotNull Context context, @NotNull Channel channel, @NotNull Message message, @NotNull User currentUser, @NotNull MessageListViewStyle style2, @NotNull Function1<? super Message, Unit> onMessageEditHandler2, @NotNull Function1<? super Message, Unit> onMessageDeleteHandler2, @NotNull Function1<? super Message, Unit> onStartThreadHandler2, @NotNull Function1<? super Message, Unit> onMessageFlagHandler2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        Intrinsics.checkNotNullParameter(onMessageEditHandler2, (String)"onMessageEditHandler");
        Intrinsics.checkNotNullParameter(onMessageDeleteHandler2, (String)"onMessageDeleteHandler");
        Intrinsics.checkNotNullParameter(onStartThreadHandler2, (String)"onStartThreadHandler");
        Intrinsics.checkNotNullParameter(onMessageFlagHandler2, (String)"onMessageFlagHandler");
        super(context, R.style.DialogTheme);
        this.channel = channel;
        this.message = message;
        this.currentUser = currentUser;
        this.style = style2;
        this.onMessageEditHandler = onMessageEditHandler2;
        this.onMessageDeleteHandler = onMessageDeleteHandler2;
        this.onStartThreadHandler = onStartThreadHandler2;
        this.onMessageFlagHandler = onMessageFlagHandler2;
        Utils.hideSoftKeyboard((Context)context);
        Window window = this.getWindow();
        if (window != null) {
            Window window2 = window;
            boolean bl = false;
            boolean bl2 = false;
            Window $this$_init__u24lambda_u2d0 = window2;
            boolean bl3 = false;
            $this$_init__u24lambda_u2d0.setFlags(32, 32);
            $this$_init__u24lambda_u2d0.setFlags(262144, 262144);
        }
        this.setupMessageActions();
    }

    private final void setupMessageActions() {
        LinearLayout $this$isVisible$iv;
        StreamDialogMessageMoreactionBinding $this$inflater$iv;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        boolean $i$f$getInflater = false;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)$this$inflater$iv);
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"from(this)");
        $this$inflater$iv = StreamDialogMessageMoreactionBinding.inflate(layoutInflater);
        $i$f$getInflater = false;
        boolean bl = false;
        StreamDialogMessageMoreactionBinding it = $this$inflater$iv;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this.applyButtonsTextStyle(it);
        this.applyButtonsIconTint(it);
        StreamDialogMessageMoreactionBinding streamDialogMessageMoreactionBinding = $this$inflater$iv;
        Intrinsics.checkNotNullExpressionValue((Object)streamDialogMessageMoreactionBinding, (String)"inflate(context.inflater\u2026onsIconTint(it)\n        }");
        StreamDialogMessageMoreactionBinding binding = streamDialogMessageMoreactionBinding;
        streamDialogMessageMoreactionBinding = this.style.getMessageActionButtonsBackground();
        if (streamDialogMessageMoreactionBinding != null) {
            $this$inflater$iv = streamDialogMessageMoreactionBinding;
            $i$f$getInflater = false;
            bl = false;
            StreamDialogMessageMoreactionBinding actionButtonsBackground = $this$inflater$iv;
            boolean bl3 = false;
            binding.messageActionButtons.setBackground((Drawable)actionButtonsBackground);
        }
        this.setContentView((View)binding.getRoot());
        this.setCanceledOnTouchOutside(true);
        streamDialogMessageMoreactionBinding = binding.startThreadButton;
        Intrinsics.checkNotNullExpressionValue((Object)streamDialogMessageMoreactionBinding, (String)"binding.startThreadButton");
        streamDialogMessageMoreactionBinding = (View)streamDialogMessageMoreactionBinding;
        boolean value$iv = this.canThreadOnMessage();
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        $this$isVisible$iv = binding.copyMessageButton;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.copyMessageButton");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv = this.canCopyOnMessage();
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        if (this.isMessageNotCreatedByCurrentUser()) {
            binding.editMessageButton.setVisibility(8);
            binding.deleteMessageButton.setVisibility(8);
            binding.flagMessageButton.setOnClickListener(arg_0 -> MessageMoreActionDialog.setupMessageActions$lambda-3(this, arg_0));
            $this$isVisible$iv = binding.flagMessageButton;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.flagMessageButton");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = this.style.getFlagMessageActionEnabled();
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        } else {
            binding.flagMessageButton.setVisibility(8);
            binding.editMessageButton.setOnClickListener(arg_0 -> MessageMoreActionDialog.setupMessageActions$lambda-4(this, arg_0));
            binding.deleteMessageButton.setOnClickListener(arg_0 -> MessageMoreActionDialog.setupMessageActions$lambda-5(this, arg_0));
            $this$isVisible$iv = binding.editMessageButton;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.editMessageButton");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = this.style.getEditMessageActionEnabled();
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
            $this$isVisible$iv = binding.deleteMessageButton;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.deleteMessageButton");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = this.style.getDeleteMessageActionEnabled();
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        }
        if (this.canReactOnMessage()) {
            binding.reactionsContainer.setBackground(new DrawableBuilder().rectangle().solidColor(this.style.getReactionInputBgColor()).cornerRadii(binding.reactionsContainer.getHeight() / 2, binding.reactionsContainer.getHeight() / 2, 0, 0).build());
            binding.reactionsRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
            ReactionDialogAdapter reactionAdapter = new ReactionDialogAdapter(this.message, this.style, arg_0 -> MessageMoreActionDialog.setupMessageActions$lambda-6(this, arg_0));
            binding.reactionsRecyclerView.setAdapter((RecyclerView.Adapter)reactionAdapter);
        } else {
            binding.reactionsContainer.setVisibility(8);
        }
        streamDialogMessageMoreactionBinding = binding.startThreadButton;
        boolean bl4 = false;
        boolean bl5 = false;
        StreamDialogMessageMoreactionBinding $this$setupMessageActions_u24lambda_u2d8 = streamDialogMessageMoreactionBinding;
        boolean bl6 = false;
        boolean enabled = this.style.getStartThreadMessageActionEnabled();
        Intrinsics.checkNotNullExpressionValue((Object)$this$setupMessageActions_u24lambda_u2d8, (String)"");
        View $this$isVisible$iv2 = (View)$this$setupMessageActions_u24lambda_u2d8;
        boolean $i$f$setVisible2 = false;
        $this$isVisible$iv2.setVisibility(enabled ? 0 : 8);
        if (enabled) {
            $this$setupMessageActions_u24lambda_u2d8.setOnClickListener(arg_0 -> MessageMoreActionDialog.setupMessageActions$lambda-8$lambda-7(this, arg_0));
        }
        streamDialogMessageMoreactionBinding = binding.copyMessageButton;
        bl4 = false;
        bl5 = false;
        StreamDialogMessageMoreactionBinding $this$setupMessageActions_u24lambda_u2d10 = streamDialogMessageMoreactionBinding;
        boolean bl7 = false;
        enabled = this.style.getCopyMessageActionEnabled();
        Intrinsics.checkNotNullExpressionValue((Object)$this$setupMessageActions_u24lambda_u2d10, (String)"");
        $this$isVisible$iv2 = (View)$this$setupMessageActions_u24lambda_u2d10;
        $i$f$setVisible2 = false;
        $this$isVisible$iv2.setVisibility(enabled ? 0 : 8);
        if (enabled) {
            $this$setupMessageActions_u24lambda_u2d10.setOnClickListener(arg_0 -> MessageMoreActionDialog.setupMessageActions$lambda-10$lambda-9((LinearLayout)$this$setupMessageActions_u24lambda_u2d10, this, arg_0));
        }
    }

    private final void applyButtonsTextStyle(StreamDialogMessageMoreactionBinding binding) {
        TextStyle textStyle = this.style.getMessageActionButtonsTextStyle();
        boolean bl = false;
        boolean bl2 = false;
        TextStyle textStyle2 = textStyle;
        boolean bl3 = false;
        StreamDialogMessageMoreactionBinding streamDialogMessageMoreactionBinding = binding;
        boolean bl4 = false;
        boolean bl5 = false;
        StreamDialogMessageMoreactionBinding $this$applyButtonsTextStyle_u24lambda_u2d12_u24lambda_u2d11 = streamDialogMessageMoreactionBinding;
        boolean bl6 = false;
        TextView textView = $this$applyButtonsTextStyle_u24lambda_u2d12_u24lambda_u2d11.startThreadButtonTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"startThreadButtonTextView");
        textStyle2.apply(textView);
        textView = $this$applyButtonsTextStyle_u24lambda_u2d12_u24lambda_u2d11.copyMessageButtonTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"copyMessageButtonTextView");
        textStyle2.apply(textView);
        textView = $this$applyButtonsTextStyle_u24lambda_u2d12_u24lambda_u2d11.flagMessageButtonTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"flagMessageButtonTextView");
        textStyle2.apply(textView);
        textView = $this$applyButtonsTextStyle_u24lambda_u2d12_u24lambda_u2d11.editMessageButtonTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"editMessageButtonTextView");
        textStyle2.apply(textView);
        textView = $this$applyButtonsTextStyle_u24lambda_u2d12_u24lambda_u2d11.deleteMessageButtonTextView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"deleteMessageButtonTextView");
        textStyle2.apply(textView);
    }

    private final void applyButtonsIconTint(StreamDialogMessageMoreactionBinding binding) {
        ColorStateList colorStateList = this.style.getMessageActionButtonsIconTint();
        boolean bl = false;
        boolean bl2 = false;
        ColorStateList tint = colorStateList;
        boolean bl3 = false;
        StreamDialogMessageMoreactionBinding streamDialogMessageMoreactionBinding = binding;
        boolean bl4 = false;
        boolean bl5 = false;
        StreamDialogMessageMoreactionBinding $this$applyButtonsIconTint_u24lambda_u2d14_u24lambda_u2d13 = streamDialogMessageMoreactionBinding;
        boolean bl6 = false;
        $this$applyButtonsIconTint_u24lambda_u2d14_u24lambda_u2d13.startThreadButtonImageView.setImageTintList(tint);
        $this$applyButtonsIconTint_u24lambda_u2d14_u24lambda_u2d13.copyMessageButtonImageView.setImageTintList(tint);
        $this$applyButtonsIconTint_u24lambda_u2d14_u24lambda_u2d13.flagMessageButtonImageView.setImageTintList(tint);
        $this$applyButtonsIconTint_u24lambda_u2d14_u24lambda_u2d13.editMessageButtonImageView.setImageTintList(tint);
        $this$applyButtonsIconTint_u24lambda_u2d14_u24lambda_u2d13.deleteMessageButtonImageView.setImageTintList(tint);
    }

    private final boolean isMessageNotCreatedByCurrentUser() {
        return !Intrinsics.areEqual((Object)this.message.getUser().getId(), (Object)this.currentUser.getId());
    }

    private final boolean canCopyOnMessage() {
        return this.message.getDeletedAt() == null && !Intrinsics.areEqual((Object)this.message.getType(), (Object)"error") && !Intrinsics.areEqual((Object)this.message.getType(), (Object)"ephemeral") && !TextUtils.isEmpty((CharSequence)this.message.getText());
    }

    private final boolean canThreadOnMessage() {
        return this.style.isThreadEnabled() && this.channel.getConfig().isThreadEnabled() && this.message.getParentId() == null;
    }

    private final boolean canReactOnMessage() {
        return this.style.isReactionEnabled() && this.channel.getConfig().isReactionsEnabled();
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.dismiss();
        return true;
    }

    private static final void setupMessageActions$lambda-3(MessageMoreActionDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onMessageFlagHandler.invoke((Object)this$0.message);
        this$0.dismiss();
    }

    private static final void setupMessageActions$lambda-4(MessageMoreActionDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onMessageEditHandler.invoke((Object)this$0.message);
        this$0.dismiss();
    }

    private static final void setupMessageActions$lambda-5(MessageMoreActionDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onMessageDeleteHandler.invoke((Object)this$0.message);
        this$0.dismiss();
    }

    private static final void setupMessageActions$lambda-6(MessageMoreActionDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.dismiss();
    }

    private static final void setupMessageActions$lambda-8$lambda-7(MessageMoreActionDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        this$0.onStartThreadHandler.invoke((Object)this$0.message);
        this$0.dismiss();
    }

    private static final void setupMessageActions$lambda-10$lambda-9(LinearLayout $this_apply, MessageMoreActionDialog this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object object = $this_apply.getContext().getSystemService("clipboard");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.content.ClipboardManager");
        }
        ClipboardManager clipboard = (ClipboardManager)object;
        ClipData clip = ClipData.newPlainText((CharSequence)"label", (CharSequence)this$0.message.getText());
        clipboard.setPrimaryClip(clip);
        this$0.dismiss();
    }
}

