/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat;

import android.content.Context;
import com.getstream.sdk.chat.ChatMarkdown;
import com.getstream.sdk.chat.ChatMarkdownImpl;
import com.getstream.sdk.chat.UrlSigner;
import com.getstream.sdk.chat.images.ImageHeadersProvider;
import com.getstream.sdk.chat.images.StreamImageLoader;
import com.getstream.sdk.chat.navigation.ChatNavigationHandler;
import com.getstream.sdk.chat.navigation.ChatNavigator;
import com.getstream.sdk.chat.navigation.ChatNavigatorImpl;
import com.getstream.sdk.chat.style.ChatFonts;
import com.getstream.sdk.chat.style.ChatFontsImpl;
import com.getstream.sdk.chat.style.ChatStyle;
import com.getstream.sdk.chat.utils.strings.ChatStrings;
import com.getstream.sdk.chat.utils.strings.ChatStringsImpl;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.header.VersionPrefixHeader;
import io.getstream.chat.android.livedata.ChatDomain;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lcom/getstream/sdk/chat/ChatUI;", "", "fonts", "Lcom/getstream/sdk/chat/style/ChatFonts;", "strings", "Lcom/getstream/sdk/chat/utils/strings/ChatStrings;", "navigator", "Lcom/getstream/sdk/chat/navigation/ChatNavigator;", "markdown", "Lcom/getstream/sdk/chat/ChatMarkdown;", "urlSigner", "Lcom/getstream/sdk/chat/UrlSigner;", "(Lcom/getstream/sdk/chat/style/ChatFonts;Lcom/getstream/sdk/chat/utils/strings/ChatStrings;Lcom/getstream/sdk/chat/navigation/ChatNavigator;Lcom/getstream/sdk/chat/ChatMarkdown;Lcom/getstream/sdk/chat/UrlSigner;)V", "getFonts", "()Lcom/getstream/sdk/chat/style/ChatFonts;", "getMarkdown", "()Lcom/getstream/sdk/chat/ChatMarkdown;", "getNavigator", "()Lcom/getstream/sdk/chat/navigation/ChatNavigator;", "getStrings", "()Lcom/getstream/sdk/chat/utils/strings/ChatStrings;", "getUrlSigner", "()Lcom/getstream/sdk/chat/UrlSigner;", "version", "", "getVersion", "()Ljava/lang/String;", "Builder", "Companion", "stream-chat-android_release"})
public final class ChatUI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChatFonts fonts;
    @NotNull
    private final ChatStrings strings;
    @NotNull
    private final ChatNavigator navigator;
    @NotNull
    private final ChatMarkdown markdown;
    @NotNull
    private final UrlSigner urlSigner;
    @Nullable
    private static ChatUI instance;

    public ChatUI(@NotNull ChatFonts fonts, @NotNull ChatStrings strings, @NotNull ChatNavigator navigator, @NotNull ChatMarkdown markdown, @NotNull UrlSigner urlSigner) {
        Intrinsics.checkNotNullParameter((Object)fonts, (String)"fonts");
        Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
        Intrinsics.checkNotNullParameter((Object)navigator, (String)"navigator");
        Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
        Intrinsics.checkNotNullParameter((Object)urlSigner, (String)"urlSigner");
        this.fonts = fonts;
        this.strings = strings;
        this.navigator = navigator;
        this.markdown = markdown;
        this.urlSigner = urlSigner;
    }

    @NotNull
    public final ChatFonts getFonts() {
        return this.fonts;
    }

    @NotNull
    public final ChatStrings getStrings() {
        return this.strings;
    }

    @NotNull
    public final ChatNavigator getNavigator() {
        return this.navigator;
    }

    @NotNull
    public final ChatMarkdown getMarkdown() {
        return this.markdown;
    }

    @NotNull
    public final UrlSigner getUrlSigner() {
        return this.urlSigner;
    }

    @NotNull
    public final String getVersion() {
        return "release:4.25.0";
    }

    @JvmStatic
    @NotNull
    public static final ChatUI instance() {
        return Companion.instance();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\r\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000fJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/getstream/sdk/chat/ChatUI$Builder;", "", "client", "Lio/getstream/chat/android/client/ChatClient;", "chatDomain", "Lio/getstream/chat/android/livedata/ChatDomain;", "appContext", "Landroid/content/Context;", "(Lio/getstream/chat/android/client/ChatClient;Lio/getstream/chat/android/livedata/ChatDomain;Landroid/content/Context;)V", "(Landroid/content/Context;)V", "fonts", "Lcom/getstream/sdk/chat/style/ChatFonts;", "markdown", "Lcom/getstream/sdk/chat/ChatMarkdown;", "navigationHandler", "Lcom/getstream/sdk/chat/navigation/ChatNavigationHandler;", "strings", "Lcom/getstream/sdk/chat/utils/strings/ChatStrings;", "style", "Lcom/getstream/sdk/chat/style/ChatStyle;", "urlSigner", "Lcom/getstream/sdk/chat/UrlSigner;", "build", "Lcom/getstream/sdk/chat/ChatUI;", "withFonts", "withImageHeadersProvider", "imageHeadersProvider", "Lcom/getstream/sdk/chat/images/ImageHeadersProvider;", "withMarkdown", "withNavigationHandler", "handler", "withStrings", "withStyle", "withUrlSigner", "signer", "stream-chat-android_release"})
    public static final class Builder {
        @NotNull
        private final Context appContext;
        @Nullable
        private ChatStyle style;
        @Nullable
        private ChatNavigationHandler navigationHandler;
        @Nullable
        private UrlSigner urlSigner;
        @Nullable
        private ChatMarkdown markdown;
        @Nullable
        private ChatFonts fonts;
        @Nullable
        private ChatStrings strings;

        public Builder(@NotNull Context appContext) {
            Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
            this.appContext = appContext;
        }

        @Deprecated(message="Deprecated constructor, `ChatClient` and `ChatDomain` is not needed anymore to build a `ChatUI` instance", replaceWith=@ReplaceWith(expression="ChatUI.Builder(appContext)", imports={}), level=DeprecationLevel.ERROR)
        public Builder(@NotNull ChatClient client, @NotNull ChatDomain chatDomain, @NotNull Context appContext) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)chatDomain, (String)"chatDomain");
            Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
            this(appContext);
        }

        @NotNull
        public final Builder withStyle(@NotNull ChatStyle style) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            Builder $this$withStyle_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$withStyle_u24lambda_u2d0.style = style;
            return builder;
        }

        @NotNull
        public final Builder withMarkdown(@NotNull ChatMarkdown markdown) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)markdown, (String)"markdown");
            Builder $this$withMarkdown_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$withMarkdown_u24lambda_u2d1.markdown = markdown;
            return builder;
        }

        @NotNull
        public final Builder withUrlSigner(@NotNull UrlSigner signer) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)signer, (String)"signer");
            Builder $this$withUrlSigner_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$withUrlSigner_u24lambda_u2d2.urlSigner = signer;
            return builder;
        }

        @NotNull
        public final Builder withNavigationHandler(@NotNull ChatNavigationHandler handler) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Builder $this$withNavigationHandler_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$withNavigationHandler_u24lambda_u2d3.navigationHandler = handler;
            return builder;
        }

        @NotNull
        public final Builder withFonts(@NotNull ChatFonts fonts) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)fonts, (String)"fonts");
            Builder $this$withFonts_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$withFonts_u24lambda_u2d4.fonts = fonts;
            return builder;
        }

        @NotNull
        public final Builder withStrings(@NotNull ChatStrings strings) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)strings, (String)"strings");
            Builder $this$withStrings_u24lambda_u2d5 = builder = this;
            boolean bl = false;
            $this$withStrings_u24lambda_u2d5.strings = strings;
            return builder;
        }

        @NotNull
        public final Builder withImageHeadersProvider(@NotNull ImageHeadersProvider imageHeadersProvider) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)imageHeadersProvider, (String)"imageHeadersProvider");
            Builder $this$withImageHeadersProvider_u24lambda_u2d6 = builder = this;
            boolean bl = false;
            StreamImageLoader.Companion.instance().setImageHeadersProvider(imageHeadersProvider);
            return builder;
        }

        @NotNull
        public final ChatUI build() {
            Object object = this.style;
            ChatStyle chatStyle = object == null ? new ChatStyle.Builder().build() : object;
            object = this.fonts;
            Object object2 = object == null ? (ChatFonts)new ChatFontsImpl(chatStyle, this.appContext) : object;
            object = this.strings;
            Object object3 = object == null ? (ChatStrings)new ChatStringsImpl(this.appContext) : object;
            object = this.navigationHandler;
            ChatNavigator chatNavigator = new ChatNavigatorImpl((ChatNavigationHandler)(object == null ? ChatNavigatorImpl.EMPTY_HANDLER : object));
            object = this.markdown;
            Object object4 = object == null ? (ChatMarkdown)new ChatMarkdownImpl(this.appContext) : object;
            object = this.urlSigner;
            instance = new ChatUI((ChatFonts)object2, (ChatStrings)object3, chatNavigator, (ChatMarkdown)object4, (UrlSigner)(object == null ? (UrlSigner)new UrlSigner.DefaultUrlSigner() : object));
            ChatClient.Companion.setVERSION_PREFIX_HEADER(VersionPrefixHeader.OLD_UI_COMPONENTS);
            return Companion.instance();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/getstream/sdk/chat/ChatUI$Companion;", "", "()V", "instance", "Lcom/getstream/sdk/chat/ChatUI;", "stream-chat-android_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ChatUI instance() {
            ChatUI chatUI = instance;
            if (chatUI == null) {
                boolean bl = false;
                String string2 = "Be sure to call ChatUI.Builder().build() before using ChatUI.instance()";
                throw new IllegalStateException(string2.toString());
            }
            return chatUI;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

