/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.attachment;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.AttachmentListItem;
import com.getstream.sdk.chat.adapter.FileAttachmentSelectedAdapter;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.viewholder.attachment.BaseAttachmentViewHolder;
import com.getstream.sdk.chat.databinding.StreamItemAttachMediaBinding;
import com.getstream.sdk.chat.databinding.StreamItemAttachmentBinding;
import com.getstream.sdk.chat.images.ViewExtensionsKt;
import com.getstream.sdk.chat.model.AttachmentMetaData;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.view.MessageListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u0018H\u0002J\b\u0010 \u001a\u00020\u0018H\u0002J\b\u0010!\u001a\u00020\u0018H\u0002J\b\u0010\"\u001a\u00020\u0018H\u0002J\b\u0010#\u001a\u00020\u0018H\u0002R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/attachment/AttachmentViewHolder;", "Lcom/getstream/sdk/chat/adapter/viewholder/attachment/BaseAttachmentViewHolder;", "parent", "Landroid/view/ViewGroup;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "bubbleHelper", "Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;", "messageItem", "Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;", "clickListener", "Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;", "longClickListener", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;", "longClickListenerView", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListenerView;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemAttachmentBinding;", "(Landroid/view/ViewGroup;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListenerView;Lcom/getstream/sdk/chat/databinding/StreamItemAttachmentBinding;)V", "attachment", "Lio/getstream/chat/android/client/models/Attachment;", "mediaBinding", "Lcom/getstream/sdk/chat/databinding/StreamItemAttachMediaBinding;", "applyStyle", "", "bind", "attachmentListItem", "Lcom/getstream/sdk/chat/adapter/AttachmentListItem;", "configAttachViewBackground", "view", "Landroid/view/View;", "configAttachment", "configClickListeners", "configFileAttach", "configImageThumbBackground", "configMediaAttach", "stream-chat-android_release"})
public final class AttachmentViewHolder
extends BaseAttachmentViewHolder {
    @NotNull
    private final MessageListViewStyle style;
    @NotNull
    private final MessageListView.BubbleHelper bubbleHelper;
    @NotNull
    private final MessageListItem.MessageItem messageItem;
    @NotNull
    private final MessageListView.AttachmentClickListener clickListener;
    @Nullable
    private final MessageListView.MessageLongClickListener longClickListener;
    @Nullable
    private final MessageListView.MessageLongClickListenerView longClickListenerView;
    @NotNull
    private final StreamItemAttachmentBinding binding;
    @NotNull
    private final StreamItemAttachMediaBinding mediaBinding;
    private Attachment attachment;

    public AttachmentViewHolder(@NotNull ViewGroup parent, @NotNull MessageListViewStyle style, @NotNull MessageListView.BubbleHelper bubbleHelper, @NotNull MessageListItem.MessageItem messageItem, @NotNull MessageListView.AttachmentClickListener clickListener2, @Nullable MessageListView.MessageLongClickListener longClickListener, @Nullable MessageListView.MessageLongClickListenerView longClickListenerView, @NotNull StreamItemAttachmentBinding binding) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)bubbleHelper, (String)"bubbleHelper");
        Intrinsics.checkNotNullParameter((Object)messageItem, (String)"messageItem");
        Intrinsics.checkNotNullParameter((Object)clickListener2, (String)"clickListener");
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Object object = binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.root");
        super((View)object);
        this.style = style;
        this.bubbleHelper = bubbleHelper;
        this.messageItem = messageItem;
        this.clickListener = clickListener2;
        this.longClickListener = longClickListener;
        this.longClickListenerView = longClickListenerView;
        this.binding = binding;
        object = this.binding.clAttachmentMedia;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"binding.clAttachmentMedia");
        this.mediaBinding = object;
        this.mediaBinding.tvMediaDes.setMaxLines(this.style.getAttachmentPreviewMaxLines());
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ AttachmentViewHolder(ViewGroup viewGroup, MessageListViewStyle messageListViewStyle, MessageListView.BubbleHelper bubbleHelper, MessageListItem.MessageItem messageItem, MessageListView.AttachmentClickListener attachmentClickListener2, MessageListView.MessageLongClickListener messageLongClickListener2, MessageListView.MessageLongClickListenerView messageLongClickListenerView, StreamItemAttachmentBinding streamItemAttachmentBinding, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            messageLongClickListener2 = null;
        }
        if ((n & 0x40) != 0) {
            messageLongClickListenerView = null;
        }
        if ((n & 0x80) != 0) {
            void $this$inflater$iv;
            ViewGroup viewGroup2 = viewGroup;
            boolean $i$f$getInflater = false;
            LayoutInflater layoutInflater = LayoutInflater.from((Context)$this$inflater$iv.getContext());
            Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"from(context)");
            StreamItemAttachmentBinding streamItemAttachmentBinding2 = StreamItemAttachmentBinding.inflate(layoutInflater, viewGroup, false);
            Intrinsics.checkNotNullExpressionValue((Object)streamItemAttachmentBinding2, (String)"class AttachmentViewHold\u2026ts.size\n        }\n    }\n}");
            streamItemAttachmentBinding = streamItemAttachmentBinding2;
        }
        this(viewGroup, messageListViewStyle, bubbleHelper, messageItem, attachmentClickListener2, messageLongClickListener2, messageLongClickListenerView, streamItemAttachmentBinding);
    }

    @Override
    public void bind(@NotNull AttachmentListItem attachmentListItem) {
        Intrinsics.checkNotNullParameter((Object)attachmentListItem, (String)"attachmentListItem");
        this.attachment = attachmentListItem.getAttachment();
        this.applyStyle();
        this.configAttachment();
    }

    private final void applyStyle() {
        if (this.messageItem.isMine()) {
            TextStyle textStyle = this.style.getAttachmentTitleTextMine();
            TextView textView = this.mediaBinding.tvMediaTitle;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"mediaBinding.tvMediaTitle");
            textStyle.apply(textView);
            TextStyle textStyle2 = this.style.getAttachmentDescriptionTextMine();
            textView = this.mediaBinding.tvMediaDes;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"mediaBinding.tvMediaDes");
            textStyle2.apply(textView);
        } else {
            TextStyle textStyle = this.style.getAttachmentTitleTextTheirs();
            TextView textView = this.mediaBinding.tvMediaTitle;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"mediaBinding.tvMediaTitle");
            textStyle.apply(textView);
            TextStyle textStyle3 = this.style.getAttachmentDescriptionTextTheirs();
            textView = this.mediaBinding.tvMediaDes;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"mediaBinding.tvMediaDes");
            textStyle3.apply(textView);
        }
    }

    private final void configAttachment() {
        Object $this$isVisible$iv;
        boolean $i$f$setVisible;
        boolean value$iv;
        boolean hasFile = false;
        boolean hasMedia = false;
        for (Attachment attachment : this.messageItem.getMessage().getAttachments()) {
            if (attachment.getType() == null) continue;
            if (Intrinsics.areEqual((Object)attachment.getType(), (Object)"file")) {
                hasFile = true;
                continue;
            }
            hasMedia = true;
        }
        if (hasMedia) {
            ConstraintLayout constraintLayout = this.mediaBinding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"mediaBinding.root");
            constraintLayout = (View)constraintLayout;
            value$iv = true;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(0);
            this.configMediaAttach();
        } else {
            $this$isVisible$iv = this.mediaBinding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.root");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = false;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
        }
        if (hasFile) {
            $this$isVisible$iv = this.binding.lvAttachmentFile;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.lvAttachmentFile");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = true;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(0);
            this.configFileAttach();
        } else {
            $this$isVisible$iv = this.binding.lvAttachmentFile;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"binding.lvAttachmentFile");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = false;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
        }
        if (!hasMedia && !hasFile) {
            Object object;
            ConstraintLayout constraintLayout;
            $this$isVisible$iv = this.mediaBinding.ivMediaThumb;
            Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.ivMediaThumb");
            $this$isVisible$iv = (View)$this$isVisible$iv;
            value$iv = false;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
            $this$isVisible$iv = this.attachment;
            if ($this$isVisible$iv == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                constraintLayout = null;
            } else {
                constraintLayout = $this$isVisible$iv;
            }
            $this$isVisible$iv = constraintLayout.getTitle();
            if (!($this$isVisible$iv == null || $this$isVisible$iv.length() == 0)) {
                Object object2;
                $this$isVisible$iv = this.mediaBinding.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.root");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = true;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                $this$isVisible$iv = this.mediaBinding.tvMediaTitle;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaTitle");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = true;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                TextView textView = this.mediaBinding.tvMediaTitle;
                $this$isVisible$iv = this.attachment;
                if ($this$isVisible$iv == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                    object2 = null;
                } else {
                    object2 = $this$isVisible$iv;
                }
                textView.setText((CharSequence)object2.getTitle());
            } else {
                $this$isVisible$iv = this.mediaBinding.tvMediaTitle;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaTitle");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = false;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(8);
            }
            $this$isVisible$iv = this.attachment;
            if ($this$isVisible$iv == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                object = null;
            } else {
                object = $this$isVisible$iv;
            }
            $this$isVisible$iv = object.getText();
            if (!($this$isVisible$iv == null || $this$isVisible$iv.length() == 0)) {
                Object object3;
                $this$isVisible$iv = this.mediaBinding.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.root");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = true;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                $this$isVisible$iv = this.mediaBinding.tvMediaDes;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaDes");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = true;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                TextView textView = this.mediaBinding.tvMediaDes;
                $this$isVisible$iv = this.attachment;
                if ($this$isVisible$iv == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                    object3 = null;
                } else {
                    object3 = $this$isVisible$iv;
                }
                textView.setText((CharSequence)object3.getText());
            } else {
                $this$isVisible$iv = this.mediaBinding.tvMediaDes;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaDes");
                $this$isVisible$iv = (View)$this$isVisible$iv;
                value$iv = false;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(8);
            }
        }
    }

    private final void configMediaAttach() {
        ConstraintLayout $this$isVisible$iv;
        Object element$iv;
        Object object;
        block12: {
            Iterable $this$first$iv = this.messageItem.getMessage().getAttachments();
            boolean $i$f$first = false;
            object = $this$first$iv.iterator();
            while (object.hasNext()) {
                element$iv = object.next();
                Attachment it = (Attachment)element$iv;
                boolean bl = false;
                if (!(!Intrinsics.areEqual((Object)it.getType(), (Object)"file"))) continue;
                break block12;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Attachment firstAttachment = (Attachment)element$iv;
        String type = firstAttachment.getType();
        String attachUrl = firstAttachment.getImageUrl();
        if (type != null) {
            if (Intrinsics.areEqual((Object)"image", (Object)type)) {
                attachUrl = firstAttachment.getImageUrl();
            } else if (Intrinsics.areEqual((Object)"giphy", (Object)type)) {
                attachUrl = firstAttachment.getThumbUrl();
            } else if (Intrinsics.areEqual((Object)"video", (Object)type)) {
                attachUrl = firstAttachment.getThumbUrl();
            } else if (attachUrl == null) {
                attachUrl = firstAttachment.getImage();
            }
        }
        if ((object = (CharSequence)attachUrl) == null || object.length() == 0) {
            object = this.mediaBinding.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"mediaBinding.root");
            object = (View)object;
            boolean value$iv = false;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
            return;
        }
        $this$isVisible$iv = this.mediaBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.root");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        boolean value$iv322 = true;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        $this$isVisible$iv = this.mediaBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.root");
        this.configAttachViewBackground((View)$this$isVisible$iv);
        this.configImageThumbBackground();
        this.configClickListeners();
        if (!StringsKt.contains$default((CharSequence)attachUrl, (CharSequence)"https:", (boolean)false, (int)2, null)) {
            attachUrl = Intrinsics.stringPlus((String)"https:", (Object)attachUrl);
        }
        $this$isVisible$iv = this.mediaBinding.ivMediaThumb;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.ivMediaThumb");
        ViewExtensionsKt.load$default((ImageView)((ImageView)$this$isVisible$iv), (Object)ChatUI.Companion.instance().getUrlSigner().signImageUrl(attachUrl), null, null, null, null, (int)30, null);
        if (!Intrinsics.areEqual((Object)this.messageItem.getMessage().getType(), (Object)"ephemeral")) {
            this.mediaBinding.tvMediaTitle.setText((CharSequence)firstAttachment.getTitle());
        }
        this.mediaBinding.tvMediaDes.setText((CharSequence)firstAttachment.getText());
        $this$isVisible$iv = this.mediaBinding.tvMediaDes;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaDes");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        CharSequence value$iv322 = firstAttachment.getText();
        boolean value$iv322 = !(value$iv322 == null || value$iv322.length() == 0);
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv322 ? 0 : 8);
        $this$isVisible$iv = this.mediaBinding.tvMediaTitle;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaTitle");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        CharSequence value$iv22 = firstAttachment.getTitle();
        boolean value$iv22 = !(value$iv22 == null || value$iv22.length() == 0);
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv22 ? 0 : 8);
        $this$isVisible$iv = this.mediaBinding.tvMediaPlay;
        Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaPlay");
        $this$isVisible$iv = (View)$this$isVisible$iv;
        value$iv22 = Intrinsics.areEqual((Object)type, (Object)"video");
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv22 ? 0 : 8);
    }

    private final void configAttachViewBackground(View view) {
        int messageBubbleDrawableRes = this.style.getMessageBubbleDrawable(this.messageItem.isMine());
        if (messageBubbleDrawableRes != -1) {
            view.setBackground(this.getContext().getDrawable(messageBubbleDrawableRes));
        }
    }

    private final void configImageThumbBackground() {
        block6: {
            Drawable background;
            block5: {
                Attachment attachment;
                Message message = this.messageItem.getMessage();
                boolean bl = this.messageItem.isMine();
                List list = this.messageItem.getPositions();
                Attachment attachment2 = this.attachment;
                if (attachment2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
                    attachment = null;
                } else {
                    attachment = attachment2;
                }
                background = this.bubbleHelper.getDrawableForAttachment(message, bl, list, attachment);
                this.mediaBinding.ivMediaThumb.setShape(this.getContext(), background);
                attachment2 = this.mediaBinding.tvMediaDes;
                Intrinsics.checkNotNullExpressionValue((Object)attachment2, (String)"mediaBinding.tvMediaDes");
                View $this$isVisible$iv = (View)attachment2;
                boolean $i$f$isVisible = false;
                if ($this$isVisible$iv.getVisibility() == 0) break block5;
                $this$isVisible$iv = this.mediaBinding.tvMediaTitle;
                Intrinsics.checkNotNullExpressionValue((Object)$this$isVisible$iv, (String)"mediaBinding.tvMediaTitle");
                $i$f$isVisible = false;
                if (!($this$isVisible$iv.getVisibility() == 0)) break block6;
            }
            background = this.bubbleHelper.getDrawableForAttachmentDescription(this.messageItem.getMessage(), this.messageItem.isMine(), this.messageItem.getPositions());
            this.mediaBinding.clDes.setBackground(background);
        }
    }

    private final void configClickListeners() {
        this.mediaBinding.getRoot().setOnClickListener(arg_0 -> AttachmentViewHolder.configClickListeners$lambda-1(this, arg_0));
        this.mediaBinding.getRoot().setOnLongClickListener(arg_0 -> AttachmentViewHolder.configClickListeners$lambda-2(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void configFileAttach() {
        Collection<AttachmentMetaData> collection;
        void $this$mapTo$iv$iv;
        ListView $this$map$iv;
        Attachment it;
        void $this$filterTo$iv$iv;
        ListView listView = this.binding.lvAttachmentFile;
        Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"binding.lvAttachmentFile");
        this.configAttachViewBackground((View)listView);
        Iterable $this$filter$iv = this.messageItem.getMessage().getAttachments();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Attachment)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)"file")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List attachments2 = (List)destination$iv$iv;
        $this$filter$iv = attachments2;
        ListView listView2 = this.binding.lvAttachmentFile;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Attachment)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            AttachmentMetaData attachmentMetaData = new AttachmentMetaData(it);
            collection.add(attachmentMetaData);
        }
        collection = (List)destination$iv$iv;
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        Function1 function1 = null;
        boolean bl = false;
        List list = collection;
        listView2.setAdapter((ListAdapter)new FileAttachmentSelectedAdapter(list, bl, function1, n, defaultConstructorMarker));
        this.binding.lvAttachmentFile.setOnItemClickListener((arg_0, arg_1, arg_2, arg_3) -> AttachmentViewHolder.configFileAttach$lambda-5(this, arg_0, arg_1, arg_2, arg_3));
        this.binding.lvAttachmentFile.setOnItemLongClickListener((arg_0, arg_1, arg_2, arg_3) -> AttachmentViewHolder.configFileAttach$lambda-6(this, arg_0, arg_1, arg_2, arg_3));
        $this$map$iv = this.binding.lvAttachmentFile;
        Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"binding.lvAttachmentFile");
        View $this$updateLayoutParams$iv = (View)$this$map$iv;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams);
        ConstraintLayout.LayoutParams $this$configFileAttach_u24lambda_u2d7 = (ConstraintLayout.LayoutParams)params$iv;
        boolean bl2 = false;
        float fileHeight = this.getContext().getResources().getDimension(R.dimen.stream_attach_file_height);
        $this$configFileAttach_u24lambda_u2d7.height = (int)fileHeight * attachments2.size();
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
    }

    private static final void configClickListeners$lambda-1(AttachmentViewHolder this$0, View it) {
        Attachment attachment;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        MessageListView.AttachmentClickListener attachmentClickListener2 = this$0.clickListener;
        Message message = this$0.messageItem.getMessage();
        Attachment attachment2 = this$0.attachment;
        if (attachment2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            attachment = null;
        } else {
            attachment = attachment2;
        }
        attachmentClickListener2.onAttachmentClick(message, attachment);
    }

    private static final boolean configClickListeners$lambda-2(AttachmentViewHolder this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.longClickListenerView != null) {
            MessageListView.MessageLongClickListenerView messageLongClickListenerView = this$0.longClickListenerView;
            Message message = this$0.messageItem.getMessage();
            View view = this$0.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
            messageLongClickListenerView.onMessageLongClick2(message, view);
        } else {
            MessageListView.MessageLongClickListener messageLongClickListener2 = this$0.longClickListener;
            if (messageLongClickListener2 != null) {
                messageLongClickListener2.onMessageLongClick(this$0.messageItem.getMessage());
            }
        }
        return true;
    }

    private static final void configFileAttach$lambda-5(AttachmentViewHolder this$0, AdapterView $noName_0, View $noName_1, int $noName_2, long $noName_3) {
        Attachment attachment;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        MessageListView.AttachmentClickListener attachmentClickListener2 = this$0.clickListener;
        Message message = this$0.messageItem.getMessage();
        Attachment attachment2 = this$0.attachment;
        if (attachment2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachment");
            attachment = null;
        } else {
            attachment = attachment2;
        }
        attachmentClickListener2.onAttachmentClick(message, attachment);
    }

    private static final boolean configFileAttach$lambda-6(AttachmentViewHolder this$0, AdapterView $noName_0, View $noName_1, int $noName_2, long $noName_3) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        if (this$0.longClickListenerView != null) {
            MessageListView.MessageLongClickListenerView messageLongClickListenerView = this$0.longClickListenerView;
            Message message = this$0.messageItem.getMessage();
            View view = this$0.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
            messageLongClickListenerView.onMessageLongClick2(message, view);
        } else {
            MessageListView.MessageLongClickListener messageLongClickListener2 = this$0.longClickListener;
            if (messageLongClickListener2 != null) {
                messageLongClickListener2.onMessageLongClick(this$0.messageItem.getMessage());
            }
        }
        return true;
    }
}

