/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.viewmodel;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelKt;
import com.getstream.sdk.chat.viewmodel.CreateChannelViewModelKt;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.call.CallKt;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.core.internal.coroutines.DispatcherProvider;
import io.getstream.chat.android.livedata.ChatDomain;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0002\u0018\u0019B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel;", "Landroidx/lifecycle/ViewModel;", "domain", "Lio/getstream/chat/android/livedata/ChatDomain;", "client", "Lio/getstream/chat/android/client/ChatClient;", "(Lio/getstream/chat/android/livedata/ChatDomain;Lio/getstream/chat/android/client/ChatClient;)V", "state", "Landroidx/lifecycle/LiveData;", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State;", "getState", "()Landroidx/lifecycle/LiveData;", "stateMerger", "Landroidx/lifecycle/MediatorLiveData;", "onEvent", "", "event", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$Event;", "queryChannel", "channelName", "", "validateChannelName", "", "channelNameCandidate", "Event", "State", "stream-chat-android_release"})
public final class CreateChannelViewModel
extends ViewModel {
    @NotNull
    private final ChatDomain domain;
    @NotNull
    private final ChatClient client;
    @NotNull
    private final MediatorLiveData<State> stateMerger;
    @NotNull
    private final LiveData<State> state;

    @JvmOverloads
    public CreateChannelViewModel(@NotNull ChatDomain domain, @NotNull ChatClient client) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.domain = domain;
        this.client = client;
        this.stateMerger = new MediatorLiveData();
        this.state = (LiveData)this.stateMerger;
    }

    public /* synthetic */ CreateChannelViewModel(ChatDomain chatDomain, ChatClient chatClient, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            chatDomain = ChatDomain.Companion.instance();
        }
        if ((n & 2) != 0) {
            chatClient = ChatClient.Companion.instance();
        }
        this(chatDomain, chatClient);
    }

    @NotNull
    public final LiveData<State> getState() {
        return this.state;
    }

    public final void onEvent(@NotNull Event event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event instanceof Event.ChannelNameSubmitted) {
            CharSequence charSequence = ((Event.ChannelNameSubmitted)event).getChannelName();
            String string2 = " ";
            string2 = new Regex(string2);
            String string3 = "-";
            charSequence = string2.replace(charSequence, string3);
            string2 = ((String)charSequence).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String channelNameCandidate = string2;
            boolean isValidName = this.validateChannelName(channelNameCandidate);
            if (isValidName) {
                this.stateMerger.postValue((Object)State.Loading.INSTANCE);
                this.queryChannel(channelNameCandidate);
            } else {
                this.stateMerger.postValue((Object)State.ValidationError.INSTANCE);
            }
        }
    }

    private final void queryChannel(String channelName) {
        Channel channel;
        User user = this.client.getCurrentUser();
        User author = user == null ? new User(null, null, false, false, null, false, null, null, null, 0, 0, null, null, null, null, Short.MAX_VALUE, null) : user;
        List members = CollectionsKt.listOf((Object)new Member(author, null, null, null, null, null, null, false, 254, null));
        Channel $this$queryChannel_u24lambda_u2d0 = channel = new Channel(null, null, null, 0, false, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, 0, null, 0xFFFFFF, null);
        boolean bl = false;
        $this$queryChannel_u24lambda_u2d0.setCid(Intrinsics.stringPlus((String)"messaging:", (Object)channelName));
        $this$queryChannel_u24lambda_u2d0.setId(channelName);
        $this$queryChannel_u24lambda_u2d0.setType("messaging");
        $this$queryChannel_u24lambda_u2d0.setName(channelName);
        $this$queryChannel_u24lambda_u2d0.setMembers(members);
        $this$queryChannel_u24lambda_u2d0.setCreatedBy(author);
        Channel channel2 = channel;
        BuildersKt.launch$default((CoroutineScope)ViewModelKt.getViewModelScope((ViewModel)this), (CoroutineContext)((CoroutineContext)DispatcherProvider.INSTANCE.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, channel2, null){
            int label;
            final /* synthetic */ CreateChannelViewModel this$0;
            final /* synthetic */ Channel $channel;
            {
                this.this$0 = $receiver;
                this.$channel = $channel;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = CallKt.await((Call)CreateChannelViewModel.access$getDomain$p(this.this$0).createChannel(this.$channel), (Continuation)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        result = (Result)v0;
                        if (result.isSuccess()) {
                            CreateChannelViewModel.access$getStateMerger$p(this.this$0).postValue((Object)State.ChannelCreated.INSTANCE);
                        } else if (result.isError()) {
                            CreateChannelViewModel.access$getStateMerger$p(this.this$0).postValue((Object)State.BackendError.INSTANCE);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean validateChannelName(String channelNameCandidate) {
        CharSequence charSequence = channelNameCandidate;
        if (charSequence.length() <= 0) return false;
        boolean bl = true;
        if (!bl) return false;
        charSequence = channelNameCandidate;
        Regex regex = CreateChannelViewModelKt.access$getCHANNEL_NAME_REGEX$p();
        if (!regex.matches(charSequence)) return false;
        return true;
    }

    @JvmOverloads
    public CreateChannelViewModel(@NotNull ChatDomain domain) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        this(domain, null, 2, null);
    }

    @JvmOverloads
    public CreateChannelViewModel() {
        this(null, null, 3, null);
    }

    public static final /* synthetic */ ChatDomain access$getDomain$p(CreateChannelViewModel $this) {
        return $this.domain;
    }

    public static final /* synthetic */ MediatorLiveData access$getStateMerger$p(CreateChannelViewModel $this) {
        return $this.stateMerger;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State;", "", "()V", "BackendError", "ChannelCreated", "Loading", "ValidationError", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State$Loading;", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State$ChannelCreated;", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State$BackendError;", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State$ValidationError;", "stream-chat-android_release"})
    public static abstract class State {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State$Loading;", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State;", "()V", "stream-chat-android_release"})
        public static final class Loading
        extends State {
            @NotNull
            public static final Loading INSTANCE = new Loading();

            private Loading() {
                super(null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State$ChannelCreated;", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State;", "()V", "stream-chat-android_release"})
        public static final class ChannelCreated
        extends State {
            @NotNull
            public static final ChannelCreated INSTANCE = new ChannelCreated();

            private ChannelCreated() {
                super(null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State$BackendError;", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State;", "()V", "stream-chat-android_release"})
        public static final class BackendError
        extends State {
            @NotNull
            public static final BackendError INSTANCE = new BackendError();

            private BackendError() {
                super(null);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State$ValidationError;", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$State;", "()V", "stream-chat-android_release"})
        public static final class ValidationError
        extends State {
            @NotNull
            public static final ValidationError INSTANCE = new ValidationError();

            private ValidationError() {
                super(null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0001\u0003B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0001\u0004\u00a8\u0006\u0005"}, d2={"Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$Event;", "", "()V", "ChannelNameSubmitted", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$Event$ChannelNameSubmitted;", "stream-chat-android_release"})
    public static abstract class Event {
        private Event() {
        }

        public /* synthetic */ Event(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$Event$ChannelNameSubmitted;", "Lcom/getstream/sdk/chat/viewmodel/CreateChannelViewModel$Event;", "channelName", "", "(Ljava/lang/String;)V", "getChannelName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "stream-chat-android_release"})
        public static final class ChannelNameSubmitted
        extends Event {
            @NotNull
            private final String channelName;

            public ChannelNameSubmitted(@NotNull String channelName) {
                Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
                super(null);
                this.channelName = channelName;
            }

            @NotNull
            public final String getChannelName() {
                return this.channelName;
            }

            @NotNull
            public final String component1() {
                return this.channelName;
            }

            @NotNull
            public final ChannelNameSubmitted copy(@NotNull String channelName) {
                Intrinsics.checkNotNullParameter((Object)channelName, (String)"channelName");
                return new ChannelNameSubmitted(channelName);
            }

            public static /* synthetic */ ChannelNameSubmitted copy$default(ChannelNameSubmitted channelNameSubmitted, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string2 = channelNameSubmitted.channelName;
                }
                return channelNameSubmitted.copy(string2);
            }

            @NotNull
            public String toString() {
                return "ChannelNameSubmitted(channelName=" + this.channelName + ')';
            }

            public int hashCode() {
                return this.channelName.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ChannelNameSubmitted)) {
                    return false;
                }
                ChannelNameSubmitted channelNameSubmitted = (ChannelNameSubmitted)other;
                return Intrinsics.areEqual((Object)this.channelName, (Object)channelNameSubmitted.channelName);
            }
        }
    }
}

