/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat;

import android.content.Context;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.getstream.sdk.chat.Chat;
import com.getstream.sdk.chat.ChatMarkdown;
import com.getstream.sdk.chat.ChatSocketListener;
import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.UrlSigner;
import com.getstream.sdk.chat.enums.OnlineStatus;
import com.getstream.sdk.chat.navigation.ChatNavigationHandler;
import com.getstream.sdk.chat.navigation.ChatNavigator;
import com.getstream.sdk.chat.navigation.ChatNavigatorImpl;
import com.getstream.sdk.chat.style.ChatFonts;
import com.getstream.sdk.chat.utils.strings.ChatStrings;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.errors.ChatError;
import io.getstream.chat.android.client.logger.ChatLogLevel;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.ChatLoggerHandler;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.client.notifications.handler.ChatNotificationHandler;
import io.getstream.chat.android.client.socket.InitConnectionListener;
import io.getstream.chat.android.client.socket.SocketListener;
import io.getstream.chat.android.client.uploader.FileUploader;
import io.getstream.chat.android.livedata.ChatDomain;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineStart;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ChatImpl
implements Chat {
    private final ChatNavigationHandler navigationHandler;
    private MutableLiveData<OnlineStatus> onlineStatus = new MutableLiveData((Object)OnlineStatus.NOT_INITIALIZED);
    private MutableLiveData<Number> unreadMessages = new MutableLiveData();
    private MutableLiveData<Number> unreadChannels = new MutableLiveData();
    private MutableLiveData<User> currentUser = new MutableLiveData();
    private final ChatNavigator navigator;
    private final ChatStrings chatStrings;
    private final ChatFonts chatFonts;
    private final UrlSigner urlSigner;
    private final ChatMarkdown markdown;
    private final String apiKey;
    private final Context context;
    private final boolean offlineEnabled;
    private final ChatNotificationHandler chatNotificationHandler;

    ChatImpl(ChatFonts chatFonts, ChatStrings chatStrings, @Nullable ChatNavigationHandler navigationHandler, UrlSigner urlSigner, ChatMarkdown markdown, String apiKey, Context context, boolean offlineEnabled, ChatNotificationHandler chatNotificationHandler, ChatLogLevel chatLogLevel, @Nullable ChatLoggerHandler chatLoggerHandler, @Nullable FileUploader fileUploader) {
        this.chatStrings = chatStrings;
        this.chatFonts = chatFonts;
        this.navigationHandler = navigationHandler;
        this.urlSigner = urlSigner;
        this.markdown = markdown;
        this.apiKey = apiKey;
        this.context = context;
        this.offlineEnabled = offlineEnabled;
        this.chatNotificationHandler = chatNotificationHandler;
        ChatNavigationHandler chatNavigationHandler = navigationHandler;
        if (chatNavigationHandler == null) {
            chatNavigationHandler = ChatNavigatorImpl.EMPTY_HANDLER;
        }
        this.navigator = new ChatNavigatorImpl(chatNavigationHandler);
        ChatClient.Builder chatBuilder = new ChatClient.Builder(this.apiKey, context).notifications(chatNotificationHandler).logLevel(chatLogLevel);
        if (chatLoggerHandler != null) {
            chatBuilder.loggerHandler(chatLoggerHandler);
        }
        if (fileUploader != null) {
            chatBuilder.fileUploader(fileUploader);
        }
        chatBuilder.build();
        ChatLogger.Companion.getInstance().logI((Object)"Chat", "Initialized: " + this.getVersion());
    }

    @Override
    @NotNull
    public ChatNavigator getNavigator() {
        return this.navigator;
    }

    @Override
    @NotNull
    public LiveData<OnlineStatus> getOnlineStatus() {
        return this.onlineStatus;
    }

    @Override
    @NotNull
    public LiveData<Number> getUnreadMessages() {
        return this.unreadMessages;
    }

    @Override
    @NotNull
    public LiveData<Number> getUnreadChannels() {
        return this.unreadChannels;
    }

    @Override
    @NotNull
    public LiveData<User> getCurrentUser() {
        return this.currentUser;
    }

    @Override
    @NotNull
    public ChatStrings getStrings() {
        return this.chatStrings;
    }

    @Override
    @NotNull
    public UrlSigner urlSigner() {
        return this.urlSigner;
    }

    @Override
    @NotNull
    public ChatFonts getFonts() {
        return this.chatFonts;
    }

    @Override
    @NotNull
    public ChatMarkdown getMarkdown() {
        return this.markdown;
    }

    @Override
    @NotNull
    public String getVersion() {
        return "4.4.3-release";
    }

    @Override
    public void setUser(@NotNull User user, @NotNull String userToken, final @NotNull InitConnectionListener callbacks) {
        ChatClient client = ChatClient.instance();
        client.disconnect();
        this.disconnectChatDomainIfAlreadyInitialized();
        ChatDomain.Builder domainBuilder = new ChatDomain.Builder(this.context, client, user);
        if (this.offlineEnabled) {
            domainBuilder.offlineEnabled();
        }
        ChatDomain domain = domainBuilder.userPresenceEnabled().enableBackgroundSync().notificationConfig(this.chatNotificationHandler.getConfig()).build();
        ChatUI.Builder uiBuilder = new ChatUI.Builder(this.context).withFonts(this.chatFonts).withMarkdown(this.markdown).withUrlSigner(this.urlSigner).withStrings(this.getStrings());
        if (this.navigationHandler != null) {
            uiBuilder.withNavigationHandler(this.navigationHandler);
        }
        uiBuilder.build();
        client.setUser(user, userToken, new InitConnectionListener(){

            public void onSuccess(@NotNull InitConnectionListener.ConnectionData data) {
                callbacks.onSuccess(data);
            }

            public void onError(@NotNull ChatError error) {
                callbacks.onError(error);
            }
        });
        this.init();
    }

    @Override
    public void disconnect() {
        ChatClient.instance().disconnect();
        this.disconnectChatDomainIfAlreadyInitialized();
    }

    private void disconnectChatDomainIfAlreadyInitialized() {
        if (!ChatDomain.Companion.isInitialized()) {
            ChatLogger.Companion.getInstance().logD((Object)"ChatImpl", "ChatDomain was not initialized yet. No need to disconnect.");
            return;
        }
        ChatDomain chatDomain = ChatDomain.instance();
        BuildersKt.launch((CoroutineScope)GlobalScope.INSTANCE, (CoroutineContext)Dispatchers.getIO(), (CoroutineStart)CoroutineStart.DEFAULT, (scope, continuation) -> chatDomain.disconnect(continuation));
    }

    protected void init() {
        this.initSocketListener();
    }

    private void initSocketListener() {
        this.client().addSocketListener((SocketListener)new ChatSocketListener((Function1<? super OnlineStatus, Unit>)((Function1)onlineStatus -> {
            this.onlineStatus.postValue((Object)onlineStatus);
            return Unit.INSTANCE;
        }), (Function1<? super User, Unit>)((Function1)user -> {
            this.currentUser.postValue(user);
            return Unit.INSTANCE;
        }), (Function1<? super Integer, Unit>)((Function1)newUnreadMessages -> {
            this.unreadMessages.postValue(newUnreadMessages);
            return Unit.INSTANCE;
        }), (Function1<? super Integer, Unit>)((Function1)newUnreadChannels -> {
            this.unreadChannels.postValue(newUnreadChannels);
            return Unit.INSTANCE;
        })));
    }

    private ChatClient client() {
        return ChatClient.instance();
    }
}

