/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.view.MessageListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Message;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import top.defaults.drawabletoolbox.DrawableBuilder;

public class DefaultBubbleHelper {
    private static int topLeftRadius;
    private static int topRightRadius;
    private static int bottomRightRadius;
    private static int bottomLeftRadius;
    private static int bgColor;
    private static int strokeColor;
    private static int strokeWidth;

    public static MessageListView.BubbleHelper initDefaultBubbleHelper(final MessageListViewStyle style2, final Context context) {
        return new MessageListView.BubbleHelper(){

            @Override
            @NonNull
            public Drawable getDrawableForMessage(@NotNull Message message, boolean mine, @NotNull List<? extends MessageListItem.Position> positions) {
                if (style2.getMessageBubbleDrawable(mine) != -1) {
                    return ContextCompat.getDrawable((Context)context, (int)style2.getMessageBubbleDrawable(mine));
                }
                DefaultBubbleHelper.configParams(style2, mine, false);
                if (DefaultBubbleHelper.isDefaultBubble(style2, mine, context)) {
                    DefaultBubbleHelper.applyStyleDefault(positions, mine, context);
                }
                if (mine && message.getType().equals("error")) {
                    bgColor = context.getResources().getColor(R.color.stream_message_failed);
                }
                return DefaultBubbleHelper.getBubbleDrawable();
            }

            @Override
            @NotNull
            public Drawable getDrawableForAttachment(@NotNull Message message, boolean mine, @NotNull List<? extends MessageListItem.Position> positions, @NotNull Attachment attachment) {
                if (attachment.getType() == null || attachment.getType().equals("unknown")) {
                    return null;
                }
                if (style2.getMessageBubbleDrawable(mine) != -1) {
                    return ContextCompat.getDrawable((Context)context, (int)style2.getMessageBubbleDrawable(mine));
                }
                DefaultBubbleHelper.configParams(style2, mine, true);
                if (DefaultBubbleHelper.isDefaultBubble(style2, mine, context)) {
                    DefaultBubbleHelper.applyStyleDefault(positions, mine, context);
                }
                if (!TextUtils.isEmpty((CharSequence)attachment.getTitle()) && !attachment.getType().equals("file")) {
                    bottomLeftRadius = (bottomRightRadius = 0);
                }
                if (message.getAttachments().indexOf(attachment) != 0) {
                    if (mine) {
                        topRightRadius = 0;
                    } else {
                        topLeftRadius = 0;
                    }
                }
                return DefaultBubbleHelper.getBubbleDrawable();
            }

            @Override
            @NotNull
            public Drawable getDrawableForAttachmentDescription(@NotNull Message message, boolean mine, @NotNull List<? extends MessageListItem.Position> positions) {
                if (style2.getMessageBubbleDrawable(mine) != -1) {
                    return ContextCompat.getDrawable((Context)context, (int)style2.getMessageBubbleDrawable(mine));
                }
                DefaultBubbleHelper.configParams(style2, mine, true);
                if (DefaultBubbleHelper.isDefaultBubble(style2, mine, context)) {
                    DefaultBubbleHelper.applyStyleDefault(positions, mine, context);
                }
                topLeftRadius = (topRightRadius = 0);
                return DefaultBubbleHelper.getBubbleDrawable();
            }
        };
    }

    private static void configParams(MessageListViewStyle style2, boolean isMine, boolean isAttachment) {
        bgColor = isAttachment ? style2.getAttachmentBackgroundColor(isMine) : style2.getMessageBackgroundColor(isMine);
        strokeColor = isAttachment ? style2.getAttachmentBorderColor(isMine) : style2.getMessageBorderColor(isMine);
        strokeWidth = style2.getMessageBorderWidth(isMine);
        topLeftRadius = style2.getMessageTopLeftCornerRadius(isMine);
        topRightRadius = style2.getMessageTopRightCornerRadius(isMine);
        bottomRightRadius = style2.getMessageBottomRightCornerRadius(isMine);
        bottomLeftRadius = style2.getMessageBottomLeftCornerRadius(isMine);
    }

    private static void applyStyleDefault(List<? extends MessageListItem.Position> positions, boolean isMine, Context context) {
        if (isMine) {
            topLeftRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1);
            bottomLeftRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1);
            if (positions.contains((Object)MessageListItem.Position.TOP)) {
                topRightRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1);
                bottomRightRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius2);
            } else {
                topRightRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius2);
                bottomRightRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius2);
            }
        } else {
            topRightRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1);
            bottomRightRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1);
            if (positions.contains((Object)MessageListItem.Position.TOP)) {
                topLeftRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1);
                bottomLeftRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius2);
            } else {
                topLeftRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius2);
                bottomLeftRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius2);
            }
        }
    }

    private static boolean isDefaultBubble(MessageListViewStyle style2, boolean isMine, Context context) {
        if (isMine) {
            return style2.getMessageTopLeftCornerRadius(isMine) == context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1) && style2.getMessageTopRightCornerRadius(isMine) == context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1) && style2.getMessageBottomRightCornerRadius(isMine) == context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius2) && style2.getMessageBottomLeftCornerRadius(isMine) == context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1);
        }
        return style2.getMessageTopLeftCornerRadius(isMine) == context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1) && style2.getMessageTopRightCornerRadius(isMine) == context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1) && style2.getMessageBottomRightCornerRadius(isMine) == context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius1) && style2.getMessageBottomLeftCornerRadius(isMine) == context.getResources().getDimensionPixelSize(R.dimen.stream_message_corner_radius2);
    }

    private static Drawable getBubbleDrawable() {
        return new DrawableBuilder().rectangle().strokeColor(strokeColor).strokeWidth(strokeWidth).solidColor(bgColor).cornerRadii(topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius).build();
    }
}

