/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter;

import androidx.annotation.Nullable;
import androidx.recyclerview.widget.DiffUtil;
import com.getstream.sdk.chat.adapter.ChannelItemPayloadDiff;
import com.getstream.sdk.chat.utils.LlcMigrationUtils;
import io.getstream.chat.android.client.models.Channel;
import java.util.List;

public class ChannelListDiffCallback
extends DiffUtil.Callback {
    private List<Channel> oldList;
    private List<Channel> newList;

    public ChannelListDiffCallback(List<Channel> oldList, List<Channel> newList) {
        this.oldList = oldList;
        this.newList = newList;
    }

    public int getOldListSize() {
        return this.oldList == null ? 0 : this.oldList.size();
    }

    public int getNewListSize() {
        return this.newList == null ? 0 : this.newList.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        Channel oldItem = this.oldList.get(oldItemPosition);
        Channel newItem = this.newList.get(newItemPosition);
        return oldItem.getCid().equals(newItem.getCid());
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        Channel oldChannel = this.oldList.get(oldItemPosition);
        Channel newChannel = this.newList.get(newItemPosition);
        boolean contentTheSame = true;
        if (!oldChannel.getCid().equals(newChannel.getCid())) {
            contentTheSame = false;
        } else if (oldChannel.getUpdatedAt() == null && newChannel.getUpdatedAt() != null) {
            contentTheSame = false;
        } else if (newChannel.getUpdatedAt() != null && oldChannel.getUpdatedAt().getTime() < newChannel.getUpdatedAt().getTime()) {
            contentTheSame = false;
        } else if (!oldChannel.getExtraData().equals(newChannel.getExtraData())) {
            contentTheSame = false;
        } else if (!LlcMigrationUtils.lastMessagesAreTheSame(oldChannel, newChannel)) {
            contentTheSame = false;
        } else if (LlcMigrationUtils.currentUserRead(oldChannel, newChannel)) {
            contentTheSame = false;
        }
        return contentTheSame;
    }

    @Nullable
    public Object getChangePayload(int oldItemPosition, int newItemPosition) {
        Channel newChannel;
        ChannelItemPayloadDiff diff = new ChannelItemPayloadDiff();
        Channel oldChannel = this.oldList.get(oldItemPosition);
        diff.lastMessage = !LlcMigrationUtils.lastMessagesAreTheSame(oldChannel, newChannel = this.newList.get(newItemPosition));
        diff.name = !LlcMigrationUtils.equalsName(newChannel, oldChannel);
        diff.avatarView = !LlcMigrationUtils.equalsUserLists(LlcMigrationUtils.getOtherUsers(oldChannel.getMembers()), LlcMigrationUtils.getOtherUsers(newChannel.getMembers()));
        diff.readState = LlcMigrationUtils.currentUserRead(oldChannel, newChannel);
        diff.lastMessageDate = !LlcMigrationUtils.equalsLastMessageDate(oldChannel, newChannel);
        return diff;
    }
}

