/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter;

import android.content.Context;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.adapter.BaseChannelListItemViewHolder;
import com.getstream.sdk.chat.adapter.ChannelItemPayloadDiff;
import com.getstream.sdk.chat.adapter.ChannelListDiffCallback;
import com.getstream.sdk.chat.adapter.ChannelViewHolderFactory;
import com.getstream.sdk.chat.view.channels.ChannelListView;
import com.getstream.sdk.chat.view.channels.ChannelListViewStyle;
import io.getstream.chat.android.client.models.Channel;
import java.util.ArrayList;
import java.util.List;

public class ChannelListItemAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private Context context;
    private List<Channel> channels;
    private ChannelListView.ChannelClickListener channelClickListener;
    private ChannelListView.ChannelClickListener channelLongClickListener;
    private ChannelListView.UserClickListener userClickListener;
    private ChannelListViewStyle style;
    private ChannelViewHolderFactory viewHolderFactory;
    private ChannelItemPayloadDiff noDiff = new ChannelItemPayloadDiff();

    public ChannelListItemAdapter(Context context, List<Channel> channels) {
        this.context = context;
        this.channels = channels;
        this.viewHolderFactory = new ChannelViewHolderFactory();
    }

    public ChannelListItemAdapter(Context context) {
        this(context, new ArrayList<Channel>());
        this.viewHolderFactory = new ChannelViewHolderFactory();
    }

    public ChannelListView.ChannelClickListener getChannelClickListener() {
        return this.channelClickListener;
    }

    public void setChannelClickListener(ChannelListView.ChannelClickListener l) {
        this.channelClickListener = l;
    }

    public ChannelListView.ChannelClickListener getChannelLongClickListener() {
        return this.channelLongClickListener;
    }

    public void setChannelLongClickListener(ChannelListView.ChannelClickListener l) {
        this.channelLongClickListener = l;
    }

    public ChannelListView.UserClickListener getUserClickListener() {
        return this.userClickListener;
    }

    public void setUserClickListener(ChannelListView.UserClickListener l) {
        this.userClickListener = l;
    }

    public void replaceChannels(List<Channel> channelList) {
        ArrayList<Channel> cloneChannelList = new ArrayList<Channel>(new ArrayList<Channel>(channelList));
        DiffUtil.DiffResult result = DiffUtil.calculateDiff((DiffUtil.Callback)new ChannelListDiffCallback(this.channels, cloneChannelList), (boolean)true);
        result.dispatchUpdatesTo((RecyclerView.Adapter)this);
        this.channels = cloneChannelList;
    }

    public int getItemViewType(int position) {
        Channel channel = this.channels.get(position);
        return this.viewHolderFactory.getChannelViewType(channel);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        BaseChannelListItemViewHolder anyViewHolder = this.viewHolderFactory.createChannelViewHolder(this, parent, viewType);
        return anyViewHolder;
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        Channel channelState = this.channels.get(position);
        ((BaseChannelListItemViewHolder)holder).bind(this.context, channelState, position, null);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position, @NonNull List<Object> payloads) {
        Channel channelState = this.channels.get(position);
        ChannelItemPayloadDiff diff = payloads.isEmpty() ? this.noDiff : (ChannelItemPayloadDiff)payloads.get(0);
        ((BaseChannelListItemViewHolder)holder).bind(this.context, channelState, position, diff);
    }

    public int getItemCount() {
        return this.channels.size();
    }

    public ChannelListViewStyle getStyle() {
        return this.style;
    }

    public void setStyle(ChannelListViewStyle s) {
        this.style = s;
    }

    public void setViewHolderFactory(ChannelViewHolderFactory viewHolderFactory) {
        this.viewHolderFactory = viewHolderFactory;
    }
}

