/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.ImageLoader;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.databinding.StreamItemAttachedMediaBinding;
import com.getstream.sdk.chat.model.AttachmentMetaData;
import com.getstream.sdk.chat.utils.StringUtility;
import com.getstream.sdk.chat.utils.roundedImageView.PorterShapeImageView;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import top.defaults.drawabletoolbox.DrawableBuilder;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\f\u0012\b\u0012\u00060\u0002R\u00020\u00000\u0001:\u0001\u001eB+\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0005J\u0006\u0010\u0010\u001a\u00020\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\b2\n\u0010\u0014\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u001c\u0010\u0016\u001a\u00060\u0002R\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0012H\u0016J\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0005J\u001b\u0010\u001b\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a2\u0006\u0002\b\u001dR&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/getstream/sdk/chat/adapter/MediaAttachmentSelectedAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/getstream/sdk/chat/adapter/MediaAttachmentSelectedAdapter$MyViewHolder;", "selectedAttachments", "", "Lcom/getstream/sdk/chat/model/AttachmentMetaData;", "cancelListener", "Lkotlin/Function1;", "", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "getCancelListener", "()Lkotlin/jvm/functions/Function1;", "setCancelListener", "(Lkotlin/jvm/functions/Function1;)V", "addAttachment", "attachment", "clear", "getItemCount", "", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "removeAttachment", "setAttachments", "attachments", "setAttachments$stream_chat_android_release", "MyViewHolder", "stream-chat-android_release"})
public final class MediaAttachmentSelectedAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    private List<AttachmentMetaData> selectedAttachments;
    @NotNull
    private Function1<? super AttachmentMetaData, Unit> cancelListener;

    @NotNull
    public MyViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        StreamItemAttachedMediaBinding streamItemAttachedMediaBinding = StreamItemAttachedMediaBinding.inflate(layoutInflater, parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)streamItemAttachedMediaBinding, (String)"StreamItemAttachedMediaB\u2026tInflater, parent, false)");
        StreamItemAttachedMediaBinding itemBinding = streamItemAttachedMediaBinding;
        return new MyViewHolder(itemBinding);
    }

    public void onBindViewHolder(@NotNull MyViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bind(this.selectedAttachments.get(position), this.cancelListener);
    }

    public int getItemCount() {
        return this.selectedAttachments.size();
    }

    public final void setAttachments$stream_chat_android_release(@NotNull List<AttachmentMetaData> attachments2) {
        Intrinsics.checkNotNullParameter(attachments2, (String)"attachments");
        this.selectedAttachments = attachments2;
        this.notifyDataSetChanged();
    }

    public final void removeAttachment(@NotNull AttachmentMetaData attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        int index = this.selectedAttachments.indexOf(attachment);
        this.selectedAttachments = CollectionsKt.minus((Iterable)this.selectedAttachments, (Object)attachment);
        if (index != -1) {
            this.notifyItemRemoved(index);
        } else {
            this.notifyDataSetChanged();
        }
    }

    public final void addAttachment(@NotNull AttachmentMetaData attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        this.selectedAttachments = CollectionsKt.plus((Collection)this.selectedAttachments, (Object)attachment);
        this.notifyItemInserted(CollectionsKt.getLastIndex(this.selectedAttachments));
    }

    public final void clear() {
        this.selectedAttachments = CollectionsKt.emptyList();
        this.notifyDataSetChanged();
    }

    @NotNull
    public final Function1<AttachmentMetaData, Unit> getCancelListener() {
        return this.cancelListener;
    }

    public final void setCancelListener(@NotNull Function1<? super AttachmentMetaData, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.cancelListener = function1;
    }

    public MediaAttachmentSelectedAdapter(@NotNull List<AttachmentMetaData> selectedAttachments, @NotNull Function1<? super AttachmentMetaData, Unit> cancelListener) {
        Intrinsics.checkNotNullParameter(selectedAttachments, (String)"selectedAttachments");
        Intrinsics.checkNotNullParameter(cancelListener, (String)"cancelListener");
        this.selectedAttachments = selectedAttachments;
        this.cancelListener = cancelListener;
    }

    public /* synthetic */ MediaAttachmentSelectedAdapter(List list, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(list, (Function1<? super AttachmentMetaData, Unit>)function1);
    }

    public MediaAttachmentSelectedAdapter() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/getstream/sdk/chat/adapter/MediaAttachmentSelectedAdapter$MyViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemAttachedMediaBinding;", "(Lcom/getstream/sdk/chat/adapter/MediaAttachmentSelectedAdapter;Lcom/getstream/sdk/chat/databinding/StreamItemAttachedMediaBinding;)V", "bind", "", "attachment", "Lcom/getstream/sdk/chat/model/AttachmentMetaData;", "cancelListener", "Lkotlin/Function1;", "stream-chat-android_release"})
    public final class MyViewHolder
    extends RecyclerView.ViewHolder {
        private final StreamItemAttachedMediaBinding binding;

        public final void bind(@NotNull AttachmentMetaData attachment, @NotNull Function1<? super AttachmentMetaData, Unit> cancelListener) {
            Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
            Intrinsics.checkNotNullParameter(cancelListener, (String)"cancelListener");
            View view = this.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"itemView");
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"itemView.context");
            int cornerRadius = context.getResources().getDimensionPixelSize(R.dimen.stream_input_upload_media_radius);
            PorterShapeImageView porterShapeImageView = this.binding.ivMedia;
            View view2 = this.itemView;
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"itemView");
            porterShapeImageView.setShape(view2.getContext(), new DrawableBuilder().rectangle().solidColor(-16777216).cornerRadii(cornerRadius, cornerRadius, cornerRadius, cornerRadius).build());
            if (Intrinsics.areEqual((Object)attachment.getType(), (Object)"video")) {
                PorterShapeImageView porterShapeImageView2 = this.binding.ivMedia;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)porterShapeImageView2), (String)"binding.ivMedia");
                ImageLoader.INSTANCE.loadVideoThumbnail((ImageView)porterShapeImageView2, attachment.getUri(), R.drawable.stream_placeholder);
            } else {
                PorterShapeImageView porterShapeImageView3 = this.binding.ivMedia;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)porterShapeImageView3), (String)"binding.ivMedia");
                ImageLoader.INSTANCE.load((ImageView)porterShapeImageView3, attachment.getUri(), R.drawable.stream_placeholder);
            }
            if (Intrinsics.areEqual((Object)"video", (Object)attachment.getType())) {
                TextView textView = this.binding.tvLength;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvLength");
                textView.setText((CharSequence)StringUtility.convertVideoLength(attachment.getVideoLength()));
            } else {
                TextView textView = this.binding.tvLength;
                Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvLength");
                textView.setText((CharSequence)"");
            }
            this.binding.btnClose.setOnClickListener(new View.OnClickListener(cancelListener, attachment){
                final /* synthetic */ Function1 $cancelListener;
                final /* synthetic */ AttachmentMetaData $attachment;

                public final void onClick(View it) {
                    this.$cancelListener.invoke((Object)this.$attachment);
                }
                {
                    this.$cancelListener = function1;
                    this.$attachment = attachmentMetaData;
                }
            });
            ImageView imageView = this.binding.ivMask;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivMask");
            imageView.setVisibility(4);
            ProgressBar progressBar = this.binding.progressBar;
            Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.progressBar");
            progressBar.setVisibility(4);
        }

        public MyViewHolder(StreamItemAttachedMediaBinding binding) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            super((View)binding.getRoot());
            this.binding = binding;
        }
    }
}

