/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.message.configurators;

import android.view.View;
import com.getstream.sdk.chat.adapter.AttachmentViewHolderFactory;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.viewholder.message.ExtensionsKt;
import com.getstream.sdk.chat.adapter.viewholder.message.configurators.Configurator;
import com.getstream.sdk.chat.databinding.StreamItemMessageBinding;
import com.getstream.sdk.chat.view.AttachmentListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.models.Message;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/AttachmentConfigurator;", "Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/Configurator;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "viewHolderFactory", "Lcom/getstream/sdk/chat/adapter/AttachmentViewHolderFactory;", "(Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lcom/getstream/sdk/chat/adapter/AttachmentViewHolderFactory;)V", "configAttachmentView", "", "messageItem", "Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;", "configure", "stream-chat-android_release"})
public final class AttachmentConfigurator
implements Configurator {
    private final StreamItemMessageBinding binding;
    private final MessageListViewStyle style;
    private final AttachmentViewHolderFactory viewHolderFactory;

    @Override
    public void configure(@NotNull MessageListItem.MessageItem messageItem) {
        Intrinsics.checkNotNullParameter((Object)messageItem, (String)"messageItem");
        this.configAttachmentView(messageItem);
    }

    private final void configAttachmentView(MessageListItem.MessageItem messageItem) {
        Message message = messageItem.getMessage();
        boolean deletedMessage = ExtensionsKt.isDeleted(message);
        boolean failedMessage = ExtensionsKt.isFailed(message);
        boolean noAttachments = ExtensionsKt.hasNoAttachments(message);
        if (deletedMessage || failedMessage || noAttachments) {
            ChatLogger chatLogger = ChatLogger.Companion.getInstance();
            String string2 = this.getClass().getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaClass.simpleName");
            chatLogger.logE((Object)string2, "attachment hidden: deletedMessage:" + deletedMessage + ", failedMessage:" + failedMessage + " noAttachments:" + noAttachments);
            AttachmentListView attachmentListView = this.binding.attachmentview;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)attachmentListView), (String)"binding.attachmentview");
            boolean bl = false;
            View $this$isVisible$iv = (View)attachmentListView;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
            return;
        }
        AttachmentListView attachmentListView = this.binding.attachmentview;
        boolean bl = false;
        boolean bl2 = false;
        AttachmentListView $this$apply = attachmentListView;
        boolean bl3 = false;
        boolean bl4 = true;
        View $this$isVisible$iv = (View)$this$apply;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        $this$apply.init(this.viewHolderFactory, this.style);
        $this$apply.setEntity(messageItem);
    }

    public AttachmentConfigurator(@NotNull StreamItemMessageBinding binding, @NotNull MessageListViewStyle style2, @NotNull AttachmentViewHolderFactory viewHolderFactory) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)style2, (String)"style");
        Intrinsics.checkNotNullParameter((Object)viewHolderFactory, (String)"viewHolderFactory");
        this.binding = binding;
        this.style = style2;
        this.viewHolderFactory = viewHolderFactory;
    }
}

