/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.message.configurators;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.method.MovementMethod;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.getstream.sdk.chat.ChatMarkdown;
import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.viewholder.message.ExtensionsKt;
import com.getstream.sdk.chat.adapter.viewholder.message.configurators.Configurator;
import com.getstream.sdk.chat.databinding.StreamItemMessageBinding;
import com.getstream.sdk.chat.navigation.destinations.WebLinkDestination;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.utils.StringUtility;
import com.getstream.sdk.chat.utils.Utils;
import com.getstream.sdk.chat.view.MessageListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Message;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/MessageTextConfigurator;", "Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/Configurator;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;", "context", "Landroid/content/Context;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "bubbleHelper", "Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;", "messageClickListener", "Lcom/getstream/sdk/chat/view/MessageListView$MessageClickListener;", "messageLongClickListener", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;", "messageRetryListener", "Lcom/getstream/sdk/chat/view/MessageListView$MessageRetryListener;", "(Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;Landroid/content/Context;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;Lcom/getstream/sdk/chat/view/MessageListView$MessageClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;Lcom/getstream/sdk/chat/view/MessageListView$MessageRetryListener;)V", "isLongClick", "", "configMessageTextBackground", "", "message", "Lio/getstream/chat/android/client/models/Message;", "messageItem", "Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;", "configMessageTextClickListener", "configMessageTextStyle", "configMessageTextViewText", "configParamsMessageText", "configure", "stream-chat-android_release"})
public final class MessageTextConfigurator
implements Configurator {
    private boolean isLongClick;
    private final StreamItemMessageBinding binding;
    private final Context context;
    private final MessageListViewStyle style;
    private final MessageListView.BubbleHelper bubbleHelper;
    private final MessageListView.MessageClickListener messageClickListener;
    private final MessageListView.MessageLongClickListener messageLongClickListener;
    private final MessageListView.MessageRetryListener messageRetryListener;

    @Override
    public void configure(@NotNull MessageListItem.MessageItem messageItem) {
        View $this$isVisible$iv;
        Intrinsics.checkNotNullParameter((Object)messageItem, (String)"messageItem");
        Message message = messageItem.getMessage();
        CharSequence charSequence = message.getText();
        boolean bl = false;
        if (charSequence.length() == 0 && !ExtensionsKt.isDeleted(message)) {
            TextView textView = this.binding.tvText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvText");
            bl = false;
            $this$isVisible$iv = (View)textView;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(8);
            return;
        }
        TextView textView = this.binding.tvText;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvText");
        boolean value$iv = true;
        $this$isVisible$iv = (View)textView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        this.configMessageTextViewText(message);
        this.configMessageTextStyle(message, messageItem);
        this.configMessageTextBackground(message, messageItem);
        this.configMessageTextClickListener(message);
        this.configParamsMessageText(messageItem);
    }

    private final void configMessageTextViewText(Message message) {
        if (ExtensionsKt.isFailed(message)) {
            SpannableStringBuilder builder = new SpannableStringBuilder();
            CharSequence charSequence = message.getCommand();
            boolean bl = false;
            boolean bl2 = false;
            int failedDes = charSequence == null || charSequence.length() == 0 ? R.string.stream_message_failed_send : R.string.stream_message_invalid_command;
            SpannableString str1 = new SpannableString(this.context.getResources().getText(failedDes));
            str1.setSpan((Object)new ForegroundColorSpan(-7829368), 0, str1.length(), 0);
            str1.setSpan((Object)new RelativeSizeSpan(0.7f), 0, str1.length(), 0);
            builder.append((CharSequence)str1);
            builder.append((CharSequence)"\n");
            SpannableString str2 = new SpannableString((CharSequence)message.getText());
            builder.append((CharSequence)str2);
            this.binding.tvText.setText((CharSequence)builder, TextView.BufferType.SPANNABLE);
            return;
        }
        String text = StringUtility.getDeletedOrMentionedText(message);
        ChatMarkdown markdown = ChatUI.Companion.instance().getMarkdown();
        markdown.setText(this.binding.tvText, text);
    }

    private final void configMessageTextStyle(Message message, MessageListItem.MessageItem messageItem) {
        if (ExtensionsKt.isDeleted(message)) {
            this.binding.tvText.setTextSize(0, (float)this.context.getResources().getDimensionPixelSize(R.dimen.stream_message_deleted_text_font_size));
            this.binding.tvText.setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.stream_gray_dark));
            return;
        }
        if (messageItem.isMine()) {
            TextStyle textStyle = this.style.getMessageTextMine();
            TextView textView = this.binding.tvText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvText");
            textStyle.apply(textView);
        } else {
            TextStyle textStyle = this.style.getMessageTextTheirs();
            TextView textView = this.binding.tvText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvText");
            textStyle.apply(textView);
        }
        int messageLinkTextColor = this.style.getMessageLinkTextColor(messageItem.isMine());
        if (messageLinkTextColor != 0) {
            this.binding.tvText.setLinkTextColor(messageLinkTextColor);
        }
    }

    private final void configMessageTextBackground(Message message, MessageListItem.MessageItem messageItem) {
        Drawable background;
        Drawable drawable2;
        if (ExtensionsKt.isFailed(message)) {
            drawable2 = this.bubbleHelper.getDrawableForMessage(messageItem.getMessage(), messageItem.isMine(), messageItem.getPositions());
        } else if (ExtensionsKt.isDeleted(message) || StringUtility.INSTANCE.isEmoji(message.getText())) {
            drawable2 = null;
        } else {
            Collection collection = message.getAttachments();
            boolean bl = false;
            drawable2 = background = !collection.isEmpty() ? this.bubbleHelper.getDrawableForMessage(messageItem.getMessage(), messageItem.isMine(), CollectionsKt.listOf((Object)((Object)MessageListItem.Position.MIDDLE))) : this.bubbleHelper.getDrawableForMessage(messageItem.getMessage(), messageItem.isMine(), messageItem.getPositions());
        }
        if (background != null) {
            TextView textView = this.binding.tvText;
            Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvText");
            textView.setBackground(background);
        } else {
            this.binding.tvText.setBackgroundResource(0);
        }
    }

    private final void configMessageTextClickListener(Message message) {
        this.binding.tvText.setOnClickListener(new View.OnClickListener(this, message){
            final /* synthetic */ MessageTextConfigurator this$0;
            final /* synthetic */ Message $message;

            /*
             * Enabled aggressive block sorting
             */
            public final void onClick(View it) {
                if (ExtensionsKt.isFailed(this.$message)) {
                    CharSequence charSequence = this.$message.getCommand();
                    boolean bl = false;
                    boolean bl2 = false;
                    if (charSequence == null || charSequence.length() == 0) {
                        MessageTextConfigurator.access$getMessageRetryListener$p(this.this$0).onRetryMessage(this.$message);
                        return;
                    }
                }
                MessageTextConfigurator.access$getMessageClickListener$p(this.this$0).onMessageClick(this.$message);
            }
            {
                this.this$0 = messageTextConfigurator;
                this.$message = message;
            }
        });
        this.binding.tvText.setOnLongClickListener(new View.OnLongClickListener(this, message){
            final /* synthetic */ MessageTextConfigurator this$0;
            final /* synthetic */ Message $message;

            public final boolean onLongClick(View it) {
                if (ExtensionsKt.isDeleted(this.$message) || ExtensionsKt.isFailed(this.$message)) {
                    return true;
                }
                MessageTextConfigurator.access$setLongClick$p(this.this$0, true);
                MessageTextConfigurator.access$getMessageLongClickListener$p(this.this$0).onMessageLongClick(this.$message);
                return true;
            }
            {
                this.this$0 = messageTextConfigurator;
                this.$message = message;
            }
        });
        TextView textView = this.binding.tvText;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvText");
        textView.setMovementMethod((MovementMethod)new Utils.TextViewLinkHandler(this, message){
            final /* synthetic */ MessageTextConfigurator this$0;
            final /* synthetic */ Message $message;

            public void onLinkClick(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                if (ExtensionsKt.isDeleted(this.$message) || ExtensionsKt.isFailed(this.$message)) {
                    return;
                }
                if (MessageTextConfigurator.access$isLongClick$p(this.this$0)) {
                    MessageTextConfigurator.access$setLongClick$p(this.this$0, false);
                    return;
                }
                ChatUI.Companion.instance().getNavigator().navigate(new WebLinkDestination(url, MessageTextConfigurator.access$getContext$p(this.this$0)));
            }
            {
                this.this$0 = this$0;
                this.$message = $captured_local_variable$1;
            }
        });
    }

    private final void configParamsMessageText(MessageListItem.MessageItem messageItem) {
        TextView textView = this.binding.tvText;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvText");
        View $this$isGone$iv = (View)textView;
        boolean $i$f$isGone = false;
        if ($this$isGone$iv.getVisibility() == 8) {
            return;
        }
        TextView textView2 = this.binding.tvText;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.tvText");
        View $this$updateLayoutParams$iv = (View)textView2;
        boolean $i$f$updateLayoutParamsTyped = false;
        ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams);
        ConstraintLayout.LayoutParams $this$updateLayoutParams = (ConstraintLayout.LayoutParams)params$iv;
        boolean bl = false;
        $this$updateLayoutParams.horizontalBias = messageItem.isTheirs() ? 0.0f : 1.0f;
        $this$updateLayoutParams$iv.setLayoutParams(params$iv);
    }

    public MessageTextConfigurator(@NotNull StreamItemMessageBinding binding, @NotNull Context context, @NotNull MessageListViewStyle style, @NotNull MessageListView.BubbleHelper bubbleHelper, @NotNull MessageListView.MessageClickListener messageClickListener2, @NotNull MessageListView.MessageLongClickListener messageLongClickListener2, @NotNull MessageListView.MessageRetryListener messageRetryListener2) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)bubbleHelper, (String)"bubbleHelper");
        Intrinsics.checkNotNullParameter((Object)messageClickListener2, (String)"messageClickListener");
        Intrinsics.checkNotNullParameter((Object)messageLongClickListener2, (String)"messageLongClickListener");
        Intrinsics.checkNotNullParameter((Object)messageRetryListener2, (String)"messageRetryListener");
        this.binding = binding;
        this.context = context;
        this.style = style;
        this.bubbleHelper = bubbleHelper;
        this.messageClickListener = messageClickListener2;
        this.messageLongClickListener = messageLongClickListener2;
        this.messageRetryListener = messageRetryListener2;
    }

    public static final /* synthetic */ MessageListView.MessageRetryListener access$getMessageRetryListener$p(MessageTextConfigurator $this) {
        return $this.messageRetryListener;
    }

    public static final /* synthetic */ MessageListView.MessageClickListener access$getMessageClickListener$p(MessageTextConfigurator $this) {
        return $this.messageClickListener;
    }

    public static final /* synthetic */ boolean access$isLongClick$p(MessageTextConfigurator $this) {
        return $this.isLongClick;
    }

    public static final /* synthetic */ void access$setLongClick$p(MessageTextConfigurator $this, boolean bl) {
        $this.isLongClick = bl;
    }

    public static final /* synthetic */ MessageListView.MessageLongClickListener access$getMessageLongClickListener$p(MessageTextConfigurator $this) {
        return $this.messageLongClickListener;
    }

    public static final /* synthetic */ Context access$getContext$p(MessageTextConfigurator $this) {
        return $this.context;
    }
}

