/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.navigation.destinations;

import android.content.Context;
import android.content.Intent;
import android.widget.Toast;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.navigation.destinations.ChatDestination;
import com.getstream.sdk.chat.utils.frescoimageviewer.ImageViewer;
import com.getstream.sdk.chat.view.activity.AttachmentActivity;
import com.getstream.sdk.chat.view.activity.AttachmentDocumentActivity;
import com.getstream.sdk.chat.view.activity.AttachmentMediaActivity;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Message;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0016\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/getstream/sdk/chat/navigation/destinations/AttachmentDestination;", "Lcom/getstream/sdk/chat/navigation/destinations/ChatDestination;", "message", "Lio/getstream/chat/android/client/models/Message;", "attachment", "Lio/getstream/chat/android/client/models/Attachment;", "context", "Landroid/content/Context;", "(Lio/getstream/chat/android/client/models/Message;Lio/getstream/chat/android/client/models/Attachment;Landroid/content/Context;)V", "getAttachment", "()Lio/getstream/chat/android/client/models/Attachment;", "getMessage", "()Lio/getstream/chat/android/client/models/Message;", "loadFile", "", "navigate", "showAttachment", "showImageViewer", "stream-chat-android_release"})
public final class AttachmentDestination
extends ChatDestination {
    @NotNull
    private final Message message;
    @NotNull
    private final Attachment attachment;

    @Override
    public void navigate() {
        this.showAttachment(this.message, this.attachment);
    }

    public final void showAttachment(@NotNull Message message, @NotNull Attachment attachment) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        String url = null;
        String type = attachment.getType();
        String string2 = attachment.getType();
        if (string2 != null) {
            switch (string2) {
                case "file": {
                    this.loadFile(attachment);
                    return;
                }
                case "image": {
                    if (attachment.getOgUrl() != null) {
                        url = attachment.getOgUrl();
                        type = "link";
                        break;
                    }
                    this.showImageViewer(message, attachment);
                    return;
                }
                case "video": {
                    url = attachment.getAssetUrl();
                    break;
                }
                case "giphy": {
                    url = attachment.getAssetUrl();
                    break;
                }
                case "product": {
                    url = attachment.getUrl();
                    break;
                }
            }
        }
        CharSequence charSequence = url;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.stream_attachment_invalid_url), (int)0).show();
            return;
        }
        Intent intent = new Intent(this.getContext(), AttachmentActivity.class);
        bl2 = false;
        boolean bl3 = false;
        Intent $this$apply = intent;
        boolean bl4 = false;
        $this$apply.putExtra("type", type);
        $this$apply.putExtra("url", url);
        Intent intent2 = intent;
        this.start(intent2);
    }

    private final void loadFile(Attachment attachment) {
        block2: {
            String url;
            String mimeType;
            block1: {
                mimeType = attachment.getMimeType();
                url = attachment.getAssetUrl();
                if (mimeType == null) {
                    ChatLogger.Companion.getInstance().logE((Object)"AttachmentDestination", "MimeType is null for url " + url);
                    Toast.makeText((Context)this.getContext(), (CharSequence)this.getContext().getString(R.string.stream_attachment_invalid_mime_type, new Object[]{attachment.getName()}), (int)0).show();
                    return;
                }
                if (!StringsKt.contains$default((CharSequence)mimeType, (CharSequence)"audio", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)mimeType, (CharSequence)"video", (boolean)false, (int)2, null)) break block1;
                Intent intent = new Intent(this.getContext(), AttachmentMediaActivity.class);
                boolean bl = false;
                boolean bl2 = false;
                Intent $this$apply = intent;
                boolean bl3 = false;
                $this$apply.putExtra("type", mimeType);
                $this$apply.putExtra("url", url);
                Intent intent2 = intent;
                this.start(intent2);
                break block2;
            }
            if (!Intrinsics.areEqual((Object)mimeType, (Object)"application/msword") && !Intrinsics.areEqual((Object)mimeType, (Object)"text/plain") && !Intrinsics.areEqual((Object)mimeType, (Object)"application/pdf") && !StringsKt.contains$default((CharSequence)mimeType, (CharSequence)"application/vnd", (boolean)false, (int)2, null)) break block2;
            Intent intent = new Intent(this.getContext(), AttachmentDocumentActivity.class);
            boolean bl = false;
            boolean bl4 = false;
            Intent $this$apply = intent;
            boolean bl5 = false;
            $this$apply.putExtra("url", url);
            Intent intent3 = intent;
            this.start(intent3);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void showImageViewer(Message message, Attachment attachment) {
        $this$filter$iv = message.getAttachments();
        $i$f$filter = false;
        var6_6 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (Attachment)element$iv$iv;
            $i$a$-filter-AttachmentDestination$showImageViewer$imageUrls$1 = false;
            if (!Intrinsics.areEqual((Object)attachment.getType(), (Object)"image")) ** GOTO lbl-1000
            var13_13 = attachment.getImageUrl();
            var14_14 = false;
            var15_15 = false;
            if (!(var13_13 == null || var13_13.length() == 0)) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            it = (Attachment)item$iv$iv;
            var16_16 = destination$iv$iv;
            $i$a$-map-AttachmentDestination$showImageViewer$imageUrls$2 = false;
            var17_17 = it.getImageUrl();
            var16_16.add(var17_17);
        }
        imageUrls = (List)destination$iv$iv;
        if (imageUrls.isEmpty()) {
            Toast.makeText((Context)this.getContext(), (CharSequence)"Invalid image(s)!", (int)0).show();
            return;
        }
        attachmentIndex = message.getAttachments().indexOf(attachment);
        new ImageViewer.Builder<T>(this.getContext(), imageUrls).setStartPosition(0 <= (var5_5 = attachmentIndex) && ((Collection)imageUrls).size() > var5_5 ? attachmentIndex : 0).show();
    }

    @NotNull
    public final Message getMessage() {
        return this.message;
    }

    @NotNull
    public final Attachment getAttachment() {
        return this.attachment;
    }

    public AttachmentDestination(@NotNull Message message, @NotNull Attachment attachment, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.message = message;
        this.attachment = attachment;
    }
}

