/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.style;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.SparseArray;
import android.widget.TextView;
import androidx.annotation.FontRes;
import androidx.core.content.res.ResourcesCompat;
import com.getstream.sdk.chat.style.ChatFonts;
import com.getstream.sdk.chat.style.ChatStyle;
import com.getstream.sdk.chat.style.TextStyle;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\f2\b\b\u0001\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/getstream/sdk/chat/style/ChatFontsImpl;", "Lcom/getstream/sdk/chat/style/ChatFonts;", "style", "Lcom/getstream/sdk/chat/style/ChatStyle;", "context", "Landroid/content/Context;", "(Lcom/getstream/sdk/chat/style/ChatStyle;Landroid/content/Context;)V", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "pathMap", "", "", "Landroid/graphics/Typeface;", "resourceMap", "Landroid/util/SparseArray;", "getFont", "textStyle", "Lcom/getstream/sdk/chat/style/TextStyle;", "fontRes", "", "fontPath", "safeLoadTypeface", "setDefaultFont", "", "textView", "Landroid/widget/TextView;", "setFont", "stream-chat-android_release"})
public final class ChatFontsImpl
implements ChatFonts {
    private final SparseArray<Typeface> resourceMap;
    private final Map<String, Typeface> pathMap;
    private final TaggedLogger logger;
    private final ChatStyle style;
    private final Context context;

    @Override
    public void setFont(@NotNull TextStyle textStyle, @NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        if (textStyle.getFont() != null) {
            textView.setTypeface(textStyle.getFont(), textStyle.getStyle());
        } else {
            this.setDefaultFont(textView, textStyle.getStyle());
        }
    }

    @Override
    @Nullable
    public Typeface getFont(@NotNull TextStyle textStyle) {
        Typeface typeface;
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        if (textStyle.getFontResource() != -1) {
            typeface = this.getFont(textStyle.getFontResource());
        } else {
            CharSequence charSequence = textStyle.getFontAssetsPath();
            boolean bl = false;
            boolean bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                String string2 = textStyle.getFontAssetsPath();
                Intrinsics.checkNotNull((Object)string2);
                typeface = this.getFont(string2);
            } else {
                typeface = null;
            }
        }
        return typeface;
    }

    private final Typeface getFont(String fontPath) {
        Map<String, Typeface> map = this.pathMap;
        boolean bl = false;
        Map<String, Typeface> map2 = map;
        boolean bl2 = false;
        if (map2.containsKey(fontPath)) {
            return this.pathMap.get(fontPath);
        }
        Typeface typeface = this.safeLoadTypeface(fontPath);
        if (typeface == null) {
            return null;
        }
        Typeface typeface2 = typeface;
        this.pathMap.put(fontPath, typeface2);
        return typeface2;
    }

    private final Typeface getFont(@FontRes int fontRes) {
        SparseArray<Typeface> $this$contains$iv = this.resourceMap;
        boolean $i$f$contains = false;
        if ($this$contains$iv.indexOfKey(fontRes) >= 0) {
            return (Typeface)this.resourceMap.get(fontRes);
        }
        Typeface typeface = this.safeLoadTypeface(fontRes);
        if (typeface == null) {
            return null;
        }
        Typeface typeface2 = typeface;
        this.resourceMap.put(fontRes, (Object)typeface2);
        return typeface2;
    }

    private final void setDefaultFont(TextView textView, int textStyle) {
        if (this.style.hasDefaultFont()) {
            textView.setTypeface(this.getFont(this.style.getDefaultTextStyle()), textStyle);
        } else {
            textView.setTypeface(Typeface.DEFAULT, textStyle);
        }
    }

    private final Typeface safeLoadTypeface(@FontRes int fontRes) {
        Typeface typeface;
        try {
            typeface = ResourcesCompat.getFont((Context)this.context, (int)fontRes);
        }
        catch (Throwable t) {
            this.logger.logE(t);
            typeface = null;
        }
        return typeface;
    }

    private final Typeface safeLoadTypeface(String fontPath) {
        Typeface typeface;
        try {
            typeface = Typeface.createFromAsset((AssetManager)this.context.getAssets(), (String)fontPath);
        }
        catch (Throwable t) {
            this.logger.logE(t);
            typeface = null;
        }
        return typeface;
    }

    public ChatFontsImpl(@NotNull ChatStyle style, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.style = style;
        this.context = context;
        this.resourceMap = new SparseArray();
        this.pathMap = new HashMap();
        String string2 = ChatFonts.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ChatFonts::class.java.simpleName");
        this.logger = ChatLogger.Companion.get((Object)string2);
    }
}

