/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.style;

import android.content.res.TypedArray;
import android.graphics.Typeface;
import android.widget.TextView;
import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.style.ChatFonts;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 &2\u00020\u0001:\u0002%&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0006\"\u0004\b\u0015\u0010\bR\u001a\u0010\u0016\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0006\"\u0004\b\u0018\u0010\bR\u001a\u0010\u0019\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0006\"\u0004\b\u001b\u0010\bR\u001a\u0010\u001c\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0006\"\u0004\b\u001e\u0010\b\u00a8\u0006'"}, d2={"Lcom/getstream/sdk/chat/style/TextStyle;", "", "()V", "color", "", "getColor", "()I", "setColor", "(I)V", "font", "Landroid/graphics/Typeface;", "getFont", "()Landroid/graphics/Typeface;", "fontAssetsPath", "", "getFontAssetsPath", "()Ljava/lang/String;", "setFontAssetsPath", "(Ljava/lang/String;)V", "fontResource", "getFontResource", "setFontResource", "hintColor", "getHintColor", "setHintColor", "size", "getSize", "setSize", "style", "getStyle", "setStyle", "apply", "", "textView", "Landroid/widget/TextView;", "hasFont", "", "Builder", "Companion", "stream-chat-android_release"})
public final class TextStyle {
    private int fontResource = -1;
    @Nullable
    private String fontAssetsPath;
    private int style = -1;
    private int size = -1;
    private int color = Integer.MAX_VALUE;
    private int hintColor = Integer.MAX_VALUE;
    public static final int UNSET_SIZE = -1;
    public static final int UNSET_COLOR = Integer.MAX_VALUE;
    public static final int UNSET_HINT_COLOR = Integer.MAX_VALUE;
    public static final int UNSET_FONT_RESOURCE = -1;
    private static final Companion Companion = new Companion(null);

    public final int getFontResource() {
        return this.fontResource;
    }

    public final void setFontResource(int n) {
        this.fontResource = n;
    }

    @Nullable
    public final String getFontAssetsPath() {
        return this.fontAssetsPath;
    }

    public final void setFontAssetsPath(@Nullable String string2) {
        this.fontAssetsPath = string2;
    }

    public final int getStyle() {
        return this.style;
    }

    public final void setStyle(int n) {
        this.style = n;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    public final int getColor() {
        return this.color;
    }

    public final void setColor(int n) {
        this.color = n;
    }

    public final int getHintColor() {
        return this.hintColor;
    }

    public final void setHintColor(int n) {
        this.hintColor = n;
    }

    @Nullable
    public final Typeface getFont() {
        return ChatUI.Companion.instance().getFonts().getFont(this);
    }

    public final void apply(@NotNull TextView textView) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        ChatFonts chatFonts = ChatUI.Companion.instance().getFonts();
        if (this.size != -1) {
            textView.setTextSize(0, (float)this.size);
        }
        if (this.color != Integer.MAX_VALUE) {
            textView.setTextColor(this.color);
        }
        if (this.hintColor != Integer.MAX_VALUE) {
            textView.setHintTextColor(this.hintColor);
        }
        chatFonts.setFont(this, textView);
    }

    public final boolean hasFont() {
        return this.fontAssetsPath != null || this.fontResource != -1;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0006J\u0016\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nJ\u0016\u0010\u000f\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0010\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0016\u0010\u0011\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/getstream/sdk/chat/style/TextStyle$Builder;", "", "array", "Landroid/content/res/TypedArray;", "(Landroid/content/res/TypedArray;)V", "result", "Lcom/getstream/sdk/chat/style/TextStyle;", "build", "color", "ref", "", "defValue", "font", "assetsPath", "resId", "hintColor", "size", "style", "stream-chat-android_release"})
    public static final class Builder {
        private final TextStyle result;
        private final TypedArray array;

        @NotNull
        public final Builder size(int ref) {
            return this.size(ref, -1);
        }

        @NotNull
        public final Builder size(int ref, int defValue) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.result.setSize($this$apply.array.getDimensionPixelSize(ref, defValue));
            return builder;
        }

        @NotNull
        public final Builder font(int assetsPath, int resId) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.result.setFontAssetsPath($this$apply.array.getString(assetsPath));
            $this$apply.result.setFontResource($this$apply.array.getResourceId(resId, -1));
            return builder;
        }

        @NotNull
        public final Builder color(int ref, int defValue) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.result.setColor($this$apply.array.getColor(ref, defValue));
            return builder;
        }

        @NotNull
        public final Builder hintColor(int ref, int defValue) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.result.setHintColor($this$apply.array.getColor(ref, defValue));
            return builder;
        }

        @NotNull
        public final Builder style(int ref, int defValue) {
            Builder builder = this;
            boolean bl = false;
            boolean bl2 = false;
            Builder $this$apply = builder;
            boolean bl3 = false;
            $this$apply.result.setStyle($this$apply.array.getInt(ref, defValue));
            return builder;
        }

        @NotNull
        public final TextStyle build() {
            return this.result;
        }

        public Builder(@NotNull TypedArray array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            this.array = array;
            this.result = new TextStyle();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/getstream/sdk/chat/style/TextStyle$Companion;", "", "()V", "UNSET_COLOR", "", "UNSET_FONT_RESOURCE", "UNSET_HINT_COLOR", "UNSET_SIZE", "stream-chat-android_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

