/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.model.AttachmentMetaData;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.ChannelUserRead;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.livedata.ChatDomain;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LlcMigrationUtils {
    private static Map<String, String> reactionTypes;

    @Nullable
    public static String getName(Channel channel) {
        if (channel.getExtraData().containsKey("name")) {
            return (String)channel.getExtraData().get("name");
        }
        return "";
    }

    public static List<AttachmentMetaData> getMetaAttachments(List<Attachment> attachments2) {
        ArrayList<AttachmentMetaData> result = new ArrayList<AttachmentMetaData>();
        for (Attachment attachment : attachments2) {
            result.add(new AttachmentMetaData(attachment));
        }
        return result;
    }

    public static String getFileSizeHumanized(Attachment attachment) {
        int size = attachment.getFileSize();
        if (size <= 0) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static boolean readLastMessage(Channel channel) {
        User currentUser = LlcMigrationUtils.getCurrentUser();
        String currentUserId = currentUser.getId();
        Date myReadDate = LlcMigrationUtils.getReadDateOfChannelLastMessage(currentUserId, channel);
        Message lastMessage = LlcMigrationUtils.computeLastMessage(channel);
        if (myReadDate == null) {
            return false;
        }
        if (lastMessage == null) {
            return true;
        }
        Date lastMessageDate = lastMessage.getCreatedAt() != null ? lastMessage.getCreatedAt() : lastMessage.getCreatedLocallyAt();
        long lastMessageTime = lastMessageDate != null ? lastMessageDate.getTime() : 0L;
        return myReadDate.getTime() >= lastMessageTime;
    }

    public static List<ChannelUserRead> getLastMessageReads(Channel channel) {
        Message lastMessage = LlcMigrationUtils.computeLastMessage(channel);
        ArrayList<ChannelUserRead> readLastMessage = new ArrayList<ChannelUserRead>();
        List reads = channel.getRead();
        if (lastMessage == null || lastMessage.getCreatedAt() == null) {
            return readLastMessage;
        }
        User currentUser = LlcMigrationUtils.getCurrentUser();
        String currentUserId = currentUser.getId();
        for (ChannelUserRead r : reads) {
            if (r.getUserId().equals(currentUserId) || r.getLastRead() == null || r.getLastRead().compareTo(lastMessage.getCreatedAt()) <= -1) continue;
            readLastMessage.add(r);
        }
        Collections.sort(readLastMessage, (o1, o2) -> o1.getLastRead().compareTo(o2.getLastRead()));
        return readLastMessage;
    }

    public static Date getLastActive(List<Member> members) {
        Date lastActive = new Date();
        for (Member member : members) {
            if (member.getUser().getId() == ChatDomain.instance().getCurrentUser().getId() || member.getUser().getLastActive() == null) continue;
            lastActive = member.getUser().getLastActive();
        }
        return lastActive;
    }

    public static String getChannelNameOrMembers(Channel channel) {
        String channelName;
        String name = LlcMigrationUtils.getName(channel);
        if (!TextUtils.isEmpty((CharSequence)name)) {
            channelName = name;
        } else {
            List<User> users = LlcMigrationUtils.getOtherUsers(channel.getMembers());
            List<User> top3 = users.subList(0, Math.min(3, users.size()));
            ArrayList<Object> usernames = new ArrayList<Object>();
            for (User u : top3) {
                if (u == null) continue;
                usernames.add(u.getExtraValue("name", (Object)""));
            }
            channelName = TextUtils.join((CharSequence)", ", usernames);
            if (users.size() > 3) {
                channelName = channelName + "...";
            }
        }
        if (channelName == null) {
            return "";
        }
        return channelName;
    }

    public static boolean equalsName(Channel a, Channel b) {
        String nameA = LlcMigrationUtils.getName(a);
        String nameB = LlcMigrationUtils.getName(b);
        return nameA.equals(nameB);
    }

    public static boolean equalsLastMessageDate(Channel a, Channel b) {
        Date lastA = a.getLastMessageAt();
        Date lastB = b.getLastMessageAt();
        if (lastA == null && lastB != null) {
            return false;
        }
        if (lastA != null && lastB == null) {
            return false;
        }
        if (lastA == null) {
            return true;
        }
        return lastA.equals(lastB);
    }

    public static boolean currentUserRead(Channel oldCh, Channel newCh) {
        User currentUser = LlcMigrationUtils.getCurrentUser();
        String id2 = currentUser.getId();
        ChannelUserRead oldRead = LlcMigrationUtils.getRead(oldCh, id2);
        ChannelUserRead newRead = LlcMigrationUtils.getRead(newCh, id2);
        if (oldRead == null && newRead == null) {
            return false;
        }
        if (oldRead == null) {
            return false;
        }
        if (newRead == null) {
            return false;
        }
        Date newDate = newRead.getLastRead();
        Date oldDate = oldRead.getLastRead();
        return newDate.after(oldDate);
    }

    public static ChannelUserRead getRead(Channel channel, String userId) {
        int idx = LlcMigrationUtils.indexOfRead(channel, userId);
        if (idx == -1) {
            return null;
        }
        return (ChannelUserRead)channel.getRead().get(idx);
    }

    public static boolean lastMessagesAreTheSame(Channel a, Channel b) {
        Message oldLastMessage = LlcMigrationUtils.computeLastMessage(a);
        Message newLastMessage = LlcMigrationUtils.computeLastMessage(b);
        if (oldLastMessage == null && newLastMessage == null) {
            return true;
        }
        if (oldLastMessage == null || newLastMessage == null) {
            return false;
        }
        return oldLastMessage.equals((Object)newLastMessage);
    }

    public static int indexOfRead(Channel channel, String userId) {
        for (int i = 0; i < channel.getRead().size(); ++i) {
            if (!((ChannelUserRead)channel.getRead().get(i)).getUser().getId().equals(userId)) continue;
            return i;
        }
        return -1;
    }

    public static boolean equalsUserLists(List<User> a, List<User> b) {
        if (a.size() != b.size()) {
            return false;
        }
        if (a.size() == 0 && b.size() == 0) {
            return true;
        }
        for (int i = 0; i < a.size(); ++i) {
            User userA = a.get(i);
            User userB = b.get(i);
            if (userA.getId().equals(userB.getId())) continue;
            return false;
        }
        return true;
    }

    public static List<User> getOtherUsers(List<Member> members) {
        ArrayList<User> result = new ArrayList<User>();
        for (Member m : members) {
            User user;
            String memberId = m.getUserId();
            boolean isFromCurrentUser = LlcMigrationUtils.isFromCurrentUser(memberId);
            if (isFromCurrentUser || (user = m.getUser()) == null) continue;
            result.add(user);
        }
        return result;
    }

    public static Map<String, String> getReactionTypes() {
        if (reactionTypes == null) {
            reactionTypes = new HashMap<String, String>(){
                {
                    this.put("like", "\ud83d\udc4d");
                    this.put("love", "\u2764\ufe0f");
                    this.put("haha", "\ud83d\ude02");
                    this.put("wow", "\ud83d\ude32");
                    this.put("sad", " \ud83d\ude41");
                    this.put("angry", "\ud83d\ude21");
                }
            };
        }
        return reactionTypes;
    }

    public static int getIcon(Attachment attachment) {
        return LlcMigrationUtils.getIcon(attachment.getMimeType());
    }

    public static int getIcon(String mimeType) {
        int fileTyineRes = R.drawable.stream_ic_file;
        if (mimeType == null) {
            return fileTyineRes;
        }
        switch (mimeType) {
            case "application/pdf": {
                fileTyineRes = R.drawable.stream_ic_file_pdf;
                break;
            }
            case "application/vnd.ms-excel": {
                fileTyineRes = R.drawable.stream_ic_file_csv;
                break;
            }
            case "application/tar": {
                fileTyineRes = R.drawable.stream_ic_file_tar;
                break;
            }
            case "application/zip": {
                fileTyineRes = R.drawable.stream_ic_file_zip;
                break;
            }
            case "application/msword": 
            case "application/vnd.openxmlformats-officedocument.wordprocessingml.document": 
            case "text/plain": {
                fileTyineRes = R.drawable.stream_ic_file_doc;
                break;
            }
            case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
                fileTyineRes = R.drawable.stream_ic_file_xls;
                break;
            }
            case "application/vnd.ms-powerpoint": {
                fileTyineRes = R.drawable.stream_ic_file_ppt;
                break;
            }
            case "video/mov": 
            case "video/mp4": {
                fileTyineRes = R.drawable.stream_ic_file_mov;
                break;
            }
            case "audio/m4a": 
            case "audio/mp3": {
                fileTyineRes = R.drawable.stream_ic_file_mp3;
                break;
            }
            default: {
                if (mimeType.contains("audio")) {
                    fileTyineRes = R.drawable.stream_ic_file_mp3;
                    break;
                }
                if (!mimeType.contains("video")) break;
                fileTyineRes = R.drawable.stream_ic_file_mov;
            }
        }
        return fileTyineRes;
    }

    public static boolean isFromCurrentUser(String userId) {
        User currentUser = LlcMigrationUtils.getCurrentUser();
        if (userId == null || currentUser == null) {
            return false;
        }
        return userId.equals(currentUser.getId());
    }

    public static Date getReadDateOfChannelLastMessage(String userId, Channel channel) {
        List read = channel.getRead();
        if (read == null || read.isEmpty()) {
            return null;
        }
        Date lastReadDate = null;
        try {
            for (int i = read.size() - 1; i >= 0; --i) {
                ChannelUserRead channelUserRead = (ChannelUserRead)read.get(i);
                if (!channelUserRead.getUser().getId().equals(userId)) continue;
                lastReadDate = channelUserRead.getLastRead();
                break;
            }
        }
        catch (Exception e) {
            ChatLogger.Companion.getInstance().logE((Object)e, "getReadDateOfChannelLastMessage");
        }
        return lastReadDate;
    }

    @Nullable
    public static Message computeLastMessage(Channel channel) {
        Message lastMessage = null;
        List messages = channel.getMessages();
        for (int i = messages.size() - 1; i >= 0; --i) {
            Message message = (Message)messages.get(i);
            if (message.getDeletedAt() != null || !message.getType().equals("regular")) continue;
            lastMessage = message;
            break;
        }
        return lastMessage;
    }

    public static User getCurrentUser() {
        return ChatDomain.instance().getCurrentUser();
    }
}

