/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.MediaStore;
import com.getstream.sdk.chat.model.AttachmentMetaData;
import com.getstream.sdk.chat.utils.ImageMediaType;
import com.getstream.sdk.chat.utils.MediaType;
import com.getstream.sdk.chat.utils.StorageHelperKt;
import com.getstream.sdk.chat.utils.VideoMediaType;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J)\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0006H\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u001b\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/getstream/sdk/chat/utils/StorageHelper;", "", "()V", "dateFormat", "Ljava/text/SimpleDateFormat;", "getAttachmentsFromCursor", "", "Lcom/getstream/sdk/chat/model/AttachmentMetaData;", "context", "Landroid/content/Context;", "cursor", "Landroid/database/Cursor;", "getAttachmentsFromUriList", "uriList", "Landroid/net/Uri;", "getAttachmentsFromUriList$stream_chat_android_release", "getCachedFileFromUri", "Ljava/io/File;", "attachmentMetaData", "getCachedFileFromUri$stream_chat_android_release", "getFileName", "", "getMediaAttachments", "getMediaAttachments$stream_chat_android_release", "stream-chat-android_release"})
public final class StorageHelper {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmssSSS", Locale.US);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File getCachedFileFromUri$stream_chat_android_release(@NotNull Context context, @NotNull AttachmentMetaData attachmentMetaData) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attachmentMetaData, (String)"attachmentMetaData");
        if (attachmentMetaData.getFile() == null && attachmentMetaData.getUri() == null) {
            throw (Throwable)new IllegalStateException("Unable to create cache file for attachment: " + attachmentMetaData + ". Either file or URI cannot be null.");
        }
        if (attachmentMetaData.getFile() != null) {
            File file = attachmentMetaData.getFile();
            Intrinsics.checkNotNull((Object)file);
            return file;
        }
        File cachedFile = new File(context.getCacheDir(), this.getFileName(attachmentMetaData));
        ContentResolver contentResolver = context.getContentResolver();
        Uri uri = attachmentMetaData.getUri();
        Intrinsics.checkNotNull((Object)uri);
        InputStream inputStream = contentResolver.openInputStream(uri);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                long l;
                InputStream inputStream2 = (InputStream)closeable;
                boolean bl3 = false;
                Object object = cachedFile;
                boolean bl4 = false;
                object = new FileOutputStream((File)object);
                bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    FileOutputStream it = (FileOutputStream)object;
                    boolean bl6 = false;
                    InputStream inputStream3 = inputStream2;
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream3, (String)"inputStream");
                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream3, (OutputStream)it, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
                Long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return cachedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<AttachmentMetaData> getMediaAttachments$stream_chat_android_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String[] columns = new String[]{"_id", "_display_name", "mime_type", "media_type", "_size", "duration"};
        String selection = "media_type=1 OR media_type=3";
        Cursor cursor = context.getContentResolver().query(MediaStore.Files.getContentUri((String)"external"), columns, selection, null, "date_added DESC");
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Cursor it = (Cursor)closeable;
                boolean bl3 = false;
                Cursor cursor2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)cursor2, (String)"it");
                List<AttachmentMetaData> list = this.getAttachmentsFromCursor(context, cursor2);
                return list;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<AttachmentMetaData> getAttachmentsFromUriList$stream_chat_android_release(@NotNull Context context, @NotNull List<? extends Uri> uriList) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(uriList, (String)"uriList");
        Iterable $this$mapNotNull$iv = uriList;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AttachmentMetaData attachmentMetaData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Uri uri = (Uri)element$iv$iv;
            boolean bl2 = false;
            Cursor cursor = context.getContentResolver().query(uri, null, null, null, null);
            if (cursor != null) {
                Closeable closeable = (Closeable)cursor;
                boolean bl3 = false;
                boolean bl4 = false;
                Throwable throwable = null;
                try {
                    Cursor cursor2 = (Cursor)closeable;
                    boolean bl5 = false;
                    cursor2.moveToFirst();
                    AttachmentMetaData attachmentMetaData2 = new AttachmentMetaData(uri, "file", context.getContentResolver().getType(uri), cursor2.getString(cursor2.getColumnIndex("_display_name")), null, 16, null);
                    boolean bl6 = false;
                    boolean bl7 = false;
                    AttachmentMetaData $this$apply = attachmentMetaData2;
                    boolean bl8 = false;
                    $this$apply.setSize(cursor2.getLong(cursor2.getColumnIndex("_size")));
                    AttachmentMetaData attachmentMetaData3 = attachmentMetaData2;
                    attachmentMetaData = attachmentMetaData3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                attachmentMetaData = null;
            }
            if (attachmentMetaData == null) continue;
            AttachmentMetaData attachmentMetaData4 = attachmentMetaData;
            boolean bl9 = false;
            boolean bl10 = false;
            AttachmentMetaData it$iv$iv = attachmentMetaData4;
            boolean bl11 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AttachmentMetaData> getAttachmentsFromCursor(Context context, Cursor cursor) {
        boolean bl = false;
        List attachments2 = new ArrayList();
        bl = false;
        boolean bl2 = false;
        Cursor $this$with = cursor;
        boolean bl3 = false;
        int n = 0;
        int n2 = $this$with.getCount();
        while (n < n2) {
            void i;
            block5: {
                void $this$getLongOrNull$iv;
                MediaType mediaType;
                block4: {
                    int type;
                    block3: {
                        $this$with.moveToPosition((int)i);
                        type = $this$with.getInt($this$with.getColumnIndex("media_type"));
                        if (type != 1) break block3;
                        mediaType = ImageMediaType.INSTANCE;
                        break block4;
                    }
                    if (type != 3) break block5;
                    mediaType = VideoMediaType.INSTANCE;
                }
                MediaType mediaType2 = mediaType;
                Uri uri = ContentUris.withAppendedId((Uri)mediaType2.getContentUri(), (long)$this$with.getLong($this$with.getColumnIndex("_id")));
                String displayName = $this$with.getString($this$with.getColumnIndex("_display_name"));
                Cursor cursor2 = $this$with;
                int index$iv = $this$with.getColumnIndex("duration");
                boolean $i$f$getLongOrNull = false;
                Long l = $this$getLongOrNull$iv.isNull(index$iv) ? null : Long.valueOf($this$getLongOrNull$iv.getLong(index$iv));
                long videoLength = l != null ? l : 0L;
                String mimeType = context.getContentResolver().getType(uri);
                Collection collection = attachments2;
                AttachmentMetaData attachmentMetaData = new AttachmentMetaData(uri, null, mimeType, null, null, 26, null);
                boolean bl4 = false;
                boolean bl5 = false;
                AttachmentMetaData $this$apply = attachmentMetaData;
                boolean bl6 = false;
                $this$apply.setType(mediaType2.getModelType());
                $this$apply.setSize($this$with.getLong($this$with.getColumnIndex("_size")));
                $this$apply.setTitle(displayName);
                $this$apply.setVideoLength(videoLength / (long)1000);
                bl4 = false;
                collection.add(attachmentMetaData);
            }
            ++i;
        }
        return attachments2;
    }

    private final String getFileName(AttachmentMetaData attachmentMetaData) {
        return "STREAM_" + this.dateFormat.format(new Date().getTime()) + '_' + StorageHelperKt.access$getTitleWithExtension(attachmentMetaData);
    }
}

