/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils;

import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.R;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import java.text.DecimalFormat;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0006H\u0007J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u0004\u00a8\u0006\u0011"}, d2={"Lcom/getstream/sdk/chat/utils/StringUtility;", "", "()V", "convertFileSizeByteCount", "", "bytes", "", "convertMentionedText", "text", "userName", "convertVideoLength", "videoLength", "getDeletedOrMentionedText", "message", "Lio/getstream/chat/android/client/models/Message;", "isEmoji", "", "stream-chat-android_release"})
public final class StringUtility {
    public static final StringUtility INSTANCE;

    public final boolean isEmoji(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        CharSequence charSequence = message;
        String string2 = "(?:[\ud83c\udf00-\ud83d\uddff]|[\ud83e\udd00-\ud83e\uddff]|[\ud83d\ude00-\ud83d\ude4f]|[\ud83d\ude80-\ud83d\udeff]|[\u2600-\u26ff]\ufe0f?|[\u2700-\u27bf]\ufe0f?|\u24c2\ufe0f?|[\ud83c\udde6-\ud83c\uddff]{1,2}|[\ud83c\udd70\ud83c\udd71\ud83c\udd7e\ud83c\udd7f\ud83c\udd8e\ud83c\udd91-\ud83c\udd9a]\ufe0f?|[#*0-9]\ufe0f?\u20e3|[\u2194-\u2199\u21a9-\u21aa]\ufe0f?|[\u2b05-\u2b07\u2b1b\u2b1c\u2b50\u2b55]\ufe0f?|[\u2934\u2935]\ufe0f?|[\u3030\u303d]\ufe0f?|[\u3297\u3299]\ufe0f?|[\ud83c\ude01\ud83c\ude02\ud83c\ude1a\ud83c\ude2f\ud83c\ude32-\ud83c\ude3a\ud83c\ude50\ud83c\ude51]\ufe0f?|[\u203c\u2049]\ufe0f?|[\u25aa\u25ab\u25b6\u25c0\u25fb-\u25fe]\ufe0f?|[\u00a9\u00ae]\ufe0f?|[\u2122\u2139]\ufe0f?|\ud83c\udc04\ufe0f?|\ud83c\udccf\ufe0f?|[\u231a\u231b\u2328\u23cf\u23e9-\u23f3\u23f8-\u23fa]\ufe0f?)+";
        boolean bl = false;
        string2 = new Regex(string2);
        bl = false;
        return string2.matches(charSequence);
    }

    @JvmStatic
    @NotNull
    public static final String getDeletedOrMentionedText(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = message.getText();
        String string2 = "^[\r\n]+|[\r\n]+$";
        boolean bl = false;
        string2 = new Regex(string2);
        String string3 = "";
        boolean bl2 = false;
        String text = string2.replace((CharSequence)object, string3);
        if (message.getDeletedAt() != null) {
            text = "_" + ChatUI.Companion.instance().getStrings().get(R.string.stream_delete_message) + "_";
            return text;
        }
        object = message.getMentionedUsers();
        boolean bl3 = false;
        boolean bl4 = false;
        if (!(object == null || object.isEmpty())) {
            for (User mentionedUser : message.getMentionedUsers()) {
                String userName = (String)mentionedUser.getExtraValue("name", (Object)"");
                int index = StringsKt.indexOf$default((CharSequence)text, (String)userName, (int)0, (boolean)false, (int)6, null);
                text = index > 1 && text.charAt(index - 2) != ' ' ? StringsKt.replace$default((String)text, (String)('@' + userName), (String)(" **@" + userName + "**"), (boolean)false, (int)4, null) : StringsKt.replace$default((String)text, (String)('@' + userName), (String)("**@" + userName + "**"), (boolean)false, (int)4, null);
            }
        }
        object = text;
        String string4 = "\n";
        boolean bl5 = false;
        string4 = new Regex(string4);
        String string5 = "  \n";
        bl2 = false;
        return string4.replace((CharSequence)object, string5);
    }

    @JvmStatic
    @NotNull
    public static final String convertVideoLength(long videoLength) {
        long hours = videoLength / (long)3600;
        long minutes = videoLength % (long)3600 / (long)60;
        long seconds = videoLength % (long)60;
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string2 = "%02d:%02d:%02d";
        Object[] objectArray = new Object[]{hours, minutes, seconds};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        return string3;
    }

    @JvmStatic
    @NotNull
    public static final String convertFileSizeByteCount(long bytes) {
        int unit = 1000;
        if (bytes <= 0L) {
            return "0 B";
        }
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = String.valueOf("KMGTPE".charAt(exp - 1));
        DecimalFormat df = new DecimalFormat("###.##");
        return df.format((double)bytes / Math.pow(unit, exp)) + " " + pre + "B";
    }

    @JvmStatic
    @NotNull
    public static final String convertMentionedText(@NotNull String text, @NotNull String userName) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
        if (StringsKt.last((CharSequence)text) == '@') {
            return text + userName;
        }
        String lastName = StringsKt.substringAfterLast$default((String)text, (char)'@', null, (int)2, null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = text;
        int n = 0;
        int n2 = text.length() - lastName.length();
        boolean bl = false;
        String string3 = string2.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return stringBuilder.append(string3).append(userName).toString();
    }

    private StringUtility() {
    }

    static {
        StringUtility stringUtility;
        INSTANCE = stringUtility = new StringUtility();
    }
}

