/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.exomedia;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.getstream.sdk.chat.utils.exomedia.ExoMedia;
import com.getstream.sdk.chat.utils.exomedia.core.ListenerMux;
import com.getstream.sdk.chat.utils.exomedia.core.api.AudioPlayerApi;
import com.getstream.sdk.chat.utils.exomedia.core.audio.ExoAudioPlayer;
import com.getstream.sdk.chat.utils.exomedia.core.audio.NativeAudioPlayer;
import com.getstream.sdk.chat.utils.exomedia.core.exoplayer.ExoMediaPlayer;
import com.getstream.sdk.chat.utils.exomedia.core.exoplayer.WindowInfo;
import com.getstream.sdk.chat.utils.exomedia.core.listener.MetadataListener;
import com.getstream.sdk.chat.utils.exomedia.listener.OnBufferUpdateListener;
import com.getstream.sdk.chat.utils.exomedia.listener.OnCompletionListener;
import com.getstream.sdk.chat.utils.exomedia.listener.OnErrorListener;
import com.getstream.sdk.chat.utils.exomedia.listener.OnPreparedListener;
import com.getstream.sdk.chat.utils.exomedia.listener.OnSeekCompletionListener;
import com.getstream.sdk.chat.utils.exomedia.util.DeviceUtil;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.util.Map;

public class AudioPlayer {
    protected ListenerMux listenerMux;
    protected AudioPlayerApi audioPlayerImpl;
    protected long overriddenDuration = -1L;

    public AudioPlayer(@NonNull Context context) {
        this(context, new DeviceUtil());
    }

    public AudioPlayer(@NonNull Context context, @NonNull DeviceUtil deviceUtil) {
        this.init(deviceUtil.supportsExoPlayer(context) ? new ExoAudioPlayer(context) : new NativeAudioPlayer(context));
    }

    public AudioPlayer(AudioPlayerApi audioPlayerImpl) {
        this.init(audioPlayerImpl);
    }

    protected void init(AudioPlayerApi audioPlayerImpl) {
        this.audioPlayerImpl = audioPlayerImpl;
        this.listenerMux = new ListenerMux(new MuxNotifier());
        audioPlayerImpl.setListenerMux(this.listenerMux);
    }

    public int getAudioSessionId() {
        return this.audioPlayerImpl.getAudioSessionId();
    }

    public void setRepeatMode(int repeatMode) {
        this.audioPlayerImpl.setRepeatMode(repeatMode);
    }

    public boolean setPlaybackSpeed(float speed) {
        return this.audioPlayerImpl.setPlaybackSpeed(speed);
    }

    public float getPlaybackSpeed() {
        return this.audioPlayerImpl.getPlaybackSpeed();
    }

    public void setAudioStreamType(int streamType) {
        this.audioPlayerImpl.setAudioStreamType(streamType);
    }

    public void setDataSource(@Nullable Uri uri) {
        this.audioPlayerImpl.setDataSource(uri);
        this.overrideDuration(-1L);
    }

    public void setDataSource(@Nullable Uri uri, @Nullable MediaSource mediaSource) {
        this.audioPlayerImpl.setDataSource(uri, mediaSource);
        this.overrideDuration(-1L);
    }

    public void setDrmCallback(@Nullable MediaDrmCallback drmCallback) {
        this.audioPlayerImpl.setDrmCallback(drmCallback);
    }

    public void prepareAsync() {
        this.audioPlayerImpl.prepareAsync();
    }

    @FloatRange(from=0.0, to=1.0)
    public float getVolumeLeft() {
        return this.audioPlayerImpl.getVolumeLeft();
    }

    @FloatRange(from=0.0, to=1.0)
    float getVolumeRight() {
        return this.audioPlayerImpl.getVolumeRight();
    }

    public void setVolume(@FloatRange(from=0.0, to=1.0) float leftVolume, @FloatRange(from=0.0, to=1.0) float rightVolume) {
        this.audioPlayerImpl.setVolume(leftVolume, rightVolume);
    }

    public void setWakeMode(Context context, int mode) {
        this.audioPlayerImpl.setWakeMode(context, mode);
    }

    public void reset() {
        this.stopPlayback();
        this.setDataSource(null, null);
        this.audioPlayerImpl.reset();
    }

    public void seekTo(long milliSeconds) {
        this.audioPlayerImpl.seekTo(milliSeconds);
    }

    public boolean isPlaying() {
        return this.audioPlayerImpl.isPlaying();
    }

    public void start() {
        this.audioPlayerImpl.start();
    }

    public void pause() {
        this.audioPlayerImpl.pause();
    }

    public void stopPlayback() {
        this.audioPlayerImpl.stopPlayback();
    }

    public void release() {
        this.audioPlayerImpl.release();
    }

    public long getDuration() {
        if (this.overriddenDuration >= 0L) {
            return this.overriddenDuration;
        }
        return this.audioPlayerImpl.getDuration();
    }

    public void overrideDuration(long duration) {
        this.overriddenDuration = duration;
    }

    public long getCurrentPosition() {
        return this.audioPlayerImpl.getCurrentPosition();
    }

    public int getBufferPercentage() {
        return this.audioPlayerImpl.getBufferedPercent();
    }

    @Nullable
    public WindowInfo getWindowInfo() {
        return this.audioPlayerImpl.getWindowInfo();
    }

    public boolean trackSelectionAvailable() {
        return this.audioPlayerImpl.trackSelectionAvailable();
    }

    @Deprecated
    public void setTrack(ExoMedia.RendererType trackType, int trackIndex) {
        this.audioPlayerImpl.setTrack(trackType, 0, trackIndex);
    }

    public void setTrack(ExoMedia.RendererType trackType, int groupIndex, int trackIndex) {
        this.audioPlayerImpl.setTrack(trackType, groupIndex, trackIndex);
    }

    public int getSelectedTrackIndex(@NonNull ExoMedia.RendererType type, int groupIndex) {
        return this.audioPlayerImpl.getSelectedTrackIndex(type, groupIndex);
    }

    @Nullable
    public Map<ExoMedia.RendererType, TrackGroupArray> getAvailableTracks() {
        return this.audioPlayerImpl.getAvailableTracks();
    }

    public void setOnPreparedListener(@Nullable OnPreparedListener listener) {
        this.listenerMux.setOnPreparedListener(listener);
    }

    public void setOnCompletionListener(@Nullable OnCompletionListener listener) {
        this.listenerMux.setOnCompletionListener(listener);
    }

    public void setOnBufferUpdateListener(@Nullable OnBufferUpdateListener listener) {
        this.listenerMux.setOnBufferUpdateListener(listener);
    }

    public void setOnSeekCompletionListener(@Nullable OnSeekCompletionListener listener) {
        this.listenerMux.setOnSeekCompletionListener(listener);
    }

    public void setOnErrorListener(@Nullable OnErrorListener listener) {
        this.listenerMux.setOnErrorListener(listener);
    }

    public void setMetadataListener(@Nullable MetadataListener listener) {
        this.listenerMux.setMetadataListener(listener);
    }

    public void setAnalyticsListener(@Nullable AnalyticsListener listener) {
        this.listenerMux.setAnalyticsListener(listener);
    }

    private void onPlaybackEnded() {
        this.pause();
    }

    private class MuxNotifier
    extends ListenerMux.Notifier {
        private MuxNotifier() {
        }

        @Override
        public boolean shouldNotifyCompletion(long endLeeway) {
            long position = AudioPlayer.this.getCurrentPosition();
            long duration = AudioPlayer.this.getDuration();
            return position > 0L && duration > 0L && position + endLeeway >= duration;
        }

        @Override
        public void onExoPlayerError(ExoMediaPlayer exoMediaPlayer, Exception e) {
            AudioPlayer.this.stopPlayback();
            if (exoMediaPlayer != null) {
                exoMediaPlayer.forcePrepare();
            }
        }

        @Override
        public void onMediaPlaybackEnded() {
            AudioPlayer.this.onPlaybackEnded();
        }

        @Override
        public void onPrepared() {
            AudioPlayer.this.audioPlayerImpl.onMediaPrepared();
        }
    }
}

