/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.exomedia.core.audio;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.getstream.sdk.chat.utils.exomedia.ExoMedia;
import com.getstream.sdk.chat.utils.exomedia.core.ListenerMux;
import com.getstream.sdk.chat.utils.exomedia.core.api.AudioPlayerApi;
import com.getstream.sdk.chat.utils.exomedia.core.exoplayer.ExoMediaPlayer;
import com.getstream.sdk.chat.utils.exomedia.core.exoplayer.WindowInfo;
import com.getstream.sdk.chat.utils.exomedia.core.listener.MetadataListener;
import com.getstream.sdk.chat.utils.exomedia.listener.OnBufferUpdateListener;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.TrackGroupArray;
import java.util.Map;

@TargetApi(value=16)
public class ExoAudioPlayer
implements AudioPlayerApi {
    @NonNull
    protected final ExoMediaPlayer exoMediaPlayer;
    @NonNull
    protected final Context context;
    protected ListenerMux listenerMux;
    @NonNull
    protected InternalListeners internalListeners = new InternalListeners();
    protected boolean playRequested = false;

    public ExoAudioPlayer(@NonNull Context context) {
        this.context = context;
        this.exoMediaPlayer = new ExoMediaPlayer(context);
        this.exoMediaPlayer.setMetadataListener(this.internalListeners);
        this.exoMediaPlayer.setBufferUpdateListener(this.internalListeners);
    }

    @Override
    public void setDataSource(@Nullable Uri uri) {
        this.setDataSource(uri, null);
    }

    @Override
    public void setDataSource(@Nullable Uri uri, @Nullable MediaSource mediaSource) {
        this.listenerMux.setNotifiedPrepared(false);
        this.exoMediaPlayer.seekTo(0L);
        if (mediaSource != null) {
            this.exoMediaPlayer.setMediaSource(mediaSource);
            this.listenerMux.setNotifiedCompleted(false);
        } else if (uri != null) {
            this.exoMediaPlayer.setUri(uri);
            this.listenerMux.setNotifiedCompleted(false);
        } else {
            this.exoMediaPlayer.setMediaSource(null);
        }
    }

    @Override
    public void setDrmCallback(@Nullable MediaDrmCallback drmCallback) {
        this.exoMediaPlayer.setDrmCallback(drmCallback);
    }

    @Override
    public void prepareAsync() {
        this.exoMediaPlayer.prepare();
    }

    @Override
    public void reset() {
    }

    @Override
    public float getVolumeLeft() {
        return this.exoMediaPlayer.getVolume();
    }

    @Override
    public float getVolumeRight() {
        return this.exoMediaPlayer.getVolume();
    }

    @Override
    public void setVolume(@FloatRange(from=0.0, to=1.0) float left, @FloatRange(from=0.0, to=1.0) float right) {
        this.exoMediaPlayer.setVolume((left + right) / 2.0f);
    }

    @Override
    public void seekTo(@IntRange(from=0L) long milliseconds) {
        this.exoMediaPlayer.seekTo(milliseconds);
    }

    @Override
    public boolean isPlaying() {
        return this.exoMediaPlayer.getPlayWhenReady();
    }

    @Override
    public void start() {
        this.exoMediaPlayer.setPlayWhenReady(true);
        this.listenerMux.setNotifiedCompleted(false);
        this.playRequested = true;
    }

    @Override
    public void pause() {
        this.exoMediaPlayer.setPlayWhenReady(false);
        this.playRequested = false;
    }

    @Override
    public void stopPlayback() {
        this.exoMediaPlayer.stop();
        this.playRequested = false;
    }

    @Override
    public boolean restart() {
        if (!this.exoMediaPlayer.restart()) {
            return false;
        }
        this.listenerMux.setNotifiedCompleted(false);
        this.listenerMux.setNotifiedPrepared(false);
        return true;
    }

    @Override
    public long getDuration() {
        if (!this.listenerMux.isPrepared()) {
            return 0L;
        }
        return this.exoMediaPlayer.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        if (!this.listenerMux.isPrepared()) {
            return 0L;
        }
        return this.exoMediaPlayer.getCurrentPosition();
    }

    @Override
    public int getBufferedPercent() {
        return this.exoMediaPlayer.getBufferedPercentage();
    }

    @Override
    @Nullable
    public WindowInfo getWindowInfo() {
        return this.exoMediaPlayer.getWindowInfo();
    }

    @Override
    public void release() {
        this.exoMediaPlayer.release();
    }

    @Override
    public int getAudioSessionId() {
        return this.exoMediaPlayer.getAudioSessionId();
    }

    @Override
    public boolean setPlaybackSpeed(float speed) {
        return this.exoMediaPlayer.setPlaybackSpeed(speed);
    }

    @Override
    public float getPlaybackSpeed() {
        return this.exoMediaPlayer.getPlaybackSpeed();
    }

    @Override
    public void setAudioStreamType(int streamType) {
        this.exoMediaPlayer.setAudioStreamType(streamType);
    }

    @Override
    public void setWakeMode(@NonNull Context context, int mode) {
        this.exoMediaPlayer.setWakeMode(context, mode);
    }

    @Override
    public boolean trackSelectionAvailable() {
        return true;
    }

    @Override
    public void setTrack(@NonNull ExoMedia.RendererType type, int trackIndex) {
        this.exoMediaPlayer.setSelectedTrack(type, 0, trackIndex);
    }

    @Override
    public void setTrack(@NonNull ExoMedia.RendererType type, int groupIndex, int trackIndex) {
        this.exoMediaPlayer.setSelectedTrack(type, groupIndex, trackIndex);
    }

    @Override
    public int getSelectedTrackIndex(@NonNull ExoMedia.RendererType type, int groupIndex) {
        return this.exoMediaPlayer.getSelectedTrackIndex(type, groupIndex);
    }

    @Override
    @Nullable
    public Map<ExoMedia.RendererType, TrackGroupArray> getAvailableTracks() {
        return this.exoMediaPlayer.getAvailableTracks();
    }

    @Override
    public void setListenerMux(ListenerMux listenerMux) {
        if (this.listenerMux != null) {
            this.exoMediaPlayer.removeListener(this.listenerMux);
            this.exoMediaPlayer.removeAnalyticsListener(this.listenerMux);
        }
        this.listenerMux = listenerMux;
        this.exoMediaPlayer.addListener(listenerMux);
        this.exoMediaPlayer.addAnalyticsListener(listenerMux);
    }

    @Override
    public void onMediaPrepared() {
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.exoMediaPlayer.setRepeatMode(repeatMode);
    }

    protected class InternalListeners
    implements MetadataListener,
    OnBufferUpdateListener {
        protected InternalListeners() {
        }

        @Override
        public void onMetadata(Metadata metadata) {
            ExoAudioPlayer.this.listenerMux.onMetadata(metadata);
        }

        @Override
        public void onBufferingUpdate(@IntRange(from=0L, to=100L) int percent) {
            ExoAudioPlayer.this.listenerMux.onBufferingUpdate(percent);
        }
    }
}

