/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.exomedia.core.exoplayer;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.PowerManager;
import android.view.Surface;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.collection.ArrayMap;
import com.getstream.sdk.chat.utils.exomedia.ExoMedia;
import com.getstream.sdk.chat.utils.exomedia.core.exoplayer.WindowInfo;
import com.getstream.sdk.chat.utils.exomedia.core.listener.CaptionListener;
import com.getstream.sdk.chat.utils.exomedia.core.listener.ExoPlayerListener;
import com.getstream.sdk.chat.utils.exomedia.core.listener.MetadataListener;
import com.getstream.sdk.chat.utils.exomedia.core.renderer.RendererProvider;
import com.getstream.sdk.chat.utils.exomedia.listener.OnBufferUpdateListener;
import com.getstream.sdk.chat.utils.exomedia.util.Repeater;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayer;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.PlaybackParameters;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.PlayerMessage;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsCollector;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.audio.AudioAttributes;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.decoder.DecoderCounters;
import com.google.android.exoplayer2.drm.DefaultDrmSessionManager;
import com.google.android.exoplayer2.drm.DrmSessionManager;
import com.google.android.exoplayer2.drm.ExoMediaDrm;
import com.google.android.exoplayer2.drm.FrameworkMediaDrm;
import com.google.android.exoplayer2.drm.MediaDrmCallback;
import com.google.android.exoplayer2.drm.MediaDrmCallbackException;
import com.google.android.exoplayer2.metadata.Metadata;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceEventListener;
import com.google.android.exoplayer2.source.TrackGroup;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.MappingTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.upstream.BandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExoMediaPlayer
implements Player.EventListener {
    private static final String TAG = "ExoMediaPlayer";
    private static final int BUFFER_REPEAT_DELAY = 1000;
    private static final int WAKE_LOCK_TIMEOUT = 1000;
    private TaggedLogger logger = ChatLogger.Companion.get((Object)"ExoMediaPlayer");
    @NonNull
    private final Context context;
    @NonNull
    private final ExoPlayer player;
    @NonNull
    private final DefaultTrackSelector trackSelector;
    @NonNull
    private final Handler mainHandler;
    @NonNull
    private final CopyOnWriteArrayList<ExoPlayerListener> listeners = new CopyOnWriteArrayList();
    @NonNull
    private final AtomicBoolean stopped = new AtomicBoolean();
    @FloatRange(from=0.0, to=1.0)
    protected float requestedVolume = 1.0f;
    private boolean prepared = false;
    @NonNull
    private StateStore stateStore = new StateStore();
    @NonNull
    private Repeater bufferRepeater = new Repeater();
    @Nullable
    private Surface surface;
    @Nullable
    private MediaDrmCallback drmCallback;
    @Nullable
    private MediaSource mediaSource;
    @NonNull
    private List<Renderer> renderers;
    @NonNull
    private DefaultBandwidthMeter bandwidthMeter;
    @Nullable
    private CaptionListener captionListener;
    @Nullable
    private MetadataListener metadataListener;
    @Nullable
    private OnBufferUpdateListener bufferUpdateListener;
    @Nullable
    private PowerManager.WakeLock wakeLock = null;
    private int audioSessionId = 0;
    @NonNull
    private AnalyticsCollector analyticsCollector;

    public ExoMediaPlayer(@NonNull Context context) {
        this.context = context;
        this.bandwidthMeter = new DefaultBandwidthMeter.Builder(context).build();
        this.bufferRepeater.setRepeaterDelay(1000);
        this.bufferRepeater.setRepeatListener(new BufferRepeatListener());
        this.mainHandler = new Handler();
        ComponentListener componentListener = new ComponentListener();
        RendererProvider rendererProvider = new RendererProvider(context, this.mainHandler, componentListener, componentListener, componentListener, componentListener);
        DrmSessionManager drmSessionManager = this.generateDrmSessionManager();
        rendererProvider.setDrmSessionManager(drmSessionManager);
        this.renderers = rendererProvider.generate();
        AdaptiveTrackSelection.Factory adaptiveTrackSelectionFactory = new AdaptiveTrackSelection.Factory();
        this.trackSelector = new DefaultTrackSelector(context, (TrackSelection.Factory)adaptiveTrackSelectionFactory);
        LoadControl loadControl = ExoMedia.Data.loadControl != null ? ExoMedia.Data.loadControl : new DefaultLoadControl();
        this.player = new ExoPlayer.Builder(context, this.renderers.toArray(new Renderer[0])).setTrackSelector((TrackSelector)this.trackSelector).setLoadControl(loadControl).setBandwidthMeter((BandwidthMeter)this.bandwidthMeter).build();
        this.player.addListener((Player.EventListener)this);
        this.analyticsCollector = new AnalyticsCollector(Clock.DEFAULT);
        this.analyticsCollector.setPlayer((Player)this.player);
        this.player.addListener((Player.EventListener)this.analyticsCollector);
    }

    public void onPlayerStateChanged(boolean playWhenReady, int state) {
        this.reportPlayerState();
    }

    public void onPlayerError(ExoPlaybackException exception) {
        for (ExoPlayerListener listener : this.listeners) {
            listener.onError(this, (Exception)exception);
        }
    }

    public void setDrmCallback(@Nullable MediaDrmCallback drmCallback) {
        this.drmCallback = drmCallback;
    }

    public void setUri(@Nullable Uri uri) {
        this.setMediaSource(uri != null ? ExoMedia.Data.mediaSourceProvider.generate(this.context, this.mainHandler, uri, (TransferListener)this.bandwidthMeter) : null);
    }

    public void setMediaSource(@Nullable MediaSource source) {
        if (this.mediaSource != null) {
            this.mediaSource.removeEventListener((MediaSourceEventListener)this.analyticsCollector);
        }
        if (source != null) {
            source.addEventListener(this.mainHandler, (MediaSourceEventListener)this.analyticsCollector);
        }
        this.mediaSource = source;
        this.prepared = false;
        this.prepare();
    }

    public void addListener(ExoPlayerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(ExoPlayerListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void setBufferUpdateListener(@Nullable OnBufferUpdateListener listener) {
        this.bufferUpdateListener = listener;
        this.setBufferRepeaterStarted(listener != null);
    }

    public void setCaptionListener(@Nullable CaptionListener listener) {
        this.captionListener = listener;
    }

    public void setMetadataListener(@Nullable MetadataListener listener) {
        this.metadataListener = listener;
    }

    @Nullable
    public Surface getSurface() {
        return this.surface;
    }

    public void setSurface(@Nullable Surface surface) {
        this.surface = surface;
        this.sendMessage(2, 1, surface, false);
    }

    @NonNull
    public ExoPlayer getExoPlayer() {
        return this.player;
    }

    @NonNull
    public BandwidthMeter getBandwidthMeter() {
        return this.bandwidthMeter;
    }

    @NonNull
    public AnalyticsCollector getAnalyticsCollector() {
        return this.analyticsCollector;
    }

    public void addAnalyticsListener(AnalyticsListener listener) {
        this.analyticsCollector.addListener(listener);
    }

    public void removeAnalyticsListener(AnalyticsListener listener) {
        this.analyticsCollector.removeListener(listener);
    }

    public void clearSurface() {
        if (this.surface != null) {
            this.surface.release();
        }
        this.surface = null;
        this.sendMessage(2, 1, null, false);
    }

    @Deprecated
    public void blockingClearSurface() {
        this.clearSurface();
    }

    @Nullable
    public Map<ExoMedia.RendererType, TrackGroupArray> getAvailableTracks() {
        ExoMedia.RendererType[] types;
        if (this.getPlaybackState() == 1) {
            return null;
        }
        ArrayMap trackMap = new ArrayMap();
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        if (mappedTrackInfo == null) {
            return trackMap;
        }
        for (ExoMedia.RendererType type : types = new ExoMedia.RendererType[]{ExoMedia.RendererType.AUDIO, ExoMedia.RendererType.VIDEO, ExoMedia.RendererType.CLOSED_CAPTION, ExoMedia.RendererType.METADATA}) {
            ArrayList<TrackGroup> trackGroups = new ArrayList<TrackGroup>();
            for (Integer exoPlayerTrackIndex : this.getExoPlayerTracksInfo((ExoMedia.RendererType)type, (int)0, (MappingTrackSelector.MappedTrackInfo)mappedTrackInfo).rendererTrackIndexes) {
                TrackGroupArray trackGroupArray = mappedTrackInfo.getTrackGroups(exoPlayerTrackIndex.intValue());
                for (int i = 0; i < trackGroupArray.length; ++i) {
                    trackGroups.add(trackGroupArray.get(i));
                }
            }
            if (trackGroups.isEmpty()) continue;
            trackMap.put(type, new TrackGroupArray(trackGroups.toArray(new TrackGroup[trackGroups.size()])));
        }
        return trackMap;
    }

    public int getSelectedTrackIndex(@NonNull ExoMedia.RendererType type) {
        return this.getSelectedTrackIndex(type, 0);
    }

    public int getSelectedTrackIndex(@NonNull ExoMedia.RendererType type, int groupIndex) {
        TrackGroupArray trackGroupArray;
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        ExoPlayerRendererTracksInfo tracksInfo = this.getExoPlayerTracksInfo(type, groupIndex, mappedTrackInfo);
        TrackGroupArray trackGroupArray2 = trackGroupArray = tracksInfo.rendererTrackIndex == -1 ? null : mappedTrackInfo.getTrackGroups(tracksInfo.rendererTrackIndex);
        if (trackGroupArray == null || trackGroupArray.length == 0) {
            return -1;
        }
        DefaultTrackSelector.SelectionOverride selectionOverride = this.trackSelector.getParameters().getSelectionOverride(tracksInfo.rendererTrackIndex, trackGroupArray);
        if (selectionOverride == null || selectionOverride.groupIndex != tracksInfo.rendererTrackGroupIndex || selectionOverride.length <= 0) {
            return -1;
        }
        return selectionOverride.tracks[0];
    }

    @Deprecated
    public void setSelectedTrack(@NonNull ExoMedia.RendererType type, int index) {
        this.setSelectedTrack(type, 0, index);
    }

    public void setSelectedTrack(@NonNull ExoMedia.RendererType type, int groupIndex, int trackIndex) {
        TrackGroupArray trackGroupArray;
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        ExoPlayerRendererTracksInfo tracksInfo = this.getExoPlayerTracksInfo(type, groupIndex, mappedTrackInfo);
        TrackGroupArray trackGroupArray2 = trackGroupArray = tracksInfo.rendererTrackIndex == -1 || mappedTrackInfo == null ? null : mappedTrackInfo.getTrackGroups(tracksInfo.rendererTrackIndex);
        if (trackGroupArray == null || trackGroupArray.length == 0 || trackGroupArray.length <= tracksInfo.rendererTrackGroupIndex) {
            return;
        }
        TrackGroup group = trackGroupArray.get(tracksInfo.rendererTrackGroupIndex);
        if (group == null || group.length <= trackIndex) {
            return;
        }
        DefaultTrackSelector.ParametersBuilder parametersBuilder = this.trackSelector.buildUponParameters();
        for (int rendererTrackIndex : tracksInfo.rendererTrackIndexes) {
            parametersBuilder.clearSelectionOverrides(rendererTrackIndex);
            if (tracksInfo.rendererTrackIndex == rendererTrackIndex) {
                parametersBuilder.setSelectionOverride(rendererTrackIndex, trackGroupArray, new DefaultTrackSelector.SelectionOverride(tracksInfo.rendererTrackGroupIndex, new int[]{trackIndex}));
                parametersBuilder.setRendererDisabled(rendererTrackIndex, false);
                continue;
            }
            parametersBuilder.setRendererDisabled(rendererTrackIndex, true);
        }
        this.trackSelector.setParameters(parametersBuilder);
    }

    public void clearSelectedTracks(@NonNull ExoMedia.RendererType type) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        ExoPlayerRendererTracksInfo tracksInfo = this.getExoPlayerTracksInfo(type, 0, mappedTrackInfo);
        DefaultTrackSelector.ParametersBuilder parametersBuilder = this.trackSelector.buildUponParameters();
        for (int rendererTrackIndex : tracksInfo.rendererTrackIndexes) {
            parametersBuilder.setRendererDisabled(rendererTrackIndex, false).clearSelectionOverrides(rendererTrackIndex);
        }
        this.trackSelector.setParameters(parametersBuilder);
    }

    public void setRendererEnabled(@NonNull ExoMedia.RendererType type, boolean enabled) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        ExoPlayerRendererTracksInfo tracksInfo = this.getExoPlayerTracksInfo(type, 0, mappedTrackInfo);
        if (!tracksInfo.rendererTrackIndexes.isEmpty()) {
            boolean enabledSomething = false;
            DefaultTrackSelector.ParametersBuilder parametersBuilder = this.trackSelector.buildUponParameters();
            for (int rendererTrackIndex : tracksInfo.rendererTrackIndexes) {
                if (enabled) {
                    DefaultTrackSelector.SelectionOverride selectionOverride = this.trackSelector.getParameters().getSelectionOverride(rendererTrackIndex, mappedTrackInfo.getTrackGroups(rendererTrackIndex));
                    if (selectionOverride == null) continue;
                    parametersBuilder.setRendererDisabled(rendererTrackIndex, false);
                    enabledSomething = true;
                    continue;
                }
                parametersBuilder.setRendererDisabled(rendererTrackIndex, true);
            }
            if (enabled && !enabledSomething) {
                parametersBuilder.setRendererDisabled(tracksInfo.rendererTrackIndexes.get(0).intValue(), false);
            }
            this.trackSelector.setParameters(parametersBuilder);
        }
    }

    public boolean isRendererEnabled(@NonNull ExoMedia.RendererType type) {
        MappingTrackSelector.MappedTrackInfo mappedTrackInfo = this.trackSelector.getCurrentMappedTrackInfo();
        ExoPlayerRendererTracksInfo tracksInfo = this.getExoPlayerTracksInfo(type, 0, mappedTrackInfo);
        DefaultTrackSelector.Parameters parameters = this.trackSelector.getParameters();
        for (Integer rendererTrackIndex : tracksInfo.rendererTrackIndexes) {
            if (parameters.getRendererDisabled(rendererTrackIndex.intValue())) continue;
            return true;
        }
        return false;
    }

    @FloatRange(from=0.0, to=1.0)
    public float getVolume() {
        return this.requestedVolume;
    }

    public void setVolume(@FloatRange(from=0.0, to=1.0) float volume) {
        this.requestedVolume = volume;
        this.sendMessage(1, 2, Float.valueOf(this.requestedVolume));
    }

    public void setAudioStreamType(int streamType) {
        int usage = Util.getAudioUsageForStreamType((int)streamType);
        int contentType = Util.getAudioContentTypeForStreamType((int)streamType);
        AudioAttributes audioAttributes = new AudioAttributes.Builder().setUsage(usage).setContentType(contentType).build();
        this.sendMessage(1, 3, audioAttributes);
    }

    public void forcePrepare() {
        this.prepared = false;
    }

    public void prepare() {
        if (this.prepared || this.mediaSource == null) {
            return;
        }
        if (!this.renderers.isEmpty()) {
            this.player.stop();
        }
        this.stateStore.reset();
        this.player.prepare(this.mediaSource);
        this.prepared = true;
        this.stopped.set(false);
    }

    public void stop() {
        if (!this.stopped.getAndSet(true)) {
            this.player.setPlayWhenReady(false);
            this.player.stop();
        }
    }

    public void seekTo(long positionMs) {
        this.seekTo(positionMs, false);
    }

    public void seekTo(long positionMs, boolean limitToCurrentWindow) {
        this.analyticsCollector.notifySeekStarted();
        if (limitToCurrentWindow) {
            this.player.seekTo(positionMs);
            this.stateStore.setMostRecentState(this.stateStore.isLastReportedPlayWhenReady(), 100);
            return;
        }
        Timeline timeline = this.player.getCurrentTimeline();
        int windowCount = timeline.getWindowCount();
        long cumulativePositionMs = 0L;
        Timeline.Window window = new Timeline.Window();
        for (int index = 0; index < windowCount; ++index) {
            timeline.getWindow(index, window);
            long windowDurationMs = window.getDurationMs();
            if (cumulativePositionMs < positionMs && positionMs <= cumulativePositionMs + windowDurationMs) {
                this.player.seekTo(index, positionMs - cumulativePositionMs);
                this.stateStore.setMostRecentState(this.stateStore.isLastReportedPlayWhenReady(), 100);
                return;
            }
            cumulativePositionMs += windowDurationMs;
        }
        this.logger.logE("Unable to seek across windows, falling back to in-window seeking");
        this.player.seekTo(positionMs);
        this.stateStore.setMostRecentState(this.stateStore.isLastReportedPlayWhenReady(), 100);
    }

    public boolean restart() {
        int playbackState = this.getPlaybackState();
        if (playbackState != 1 && playbackState != 4) {
            return false;
        }
        this.seekTo(0L);
        this.setPlayWhenReady(true);
        this.forcePrepare();
        this.prepare();
        return true;
    }

    public void release() {
        this.setBufferRepeaterStarted(false);
        this.listeners.clear();
        if (this.mediaSource != null) {
            this.mediaSource.removeEventListener((MediaSourceEventListener)this.analyticsCollector);
        }
        this.surface = null;
        this.player.release();
        this.stayAwake(false);
    }

    public int getPlaybackState() {
        return this.player.getPlaybackState();
    }

    public int getAudioSessionId() {
        return this.audioSessionId;
    }

    public boolean setPlaybackSpeed(float speed) {
        PlaybackParameters params = new PlaybackParameters(speed, 1.0f);
        this.player.setPlaybackParameters(params);
        return true;
    }

    public float getPlaybackSpeed() {
        PlaybackParameters params = this.player.getPlaybackParameters();
        return params.speed;
    }

    public long getCurrentPosition() {
        return this.getCurrentPosition(false);
    }

    public long getCurrentPosition(boolean limitToCurrentWindow) {
        long positionInCurrentWindow = this.player.getCurrentPosition();
        if (limitToCurrentWindow) {
            return positionInCurrentWindow;
        }
        Timeline timeline = this.player.getCurrentTimeline();
        int maxWindowIndex = Math.min(timeline.getWindowCount() - 1, this.player.getCurrentWindowIndex());
        long cumulativePositionMs = 0L;
        Timeline.Window window = new Timeline.Window();
        for (int index = 0; index < maxWindowIndex; ++index) {
            timeline.getWindow(index, window);
            cumulativePositionMs += window.getDurationMs();
        }
        return cumulativePositionMs + positionInCurrentWindow;
    }

    public long getDuration() {
        return this.player.getDuration();
    }

    public int getBufferedPercentage() {
        return this.player.getBufferedPercentage();
    }

    @Nullable
    public WindowInfo getWindowInfo() {
        Timeline timeline = this.player.getCurrentTimeline();
        if (timeline.isEmpty()) {
            return null;
        }
        int currentWindowIndex = this.player.getCurrentWindowIndex();
        Timeline.Window currentWindow = timeline.getWindow(currentWindowIndex, new Timeline.Window(), true);
        return new WindowInfo(this.player.getPreviousWindowIndex(), currentWindowIndex, this.player.getNextWindowIndex(), currentWindow);
    }

    public boolean getPlayWhenReady() {
        return this.player.getPlayWhenReady();
    }

    public void setPlayWhenReady(boolean playWhenReady) {
        this.player.setPlayWhenReady(playWhenReady);
        this.stayAwake(playWhenReady);
    }

    public void setWakeMode(Context context, int mode) {
        boolean wasHeld = false;
        if (this.wakeLock != null) {
            if (this.wakeLock.isHeld()) {
                wasHeld = true;
                this.wakeLock.release();
            }
            this.wakeLock = null;
        }
        if (context.getPackageManager().checkPermission("android.permission.WAKE_LOCK", context.getPackageName()) == 0) {
            PowerManager pm = (PowerManager)context.getSystemService("power");
            if (pm != null) {
                this.wakeLock = pm.newWakeLock(mode | 0x20000000, ExoMediaPlayer.class.getName());
                this.wakeLock.setReferenceCounted(false);
            } else {
                this.logger.logE("Unable to acquire WAKE_LOCK due to a null power manager");
            }
        } else {
            this.logger.logW("Unable to acquire WAKE_LOCK due to missing manifest permission");
        }
        this.stayAwake(wasHeld);
    }

    public void setRepeatMode(int repeatMode) {
        this.player.setRepeatMode(repeatMode);
    }

    protected int getExoPlayerTrackType(@NonNull ExoMedia.RendererType type) {
        switch (type) {
            case AUDIO: {
                return 1;
            }
            case VIDEO: {
                return 2;
            }
            case CLOSED_CAPTION: {
                return 3;
            }
            case METADATA: {
                return 4;
            }
        }
        return -1;
    }

    protected ExoMedia.RendererType getExoMediaRendererType(int exoPlayerTrackType) {
        switch (exoPlayerTrackType) {
            case 1: {
                return ExoMedia.RendererType.AUDIO;
            }
            case 2: {
                return ExoMedia.RendererType.VIDEO;
            }
            case 3: {
                return ExoMedia.RendererType.CLOSED_CAPTION;
            }
            case 4: {
                return ExoMedia.RendererType.METADATA;
            }
        }
        return null;
    }

    protected ExoPlayerRendererTracksInfo getExoPlayerTracksInfo(@NonNull ExoMedia.RendererType type, int groupIndex, MappingTrackSelector.MappedTrackInfo mappedTrackInfo) {
        ArrayList<Integer> exoPlayerRendererTrackIndexes = new ArrayList<Integer>();
        int exoPlayerRendererTrackIndex = -1;
        int exoPlayerRendererTrackGroupIndex = -1;
        int skippedRenderersGroupsCount = 0;
        if (mappedTrackInfo != null) {
            for (int rendererIndex = 0; rendererIndex < mappedTrackInfo.getRendererCount(); ++rendererIndex) {
                int exoPlayerRendererType = mappedTrackInfo.getRendererType(rendererIndex);
                if (type != this.getExoMediaRendererType(exoPlayerRendererType)) continue;
                exoPlayerRendererTrackIndexes.add(rendererIndex);
                TrackGroupArray trackGroups = mappedTrackInfo.getTrackGroups(rendererIndex);
                if (skippedRenderersGroupsCount + trackGroups.length > groupIndex) {
                    if (exoPlayerRendererTrackIndex != -1) continue;
                    exoPlayerRendererTrackIndex = rendererIndex;
                    exoPlayerRendererTrackGroupIndex = groupIndex - skippedRenderersGroupsCount;
                    continue;
                }
                skippedRenderersGroupsCount += trackGroups.length;
            }
        }
        return new ExoPlayerRendererTracksInfo(exoPlayerRendererTrackIndexes, exoPlayerRendererTrackIndex, exoPlayerRendererTrackGroupIndex);
    }

    protected void sendMessage(int renderType, int messageType, Object message) {
        this.sendMessage(renderType, messageType, message, false);
    }

    protected void sendMessage(int renderType, int messageType, Object message, boolean blocking) {
        if (this.renderers.isEmpty()) {
            return;
        }
        ArrayList<PlayerMessage> messages = new ArrayList<PlayerMessage>();
        for (Renderer renderer : this.renderers) {
            if (renderer.getTrackType() != renderType) continue;
            messages.add(this.player.createMessage((PlayerMessage.Target)renderer).setType(messageType).setPayload(message));
        }
        if (blocking) {
            this.blockingSendMessages(messages);
        } else {
            for (PlayerMessage playerMessage : messages) {
                playerMessage.send();
            }
        }
    }

    protected void blockingSendMessages(List<PlayerMessage> messages) {
        boolean wasInterrupted = false;
        for (PlayerMessage message : messages) {
            boolean blockMessage = true;
            while (blockMessage) {
                try {
                    message.blockUntilDelivered();
                    blockMessage = false;
                }
                catch (InterruptedException e) {
                    wasInterrupted = true;
                }
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    protected void stayAwake(boolean awake) {
        if (this.wakeLock == null) {
            return;
        }
        if (awake && !this.wakeLock.isHeld()) {
            this.wakeLock.acquire(1000L);
        } else if (!awake && this.wakeLock.isHeld()) {
            this.wakeLock.release();
        }
    }

    @Nullable
    protected DrmSessionManager generateDrmSessionManager() {
        if (Build.VERSION.SDK_INT < 18) {
            return null;
        }
        UUID uuid = C.WIDEVINE_UUID;
        try {
            DefaultDrmSessionManager sessionManager = new DefaultDrmSessionManager.Builder().setUuidAndExoMediaDrmProvider(uuid, FrameworkMediaDrm.DEFAULT_PROVIDER).build((MediaDrmCallback)new DelegatedMediaDrmCallback());
            return sessionManager;
        }
        catch (Exception e) {
            this.logger.logE((Throwable)e);
            return null;
        }
    }

    private void reportPlayerState() {
        int playbackState;
        boolean playWhenReady = this.player.getPlayWhenReady();
        int newState = this.stateStore.getState(playWhenReady, playbackState = this.getPlaybackState());
        if (newState != this.stateStore.getMostRecentState()) {
            this.stateStore.setMostRecentState(playWhenReady, playbackState);
            if (newState == 3) {
                this.setBufferRepeaterStarted(true);
            } else if (newState == 1 || newState == 4) {
                this.setBufferRepeaterStarted(false);
            }
            boolean informSeekCompletion = this.stateStore.matchesHistory(new int[]{100, 2, 3}, true);
            informSeekCompletion |= this.stateStore.matchesHistory(new int[]{2, 100, 3}, true);
            informSeekCompletion |= this.stateStore.matchesHistory(new int[]{100, 3, 2, 3}, true);
            for (ExoPlayerListener listener : this.listeners) {
                listener.onStateChanged(playWhenReady, playbackState);
                if (!informSeekCompletion) continue;
                listener.onSeekComplete();
            }
        }
    }

    private void setBufferRepeaterStarted(boolean start) {
        if (start && this.bufferUpdateListener != null) {
            this.bufferRepeater.start();
        } else {
            this.bufferRepeater.stop();
        }
    }

    private class ComponentListener
    implements VideoRendererEventListener,
    AudioRendererEventListener,
    TextOutput,
    MetadataOutput {
        private ComponentListener() {
        }

        public void onAudioEnabled(DecoderCounters counters) {
            ExoMediaPlayer.this.analyticsCollector.onAudioEnabled(counters);
        }

        public void onAudioDisabled(DecoderCounters counters) {
            ExoMediaPlayer.this.audioSessionId = 0;
            ExoMediaPlayer.this.analyticsCollector.onAudioDisabled(counters);
        }

        public void onAudioSessionId(int sessionId) {
            ExoMediaPlayer.this.audioSessionId = sessionId;
            ExoMediaPlayer.this.analyticsCollector.onAudioSessionId(sessionId);
        }

        public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            ExoMediaPlayer.this.analyticsCollector.onAudioDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
        }

        public void onAudioInputFormatChanged(Format format) {
            ExoMediaPlayer.this.analyticsCollector.onAudioInputFormatChanged(format);
        }

        public void onVideoEnabled(DecoderCounters counters) {
            ExoMediaPlayer.this.analyticsCollector.onVideoEnabled(counters);
        }

        public void onVideoDisabled(DecoderCounters counters) {
            ExoMediaPlayer.this.analyticsCollector.onVideoDisabled(counters);
        }

        public void onVideoDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            ExoMediaPlayer.this.analyticsCollector.onVideoDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs);
        }

        public void onVideoInputFormatChanged(Format format) {
            ExoMediaPlayer.this.analyticsCollector.onVideoInputFormatChanged(format);
        }

        public void onDroppedFrames(int count, long elapsedMs) {
            ExoMediaPlayer.this.analyticsCollector.onDroppedFrames(count, elapsedMs);
        }

        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            for (ExoPlayerListener listener : ExoMediaPlayer.this.listeners) {
                listener.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
            }
            ExoMediaPlayer.this.analyticsCollector.onVideoSizeChanged(width, height, unappliedRotationDegrees, pixelWidthHeightRatio);
        }

        public void onRenderedFirstFrame(Surface surface) {
            ExoMediaPlayer.this.analyticsCollector.onRenderedFirstFrame(surface);
        }

        public void onMetadata(Metadata metadata) {
            if (ExoMediaPlayer.this.metadataListener != null) {
                ExoMediaPlayer.this.metadataListener.onMetadata(metadata);
            }
            ExoMediaPlayer.this.analyticsCollector.onMetadata(metadata);
        }

        public void onCues(List<Cue> cues) {
            if (ExoMediaPlayer.this.captionListener != null) {
                ExoMediaPlayer.this.captionListener.onCues(cues);
            }
        }
    }

    private class DelegatedMediaDrmCallback
    implements MediaDrmCallback {
        private DelegatedMediaDrmCallback() {
        }

        public byte[] executeProvisionRequest(UUID uuid, ExoMediaDrm.ProvisionRequest request) throws MediaDrmCallbackException {
            return ExoMediaPlayer.this.drmCallback != null ? ExoMediaPlayer.this.drmCallback.executeProvisionRequest(uuid, request) : new byte[]{};
        }

        public byte[] executeKeyRequest(UUID uuid, ExoMediaDrm.KeyRequest request) throws MediaDrmCallbackException {
            return ExoMediaPlayer.this.drmCallback != null ? ExoMediaPlayer.this.drmCallback.executeKeyRequest(uuid, request) : new byte[]{};
        }
    }

    private class BufferRepeatListener
    implements Repeater.RepeatListener {
        private BufferRepeatListener() {
        }

        @Override
        public void onRepeat() {
            if (ExoMediaPlayer.this.bufferUpdateListener != null) {
                ExoMediaPlayer.this.bufferUpdateListener.onBufferingUpdate(ExoMediaPlayer.this.getBufferedPercentage());
            }
        }
    }

    class ExoPlayerRendererTracksInfo {
        final List<Integer> rendererTrackIndexes;
        final int rendererTrackIndex;
        final int rendererTrackGroupIndex;

        public ExoPlayerRendererTracksInfo(List<Integer> rendererTrackIndexes, int rendererTrackIndex, int rendererTrackGroupIndex) {
            this.rendererTrackIndexes = Collections.unmodifiableList(rendererTrackIndexes);
            this.rendererTrackIndex = rendererTrackIndex;
            this.rendererTrackGroupIndex = rendererTrackGroupIndex;
        }
    }

    private static class StateStore {
        public static final int FLAG_PLAY_WHEN_READY = -268435456;
        public static final int STATE_SEEKING = 100;
        private int[] prevStates = new int[]{1, 1, 1, 1};

        private StateStore() {
        }

        public void reset() {
            for (int i = 0; i < this.prevStates.length; ++i) {
                this.prevStates[i] = 1;
            }
        }

        public void setMostRecentState(boolean playWhenReady, int state) {
            int newState = this.getState(playWhenReady, state);
            if (this.prevStates[3] == newState) {
                return;
            }
            this.prevStates[0] = this.prevStates[1];
            this.prevStates[1] = this.prevStates[2];
            this.prevStates[2] = this.prevStates[3];
            this.prevStates[3] = state;
        }

        public int getState(boolean playWhenReady, int state) {
            return state | (playWhenReady ? -268435456 : 0);
        }

        public int getMostRecentState() {
            return this.prevStates[3];
        }

        public boolean isLastReportedPlayWhenReady() {
            return (this.prevStates[3] & 0xF0000000) != 0;
        }

        public boolean matchesHistory(@Size(min=1L, max=4L) int[] states, boolean ignorePlayWhenReady) {
            int startIndex;
            boolean flag = true;
            int andFlag = ignorePlayWhenReady ? 0xFFFFFFF : -1;
            for (int i = startIndex = this.prevStates.length - states.length; i < this.prevStates.length; ++i) {
                flag &= (this.prevStates[i] & andFlag) == (states[i - startIndex] & andFlag);
            }
            return flag;
        }
    }
}

