/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.exomedia.core.video;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.SurfaceTexture;
import android.os.Build;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.getstream.sdk.chat.utils.exomedia.core.video.ClearableSurface;
import com.getstream.sdk.chat.utils.exomedia.core.video.scale.MatrixManager;
import com.getstream.sdk.chat.utils.exomedia.core.video.scale.ScaleType;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class ResizingTextureView
extends TextureView
implements ClearableSurface {
    protected static final int MAX_DEGREES = 360;
    private static final String TAG = "ResizingTextureView";
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int[] GL_CLEAR_CONFIG_ATTRIBUTES = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12352, 4, 12344, 0, 12344};
    private static final int[] GL_CLEAR_CONTEXT_ATTRIBUTES = new int[]{12440, 2, 12344};
    @NonNull
    protected final ReentrantLock globalLayoutMatrixListenerLock = new ReentrantLock(true);
    @Nullable
    protected OnSizeChangeListener onSizeChangeListener;
    @NonNull
    protected Point lastNotifiedSize = new Point(0, 0);
    @NonNull
    protected Point videoSize = new Point(0, 0);
    @NonNull
    protected MatrixManager matrixManager = new MatrixManager();
    @NonNull
    protected AttachedListener attachedListener = new AttachedListener();
    @NonNull
    protected GlobalLayoutMatrixListener globalLayoutMatrixListener = new GlobalLayoutMatrixListener();
    @IntRange(from=0L, to=359L)
    protected int requestedUserRotation = 0;
    @IntRange(from=0L, to=359L)
    protected int requestedConfigurationRotation = 0;
    protected boolean measureBasedOnAspectRatio;
    private TaggedLogger logger = ChatLogger.Companion.get((Object)this);

    public ResizingTextureView(Context context) {
        super(context);
    }

    public ResizingTextureView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ResizingTextureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public ResizingTextureView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (!this.measureBasedOnAspectRatio) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            this.notifyOnSizeChangeListener(this.getMeasuredWidth(), this.getMeasuredHeight());
            return;
        }
        int width = ResizingTextureView.getDefaultSize((int)this.videoSize.x, (int)widthMeasureSpec);
        int height = ResizingTextureView.getDefaultSize((int)this.videoSize.y, (int)heightMeasureSpec);
        if (this.videoSize.x <= 0 || this.videoSize.y <= 0) {
            this.setMeasuredDimension(width, height);
            this.notifyOnSizeChangeListener(width, height);
            return;
        }
        int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
            height = heightSpecSize;
            width = widthSpecSize;
            if (this.videoSize.x * height < width * this.videoSize.y) {
                width = height * this.videoSize.x / this.videoSize.y;
            } else if (this.videoSize.x * height > width * this.videoSize.y) {
                height = width * this.videoSize.y / this.videoSize.x;
            }
        } else if (widthSpecMode == 0x40000000) {
            width = widthSpecSize;
            height = width * this.videoSize.y / this.videoSize.x;
            if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                height = heightSpecSize;
            }
        } else if (heightSpecMode == 0x40000000) {
            height = heightSpecSize;
            width = height * this.videoSize.x / this.videoSize.y;
            if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                width = widthSpecSize;
            }
        } else {
            width = this.videoSize.x;
            height = this.videoSize.y;
            if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                height = heightSpecSize;
                width = height * this.videoSize.x / this.videoSize.y;
            }
            if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                width = widthSpecSize;
                height = width * this.videoSize.y / this.videoSize.x;
            }
        }
        this.setMeasuredDimension(width, height);
        this.notifyOnSizeChangeListener(width, height);
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        this.updateMatrixOnLayout();
        super.onConfigurationChanged(newConfig);
    }

    public void setOnSizeChangeListener(@Nullable OnSizeChangeListener listener) {
        this.onSizeChangeListener = listener;
    }

    @Override
    public void clearSurface() {
        if (this.getSurfaceTexture() == null) {
            return;
        }
        try {
            EGL10 gl10 = (EGL10)EGLContext.getEGL();
            EGLDisplay display = gl10.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
            gl10.eglInitialize(display, null);
            EGLConfig[] configs = new EGLConfig[1];
            gl10.eglChooseConfig(display, GL_CLEAR_CONFIG_ATTRIBUTES, configs, configs.length, new int[1]);
            EGLContext context = gl10.eglCreateContext(display, configs[0], EGL10.EGL_NO_CONTEXT, GL_CLEAR_CONTEXT_ATTRIBUTES);
            EGLSurface eglSurface = gl10.eglCreateWindowSurface(display, configs[0], (Object)this.getSurfaceTexture(), new int[]{12344});
            gl10.eglMakeCurrent(display, eglSurface, eglSurface, context);
            gl10.eglSwapBuffers(display, eglSurface);
            gl10.eglDestroySurface(display, eglSurface);
            gl10.eglMakeCurrent(display, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
            gl10.eglDestroyContext(display, context);
            gl10.eglTerminate(display);
        }
        catch (Exception e) {
            this.logger.logE("Error clearing surface", (Throwable)e);
        }
    }

    protected boolean updateVideoSize(int width, int height) {
        this.matrixManager.setIntrinsicVideoSize(width, height);
        this.updateMatrixOnLayout();
        this.videoSize.x = width;
        this.videoSize.y = height;
        if (width == 0 || height == 0) {
            return false;
        }
        if (Build.VERSION.SDK_INT >= 15) {
            SurfaceTexture surfaceTexture = this.getSurfaceTexture();
            if (surfaceTexture != null) {
                surfaceTexture.setDefaultBufferSize(width, height);
            } else {
                return false;
            }
        }
        return true;
    }

    @NonNull
    public ScaleType getScaleType() {
        return this.matrixManager.getCurrentScaleType();
    }

    public void setScaleType(@NonNull ScaleType scaleType) {
        this.matrixManager.scale((View)this, scaleType);
    }

    public void setMeasureBasedOnAspectRatioEnabled(boolean enabled) {
        this.measureBasedOnAspectRatio = enabled;
        this.requestLayout();
    }

    public void setVideoRotation(@IntRange(from=0L, to=359L) int rotation, boolean fromUser) {
        this.setVideoRotation(fromUser ? rotation : this.requestedUserRotation, !fromUser ? rotation : this.requestedConfigurationRotation);
    }

    public void setVideoRotation(@IntRange(from=0L, to=359L) int userRotation, @IntRange(from=0L, to=359L) int configurationRotation) {
        this.requestedUserRotation = userRotation;
        this.requestedConfigurationRotation = configurationRotation;
        this.matrixManager.rotate((View)this, (userRotation + configurationRotation) % 360);
    }

    protected void updateMatrixOnLayout() {
        this.globalLayoutMatrixListenerLock.lock();
        if (this.getWindowToken() == null) {
            this.addOnAttachStateChangeListener(this.attachedListener);
        } else {
            this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this.globalLayoutMatrixListener);
        }
        this.globalLayoutMatrixListenerLock.unlock();
    }

    protected void notifyOnSizeChangeListener(int width, int height) {
        if (this.lastNotifiedSize.x == width && this.lastNotifiedSize.y == height) {
            return;
        }
        this.lastNotifiedSize.x = width;
        this.lastNotifiedSize.y = height;
        this.updateMatrixOnLayout();
        if (this.onSizeChangeListener != null) {
            this.onSizeChangeListener.onVideoSurfaceSizeChange(width, height);
        }
    }

    private class GlobalLayoutMatrixListener
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private GlobalLayoutMatrixListener() {
        }

        public void onGlobalLayout() {
            ResizingTextureView.this.setScaleType(ResizingTextureView.this.matrixManager.getCurrentScaleType());
            if (Build.VERSION.SDK_INT >= 16) {
                ResizingTextureView.this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            } else {
                ResizingTextureView.this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
    }

    private class AttachedListener
    implements View.OnAttachStateChangeListener {
        private AttachedListener() {
        }

        public void onViewAttachedToWindow(View view) {
            ResizingTextureView.this.globalLayoutMatrixListenerLock.lock();
            ResizingTextureView.this.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)ResizingTextureView.this.globalLayoutMatrixListener);
            ResizingTextureView.this.removeOnAttachStateChangeListener(this);
            ResizingTextureView.this.globalLayoutMatrixListenerLock.unlock();
        }

        public void onViewDetachedFromWindow(View view) {
        }
    }

    public static interface OnSizeChangeListener {
        public void onVideoSurfaceSizeChange(int var1, int var2);
    }
}

