/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.exomedia.ui.animation;

import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;

public class TopViewHideShowAnimation
extends AnimationSet {
    private View animationView;
    private boolean toVisible;

    public TopViewHideShowAnimation(View view, boolean toVisible, long duration) {
        super(false);
        this.toVisible = toVisible;
        this.animationView = view;
        float startAlpha = toVisible ? 0.0f : 1.0f;
        float endAlpha = toVisible ? 1.0f : 0.0f;
        AlphaAnimation alphaAnimation = new AlphaAnimation(startAlpha, endAlpha);
        alphaAnimation.setDuration(duration);
        int startY = toVisible ? -view.getHeight() : 0;
        int endY = toVisible ? 0 : -view.getHeight();
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)startY, (float)endY);
        translateAnimation.setInterpolator((Interpolator)(toVisible ? new LinearOutSlowInInterpolator() : new FastOutLinearInInterpolator()));
        translateAnimation.setDuration(duration);
        this.addAnimation((Animation)alphaAnimation);
        this.addAnimation((Animation)translateAnimation);
        this.setAnimationListener(new Listener());
    }

    private class Listener
    implements Animation.AnimationListener {
        private Listener() {
        }

        public void onAnimationStart(Animation animation) {
            TopViewHideShowAnimation.this.animationView.setVisibility(0);
        }

        public void onAnimationEnd(Animation animation) {
            TopViewHideShowAnimation.this.animationView.setVisibility(TopViewHideShowAnimation.this.toVisible ? 0 : 8);
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }
}

