/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.exomedia.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.WindowInsets;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;

public class FitsSystemWindowRelativeLayout
extends RelativeLayout {
    private Rect originalPadding;

    public FitsSystemWindowRelativeLayout(Context context) {
        super(context);
        this.setup();
    }

    public FitsSystemWindowRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup();
    }

    public FitsSystemWindowRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup();
    }

    @TargetApi(value=21)
    public FitsSystemWindowRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup();
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.navBarCanMove()) {
            this.setup();
        }
    }

    protected boolean fitSystemWindows(@NonNull Rect insets) {
        this.updatePadding(insets);
        return false;
    }

    @TargetApi(value=20)
    public WindowInsets onApplyWindowInsets(WindowInsets insets) {
        Rect windowInsets = new Rect(insets.getSystemWindowInsetLeft(), insets.getSystemWindowInsetTop(), insets.getSystemWindowInsetRight(), insets.getSystemWindowInsetBottom());
        this.fitSystemWindows(windowInsets);
        return insets;
    }

    private void setup() {
        if (Build.VERSION.SDK_INT >= 14) {
            this.setFitsSystemWindows(true);
        }
        if (this.originalPadding == null) {
            this.originalPadding = new Rect(this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
        this.updatePadding(new Rect());
    }

    private void updatePadding(Rect insets) {
        int leftPadding = this.originalPadding.left + insets.left;
        int rightPadding = this.originalPadding.right + insets.right;
        int bottomPadding = this.originalPadding.bottom + insets.bottom;
        int topPadding = this.originalPadding.top + insets.top;
        this.setPadding(leftPadding, topPadding, rightPadding, bottomPadding);
    }

    private boolean navBarCanMove() {
        return this.getResources().getConfiguration().smallestScreenWidthDp <= 600;
    }
}

