/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.exomedia.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.ColorRes;
import androidx.annotation.IntRange;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.utils.exomedia.listener.VideoControlsButtonListener;
import com.getstream.sdk.chat.utils.exomedia.listener.VideoControlsSeekListener;
import com.getstream.sdk.chat.utils.exomedia.listener.VideoControlsVisibilityListener;
import com.getstream.sdk.chat.utils.exomedia.ui.widget.VideoControlsCore;
import com.getstream.sdk.chat.utils.exomedia.ui.widget.VideoView;
import com.getstream.sdk.chat.utils.exomedia.util.Repeater;
import com.getstream.sdk.chat.utils.exomedia.util.ResourceUtil;
import com.getstream.sdk.chat.utils.exomedia.util.TimeFormatUtil;
import java.util.LinkedList;
import java.util.List;

public abstract class VideoControls
extends RelativeLayout
implements VideoControlsCore {
    public static final int DEFAULT_CONTROL_HIDE_DELAY = 2000;
    protected static final long CONTROL_VISIBILITY_ANIMATION_LENGTH = 300L;
    protected TextView currentTimeTextView;
    protected TextView endTimeTextView;
    protected TextView titleTextView;
    protected TextView subTitleTextView;
    protected TextView descriptionTextView;
    protected ImageButton playPauseButton;
    protected ImageButton previousButton;
    protected ImageButton nextButton;
    protected ProgressBar loadingProgressBar;
    protected ViewGroup controlsContainer;
    protected ViewGroup textContainer;
    protected Drawable playDrawable;
    protected Drawable pauseDrawable;
    @NonNull
    protected Handler visibilityHandler = new Handler();
    @NonNull
    protected Repeater progressPollRepeater = new Repeater();
    @Nullable
    protected VideoView videoView;
    @Nullable
    protected VideoControlsSeekListener seekListener;
    @Nullable
    protected VideoControlsButtonListener buttonsListener;
    @Nullable
    protected VideoControlsVisibilityListener visibilityListener;
    @NonNull
    protected InternalListener internalListener = new InternalListener();
    @NonNull
    protected SparseBooleanArray enabledViews = new SparseBooleanArray();
    protected long hideDelay = 2000L;
    protected boolean isLoading = false;
    protected boolean isVisible = true;
    protected boolean canViewHide = true;
    protected boolean hideEmptyTextContainer = true;
    private long lastUpdatedPosition;

    public VideoControls(Context context) {
        super(context);
        this.setup(context);
    }

    public VideoControls(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setup(context);
    }

    public VideoControls(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setup(context);
    }

    @TargetApi(value=21)
    public VideoControls(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setup(context);
    }

    public abstract void setPosition(@IntRange(from=0L) long var1);

    public abstract void updateProgress(@IntRange(from=0L) long var1, @IntRange(from=0L) long var3, @IntRange(from=0L, to=100L) int var5);

    @LayoutRes
    protected abstract int getLayoutResource();

    protected abstract void animateVisibility(boolean var1);

    protected abstract void updateTextContainerVisibility();

    protected void updateCurrentTime(long position) {
        if (Math.abs(position - this.lastUpdatedPosition) >= 1000L || this.lastUpdatedPosition == 0L) {
            this.lastUpdatedPosition = position;
            this.currentTimeTextView.setText((CharSequence)TimeFormatUtil.formatMs(position));
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.progressPollRepeater.setRepeatListener(new Repeater.RepeatListener(){

            @Override
            public void onRepeat() {
                VideoControls.this.updateProgress();
            }
        });
        if (this.videoView != null && this.videoView.isPlaying()) {
            this.updatePlaybackState(true);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.progressPollRepeater.stop();
        this.progressPollRepeater.setRepeatListener(null);
    }

    @Override
    public void onAttachedToView(@NonNull VideoView videoView) {
        videoView.addView((View)this);
        this.setVideoView(videoView);
    }

    @Override
    public void onDetachedFromView(@NonNull VideoView videoView) {
        videoView.removeView((View)this);
        this.setVideoView(null);
    }

    @Deprecated
    public void setVideoView(@Nullable VideoView VideoView2) {
        this.videoView = VideoView2;
    }

    public void setSeekListener(@Nullable VideoControlsSeekListener callbacks) {
        this.seekListener = callbacks;
    }

    public void setButtonListener(@Nullable VideoControlsButtonListener callback) {
        this.buttonsListener = callback;
    }

    public void setVisibilityListener(@Nullable VideoControlsVisibilityListener callbacks) {
        this.visibilityListener = callbacks;
    }

    @Override
    public void updatePlaybackState(boolean isPlaying) {
        this.updatePlayPauseImage(isPlaying);
        this.progressPollRepeater.start();
        if (isPlaying) {
            this.hideDelayed();
        } else {
            this.show();
        }
    }

    public void setTitle(@Nullable CharSequence title) {
        this.titleTextView.setText(title);
        this.updateTextContainerVisibility();
    }

    public void setSubTitle(@Nullable CharSequence subTitle) {
        this.subTitleTextView.setText(subTitle);
        this.updateTextContainerVisibility();
    }

    public void setDescription(@Nullable CharSequence description) {
        this.descriptionTextView.setText(description);
        this.updateTextContainerVisibility();
    }

    public void setPlayPauseDrawables(Drawable playDrawable, Drawable pauseDrawable) {
        this.playDrawable = playDrawable;
        this.pauseDrawable = pauseDrawable;
        this.updatePlayPauseImage(this.videoView != null && this.videoView.isPlaying());
    }

    public void setPreviousDrawable(Drawable drawable2) {
        this.previousButton.setImageDrawable(drawable2);
    }

    public void setNextDrawable(Drawable drawable2) {
        this.nextButton.setImageDrawable(drawable2);
    }

    public void setRewindDrawable(Drawable drawable2) {
    }

    public void setFastForwardDrawable(Drawable drawable2) {
    }

    public void updatePlayPauseImage(boolean isPlaying) {
        this.playPauseButton.setImageDrawable(isPlaying ? this.pauseDrawable : this.playDrawable);
    }

    public void setPreviousButtonEnabled(boolean enabled) {
        this.previousButton.setEnabled(enabled);
        this.enabledViews.put(R.id.exomedia_controls_previous_btn, enabled);
    }

    public void setNextButtonEnabled(boolean enabled) {
        this.nextButton.setEnabled(enabled);
        this.enabledViews.put(R.id.exomedia_controls_next_btn, enabled);
    }

    public void setRewindButtonEnabled(boolean enabled) {
    }

    public void setFastForwardButtonEnabled(boolean enabled) {
    }

    public void setPreviousButtonRemoved(boolean removed) {
        this.previousButton.setVisibility(removed ? 8 : 0);
    }

    public void setNextButtonRemoved(boolean removed) {
        this.nextButton.setVisibility(removed ? 8 : 0);
    }

    public void setRewindButtonRemoved(boolean removed) {
    }

    public void setFastForwardButtonRemoved(boolean removed) {
    }

    public void addExtraView(@NonNull View view) {
    }

    public void removeExtraView(@NonNull View view) {
    }

    @NonNull
    public List<View> getExtraViews() {
        return new LinkedList<View>();
    }

    @Override
    public void show() {
        this.visibilityHandler.removeCallbacksAndMessages(null);
        this.clearAnimation();
        this.animateVisibility(true);
    }

    @Override
    public void hide(boolean delayed) {
        if (delayed) {
            this.hideDelayed();
        } else {
            this.hide();
        }
    }

    public void hide() {
        if (!this.canViewHide || this.isLoading) {
            return;
        }
        this.visibilityHandler.removeCallbacksAndMessages(null);
        this.clearAnimation();
        this.animateVisibility(false);
    }

    public void hideDelayed() {
        this.hideDelayed(this.hideDelay);
    }

    public void hideDelayed(long delay) {
        this.hideDelay = delay;
        if (delay < 0L || !this.canViewHide || this.isLoading) {
            return;
        }
        this.visibilityHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                VideoControls.this.hide();
            }
        }, delay);
    }

    public void setHideDelay(long delay) {
        this.hideDelay = delay;
    }

    public void setCanHide(boolean canHide) {
        this.canViewHide = canHide;
    }

    public void setHideEmptyTextContainer(boolean hide) {
        this.hideEmptyTextContainer = hide;
        this.updateTextContainerVisibility();
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    protected void retrieveViews() {
        this.currentTimeTextView = (TextView)this.findViewById(R.id.exomedia_controls_current_time);
        this.endTimeTextView = (TextView)this.findViewById(R.id.exomedia_controls_end_time);
        this.titleTextView = (TextView)this.findViewById(R.id.exomedia_controls_title);
        this.subTitleTextView = (TextView)this.findViewById(R.id.exomedia_controls_sub_title);
        this.descriptionTextView = (TextView)this.findViewById(R.id.exomedia_controls_description);
        this.playPauseButton = (ImageButton)this.findViewById(R.id.exomedia_controls_play_pause_btn);
        this.previousButton = (ImageButton)this.findViewById(R.id.exomedia_controls_previous_btn);
        this.nextButton = (ImageButton)this.findViewById(R.id.exomedia_controls_next_btn);
        this.loadingProgressBar = (ProgressBar)this.findViewById(R.id.exomedia_controls_video_loading);
        this.controlsContainer = (ViewGroup)this.findViewById(R.id.exomedia_controls_interactive_container);
        this.textContainer = (ViewGroup)this.findViewById(R.id.exomedia_controls_text_container);
    }

    protected void registerListeners() {
        this.playPauseButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoControls.this.onPlayPauseClick();
            }
        });
        this.previousButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoControls.this.onPreviousClick();
            }
        });
        this.nextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                VideoControls.this.onNextClick();
            }
        });
    }

    protected void updateButtonDrawables() {
        this.updateButtonDrawables(R.color.stream_exomedia_default_controls_button_selector);
    }

    protected void updateButtonDrawables(@ColorRes int tintList) {
        this.playDrawable = ResourceUtil.tintList(this.getContext(), R.drawable.stream_exomedia_ic_play_arrow_white, tintList);
        this.pauseDrawable = ResourceUtil.tintList(this.getContext(), R.drawable.stream_exomedia_ic_pause_white, tintList);
        this.playPauseButton.setImageDrawable(this.playDrawable);
        Drawable previousDrawable = ResourceUtil.tintList(this.getContext(), R.drawable.stream_exomedia_ic_skip_previous_white, tintList);
        this.previousButton.setImageDrawable(previousDrawable);
        Drawable nextDrawable = ResourceUtil.tintList(this.getContext(), R.drawable.stream_exomedia_ic_skip_next_white, tintList);
        this.nextButton.setImageDrawable(nextDrawable);
    }

    protected void onPlayPauseClick() {
        if (this.buttonsListener == null || !this.buttonsListener.onPlayPauseClicked()) {
            this.internalListener.onPlayPauseClicked();
        }
    }

    protected void onPreviousClick() {
        if (this.buttonsListener == null || !this.buttonsListener.onPreviousClicked()) {
            this.internalListener.onPreviousClicked();
        }
    }

    protected void onNextClick() {
        if (this.buttonsListener == null || !this.buttonsListener.onNextClicked()) {
            this.internalListener.onNextClicked();
        }
    }

    protected void setup(Context context) {
        View.inflate((Context)context, (int)this.getLayoutResource(), (ViewGroup)this);
        this.retrieveViews();
        this.registerListeners();
        this.updateButtonDrawables();
    }

    protected boolean isTextContainerEmpty() {
        if (this.titleTextView.getText() != null && this.titleTextView.getText().length() > 0) {
            return false;
        }
        if (this.subTitleTextView.getText() != null && this.subTitleTextView.getText().length() > 0) {
            return false;
        }
        return this.descriptionTextView.getText() == null || this.descriptionTextView.getText().length() <= 0;
    }

    protected void onVisibilityChanged() {
        if (this.visibilityListener == null) {
            return;
        }
        if (this.isVisible) {
            this.visibilityListener.onControlsShown();
        } else {
            this.visibilityListener.onControlsHidden();
        }
    }

    protected void updateProgress() {
        if (this.videoView != null) {
            this.updateProgress(this.videoView.getCurrentPosition(), this.videoView.getDuration(), this.videoView.getBufferPercentage());
        }
    }

    protected class InternalListener
    implements VideoControlsSeekListener,
    VideoControlsButtonListener {
        protected boolean pausedForSeek = false;

        protected InternalListener() {
        }

        @Override
        public boolean onPlayPauseClicked() {
            if (VideoControls.this.videoView == null) {
                return false;
            }
            if (VideoControls.this.videoView.isPlaying()) {
                VideoControls.this.videoView.pause();
            } else {
                VideoControls.this.videoView.start();
            }
            return true;
        }

        @Override
        public boolean onPreviousClicked() {
            return false;
        }

        @Override
        public boolean onNextClicked() {
            return false;
        }

        @Override
        public boolean onRewindClicked() {
            return false;
        }

        @Override
        public boolean onFastForwardClicked() {
            return false;
        }

        @Override
        public boolean onSeekStarted() {
            if (VideoControls.this.videoView == null) {
                return false;
            }
            if (VideoControls.this.videoView.isPlaying()) {
                this.pausedForSeek = true;
                VideoControls.this.videoView.pause(true);
            }
            VideoControls.this.show();
            return true;
        }

        @Override
        public boolean onSeekEnded(long seekTime) {
            if (VideoControls.this.videoView == null) {
                return false;
            }
            VideoControls.this.videoView.seekTo(seekTime);
            if (this.pausedForSeek) {
                this.pausedForSeek = false;
                VideoControls.this.videoView.start();
                VideoControls.this.hideDelayed();
            }
            return true;
        }
    }
}

