/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.exomedia.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import android.widget.SeekBar;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.utils.exomedia.ui.animation.BottomViewHideShowAnimation;
import com.getstream.sdk.chat.utils.exomedia.ui.animation.TopViewHideShowAnimation;
import com.getstream.sdk.chat.utils.exomedia.ui.widget.VideoControls;
import com.getstream.sdk.chat.utils.exomedia.util.TimeFormatUtil;
import java.util.LinkedList;
import java.util.List;

public class VideoControlsMobile
extends VideoControls {
    protected SeekBar seekBar;
    protected LinearLayout extraViewsContainer;
    protected boolean userInteracting = false;

    public VideoControlsMobile(Context context) {
        super(context);
    }

    public VideoControlsMobile(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public VideoControlsMobile(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public VideoControlsMobile(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected int getLayoutResource() {
        return R.layout.stream_exomedia_default_controls_mobile;
    }

    @Override
    public void setPosition(@IntRange(from=0L) long position) {
        this.currentTimeTextView.setText((CharSequence)TimeFormatUtil.formatMs(position));
        this.seekBar.setProgress((int)position);
    }

    @Override
    public void setDuration(@IntRange(from=0L) long duration) {
        if (duration != (long)this.seekBar.getMax()) {
            this.endTimeTextView.setText((CharSequence)TimeFormatUtil.formatMs(duration));
            this.seekBar.setMax((int)duration);
        }
    }

    @Override
    public void updateProgress(@IntRange(from=0L) long position, @IntRange(from=0L) long duration, @IntRange(from=0L, to=100L) int bufferPercent) {
        if (!this.userInteracting) {
            this.seekBar.setSecondaryProgress((int)((float)this.seekBar.getMax() * ((float)bufferPercent / 100.0f)));
            this.seekBar.setProgress((int)position);
            this.updateCurrentTime(position);
        }
    }

    @Override
    protected void retrieveViews() {
        super.retrieveViews();
        this.seekBar = (SeekBar)this.findViewById(R.id.exomedia_controls_video_seek);
        this.extraViewsContainer = (LinearLayout)this.findViewById(R.id.exomedia_controls_extra_container);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.seekBar.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)new SeekBarChanged());
    }

    @Override
    public void addExtraView(@NonNull View view) {
        this.extraViewsContainer.addView(view);
    }

    @Override
    public void removeExtraView(@NonNull View view) {
        this.extraViewsContainer.removeView(view);
    }

    @Override
    @NonNull
    public List<View> getExtraViews() {
        int childCount = this.extraViewsContainer.getChildCount();
        if (childCount <= 0) {
            return super.getExtraViews();
        }
        LinkedList<View> children = new LinkedList<View>();
        for (int i = 0; i < childCount; ++i) {
            children.add(this.extraViewsContainer.getChildAt(i));
        }
        return children;
    }

    @Override
    public void hideDelayed(long delay) {
        this.hideDelay = delay;
        if (delay < 0L || !this.canViewHide || this.isLoading) {
            return;
        }
        if (!this.userInteracting) {
            this.visibilityHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    VideoControlsMobile.this.animateVisibility(false);
                }
            }, delay);
        }
    }

    @Override
    protected void animateVisibility(boolean toVisible) {
        if (this.isVisible == toVisible) {
            return;
        }
        if (!this.hideEmptyTextContainer || !this.isTextContainerEmpty()) {
            this.textContainer.startAnimation((Animation)new TopViewHideShowAnimation((View)this.textContainer, toVisible, 300L));
        }
        if (!this.isLoading) {
            this.controlsContainer.startAnimation((Animation)new BottomViewHideShowAnimation((View)this.controlsContainer, toVisible, 300L));
        }
        this.isVisible = toVisible;
        this.onVisibilityChanged();
    }

    @Override
    protected void updateTextContainerVisibility() {
        if (!this.isVisible) {
            return;
        }
        boolean emptyText = this.isTextContainerEmpty();
        if (this.hideEmptyTextContainer && emptyText && this.textContainer.getVisibility() == 0) {
            this.textContainer.clearAnimation();
            this.textContainer.startAnimation((Animation)new TopViewHideShowAnimation((View)this.textContainer, false, 300L));
        } else if (!(this.hideEmptyTextContainer && emptyText || this.textContainer.getVisibility() == 0)) {
            this.textContainer.clearAnimation();
            this.textContainer.startAnimation((Animation)new TopViewHideShowAnimation((View)this.textContainer, true, 300L));
        }
    }

    @Override
    public void showLoading(boolean initialLoad) {
        if (this.isLoading) {
            return;
        }
        this.isLoading = true;
        this.loadingProgressBar.setVisibility(0);
        if (initialLoad) {
            this.controlsContainer.setVisibility(8);
        } else {
            this.playPauseButton.setEnabled(false);
            this.previousButton.setEnabled(false);
            this.nextButton.setEnabled(false);
        }
        this.show();
    }

    @Override
    public void finishLoading() {
        if (!this.isLoading) {
            return;
        }
        this.isLoading = false;
        this.loadingProgressBar.setVisibility(8);
        this.controlsContainer.setVisibility(0);
        this.playPauseButton.setEnabled(true);
        this.previousButton.setEnabled(this.enabledViews.get(R.id.exomedia_controls_previous_btn, true));
        this.nextButton.setEnabled(this.enabledViews.get(R.id.exomedia_controls_next_btn, true));
        this.updatePlaybackState(this.videoView != null && this.videoView.isPlaying());
    }

    protected class SeekBarChanged
    implements SeekBar.OnSeekBarChangeListener {
        private long seekToTime;

        protected SeekBarChanged() {
        }

        public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
            if (!fromUser) {
                return;
            }
            this.seekToTime = progress;
            if (VideoControlsMobile.this.currentTimeTextView != null) {
                VideoControlsMobile.this.currentTimeTextView.setText((CharSequence)TimeFormatUtil.formatMs(this.seekToTime));
            }
        }

        public void onStartTrackingTouch(SeekBar seekBar) {
            VideoControlsMobile.this.userInteracting = true;
            if (VideoControlsMobile.this.seekListener == null || !VideoControlsMobile.this.seekListener.onSeekStarted()) {
                VideoControlsMobile.this.internalListener.onSeekStarted();
            }
        }

        public void onStopTrackingTouch(SeekBar seekBar) {
            VideoControlsMobile.this.userInteracting = false;
            if (VideoControlsMobile.this.seekListener == null || !VideoControlsMobile.this.seekListener.onSeekEnded(this.seekToTime)) {
                VideoControlsMobile.this.internalListener.onSeekEnded(this.seekToTime);
            }
        }
    }
}

