/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.frescoimageviewer;

import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.view.KeyEvent;
import android.view.View;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.StyleRes;
import androidx.appcompat.app.AlertDialog;
import androidx.viewpager.widget.ViewPager;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.getstream.sdk.chat.utils.frescoimageviewer.ImageViewerView;
import io.getstream.chat.android.client.logger.ChatLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ImageViewer
implements com.getstream.sdk.chat.utils.frescoimageviewer.OnDismissListener,
DialogInterface.OnKeyListener {
    private static final String TAG = ImageViewer.class.getSimpleName();
    private Builder builder;
    private AlertDialog dialog;
    private ImageViewerView viewer;

    protected ImageViewer(Builder builder) {
        this.builder = builder;
        this.createDialog();
    }

    public static ImageRequestBuilder createImageRequestBuilder() {
        return ImageRequestBuilder.newBuilderWithSource((Uri)Uri.parse((String)""));
    }

    public void show() {
        if (!this.builder.dataSet.data.isEmpty()) {
            this.dialog.show();
        } else {
            ChatLogger.Companion.getInstance().logE((Object)"ImageView", "Images list cannot be empty! Viewer ignored.");
        }
    }

    public String getUrl() {
        return this.viewer.getUrl();
    }

    private void createDialog() {
        this.viewer = new ImageViewerView(this.builder.context);
        this.viewer.setCustomImageRequestBuilder(this.builder.customImageRequestBuilder);
        this.viewer.setCustomDraweeHierarchyBuilder(this.builder.customHierarchyBuilder);
        this.viewer.allowZooming(this.builder.isZoomingAllowed);
        this.viewer.allowSwipeToDismiss(this.builder.isSwipeToDismissAllowed);
        this.viewer.setOnDismissListener(this);
        this.viewer.setBackgroundColor(this.builder.backgroundColor);
        this.viewer.setOverlayView(this.builder.overlayView);
        this.viewer.setImageMargin(this.builder.imageMarginPixels);
        this.viewer.setContainerPadding(this.builder.containerPaddingPixels);
        this.viewer.setUrls(this.builder.dataSet, this.builder.startPosition);
        this.viewer.setPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageSelected(int position) {
                if (ImageViewer.this.builder.imageChangeListener != null) {
                    ImageViewer.this.builder.imageChangeListener.onImageChange(position);
                }
            }
        });
        this.dialog = new AlertDialog.Builder(this.builder.context, this.getDialogStyle()).setView((View)this.viewer).setOnKeyListener((DialogInterface.OnKeyListener)this).create();
        this.dialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialogInterface) {
                if (ImageViewer.this.builder.onDismissListener != null) {
                    ImageViewer.this.builder.onDismissListener.onDismiss();
                }
            }
        });
    }

    @Override
    public void onDismiss() {
        this.dialog.dismiss();
    }

    public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
        if (keyCode == 4 && event.getAction() == 1 && !event.isCanceled()) {
            if (this.viewer.isScaled()) {
                this.viewer.resetScale();
            } else {
                dialog.cancel();
            }
        }
        return true;
    }

    @StyleRes
    private int getDialogStyle() {
        return this.builder.shouldStatusBarHide ? 0x1030011 : 0x1030010;
    }

    public static class Builder<T> {
        private Context context;
        private DataSet<T> dataSet;
        @ColorInt
        private int backgroundColor = -16777216;
        private int startPosition;
        private OnImageChangeListener imageChangeListener;
        private OnDismissListener onDismissListener;
        private View overlayView;
        private int imageMarginPixels;
        private int[] containerPaddingPixels = new int[4];
        private ImageRequestBuilder customImageRequestBuilder;
        private GenericDraweeHierarchyBuilder customHierarchyBuilder;
        private boolean shouldStatusBarHide = true;
        private boolean isZoomingAllowed = true;
        private boolean isSwipeToDismissAllowed = true;

        public Builder(Context context, T[] images) {
            this(context, new ArrayList<T>(Arrays.asList(images)));
        }

        public Builder(Context context, List<T> images) {
            this.context = context;
            this.dataSet = new DataSet<T>(images);
        }

        public Builder setFormatter(Formatter<T> formatter) {
            ((DataSet)this.dataSet).formatter = formatter;
            return this;
        }

        public Builder setBackgroundColorRes(@ColorRes int color2) {
            return this.setBackgroundColor(this.context.getResources().getColor(color2));
        }

        public Builder setBackgroundColor(@ColorInt int color2) {
            this.backgroundColor = color2;
            return this;
        }

        public Builder setStartPosition(int position) {
            this.startPosition = position;
            return this;
        }

        public Builder setImageChangeListener(OnImageChangeListener imageChangeListener) {
            this.imageChangeListener = imageChangeListener;
            return this;
        }

        public Builder setOverlayView(View view) {
            this.overlayView = view;
            return this;
        }

        public Builder setImageMarginPx(int marginPixels) {
            this.imageMarginPixels = marginPixels;
            return this;
        }

        public Builder setImageMargin(Context context, @DimenRes int dimen2) {
            this.imageMarginPixels = Math.round(context.getResources().getDimension(dimen2));
            return this;
        }

        public Builder setContainerPaddingPx(int start, int top, int end, int bottom) {
            this.containerPaddingPixels = new int[]{start, top, end, bottom};
            return this;
        }

        public Builder setContainerPadding(Context context, @DimenRes int start, @DimenRes int top, @DimenRes int end, @DimenRes int bottom) {
            this.setContainerPaddingPx(Math.round(context.getResources().getDimension(start)), Math.round(context.getResources().getDimension(top)), Math.round(context.getResources().getDimension(end)), Math.round(context.getResources().getDimension(bottom)));
            return this;
        }

        public Builder setContainerPaddingPx(int padding) {
            this.containerPaddingPixels = new int[]{padding, padding, padding, padding};
            return this;
        }

        public Builder setContainerPadding(Context context, @DimenRes int padding) {
            int paddingPx = Math.round(context.getResources().getDimension(padding));
            this.setContainerPaddingPx(paddingPx, paddingPx, paddingPx, paddingPx);
            return this;
        }

        public Builder hideStatusBar(boolean shouldHide) {
            this.shouldStatusBarHide = shouldHide;
            return this;
        }

        public Builder allowZooming(boolean value) {
            this.isZoomingAllowed = value;
            return this;
        }

        public Builder allowSwipeToDismiss(boolean value) {
            this.isSwipeToDismissAllowed = value;
            return this;
        }

        public Builder setOnDismissListener(OnDismissListener onDismissListener) {
            this.onDismissListener = onDismissListener;
            return this;
        }

        public Builder setCustomImageRequestBuilder(ImageRequestBuilder customImageRequestBuilder) {
            this.customImageRequestBuilder = customImageRequestBuilder;
            return this;
        }

        public Builder setCustomDraweeHierarchyBuilder(GenericDraweeHierarchyBuilder customHierarchyBuilder) {
            this.customHierarchyBuilder = customHierarchyBuilder;
            return this;
        }

        public ImageViewer build() {
            return new ImageViewer(this);
        }

        public ImageViewer show() {
            ImageViewer dialog = this.build();
            dialog.show();
            return dialog;
        }
    }

    static class DataSet<T> {
        private List<T> data;
        private Formatter<T> formatter;

        DataSet(List<T> data) {
            this.data = data;
        }

        String format(int position) {
            return this.format(this.data.get(position));
        }

        String format(T t) {
            if (this.formatter == null) {
                return t.toString();
            }
            return this.formatter.format(t);
        }

        public List<T> getData() {
            return this.data;
        }
    }

    public static interface Formatter<T> {
        public String format(T var1);
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    public static interface OnImageChangeListener {
        public void onImageChange(int var1);
    }
}

