/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.frescoimageviewer;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import androidx.annotation.NonNull;
import androidx.viewpager.widget.ViewPager;

public class MultiTouchViewPager
extends ViewPager {
    private boolean isDisallowIntercept;
    private boolean isScrolled = true;

    public MultiTouchViewPager(Context context) {
        super(context);
        this.setScrollStateListener();
    }

    public MultiTouchViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setScrollStateListener();
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        this.isDisallowIntercept = disallowIntercept;
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent ev) {
        if (ev.getPointerCount() > 1 && this.isDisallowIntercept) {
            this.requestDisallowInterceptTouchEvent(false);
            boolean handled = super.dispatchTouchEvent(ev);
            this.requestDisallowInterceptTouchEvent(true);
            return handled;
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (ev.getPointerCount() > 1) {
            return false;
        }
        try {
            return super.onInterceptTouchEvent(ev);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        try {
            return super.onTouchEvent(ev);
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public boolean isScrolled() {
        return this.isScrolled;
    }

    private void setScrollStateListener() {
        this.addOnPageChangeListener((ViewPager.OnPageChangeListener)new ViewPager.SimpleOnPageChangeListener(){

            public void onPageScrollStateChanged(int state) {
                MultiTouchViewPager.this.isScrolled = state == 0;
            }
        });
    }
}

