/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.frescoimageviewer.adapter;

import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;

public abstract class ViewHolder {
    private static final String STATE = ViewHolder.class.getSimpleName();
    public final View itemView;
    boolean mIsAttached;
    int mPosition;

    public ViewHolder(View itemView) {
        if (itemView == null) {
            throw new IllegalArgumentException("itemView should not be null");
        }
        this.itemView = itemView;
    }

    void attach(ViewGroup parent, int position) {
        this.mIsAttached = true;
        this.mPosition = position;
        parent.addView(this.itemView);
    }

    void detach(ViewGroup parent) {
        parent.removeView(this.itemView);
        this.mIsAttached = false;
    }

    void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            SparseArray ss;
            Bundle bundle = (Bundle)state;
            SparseArray sparseArray = ss = bundle.containsKey(STATE) ? bundle.getSparseParcelableArray(STATE) : null;
            if (ss != null) {
                this.itemView.restoreHierarchyState(ss);
            }
        }
    }

    Parcelable onSaveInstanceState() {
        SparseArray state = new SparseArray();
        this.itemView.saveHierarchyState(state);
        Bundle bundle = new Bundle();
        bundle.putSparseParcelableArray(STATE, state);
        return bundle;
    }
}

