/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils.frescoimageviewer.drawee;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.view.DraweeView;
import com.facebook.drawee.view.SimpleDraweeView;
import com.getstream.sdk.chat.utils.frescoimageviewer.drawee.NonInterceptableAttacher;
import me.relex.photodraweeview.IAttacher;
import me.relex.photodraweeview.OnPhotoTapListener;
import me.relex.photodraweeview.OnScaleChangeListener;
import me.relex.photodraweeview.OnViewTapListener;

public class ZoomableDraweeView
extends SimpleDraweeView
implements IAttacher {
    private NonInterceptableAttacher attacher;

    public ZoomableDraweeView(Context context, GenericDraweeHierarchy hierarchy) {
        super(context, hierarchy);
        this.init();
    }

    public ZoomableDraweeView(Context context) {
        super(context);
        this.init();
    }

    public ZoomableDraweeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public ZoomableDraweeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    protected void init() {
        if (this.attacher == null || this.attacher.getDraweeView() == null) {
            this.attacher = new NonInterceptableAttacher((DraweeView<GenericDraweeHierarchy>)this);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    protected void onDraw(@NonNull Canvas canvas) {
        int saveCount = canvas.save();
        canvas.concat(this.attacher.getDrawMatrix());
        super.onDraw(canvas);
        canvas.restoreToCount(saveCount);
    }

    protected void onAttachedToWindow() {
        this.init();
        super.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        this.attacher.onDetachedFromWindow();
        super.onDetachedFromWindow();
    }

    public float getMinimumScale() {
        return this.attacher.getMinimumScale();
    }

    public void setMinimumScale(float minimumScale) {
        this.attacher.setMinimumScale(minimumScale);
    }

    public float getMediumScale() {
        return this.attacher.getMediumScale();
    }

    public void setMediumScale(float mediumScale) {
        this.attacher.setMediumScale(mediumScale);
    }

    public float getMaximumScale() {
        return this.attacher.getMaximumScale();
    }

    public void setMaximumScale(float maximumScale) {
        this.attacher.setMaximumScale(maximumScale);
    }

    public float getScale() {
        return this.attacher.getScale();
    }

    public void setScale(float scale) {
        this.attacher.setScale(scale);
    }

    public void setScale(float scale, boolean animate) {
        this.setScale(scale, this.getRight() / 2, this.getBottom() / 2, animate);
    }

    public void setScale(float scale, float focalX, float focalY, boolean animate) {
        this.attacher.setScale(scale, focalX, focalY, animate);
    }

    public void setZoomTransitionDuration(long duration) {
        this.attacher.setZoomTransitionDuration(duration);
    }

    public void setAllowParentInterceptOnEdge(boolean allow) {
        this.attacher.setAllowParentInterceptOnEdge(allow);
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener listener) {
        this.attacher.setOnDoubleTapListener(listener);
    }

    public void setOnScaleChangeListener(OnScaleChangeListener listener) {
        this.attacher.setOnScaleChangeListener(listener);
    }

    public void setOnLongClickListener(View.OnLongClickListener listener) {
        this.attacher.setOnLongClickListener(listener);
    }

    public OnPhotoTapListener getOnPhotoTapListener() {
        return this.attacher.getOnPhotoTapListener();
    }

    public void setOnPhotoTapListener(OnPhotoTapListener listener) {
        this.attacher.setOnPhotoTapListener(listener);
    }

    public OnViewTapListener getOnViewTapListener() {
        return this.attacher.getOnViewTapListener();
    }

    public void setOnViewTapListener(OnViewTapListener listener) {
        this.attacher.setOnViewTapListener(listener);
    }

    public void update(int imageInfoWidth, int imageInfoHeight) {
        this.attacher.update(imageInfoWidth, imageInfoHeight);
    }
}

