/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.view.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.ImageLoader;
import com.getstream.sdk.chat.R;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;

public class AttachmentActivity
extends AppCompatActivity {
    WebView webView;
    ImageView iv_image;
    ProgressBar progressBar;
    private TaggedLogger logger = ChatLogger.Companion.get((Object)"AttachmentActivity");

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.stream_activity_attachment);
        this.webView = (WebView)this.findViewById(R.id.webView);
        this.iv_image = (ImageView)this.findViewById(R.id.iv_image);
        this.progressBar = (ProgressBar)this.findViewById(R.id.progressBar);
        this.configUIs();
        Intent intent = this.getIntent();
        String type = intent.getStringExtra("type");
        String url = intent.getStringExtra("url");
        if (TextUtils.isEmpty((CharSequence)type) || TextUtils.isEmpty((CharSequence)url)) {
            Toast.makeText((Context)this, (CharSequence)"Something error!", (int)0).show();
            return;
        }
        this.showAttachment(type, url);
    }

    private void configUIs() {
        this.iv_image.setVisibility(8);
        this.webView.setVisibility(8);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.getSettings().setLoadWithOverviewMode(true);
        this.webView.getSettings().setUseWideViewPort(true);
        this.webView.getSettings().setBuiltInZoomControls(true);
        this.webView.getSettings().setPluginState(WebSettings.PluginState.ON);
        this.webView.setWebViewClient((WebViewClient)new AppWebViewClients());
    }

    private void showAttachment(String type, String url) {
        if (type.equals("giphy")) {
            this.showGiphy(url);
        } else {
            this.loadUrlToWeb(url);
        }
    }

    public void loadUrlToWeb(String url) {
        this.iv_image.setVisibility(8);
        this.webView.setVisibility(0);
        this.progressBar.setVisibility(0);
        this.webView.loadUrl(ChatUI.instance().getUrlSigner().signFileUrl(url));
    }

    public void showGiphy(String url) {
        if (url == null) {
            Toast.makeText((Context)this, (CharSequence)"Error!", (int)0).show();
            return;
        }
        this.iv_image.setVisibility(0);
        this.webView.setVisibility(8);
        ImageLoader.load(this.iv_image, ChatUI.instance().getUrlSigner().signImageUrl(url), R.drawable.stream_placeholder);
    }

    private class AppWebViewClients
    extends WebViewClient {
        private AppWebViewClients() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            view.loadUrl(ChatUI.instance().getUrlSigner().signFileUrl(url));
            return true;
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, ChatUI.instance().getUrlSigner().signFileUrl(url));
            AttachmentActivity.this.progressBar.setVisibility(8);
        }

        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            AttachmentActivity.this.logger.logE("The load failed due to an unknown error: " + error);
            if (error == null) {
                return;
            }
            Toast.makeText((Context)AttachmentActivity.this, (CharSequence)error.toString(), (int)0).show();
        }
    }
}

