/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.view.channels;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.adapter.ChannelListItemAdapter;
import com.getstream.sdk.chat.adapter.ChannelViewHolderFactory;
import com.getstream.sdk.chat.view.channels.ChannelListViewStyle;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.User;
import java.util.List;

public class ChannelListView
extends RecyclerView {
    private ChannelListViewStyle style;
    private UserClickListener userClickListener;
    private ChannelClickListener channelClickListener;
    private ChannelClickListener channelLongClickListener;
    private EndReachedListener endReachedListener;
    private ChannelListItemAdapter adapter;
    private ChannelViewHolderFactory viewHolderFactory;
    private LinearLayoutManager layoutManager;
    private final EndReachedScrollListener scrollListener = new EndReachedScrollListener();

    public ChannelListView(Context context) {
        super(context);
        this.setHasFixedSize(true);
        this.layoutManager = new LinearLayoutManager(context);
        this.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.init();
    }

    public ChannelListView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.setHasFixedSize(true);
        this.layoutManager = new LinearLayoutManager(context);
        this.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.parseAttr(context, attrs);
        this.init();
    }

    public ChannelListView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setHasFixedSize(true);
        this.layoutManager = new LinearLayoutManager(context);
        this.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.parseAttr(context, attrs);
        this.init();
    }

    private void parseAttr(Context context, @Nullable AttributeSet attrs) {
        this.style = new ChannelListViewStyle(context, attrs);
        if (this.style.getAvatarBorderColor() == -1) {
            int color2 = -1;
            Drawable background = this.getBackground();
            if (background instanceof ColorDrawable) {
                color2 = ((ColorDrawable)background).getColor();
            }
            this.style.setAvatarBorderColor(color2);
        }
    }

    private void init() {
        this.adapter = new ChannelListItemAdapter(this.getContext());
        this.setAdapterWithStyle(this.adapter);
        this.adapter.setChannelClickListener(this.channelClickListener);
        this.setOnLongClickListener(this.channelLongClickListener);
        this.adapter.setUserClickListener(this.userClickListener);
    }

    private boolean canScrollUpForChannelEvent() {
        return this.layoutManager.findFirstVisibleItemPosition() < 3;
    }

    public void setViewHolderFactory(ChannelViewHolderFactory factory) {
        this.viewHolderFactory = factory;
        if (this.adapter != null) {
            this.adapter.setViewHolderFactory(factory);
        }
    }

    public void setOnUserClickListener(UserClickListener l) {
        this.userClickListener = l;
        if (this.adapter != null) {
            this.adapter.setUserClickListener(l);
        }
    }

    public void setOnChannelClickListener(ChannelClickListener l) {
        this.channelClickListener = l;
        if (this.adapter != null) {
            this.adapter.setChannelClickListener(l);
        }
    }

    public void setOnLongClickListener(ChannelClickListener l) {
        this.channelLongClickListener = l;
        if (this.adapter == null) {
            return;
        }
        if (l != null) {
            this.adapter.setChannelLongClickListener(l);
        }
    }

    public void setOnEndReachedListener(EndReachedListener listener) {
        this.endReachedListener = listener;
        this.observeListEndRegion();
    }

    private void observeListEndRegion() {
        this.addOnScrollListener(this.scrollListener);
    }

    public void setPaginationEnabled(boolean enabled) {
        this.scrollListener.setPaginationEnabled(enabled);
    }

    public void setChannels(List<Channel> channels) {
        this.adapter.replaceChannels(channels);
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        throw new IllegalArgumentException("Use setAdapterWithStyle instead please");
    }

    public void onVisibilityChanged(View view, int visibility) {
        super.onVisibilityChanged(view, visibility);
        if (visibility == 0 && this.adapter != null) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public void setAdapterWithStyle(ChannelListItemAdapter adapter) {
        super.setAdapter((RecyclerView.Adapter)adapter);
        adapter.setStyle(this.style);
        if (this.viewHolderFactory != null) {
            adapter.setViewHolderFactory(this.viewHolderFactory);
        }
    }

    private class EndReachedScrollListener
    extends RecyclerView.OnScrollListener {
        private boolean enabled = false;

        private EndReachedScrollListener() {
        }

        public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
            if (0 == newState) {
                boolean reachedTheEnd;
                LinearLayoutManager linearLayoutManager = (LinearLayoutManager)ChannelListView.this.getLayoutManager();
                int lastVisiblePosition = linearLayoutManager.findLastVisibleItemPosition();
                boolean bl = reachedTheEnd = ChannelListView.this.adapter.getItemCount() - 1 == lastVisiblePosition;
                if (reachedTheEnd && this.enabled) {
                    ChannelListView.this.endReachedListener.onEndReached();
                }
            }
        }

        public void setPaginationEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static interface EndReachedListener {
        public void onEndReached();
    }

    public static interface ChannelClickListener {
        public void onClick(Channel var1);
    }

    public static interface UserClickListener {
        public void onUserClick(User var1);
    }
}

