/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.view.messageinput;

import android.app.Activity;
import android.content.ClipDescription;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.view.inputmethod.InputConnectionCompat;
import androidx.core.view.inputmethod.InputContentInfoCompat;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.CaptureMediaContract;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.SelectFilesContract;
import com.getstream.sdk.chat.adapter.CommandsAdapter;
import com.getstream.sdk.chat.adapter.FileAttachmentSelectedAdapter;
import com.getstream.sdk.chat.adapter.MediaAttachmentAdapter;
import com.getstream.sdk.chat.adapter.MediaAttachmentSelectedAdapter;
import com.getstream.sdk.chat.adapter.MentionsAdapter;
import com.getstream.sdk.chat.databinding.StreamViewMessageInputBinding;
import com.getstream.sdk.chat.enums.MessageInputType;
import com.getstream.sdk.chat.model.AttachmentMetaData;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.utils.GifEditText;
import com.getstream.sdk.chat.utils.GridSpacingItemDecoration;
import com.getstream.sdk.chat.utils.TextViewUtils;
import com.getstream.sdk.chat.utils.Utils;
import com.getstream.sdk.chat.view.common.ExtensionsKt;
import com.getstream.sdk.chat.view.messageinput.InputMode;
import com.getstream.sdk.chat.view.messageinput.MessageInputController;
import com.getstream.sdk.chat.view.messageinput.MessageInputStyle;
import io.getstream.chat.android.client.models.Command;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import net.yslibrary.android.keyboardvisibilityevent.KeyboardVisibilityEvent;
import net.yslibrary.android.keyboardvisibilityevent.KeyboardVisibilityEventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0006\u0090\u0001\u0091\u0001\u0092\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u00105\u001a\u00020\t2\u0006\u00106\u001a\u000204J\b\u00107\u001a\u00020\tH\u0002J\b\u00108\u001a\u00020\tH\u0016J\b\u00109\u001a\u00020\tH\u0002J\b\u0010:\u001a\u00020\tH\u0002J\b\u0010;\u001a\u00020\tH\u0002J\b\u0010<\u001a\u00020\tH\u0002J\b\u0010=\u001a\u00020\tH\u0002J\u0014\u0010>\u001a\u00020\t2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@03J\u0014\u0010A\u001a\u00020\t2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020C03J\u001d\u0010D\u001a\u00020\t2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020)H\u0000\u00a2\u0006\u0002\bHJ\b\u0010I\u001a\u00020\tH\u0002J\r\u0010J\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bKJ\b\u0010L\u001a\u00020\tH\u0002J\b\u0010M\u001a\u00020\u0013H\u0002J\u0010\u0010N\u001a\u00020\t2\u0006\u0010O\u001a\u00020)H\u0002J\b\u0010P\u001a\u00020\tH\u0014J\b\u0010Q\u001a\u00020\tH\u0014J\b\u0010R\u001a\u00020\tH\u0002J\u000e\u0010S\u001a\u00020\t2\u0006\u00106\u001a\u000204J#\u0010T\u001a\u00020\t2\u0006\u0010U\u001a\u00020)2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020W03H\u0000\u00a2\u0006\u0002\bXJ\u0018\u0010Y\u001a\u00020\u00132\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020\u0015H\u0002J\u0015\u0010]\u001a\u00020\t2\u0006\u0010U\u001a\u00020)H\u0000\u00a2\u0006\u0002\b^J%\u0010_\u001a\u00020\t2\u0006\u0010`\u001a\u00020F2\u0006\u0010U\u001a\u00020)2\u0006\u0010a\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bbJ3\u0010c\u001a\u00020\t2\u0006\u0010`\u001a\u00020F2\u0006\u0010U\u001a\u00020)2\u0006\u0010a\u001a\u00020\u00132\f\u0010V\u001a\b\u0012\u0004\u0012\u00020W03H\u0000\u00a2\u0006\u0002\bdJ\u000e\u0010e\u001a\u00020\t2\u0006\u0010E\u001a\u00020FJ\u0010\u0010f\u001a\u00020\t2\u0006\u0010g\u001a\u00020\u0013H\u0016J\b\u0010h\u001a\u00020\tH\u0002J\u0006\u0010i\u001a\u00020\tJ\u000e\u0010j\u001a\u00020\t2\u0006\u0010`\u001a\u00020FJ\r\u0010k\u001a\u00020\tH\u0000\u00a2\u0006\u0002\blJ\r\u0010m\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bnJ\u0015\u0010o\u001a\u00020\t2\u0006\u0010p\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\bqJ\r\u0010r\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bsJ\u0015\u0010t\u001a\u00020\t2\u0006\u0010p\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\buJ\r\u0010v\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bwJ\u0015\u0010x\u001a\u00020\t2\u0006\u0010p\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\byJ\u0010\u0010z\u001a\u00020\t2\b\b\u0001\u0010{\u001a\u00020\u0015J\u0015\u0010|\u001a\u00020\t2\u0006\u0010p\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b}J\u0017\u0010~\u001a\u00020\t2\u0007\u0010\u007f\u001a\u00030\u0080\u0001H\u0000\u00a2\u0006\u0003\b\u0081\u0001J\u0019\u0010\u0082\u0001\u001a\u00020\t2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0000\u00a2\u0006\u0003\b\u0085\u0001J\u001d\u0010\u0086\u0001\u001a\u00020\t2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@03H\u0000\u00a2\u0006\u0003\b\u0087\u0001J\u001f\u0010\u0088\u0001\u001a\u00020\t2\u000e\u0010\u0089\u0001\u001a\t\u0012\u0005\u0012\u00030\u008a\u000103H\u0000\u00a2\u0006\u0003\b\u008b\u0001J\u0019\u0010\u008c\u0001\u001a\u00020\t2\b\u0010\u008d\u0001\u001a\u00030\u008e\u0001H\u0000\u00a2\u0006\u0003\b\u008f\u0001R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010*\u001a\u00020)2\u0006\u0010(\u001a\u00020)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0016\u0010/\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0093\u0001"}, d2={"Lcom/getstream/sdk/chat/view/messageinput/MessageInputView;", "Landroid/widget/RelativeLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "activityResultLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "", "binding", "Lcom/getstream/sdk/chat/databinding/StreamViewMessageInputBinding;", "commandsAdapter", "Lcom/getstream/sdk/chat/adapter/CommandsAdapter;", "gridLayoutManager", "Landroidx/recyclerview/widget/GridLayoutManager;", "gridSpacingItemDecoration", "Lcom/getstream/sdk/chat/utils/GridSpacingItemDecoration;", "isKeyboardEventListenerInitialized", "", "maxMessageLength", "", "getMaxMessageLength", "()I", "setMaxMessageLength", "(I)V", "mentionsAdapter", "Lcom/getstream/sdk/chat/adapter/MentionsAdapter;", "messageInputController", "Lcom/getstream/sdk/chat/view/messageinput/MessageInputController;", "getMessageInputController", "()Lcom/getstream/sdk/chat/view/messageinput/MessageInputController;", "messageInputController$delegate", "Lkotlin/Lazy;", "messageSendHandler", "Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$MessageSendHandler;", "getMessageSendHandler", "()Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$MessageSendHandler;", "setMessageSendHandler", "(Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$MessageSendHandler;)V", "text", "", "messageText", "getMessageText", "()Ljava/lang/String;", "setMessageText", "(Ljava/lang/String;)V", "selectFilesResultLauncher", "style", "Lcom/getstream/sdk/chat/view/messageinput/MessageInputStyle;", "typeListeners", "", "Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$TypeListener;", "addTypeListener", "typeListener", "applyStyle", "clearFocus", "configAttachmentUI", "configInputEditText", "configInputEditTextError", "configOnClickListener", "configSendButtonEnableState", "configureCommands", "commands", "Lio/getstream/chat/android/client/models/Command;", "configureMembers", "members", "Lio/getstream/chat/android/client/models/Member;", "editMessage", "oldMessage", "Lio/getstream/chat/android/client/models/Message;", "newMessageText", "editMessage$stream_chat_android_release", "handleSentMessage", "hideAttachmentsMenu", "hideAttachmentsMenu$stream_chat_android_release", "initSendMessage", "isMessageTooLong", "keyStroke", "inputMessage", "onAttachedToWindow", "onDetachedFromWindow", "onSendMessage", "removeTypeListener", "sendAttachments", "message", "attachmentFiles", "Ljava/io/File;", "sendAttachments$stream_chat_android_release", "sendGifFromKeyboard", "inputContentInfo", "Landroidx/core/view/inputmethod/InputContentInfoCompat;", "flags", "sendTextMessage", "sendTextMessage$stream_chat_android_release", "sendToThread", "parentMessage", "alsoSendToChannel", "sendToThread$stream_chat_android_release", "sendToThreadWithAttachments", "sendToThreadWithAttachments$stream_chat_android_release", "setEditMode", "setEnabled", "enabled", "setKeyboardEventListener", "setNormalMode", "setThreadMode", "showAttachmentsMenu", "showAttachmentsMenu$stream_chat_android_release", "showCameraOptions", "showCameraOptions$stream_chat_android_release", "showCameraPermissions", "shouldBeVisible", "showCameraPermissions$stream_chat_android_release", "showFileAttachments", "showFileAttachments$stream_chat_android_release", "showLoadingTotalAttachments", "showLoadingTotalAttachments$stream_chat_android_release", "showMediaAttachments", "showMediaAttachments$stream_chat_android_release", "showMediaPermissions", "showMediaPermissions$stream_chat_android_release", "showMessage", "messageResId", "showOpenAttachmentsMenuButton", "showOpenAttachmentsMenuButton$stream_chat_android_release", "showSelectedFileAttachments", "selectedFileAttachmentAdapter", "Lcom/getstream/sdk/chat/adapter/FileAttachmentSelectedAdapter;", "showSelectedFileAttachments$stream_chat_android_release", "showSelectedMediaAttachments", "selectedMediaAttachmentAdapter", "Lcom/getstream/sdk/chat/adapter/MediaAttachmentSelectedAdapter;", "showSelectedMediaAttachments$stream_chat_android_release", "showSuggestedCommand", "showSuggestedCommand$stream_chat_android_release", "showSuggestedMentions", "users", "Lio/getstream/chat/android/client/models/User;", "showSuggestedMentions$stream_chat_android_release", "showTotalMediaAttachments", "totalMediaAttachmentAdapter", "Lcom/getstream/sdk/chat/adapter/MediaAttachmentAdapter;", "showTotalMediaAttachments$stream_chat_android_release", "LauncherRequestsKeys", "MessageSendHandler", "TypeListener", "stream-chat-android_release"})
public final class MessageInputView
extends RelativeLayout {
    private final StreamViewMessageInputBinding binding;
    private final MessageInputStyle style;
    private final GridLayoutManager gridLayoutManager;
    private final GridSpacingItemDecoration gridSpacingItemDecoration;
    private boolean isKeyboardEventListenerInitialized;
    private int maxMessageLength;
    @NotNull
    private MessageSendHandler messageSendHandler;
    private ActivityResultLauncher<Unit> activityResultLauncher;
    private ActivityResultLauncher<Unit> selectFilesResultLauncher;
    private final CommandsAdapter commandsAdapter;
    private final MentionsAdapter mentionsAdapter;
    private List<? extends TypeListener> typeListeners;
    private final Lazy messageInputController$delegate;

    @NotNull
    public final String getMessageText() {
        GifEditText gifEditText = this.binding.messageTextInput;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gifEditText), (String)"binding.messageTextInput");
        return gifEditText.getText().toString();
    }

    public final void setMessageText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.binding.messageTextInput.requestFocus();
        this.binding.messageTextInput.setText(text);
        GifEditText gifEditText = this.binding.messageTextInput;
        GifEditText gifEditText2 = this.binding.messageTextInput;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gifEditText2), (String)"binding.messageTextInput");
        gifEditText.setSelection(gifEditText2.getText().length());
    }

    public final int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public final void setMaxMessageLength(int n) {
        this.maxMessageLength = n;
    }

    @NotNull
    public final MessageSendHandler getMessageSendHandler() {
        return this.messageSendHandler;
    }

    public final void setMessageSendHandler(@NotNull MessageSendHandler messageSendHandler2) {
        Intrinsics.checkNotNullParameter((Object)messageSendHandler2, (String)"<set-?>");
        this.messageSendHandler = messageSendHandler2;
    }

    protected void onAttachedToWindow() {
        ActivityResultRegistry activityResultRegistry;
        super.onAttachedToWindow();
        AppCompatActivity appCompatActivity = ExtensionsKt.getActivity((View)this);
        ActivityResultRegistry activityResultRegistry2 = activityResultRegistry = appCompatActivity != null ? appCompatActivity.getActivityResultRegistry() : null;
        this.activityResultLauncher = activityResultRegistry2 != null ? activityResultRegistry2.register("capture_media_request_key", (ActivityResultContract)new CaptureMediaContract(), (ActivityResultCallback)new ActivityResultCallback<File>(this){
            final /* synthetic */ MessageInputView this$0;

            public final void onActivityResult(@Nullable File file) {
                block0: {
                    File file2 = file;
                    if (file2 == null) break block0;
                    File file3 = file2;
                    boolean bl = false;
                    boolean bl2 = false;
                    File it = file3;
                    boolean bl3 = false;
                    MessageInputView.access$getMessageInputController$p(this.this$0).onFileCaptured$stream_chat_android_release(it);
                }
            }
            {
                this.this$0 = messageInputView;
            }
        }) : null;
        ActivityResultRegistry activityResultRegistry3 = activityResultRegistry;
        this.selectFilesResultLauncher = activityResultRegistry3 != null ? activityResultRegistry3.register("select_files_request_key", (ActivityResultContract)new SelectFilesContract(), (ActivityResultCallback)new ActivityResultCallback<List<? extends Uri>>(this){
            final /* synthetic */ MessageInputView this$0;

            public final void onActivityResult(List<? extends Uri> it) {
                MessageInputController messageInputController2 = MessageInputView.access$getMessageInputController$p(this.this$0);
                List<? extends Uri> list = it;
                Intrinsics.checkNotNullExpressionValue(list, (String)"it");
                messageInputController2.onFilesSelected$stream_chat_android_release(list);
            }
            {
                this.this$0 = messageInputView;
            }
        }) : null;
    }

    protected void onDetachedFromWindow() {
        block1: {
            super.onDetachedFromWindow();
            ActivityResultLauncher<Unit> activityResultLauncher = this.activityResultLauncher;
            if (activityResultLauncher != null) {
                activityResultLauncher.unregister();
            }
            ActivityResultLauncher<Unit> activityResultLauncher2 = this.selectFilesResultLauncher;
            if (activityResultLauncher2 == null) break block1;
            activityResultLauncher2.unregister();
        }
    }

    public final void addTypeListener(@NotNull TypeListener typeListener) {
        Intrinsics.checkNotNullParameter((Object)typeListener, (String)"typeListener");
        this.typeListeners = CollectionsKt.plus((Collection)this.typeListeners, (Object)typeListener);
    }

    public final void removeTypeListener(@NotNull TypeListener typeListener) {
        Intrinsics.checkNotNullParameter((Object)typeListener, (String)"typeListener");
        this.typeListeners = CollectionsKt.minus((Iterable)this.typeListeners, (Object)typeListener);
    }

    private final MessageInputController getMessageInputController() {
        Lazy lazy = this.messageInputController$delegate;
        MessageInputView messageInputView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (MessageInputController)lazy.getValue();
    }

    private final void applyStyle() {
        new ActivityResultContracts.GetContent();
        ImageView imageView = this.binding.ivOpenAttach;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivOpenAttach");
        boolean value$iv = this.style.isShowAttachmentButton();
        View $this$isVisible$iv = (View)imageView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        this.binding.ivOpenAttach.setImageDrawable(this.style.getAttachmentButtonIcon(false));
        Intrinsics.checkNotNullExpressionValue((Object)this.binding.ivOpenAttach, (String)"binding.ivOpenAttach");
        this.binding.ivOpenAttach.getLayoutParams().width = this.style.getAttachmentButtonWidth();
        Intrinsics.checkNotNullExpressionValue((Object)this.binding.ivOpenAttach, (String)"binding.ivOpenAttach");
        this.binding.ivOpenAttach.getLayoutParams().height = this.style.getAttachmentButtonHeight();
        Button button = this.binding.btnClose;
        Intrinsics.checkNotNullExpressionValue((Object)button, (String)"binding.btnClose");
        button.setBackground(this.style.getAttachmentCloseButtonBackground());
        this.binding.sendButton.setImageDrawable(this.style.getInputButtonIcon(false));
        Intrinsics.checkNotNullExpressionValue((Object)this.binding.sendButton, (String)"binding.sendButton");
        this.binding.sendButton.getLayoutParams().width = this.style.getInputButtonWidth();
        Intrinsics.checkNotNullExpressionValue((Object)this.binding.sendButton, (String)"binding.sendButton");
        this.binding.sendButton.getLayoutParams().height = this.style.getInputButtonHeight();
        this.binding.cbSendAlsoToChannel.setTextColor(this.style.getInputSendAlsoToChannelTextColor());
        LinearLayout linearLayout = this.binding.llComposer;
        Intrinsics.checkNotNullExpressionValue((Object)linearLayout, (String)"binding.llComposer");
        linearLayout.setBackground(this.style.getInputBackground());
        TextStyle textStyle = this.style.getInputText();
        GifEditText gifEditText = this.binding.messageTextInput;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gifEditText), (String)"binding.messageTextInput");
        textStyle.apply((TextView)gifEditText);
        GifEditText gifEditText2 = this.binding.messageTextInput;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gifEditText2), (String)"binding.messageTextInput");
        gifEditText2.setHint(this.style.getInputHint());
        TextStyle textStyle2 = this.style.getInputBackgroundText();
        TextView textView = this.binding.tvTitle;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvTitle");
        textStyle2.apply(textView);
        TextStyle textStyle3 = this.style.getInputBackgroundText();
        TextView textView2 = this.binding.tvCommand;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.tvCommand");
        textStyle3.apply(textView2);
        TextStyle textStyle4 = this.style.getInputBackgroundText();
        TextView textView3 = this.binding.tvUploadPhotoVideo;
        Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"binding.tvUploadPhotoVideo");
        textStyle4.apply(textView3);
        TextStyle textStyle5 = this.style.getInputBackgroundText();
        TextView textView4 = this.binding.tvUploadFile;
        Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"binding.tvUploadFile");
        textStyle5.apply(textView4);
        TextStyle textStyle6 = this.style.getInputBackgroundText();
        TextView textView5 = this.binding.tvUploadCamera;
        Intrinsics.checkNotNullExpressionValue((Object)textView5, (String)"binding.tvUploadCamera");
        textStyle6.apply(textView5);
        RecyclerView recyclerView = this.binding.rvMedia;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.rvMedia");
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)this.gridLayoutManager);
        this.binding.rvMedia.addItemDecoration((RecyclerView.ItemDecoration)this.gridSpacingItemDecoration);
    }

    private final void configOnClickListener() {
        this.binding.sendButton.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ MessageInputView this$0;

            public final void onClick(View it) {
                MessageInputView.access$onSendMessage(this.this$0);
            }
            {
                this.this$0 = messageInputView;
            }
        });
        this.binding.ivOpenAttach.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ MessageInputView this$0;

            public final void onClick(View it) {
                MessageInputView.access$getMessageInputController$p(this.this$0).onClickOpenAttachmentSelectionMenu$stream_chat_android_release(MessageInputType.ADD_FILE);
            }
            {
                this.this$0 = messageInputView;
            }
        });
    }

    private final void configInputEditText() {
        GifEditText gifEditText = this.binding.messageTextInput;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gifEditText), (String)"binding.messageTextInput");
        gifEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
            final /* synthetic */ MessageInputView this$0;

            public final void onFocusChange(@Nullable View $noName_0, boolean hasFocus) {
                if (hasFocus) {
                    Utils.showSoftKeyboard((View)this.this$0);
                } else {
                    Utils.hideSoftKeyboard((View)this.this$0);
                }
                if (!MessageInputView.access$isKeyboardEventListenerInitialized$p(this.this$0)) {
                    MessageInputView.access$setKeyboardEventListenerInitialized$p(this.this$0, true);
                    MessageInputView.access$setKeyboardEventListener(this.this$0);
                }
            }
            {
                this.this$0 = messageInputView;
            }
        });
        TextViewUtils.afterTextChanged((TextView)this.binding.messageTextInput, new TextViewUtils.Actions.AfterChangedAction(this){
            final /* synthetic */ MessageInputView this$0;

            public final void act(@NotNull Editable editable) {
                Intrinsics.checkNotNullParameter((Object)editable, (String)"editable");
                MessageInputView.access$keyStroke(this.this$0, editable.toString());
            }
            {
                this.this$0 = messageInputView;
            }
        });
        this.binding.messageTextInput.setCallback(new InputConnectionCompat.OnCommitContentListener(this){
            final /* synthetic */ MessageInputView this$0;

            public final boolean onCommitContent(InputContentInfoCompat inputContentInfo, int flags, Bundle $noName_2) {
                InputContentInfoCompat inputContentInfoCompat = inputContentInfo;
                Intrinsics.checkNotNullExpressionValue((Object)inputContentInfoCompat, (String)"inputContentInfo");
                return MessageInputView.access$sendGifFromKeyboard(this.this$0, inputContentInfoCompat, flags);
            }
            {
                this.this$0 = messageInputView;
            }
        });
    }

    private final void keyStroke(String inputMessage) {
        Unit unit;
        TypeListener p1;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        View view;
        this.getMessageInputController().checkCommandsOrMentions$stream_chat_android_release(this.getMessageText());
        ImageView imageView = this.binding.sendButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.sendButton");
        View view2 = (View)imageView;
        CharSequence charSequence = inputMessage;
        boolean bl = false;
        boolean $this$whenTrue$iv = !StringsKt.isBlank((CharSequence)charSequence);
        boolean $i$f$whenTrue = false;
        boolean bl2 = $this$whenTrue$iv;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean it$iv = bl2;
        boolean bl5 = false;
        if ($this$whenTrue$iv) {
            view = view2;
            boolean bl6 = false;
            $this$forEach$iv = this.typeListeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p1 = (TypeListener)element$iv;
                boolean bl7 = false;
                p1.onKeystroke();
            }
            unit = Unit.INSTANCE;
            view2 = view;
        }
        boolean $this$whenFalse$iv = bl2;
        boolean $i$f$whenFalse = false;
        bl2 = $this$whenFalse$iv;
        bl3 = false;
        bl4 = false;
        it$iv = bl2;
        boolean bl8 = false;
        if (!$this$whenFalse$iv) {
            view = view2;
            boolean bl9 = false;
            $this$forEach$iv = this.typeListeners;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p1 = (TypeListener)element$iv;
                boolean bl10 = false;
                p1.onStopTyping();
            }
            unit = Unit.INSTANCE;
            view2 = view;
        }
        boolean value$iv = bl2;
        View $this$isVisible$iv = view2;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
        this.configSendButtonEnableState();
        this.configInputEditTextError();
    }

    private final void configInputEditTextError() {
        if (this.isMessageTooLong()) {
            GifEditText gifEditText = this.binding.messageTextInput;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gifEditText), (String)"binding.messageTextInput");
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string2 = this.getContext().getString(R.string.stream_message_length_exceeded_error);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026ge_length_exceeded_error)");
            String string3 = string2;
            Object[] objectArray = new Object[]{this.maxMessageLength};
            boolean bl = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            gifEditText.setError(string4);
        } else {
            GifEditText gifEditText = this.binding.messageTextInput;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gifEditText), (String)"binding.messageTextInput");
            gifEditText.setError(null);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void configSendButtonEnableState() {
        attachments = this.getMessageInputController().getSelectedAttachments();
        var3_2 = this.getMessageText();
        var4_3 = false;
        var5_4 = false;
        if (!(var3_2 == null || StringsKt.isBlank((CharSequence)var3_2) != false)) ** GOTO lbl-1000
        var3_2 = attachments;
        var4_3 = false;
        if (var3_2.isEmpty() == false) lbl-1000:
        // 2 sources

        {
            v0 = true;
        } else {
            v0 = false;
        }
        notEmptyMessage = v0;
        v1 = this.binding.sendButton;
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"binding.sendButton");
        var4_3 = notEmptyMessage != false && this.isMessageTooLong() == false;
        $this$isVisible$iv = (View)v1;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(value$iv != false ? 0 : 8);
    }

    private final boolean isMessageTooLong() {
        return this.getMessageText().length() > this.maxMessageLength;
    }

    private final void configAttachmentUI() {
        RecyclerView recyclerView = this.binding.mediaComposer;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.mediaComposer");
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager(this.getContext(), 1, 0, false));
        this.binding.btnClose.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ MessageInputView this$0;

            public final void onClick(View it) {
                MessageInputView.access$getMessageInputController$p(this.this$0).onClickCloseAttachmentSelectionMenu$stream_chat_android_release();
                Utils.hideSoftKeyboard((View)this.this$0);
            }
            {
                this.this$0 = messageInputView;
            }
        });
        this.binding.selectMedia.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ MessageInputView this$0;

            public final void onClick(View it) {
                MessageInputView.access$getMessageInputController$p(this.this$0).onClickOpenMediaSelectView();
            }
            {
                this.this$0 = messageInputView;
            }
        });
        this.binding.selectCamera.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ MessageInputView this$0;

            public final void onClick(View it) {
                MessageInputView.access$getMessageInputController$p(this.this$0).onCameraClick();
            }
            {
                this.this$0 = messageInputView;
            }
        });
        this.binding.selectFile.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ MessageInputView this$0;

            public final void onClick(View it) {
                block0: {
                    ActivityResultLauncher activityResultLauncher = MessageInputView.access$getSelectFilesResultLauncher$p(this.this$0);
                    if (activityResultLauncher == null) break block0;
                    activityResultLauncher.launch((Object)Unit.INSTANCE);
                }
            }
            {
                this.this$0 = messageInputView;
            }
        });
    }

    public final void showCameraOptions$stream_chat_android_release() {
        block0: {
            ActivityResultLauncher<Unit> activityResultLauncher = this.activityResultLauncher;
            if (activityResultLauncher == null) break block0;
            activityResultLauncher.launch((Object)Unit.INSTANCE);
        }
    }

    private final void setKeyboardEventListener() {
        KeyboardVisibilityEvent.setEventListener((Activity)((Activity)ExtensionsKt.getActivity((View)this)), (KeyboardVisibilityEventListener)new KeyboardVisibilityEventListener(this){
            final /* synthetic */ MessageInputView this$0;

            public final void onVisibilityChanged(boolean isOpen) {
                if (!isOpen) {
                    MessageInputView.access$getBinding$p((MessageInputView)this.this$0).messageTextInput.clearFocus();
                }
            }
            {
                this.this$0 = messageInputView;
            }
        });
    }

    public void setEnabled(boolean enabled) {
        GifEditText gifEditText = this.binding.messageTextInput;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gifEditText), (String)"binding.messageTextInput");
        gifEditText.setEnabled(true);
    }

    public void clearFocus() {
        this.binding.messageTextInput.clearFocus();
    }

    public final void configureMembers(@NotNull List<Member> members) {
        Intrinsics.checkNotNullParameter(members, (String)"members");
        this.getMessageInputController().setMembers$stream_chat_android_release(members);
    }

    public final void configureCommands(@NotNull List<Command> commands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        this.getMessageInputController().setChannelCommands$stream_chat_android_release(commands);
    }

    private final void onSendMessage() {
        this.getMessageInputController().onSendMessageClick$stream_chat_android_release(this.getMessageText());
        this.handleSentMessage();
    }

    public final void sendTextMessage$stream_chat_android_release(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messageSendHandler.sendMessage(message);
    }

    public final void sendAttachments$stream_chat_android_release(@NotNull String message, @NotNull List<? extends File> attachmentFiles) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attachmentFiles, (String)"attachmentFiles");
        this.messageSendHandler.sendMessageWithAttachments(message, attachmentFiles);
    }

    public final void sendToThread$stream_chat_android_release(@NotNull Message parentMessage, @NotNull String message, boolean alsoSendToChannel) {
        Intrinsics.checkNotNullParameter((Object)parentMessage, (String)"parentMessage");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.messageSendHandler.sendToThread(parentMessage, message, alsoSendToChannel);
    }

    public final void sendToThreadWithAttachments$stream_chat_android_release(@NotNull Message parentMessage, @NotNull String message, boolean alsoSendToChannel, @NotNull List<? extends File> attachmentFiles) {
        Intrinsics.checkNotNullParameter((Object)parentMessage, (String)"parentMessage");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(attachmentFiles, (String)"attachmentFiles");
        this.messageSendHandler.sendToThreadWithAttachments(parentMessage, message, alsoSendToChannel, attachmentFiles);
    }

    public final void editMessage$stream_chat_android_release(@NotNull Message oldMessage, @NotNull String newMessageText) {
        Intrinsics.checkNotNullParameter((Object)oldMessage, (String)"oldMessage");
        Intrinsics.checkNotNullParameter((Object)newMessageText, (String)"newMessageText");
        this.messageSendHandler.editMessage(oldMessage, newMessageText);
    }

    private final void handleSentMessage() {
        Iterable $this$forEach$iv = this.typeListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeListener p1 = (TypeListener)element$iv;
            boolean bl = false;
            p1.onStopTyping();
        }
        this.initSendMessage();
    }

    private final void initSendMessage() {
        this.getMessageInputController().initSendMessage$stream_chat_android_release();
        this.binding.messageTextInput.setText("");
        ImageView imageView = this.binding.sendButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.sendButton");
        imageView.setEnabled(true);
    }

    private final boolean sendGifFromKeyboard(InputContentInfoCompat inputContentInfo, int flags) {
        if (Build.VERSION.SDK_INT >= 29 && (flags & 1) != 0) {
            try {
                inputContentInfo.requestPermission();
            }
            catch (Exception e) {
                return false;
            }
        }
        MessageInputController messageInputController2 = this.getMessageInputController();
        Uri uri = inputContentInfo.getContentUri();
        ClipDescription clipDescription = inputContentInfo.getDescription();
        Intrinsics.checkNotNullExpressionValue((Object)clipDescription, (String)"inputContentInfo.description");
        messageInputController2.setSelectedAttachments(SetsKt.setOf((Object)new AttachmentMetaData(uri, "image", "image/gif", ((Object)clipDescription.getLabel()).toString(), null, 16, null)));
        this.binding.messageTextInput.setText("");
        this.onSendMessage();
        return true;
    }

    public final void showSuggestedMentions$stream_chat_android_release(@NotNull List<User> users) {
        Intrinsics.checkNotNullParameter(users, (String)"users");
        this.mentionsAdapter.submitList(users);
    }

    public final void showSuggestedCommand$stream_chat_android_release(@NotNull List<Command> commands) {
        Intrinsics.checkNotNullParameter(commands, (String)"commands");
        this.commandsAdapter.submitList(commands);
    }

    public final void setNormalMode() {
        this.getMessageInputController().setInputMode$stream_chat_android_release(InputMode.Normal.INSTANCE);
    }

    public final void setThreadMode(@NotNull Message parentMessage) {
        Intrinsics.checkNotNullParameter((Object)parentMessage, (String)"parentMessage");
        this.getMessageInputController().setInputMode$stream_chat_android_release(new InputMode.Thread(parentMessage));
    }

    public final void setEditMode(@NotNull Message oldMessage) {
        Intrinsics.checkNotNullParameter((Object)oldMessage, (String)"oldMessage");
        this.getMessageInputController().setInputMode$stream_chat_android_release(new InputMode.Edit(oldMessage));
    }

    public final void showSelectedMediaAttachments$stream_chat_android_release(@NotNull MediaAttachmentSelectedAdapter selectedMediaAttachmentAdapter) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectedMediaAttachmentAdapter), (String)"selectedMediaAttachmentAdapter");
        RecyclerView recyclerView = this.binding.mediaComposer;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.mediaComposer");
        recyclerView.setAdapter((RecyclerView.Adapter)selectedMediaAttachmentAdapter);
        RecyclerView recyclerView2 = this.binding.mediaComposer;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"binding.mediaComposer");
        boolean value$iv = true;
        View $this$isVisible$iv = (View)recyclerView2;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        ListView listView = this.binding.fileComposer;
        Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"binding.fileComposer");
        value$iv = false;
        $this$isVisible$iv = (View)listView;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        ListView listView2 = this.binding.fileComposer;
        Intrinsics.checkNotNullExpressionValue((Object)listView2, (String)"binding.fileComposer");
        listView2.setAdapter((ListAdapter)null);
    }

    public final void showSelectedFileAttachments$stream_chat_android_release(@NotNull FileAttachmentSelectedAdapter selectedFileAttachmentAdapter) {
        Intrinsics.checkNotNullParameter((Object)((Object)selectedFileAttachmentAdapter), (String)"selectedFileAttachmentAdapter");
        ListView listView = this.binding.fileComposer;
        Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"binding.fileComposer");
        listView.setAdapter((ListAdapter)selectedFileAttachmentAdapter);
        ListView listView2 = this.binding.fileComposer;
        Intrinsics.checkNotNullExpressionValue((Object)listView2, (String)"binding.fileComposer");
        boolean value$iv = true;
        View $this$isVisible$iv = (View)listView2;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        RecyclerView recyclerView = this.binding.mediaComposer;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.mediaComposer");
        value$iv = false;
        $this$isVisible$iv = (View)recyclerView;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        RecyclerView recyclerView2 = this.binding.mediaComposer;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"binding.mediaComposer");
        recyclerView2.setAdapter((RecyclerView.Adapter)null);
    }

    public final void showTotalMediaAttachments$stream_chat_android_release(@NotNull MediaAttachmentAdapter totalMediaAttachmentAdapter) {
        Intrinsics.checkNotNullParameter((Object)((Object)totalMediaAttachmentAdapter), (String)"totalMediaAttachmentAdapter");
        RecyclerView recyclerView = this.binding.rvMedia;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.rvMedia");
        recyclerView.setAdapter((RecyclerView.Adapter)totalMediaAttachmentAdapter);
    }

    public final void showMediaAttachments$stream_chat_android_release() {
        RecyclerView recyclerView = this.binding.mediaComposer;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.mediaComposer");
        boolean value$iv = true;
        View $this$isVisible$iv = (View)recyclerView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        ListView listView = this.binding.fileComposer;
        Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"binding.fileComposer");
        value$iv = false;
        $this$isVisible$iv = (View)listView;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
    }

    public final void showFileAttachments$stream_chat_android_release() {
        RecyclerView recyclerView = this.binding.mediaComposer;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.mediaComposer");
        boolean value$iv = false;
        View $this$isVisible$iv = (View)recyclerView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        ListView listView = this.binding.fileComposer;
        Intrinsics.checkNotNullExpressionValue((Object)listView, (String)"binding.fileComposer");
        value$iv = true;
        $this$isVisible$iv = (View)listView;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
    }

    public final void showMediaPermissions$stream_chat_android_release(boolean shouldBeVisible) {
        ImageView imageView = this.binding.ivMediaPermission;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivMediaPermission");
        View $this$isVisible$iv = (View)imageView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(shouldBeVisible ? 0 : 8);
    }

    public final void showCameraPermissions$stream_chat_android_release(boolean shouldBeVisible) {
        ImageView imageView = this.binding.ivCameraPermission;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivCameraPermission");
        View $this$isVisible$iv = (View)imageView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(shouldBeVisible ? 0 : 8);
    }

    public final void hideAttachmentsMenu$stream_chat_android_release() {
        ConstraintLayout constraintLayout = this.binding.clTitle;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.clTitle");
        boolean value$iv = false;
        View $this$isVisible$iv = (View)constraintLayout;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        ConstraintLayout constraintLayout2 = this.binding.clAddFile;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"binding.clAddFile");
        value$iv = false;
        $this$isVisible$iv = (View)constraintLayout2;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        ConstraintLayout constraintLayout3 = this.binding.clSelectPhoto;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout3, (String)"binding.clSelectPhoto");
        value$iv = false;
        $this$isVisible$iv = (View)constraintLayout3;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        this.binding.getRoot().setBackgroundResource(0);
    }

    public final void showAttachmentsMenu$stream_chat_android_release() {
        this.binding.getRoot().setBackgroundResource(R.drawable.stream_round_thread_toolbar);
        ConstraintLayout constraintLayout = this.binding.clTitle;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.clTitle");
        constraintLayout.setVisibility(0);
        Button button = this.binding.btnClose;
        Intrinsics.checkNotNullExpressionValue((Object)button, (String)"binding.btnClose");
        button.setVisibility(0);
        ConstraintLayout constraintLayout2 = this.binding.clAddFile;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout2, (String)"binding.clAddFile");
        constraintLayout2.setVisibility(8);
        ConstraintLayout constraintLayout3 = this.binding.clSelectPhoto;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout3, (String)"binding.clSelectPhoto");
        constraintLayout3.setVisibility(8);
    }

    public final void showLoadingTotalAttachments$stream_chat_android_release(boolean shouldBeVisible) {
        ProgressBar progressBar = this.binding.progressBarFileLoader;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.progressBarFileLoader");
        View $this$isVisible$iv = (View)progressBar;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(shouldBeVisible ? 0 : 8);
    }

    public final void showOpenAttachmentsMenuButton$stream_chat_android_release(boolean shouldBeVisible) {
        ImageView imageView = this.binding.ivOpenAttach;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivOpenAttach");
        View $this$isVisible$iv = (View)imageView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(shouldBeVisible ? 0 : 8);
    }

    public final void showMessage(@StringRes int messageResId) {
        Toast.makeText((Context)this.getContext(), (int)messageResId, (int)0).show();
    }

    public MessageInputView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        StreamViewMessageInputBinding streamViewMessageInputBinding = StreamViewMessageInputBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamViewMessageInputBinding, (String)"StreamViewMessageInputBi\u2026rom(context), this, true)");
        this.binding = streamViewMessageInputBinding;
        this.style = new MessageInputStyle(context, attrs);
        this.gridLayoutManager = new GridLayoutManager(context, 4, 1, false);
        this.gridSpacingItemDecoration = new GridSpacingItemDecoration(4, 2, false);
        this.maxMessageLength = Integer.MAX_VALUE;
        this.messageSendHandler = new MessageSendHandler(){

            public void sendMessage(@NotNull String messageText) {
                Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
                throw (Throwable)new IllegalStateException("MessageInputView#messageSendHandler needs to be configured to send messages");
            }

            public void sendMessageWithAttachments(@NotNull String message, @NotNull List<? extends File> attachmentsFiles) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter(attachmentsFiles, (String)"attachmentsFiles");
                throw (Throwable)new IllegalStateException("MessageInputView#messageSendHandler needs to be configured to send messages");
            }

            public void sendToThread(@NotNull Message parentMessage, @NotNull String messageText, boolean alsoSendToChannel) {
                Intrinsics.checkNotNullParameter((Object)parentMessage, (String)"parentMessage");
                Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
                throw (Throwable)new IllegalStateException("MessageInputView#messageSendHandler needs to be configured to send messages");
            }

            public void sendToThreadWithAttachments(@NotNull Message parentMessage, @NotNull String message, boolean alsoSendToChannel, @NotNull List<? extends File> attachmentsFiles) {
                Intrinsics.checkNotNullParameter((Object)parentMessage, (String)"parentMessage");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter(attachmentsFiles, (String)"attachmentsFiles");
                throw (Throwable)new IllegalStateException("MessageInputView#messageSendHandler needs to be configured to send messages");
            }

            public void editMessage(@NotNull Message oldMessage, @NotNull String newMessageText) {
                Intrinsics.checkNotNullParameter((Object)oldMessage, (String)"oldMessage");
                Intrinsics.checkNotNullParameter((Object)newMessageText, (String)"newMessageText");
                throw (Throwable)new IllegalStateException("MessageInputView#messageSendHandler needs to be configured to send messages");
            }
        };
        this.commandsAdapter = new CommandsAdapter(this.style, (Function1<? super Command, Unit>)((Function1)new Function1<Command, Unit>(this){
            final /* synthetic */ MessageInputView this$0;

            public final void invoke(@NotNull Command it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MessageInputView.access$getMessageInputController$p(this.this$0).onCommandSelected$stream_chat_android_release(it);
            }
            {
                this.this$0 = messageInputView;
                super(1);
            }
        }));
        this.mentionsAdapter = new MentionsAdapter(this.style, (Function1<? super User, Unit>)((Function1)new Function1<User, Unit>(this){
            final /* synthetic */ MessageInputView this$0;

            public final void invoke(@NotNull User it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                MessageInputView.access$getMessageInputController$p(this.this$0).onUserSelected$stream_chat_android_release(this.this$0.getMessageText(), it);
            }
            {
                this.this$0 = messageInputView;
                super(1);
            }
        }));
        boolean bl = false;
        this.typeListeners = CollectionsKt.emptyList();
        this.messageInputController$delegate = LazyKt.lazy((Function0)((Function0)new Function0<MessageInputController>(this){
            final /* synthetic */ MessageInputView this$0;

            @NotNull
            public final MessageInputController invoke() {
                return new MessageInputController(MessageInputView.access$getBinding$p(this.this$0), this.this$0, MessageInputView.access$getStyle$p(this.this$0));
            }
            {
                this.this$0 = messageInputView;
                super(0);
            }
        }));
        this.applyStyle();
        RecyclerView recyclerView = this.binding.rvSuggestions;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.rvSuggestions");
        recyclerView.setAdapter((RecyclerView.Adapter)new ConcatAdapter(new RecyclerView.Adapter[]{(RecyclerView.Adapter)this.commandsAdapter, (RecyclerView.Adapter)this.mentionsAdapter}));
        ImageView imageView = this.binding.sendButton;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.sendButton");
        boolean bl2 = false;
        View $this$isVisible$iv = (View)imageView;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        this.configOnClickListener();
        this.configInputEditText();
        this.configAttachmentUI();
    }

    public static final /* synthetic */ MessageInputController access$getMessageInputController$p(MessageInputView $this) {
        return $this.getMessageInputController();
    }

    public static final /* synthetic */ void access$onSendMessage(MessageInputView $this) {
        $this.onSendMessage();
    }

    public static final /* synthetic */ boolean access$isKeyboardEventListenerInitialized$p(MessageInputView $this) {
        return $this.isKeyboardEventListenerInitialized;
    }

    public static final /* synthetic */ void access$setKeyboardEventListenerInitialized$p(MessageInputView $this, boolean bl) {
        $this.isKeyboardEventListenerInitialized = bl;
    }

    public static final /* synthetic */ void access$setKeyboardEventListener(MessageInputView $this) {
        $this.setKeyboardEventListener();
    }

    public static final /* synthetic */ void access$keyStroke(MessageInputView $this, String inputMessage) {
        $this.keyStroke(inputMessage);
    }

    public static final /* synthetic */ boolean access$sendGifFromKeyboard(MessageInputView $this, InputContentInfoCompat inputContentInfo, int flags) {
        return $this.sendGifFromKeyboard(inputContentInfo, flags);
    }

    public static final /* synthetic */ void access$setTypeListeners$p(MessageInputView $this, List list) {
        $this.typeListeners = list;
    }

    public static final /* synthetic */ ActivityResultLauncher access$getSelectFilesResultLauncher$p(MessageInputView $this) {
        return $this.selectFilesResultLauncher;
    }

    public static final /* synthetic */ void access$setSelectFilesResultLauncher$p(MessageInputView $this, ActivityResultLauncher activityResultLauncher) {
        $this.selectFilesResultLauncher = activityResultLauncher;
    }

    public static final /* synthetic */ StreamViewMessageInputBinding access$getBinding$p(MessageInputView $this) {
        return $this.binding;
    }

    public static final /* synthetic */ MessageInputStyle access$getStyle$p(MessageInputView $this) {
        return $this.style;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$LauncherRequestsKeys;", "", "()V", "CAPTURE_MEDIA", "", "SELECT_FILES", "stream-chat-android_release"})
    private static final class LauncherRequestsKeys {
        @NotNull
        public static final String CAPTURE_MEDIA = "capture_media_request_key";
        @NotNull
        public static final String SELECT_FILES = "select_files_request_key";
        public static final LauncherRequestsKeys INSTANCE;

        private LauncherRequestsKeys() {
        }

        static {
            LauncherRequestsKeys launcherRequestsKeys;
            INSTANCE = launcherRequestsKeys = new LauncherRequestsKeys();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0003H&\u00a8\u0006\u0005"}, d2={"Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$TypeListener;", "", "onKeystroke", "", "onStopTyping", "stream-chat-android_release"})
    public static interface TypeListener {
        public void onKeystroke();

        public void onStopTyping();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0007H&J\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH&J \u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0012H&J.\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH&\u00a8\u0006\u0014"}, d2={"Lcom/getstream/sdk/chat/view/messageinput/MessageInputView$MessageSendHandler;", "", "editMessage", "", "oldMessage", "Lio/getstream/chat/android/client/models/Message;", "newMessageText", "", "sendMessage", "messageText", "sendMessageWithAttachments", "message", "attachmentsFiles", "", "Ljava/io/File;", "sendToThread", "parentMessage", "alsoSendToChannel", "", "sendToThreadWithAttachments", "stream-chat-android_release"})
    public static interface MessageSendHandler {
        public void sendMessage(@NotNull String var1);

        public void sendMessageWithAttachments(@NotNull String var1, @NotNull List<? extends File> var2);

        public void sendToThread(@NotNull Message var1, @NotNull String var2, boolean var3);

        public void sendToThreadWithAttachments(@NotNull Message var1, @NotNull String var2, boolean var3, @NotNull List<? extends File> var4);

        public void editMessage(@NotNull Message var1, @NotNull String var2);
    }
}

