/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.viewmodel;

import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.livedata.ChannelData;
import io.getstream.chat.android.livedata.ChatDomain;
import io.getstream.chat.android.livedata.controller.ChannelController;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/getstream/sdk/chat/viewmodel/ChannelHeaderViewModel;", "Landroidx/lifecycle/ViewModel;", "cid", "", "chatDomain", "Lio/getstream/chat/android/livedata/ChatDomain;", "(Ljava/lang/String;Lio/getstream/chat/android/livedata/ChatDomain;)V", "_anyOtherUsersOnline", "Landroidx/lifecycle/MediatorLiveData;", "", "_channelState", "Lio/getstream/chat/android/client/models/Channel;", "_members", "", "Lio/getstream/chat/android/client/models/Member;", "anyOtherUsersOnline", "Landroidx/lifecycle/LiveData;", "getAnyOtherUsersOnline", "()Landroidx/lifecycle/LiveData;", "channelState", "getChannelState", "members", "getMembers", "stream-chat-android_release"})
public final class ChannelHeaderViewModel
extends ViewModel {
    private final MediatorLiveData<List<Member>> _members;
    private final MediatorLiveData<Channel> _channelState;
    private final MediatorLiveData<Boolean> _anyOtherUsersOnline;
    @NotNull
    private final LiveData<List<Member>> members;
    @NotNull
    private final LiveData<Channel> channelState;
    @NotNull
    private final LiveData<Boolean> anyOtherUsersOnline;
    private final ChatDomain chatDomain;

    @NotNull
    public final LiveData<List<Member>> getMembers() {
        return this.members;
    }

    @NotNull
    public final LiveData<Channel> getChannelState() {
        return this.channelState;
    }

    @NotNull
    public final LiveData<Boolean> getAnyOtherUsersOnline() {
        return this.anyOtherUsersOnline;
    }

    @JvmOverloads
    public ChannelHeaderViewModel(@NotNull String cid, @NotNull ChatDomain chatDomain) {
        Intrinsics.checkNotNullParameter((Object)cid, (String)"cid");
        Intrinsics.checkNotNullParameter((Object)chatDomain, (String)"chatDomain");
        this.chatDomain = chatDomain;
        this._members = new MediatorLiveData();
        this._channelState = new MediatorLiveData();
        this._anyOtherUsersOnline = new MediatorLiveData();
        this.members = (LiveData)this._members;
        this.channelState = (LiveData)this._channelState;
        this.anyOtherUsersOnline = (LiveData)this._anyOtherUsersOnline;
        this.chatDomain.getUseCases().getWatchChannel().invoke(cid, 0).enqueue((Function1)new Function1<Result<ChannelController>, Unit>(){

            public final void invoke(@NotNull Result<ChannelController> channelControllerResult) {
                Intrinsics.checkNotNullParameter(channelControllerResult, (String)"channelControllerResult");
                if (channelControllerResult.isSuccess()) {
                    final ChannelController channelController = (ChannelController)channelControllerResult.data();
                    _members.addSource(channelController.getMembers(), (Observer)new Observer<List<? extends Member>>(){

                        public final void onChanged(List<Member> it) {
                            _members.setValue(it);
                        }
                    });
                    _channelState.addSource(Transformations.map((LiveData)channelController.getChannelData(), (Function)((Function)new Function<ChannelData, Channel>(){

                        public final Channel apply(ChannelData it) {
                            return channelController.toChannel();
                        }
                    })), (Observer)new Observer<Channel>(){

                        public final void onChanged(Channel it) {
                            _channelState.setValue((Object)it);
                        }
                    });
                    _anyOtherUsersOnline.addSource(Transformations.map((LiveData)channelController.getMembers(), (Function)((Function)new Function<List<? extends Member>, Boolean>(){

                        public final Boolean apply(List<Member> members) {
                            boolean bl;
                            block1: {
                                List<Member> list = members;
                                Intrinsics.checkNotNullExpressionValue(list, (String)"members");
                                Sequence $this$any$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)((Function1)new Function1<Member, Boolean>(){

                                    public final boolean invoke(@NotNull Member it) {
                                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                        return Intrinsics.areEqual((Object)it.getUser(), (Object)chatDomain.getCurrentUser()) ^ true;
                                    }
                                }));
                                boolean $i$f$any = false;
                                for (Object element$iv : $this$any$iv) {
                                    Member it = (Member)element$iv;
                                    boolean bl2 = false;
                                    if (!it.getUser().getOnline()) continue;
                                    bl = true;
                                    break block1;
                                }
                                bl = false;
                            }
                            return bl;
                        }
                    })), (Observer)new Observer<Boolean>(){

                        public final void onChanged(Boolean it) {
                            _anyOtherUsersOnline.setValue((Object)it);
                        }
                    });
                }
            }
        });
    }

    public /* synthetic */ ChannelHeaderViewModel(String string2, ChatDomain chatDomain, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            chatDomain = ChatDomain.Companion.instance();
        }
        this(string2, chatDomain);
    }

    @JvmOverloads
    public ChannelHeaderViewModel(@NotNull String cid) {
        this(cid, null, 2, null);
    }
}

