/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.viewmodel;

import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import com.getstream.sdk.chat.viewmodel.MessageInputViewModel;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Command;
import io.getstream.chat.android.client.models.Member;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.livedata.ChatDomain;
import io.getstream.chat.android.livedata.controller.ChannelController;
import io.getstream.chat.android.livedata.usecase.SendMessage;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0017\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0012J\u000e\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0014J\u0006\u0010$\u001a\u00020!J\u0006\u0010%\u001a\u00020!J)\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00032\u0019\b\u0002\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020!0)\u00a2\u0006\u0002\b*J7\u0010+\u001a\u00020!2\u0006\u0010'\u001a\u00020\u00032\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\t2\u0019\b\u0002\u0010(\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020!0)\u00a2\u0006\u0002\b*J\u000e\u0010.\u001a\u00020!2\u0006\u0010/\u001a\u00020\u0012J\u0006\u00100\u001a\u00020!R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0019\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0016R\u001d\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\t0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016\u00a8\u00061"}, d2={"Lcom/getstream/sdk/chat/viewmodel/MessageInputViewModel;", "Landroidx/lifecycle/ViewModel;", "cid", "", "chatDomain", "Lio/getstream/chat/android/livedata/ChatDomain;", "(Ljava/lang/String;Lio/getstream/chat/android/livedata/ChatDomain;)V", "_commands", "Landroidx/lifecycle/MutableLiveData;", "", "Lio/getstream/chat/android/client/models/Command;", "_maxMessageLength", "", "kotlin.jvm.PlatformType", "_members", "Landroidx/lifecycle/MediatorLiveData;", "Lio/getstream/chat/android/client/models/Member;", "activeThread", "Lio/getstream/chat/android/client/models/Message;", "commands", "Landroidx/lifecycle/LiveData;", "getCommands", "()Landroidx/lifecycle/LiveData;", "editMessage", "getEditMessage", "()Landroidx/lifecycle/MutableLiveData;", "isThread", "", "()Z", "maxMessageLength", "getMaxMessageLength", "members", "getMembers", "", "message", "getActiveThread", "keystroke", "resetThread", "sendMessage", "messageText", "messageTransformer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "sendMessageWithAttachments", "attachmentFiles", "Ljava/io/File;", "setActiveThread", "parentMessage", "stopTyping", "stream-chat-android_release"})
public final class MessageInputViewModel
extends ViewModel {
    private MutableLiveData<Message> activeThread;
    private final MutableLiveData<Integer> _maxMessageLength;
    private final MutableLiveData<List<Command>> _commands;
    private final MediatorLiveData<List<Member>> _members;
    @NotNull
    private final LiveData<Integer> maxMessageLength;
    @NotNull
    private final LiveData<List<Command>> commands;
    @NotNull
    private final LiveData<List<Member>> members;
    @NotNull
    private final MutableLiveData<Message> editMessage;
    private final String cid;
    private final ChatDomain chatDomain;

    @NotNull
    public final LiveData<Integer> getMaxMessageLength() {
        return this.maxMessageLength;
    }

    @NotNull
    public final LiveData<List<Command>> getCommands() {
        return this.commands;
    }

    @NotNull
    public final LiveData<List<Member>> getMembers() {
        return this.members;
    }

    @NotNull
    public final MutableLiveData<Message> getEditMessage() {
        return this.editMessage;
    }

    public final void setActiveThread(@NotNull Message parentMessage) {
        Intrinsics.checkNotNullParameter((Object)parentMessage, (String)"parentMessage");
        this.activeThread.postValue((Object)parentMessage);
    }

    @NotNull
    public final LiveData<Message> getActiveThread() {
        return (LiveData)this.activeThread;
    }

    private final boolean isThread() {
        return this.activeThread.getValue() != null;
    }

    public final void resetThread() {
        this.activeThread.postValue(null);
    }

    public final void sendMessage(@NotNull String messageText, @NotNull Function1<? super Message, Unit> messageTransformer) {
        boolean bl;
        boolean bl2;
        Message message;
        Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
        Intrinsics.checkNotNullParameter(messageTransformer, (String)"messageTransformer");
        Message message2 = new Message(null, this.cid, messageText, null, null, null, null, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, false, 0x3FFFFF9, null);
        Message message3 = (Message)this.activeThread.getValue();
        if (message3 != null) {
            message = message3;
            bl2 = false;
            bl = false;
            Message it = message;
            boolean bl3 = false;
            message2.setParentId(it.getId());
        }
        this.stopTyping();
        SendMessage sendMessage2 = this.chatDomain.getUseCases().getSendMessage();
        message = message2;
        bl2 = false;
        bl = false;
        messageTransformer.invoke((Object)message);
        Call.DefaultImpls.enqueue$default((Call)SendMessage.DefaultImpls.invoke$default((SendMessage)sendMessage2, (Message)message, null, (int)2, null), null, (int)1, null);
    }

    public static /* synthetic */ void sendMessage$default(MessageInputViewModel messageInputViewModel, String string2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = sendMessage.1.INSTANCE;
        }
        messageInputViewModel.sendMessage(string2, (Function1<? super Message, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    public final void sendMessageWithAttachments(@NotNull String messageText, @NotNull List<? extends File> attachmentFiles, @NotNull Function1<? super Message, Unit> messageTransformer) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)messageText, (String)"messageText");
        Intrinsics.checkNotNullParameter(attachmentFiles, (String)"attachmentFiles");
        Intrinsics.checkNotNullParameter(messageTransformer, (String)"messageTransformer");
        Iterable $this$map$iv = attachmentFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file = (File)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Attachment attachment = new Attachment(null, null, null, null, null, null, null, 0, null, null, null, null, null, null, null, (File)it, null, null, 229375, null);
            collection.add(attachment);
        }
        List attachments2 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Message message = new Message(null, this.cid, messageText, null, null, null, attachments2, null, null, 0, null, null, null, null, null, null, null, null, null, null, null, null, null, false, null, false, 67108793, null);
        boolean bl = false;
        boolean bl2 = false;
        messageTransformer.invoke((Object)message);
        Message message2 = message;
        Call.DefaultImpls.enqueue$default((Call)SendMessage.DefaultImpls.invoke$default((SendMessage)this.chatDomain.getUseCases().getSendMessage(), (Message)message2, null, (int)2, null), null, (int)1, null);
    }

    public static /* synthetic */ void sendMessageWithAttachments$default(MessageInputViewModel messageInputViewModel, String string2, List list, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = sendMessageWithAttachments.1.INSTANCE;
        }
        messageInputViewModel.sendMessageWithAttachments(string2, list, (Function1<? super Message, Unit>)function1);
    }

    public final void editMessage(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.stopTyping();
        Call.DefaultImpls.enqueue$default((Call)this.chatDomain.getUseCases().getEditMessage().invoke(message), null, (int)1, null);
    }

    public final synchronized void keystroke() {
        if (this.isThread()) {
            return;
        }
        Call.DefaultImpls.enqueue$default((Call)this.chatDomain.getUseCases().getKeystroke().invoke(this.cid), null, (int)1, null);
    }

    public final void stopTyping() {
        if (this.isThread()) {
            return;
        }
        Call.DefaultImpls.enqueue$default((Call)this.chatDomain.getUseCases().getStopTyping().invoke(this.cid), null, (int)1, null);
    }

    @JvmOverloads
    public MessageInputViewModel(@NotNull String cid, @NotNull ChatDomain chatDomain) {
        Intrinsics.checkNotNullParameter((Object)cid, (String)"cid");
        Intrinsics.checkNotNullParameter((Object)chatDomain, (String)"chatDomain");
        this.cid = cid;
        this.chatDomain = chatDomain;
        this.activeThread = new MutableLiveData();
        this._maxMessageLength = new MutableLiveData((Object)0);
        this._commands = new MutableLiveData((Object)CollectionsKt.emptyList());
        this._members = new MediatorLiveData();
        this.maxMessageLength = (LiveData)this._maxMessageLength;
        this.commands = (LiveData)this._commands;
        this.members = (LiveData)this._members;
        this.editMessage = new MutableLiveData();
        this.chatDomain.getUseCases().getWatchChannel().invoke(this.cid, 0).enqueue((Function1)new Function1<Result<ChannelController>, Unit>(){

            public final void invoke(@NotNull Result<ChannelController> channelControllerResult) {
                Intrinsics.checkNotNullParameter(channelControllerResult, (String)"channelControllerResult");
                if (channelControllerResult.isSuccess()) {
                    ChannelController channelController = (ChannelController)channelControllerResult.data();
                    Channel channel = channelController.toChannel();
                    _maxMessageLength.setValue((Object)channel.getConfig().getMaxMessageLength());
                    _commands.setValue((Object)channel.getConfig().getCommands());
                    _members.addSource(channelController.getMembers(), (Observer)new Observer<List<? extends Member>>(){

                        public final void onChanged(List<Member> it) {
                            _members.setValue(it);
                        }
                    });
                }
            }
        });
    }

    public /* synthetic */ MessageInputViewModel(String string2, ChatDomain chatDomain, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            chatDomain = ChatDomain.Companion.instance();
        }
        this(string2, chatDomain);
    }

    @JvmOverloads
    public MessageInputViewModel(@NotNull String cid) {
        this(cid, null, 2, null);
    }
}

