/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.adapter.BaseChannelListItemViewHolder;
import com.getstream.sdk.chat.adapter.ChannelItemPayloadDiff;
import com.getstream.sdk.chat.adapter.ChannelListDiffCallback;
import com.getstream.sdk.chat.adapter.ChannelViewHolderFactory;
import com.getstream.sdk.chat.view.channels.ChannelListView;
import com.getstream.sdk.chat.view.channels.ChannelListViewStyle;
import io.getstream.chat.android.client.models.Channel;
import java.util.ArrayList;
import java.util.List;

public class ChannelListItemAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final ChannelItemPayloadDiff FULL_CHANNEL_ITEM_PAYLOAD_DIFF = new ChannelItemPayloadDiff(true, true, true, true, true);
    private static final ChannelItemPayloadDiff EMPTY_CHANNEL_ITEM_PAYLOAD_DIFF = new ChannelItemPayloadDiff(false, false, false, false, false);
    private List<Channel> channels;
    private ChannelListView.ChannelClickListener channelClickListener;
    private ChannelListView.ChannelClickListener channelLongClickListener;
    private ChannelListView.UserClickListener userClickListener;
    private ChannelListViewStyle style;
    private ChannelViewHolderFactory viewHolderFactory;

    public ChannelListItemAdapter(List<Channel> channels) {
        this.channels = channels;
        this.viewHolderFactory = new ChannelViewHolderFactory();
    }

    public ChannelListItemAdapter() {
        this(new ArrayList<Channel>());
        this.viewHolderFactory = new ChannelViewHolderFactory();
    }

    public ChannelListView.ChannelClickListener getChannelClickListener() {
        return this.channelClickListener;
    }

    public void setChannelClickListener(ChannelListView.ChannelClickListener l) {
        this.channelClickListener = l;
    }

    public ChannelListView.ChannelClickListener getChannelLongClickListener() {
        return this.channelLongClickListener;
    }

    public void setChannelLongClickListener(ChannelListView.ChannelClickListener l) {
        this.channelLongClickListener = l;
    }

    public ChannelListView.UserClickListener getUserClickListener() {
        return this.userClickListener;
    }

    public void setUserClickListener(ChannelListView.UserClickListener l) {
        this.userClickListener = l;
    }

    public void replaceChannels(List<Channel> channelList) {
        ArrayList<Channel> cloneChannelList = new ArrayList<Channel>(new ArrayList<Channel>(channelList));
        DiffUtil.DiffResult result = DiffUtil.calculateDiff((DiffUtil.Callback)new ChannelListDiffCallback(this.channels, cloneChannelList), (boolean)true);
        result.dispatchUpdatesTo((RecyclerView.Adapter)this);
        this.channels = cloneChannelList;
    }

    public int getItemViewType(int position) {
        Channel channel = this.channels.get(position);
        return this.viewHolderFactory.getChannelViewType(channel);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return this.viewHolderFactory.createChannelViewHolder(this, parent, viewType);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position) {
        Channel channelState = this.channels.get(position);
        ((BaseChannelListItemViewHolder)holder).bind(channelState, position, FULL_CHANNEL_ITEM_PAYLOAD_DIFF);
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, int position, @NonNull List<Object> payloads) {
        Channel channelState = this.channels.get(position);
        ChannelItemPayloadDiff diff = EMPTY_CHANNEL_ITEM_PAYLOAD_DIFF;
        if (payloads.isEmpty()) {
            diff = FULL_CHANNEL_ITEM_PAYLOAD_DIFF;
        } else {
            for (int i = 0; i < payloads.size(); ++i) {
                diff = diff.plus((ChannelItemPayloadDiff)payloads.get(i));
            }
        }
        ((BaseChannelListItemViewHolder)holder).bind(channelState, position, diff);
    }

    public int getItemCount() {
        return this.channels.size();
    }

    public ChannelListViewStyle getStyle() {
        return this.style;
    }

    public void setStyle(ChannelListViewStyle s) {
        this.style = s;
    }

    public void setViewHolderFactory(ChannelViewHolderFactory viewHolderFactory) {
        this.viewHolderFactory = viewHolderFactory;
    }
}

