/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.databinding.StreamItemAttachFileBinding;
import com.getstream.sdk.chat.model.AttachmentMetaData;
import com.getstream.sdk.chat.utils.MediaStringUtil;
import com.getstream.sdk.chat.utils.UiUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000f\u001a\u00020\tJ\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0015H\u0016J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0014\u0010\u001f\u001a\u00020\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/getstream/sdk/chat/adapter/FileAttachmentSelectedAdapter;", "Landroid/widget/BaseAdapter;", "attachments", "", "Lcom/getstream/sdk/chat/model/AttachmentMetaData;", "localAttach", "", "cancelListener", "Lkotlin/Function1;", "", "(Ljava/util/List;ZLkotlin/jvm/functions/Function1;)V", "getCancelListener", "()Lkotlin/jvm/functions/Function1;", "setCancelListener", "(Lkotlin/jvm/functions/Function1;)V", "clear", "configureFileAttach", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemAttachFileBinding;", "attachment", "getCount", "", "getItem", "position", "getItemId", "", "getView", "Landroid/view/View;", "convertView", "parent", "Landroid/view/ViewGroup;", "setAttachments", "stream-chat-android_release"})
public final class FileAttachmentSelectedAdapter
extends BaseAdapter {
    private List<AttachmentMetaData> attachments;
    private final boolean localAttach;
    @NotNull
    private Function1<? super AttachmentMetaData, Unit> cancelListener;

    public int getCount() {
        return this.attachments.size();
    }

    @NotNull
    public AttachmentMetaData getItem(int position) {
        return this.attachments.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    @NotNull
    public View getView(int position, @Nullable View convertView, @NotNull ViewGroup parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        View view = convertView;
        if (view == null) {
            view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.stream_item_attach_file, parent, false);
        }
        View view2 = view;
        StreamItemAttachFileBinding streamItemAttachFileBinding = StreamItemAttachFileBinding.bind(view2);
        Intrinsics.checkNotNullExpressionValue((Object)streamItemAttachFileBinding, (String)"StreamItemAttachFileBinding.bind(view)");
        StreamItemAttachFileBinding binding = streamItemAttachFileBinding;
        this.configureFileAttach(binding, this.attachments.get(position));
        View view3 = view2;
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"view");
        return view3;
    }

    private final void configureFileAttach(StreamItemAttachFileBinding binding, AttachmentMetaData attachment) {
        binding.ivFileThumb.setImageResource(UiUtils.INSTANCE.getIcon(attachment.getMimeType()));
        TextView textView = binding.tvFileTitle;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvFileTitle");
        textView.setText((CharSequence)attachment.getTitle());
        ImageView imageView = binding.ivLargeFileMark;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivLargeFileMark");
        imageView.setVisibility(4);
        ImageView imageView2 = binding.ivSelectMark;
        Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.ivSelectMark");
        boolean bl = false;
        View $this$isVisible$iv = (View)imageView2;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        TextView textView2 = binding.tvClose;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.tvClose");
        textView2.setVisibility(4);
        ProgressBar progressBar = binding.progressBar;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.progressBar");
        boolean value$iv = false;
        $this$isVisible$iv = (View)progressBar;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
        TextView textView3 = binding.tvFileSize;
        Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"binding.tvFileSize");
        textView3.setText((CharSequence)MediaStringUtil.convertFileSizeByteCount((long)attachment.getSize()));
        if (!this.localAttach) {
            return;
        }
        TextView textView4 = binding.tvClose;
        Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"binding.tvClose");
        value$iv = true;
        $this$isVisible$iv = (View)textView4;
        $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
        binding.tvClose.setOnClickListener(new View.OnClickListener(this, attachment){
            final /* synthetic */ FileAttachmentSelectedAdapter this$0;
            final /* synthetic */ AttachmentMetaData $attachment;

            public final void onClick(View it) {
                this.this$0.getCancelListener().invoke((Object)this.$attachment);
            }
            {
                this.this$0 = fileAttachmentSelectedAdapter;
                this.$attachment = attachmentMetaData;
            }
        });
    }

    public final void setAttachments(@NotNull List<AttachmentMetaData> attachments2) {
        Intrinsics.checkNotNullParameter(attachments2, (String)"attachments");
        this.attachments = attachments2;
        this.notifyDataSetChanged();
    }

    public final void clear() {
        this.attachments = CollectionsKt.emptyList();
        this.notifyDataSetChanged();
    }

    @NotNull
    public final Function1<AttachmentMetaData, Unit> getCancelListener() {
        return this.cancelListener;
    }

    public final void setCancelListener(@NotNull Function1<? super AttachmentMetaData, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.cancelListener = function1;
    }

    public FileAttachmentSelectedAdapter(@NotNull List<AttachmentMetaData> attachments2, boolean localAttach, @NotNull Function1<? super AttachmentMetaData, Unit> cancelListener) {
        Intrinsics.checkNotNullParameter(attachments2, (String)"attachments");
        Intrinsics.checkNotNullParameter(cancelListener, (String)"cancelListener");
        this.attachments = attachments2;
        this.localAttach = localAttach;
        this.cancelListener = cancelListener;
    }

    public /* synthetic */ FileAttachmentSelectedAdapter(List list, boolean bl, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(list, bl, (Function1<? super AttachmentMetaData, Unit>)function1);
    }
}

