/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.utils.UiUtils;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.Reaction;
import io.getstream.chat.android.livedata.ChatDomain;
import java.util.List;
import java.util.Map;
import kotlin.Unit;

public class ReactionDialogAdapter
extends RecyclerView.Adapter<ReactionViewHolder> {
    private static final String TAG = ReactionDialogAdapter.class.getSimpleName();
    private Message message;
    private String cid = "";
    private View.OnClickListener clickListener;
    private Map<String, String> reactionTypes;
    private MessageListViewStyle style;

    public ReactionDialogAdapter(Message message, MessageListViewStyle style, View.OnClickListener clickListener2) {
        this.message = message;
        this.reactionTypes = UiUtils.getReactionTypes();
        this.style = style;
        this.clickListener = clickListener2;
        if (!message.getCid().equals("")) {
            this.cid = message.getCid();
        }
    }

    public ReactionViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.stream_item_dialog_reaction, parent, false);
        return new ReactionViewHolder(itemView);
    }

    public void onBindViewHolder(ReactionViewHolder holder, int position) {
        this.applyStyle(holder);
        String key = (String)this.reactionTypes.keySet().toArray()[position];
        holder.bind(key, position);
    }

    private void applyStyle(ReactionViewHolder holder) {
        holder.tv_emoji.setTextSize(0, (float)this.style.getReactionInputEmojiSize());
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)holder.tv_emoji.getLayoutParams();
        params.leftMargin = this.style.getReactionInputEmojiMargin();
        params.rightMargin = this.style.getReactionInputEmojiMargin();
        params.topMargin = this.style.getReactionInputEmojiMargin();
        params.bottomMargin = this.style.getReactionInputEmojiMargin();
        holder.tv_emoji.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    public int getItemCount() {
        return this.reactionTypes.size();
    }

    public class ReactionViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        private TextView tv_emoji;
        private TextView tv_count;
        private String reactionKey;
        private int position;

        private ReactionViewHolder(View view) {
            super(view);
            this.tv_emoji = (TextView)view.findViewById(R.id.tv_emoji);
            this.tv_count = (TextView)view.findViewById(R.id.tv_count);
            view.setOnClickListener((View.OnClickListener)this);
        }

        void bind(String key, int position) {
            this.reactionKey = key;
            this.position = position;
            String value = (String)ReactionDialogAdapter.this.reactionTypes.get(key);
            this.tv_emoji.setText((CharSequence)value);
            Map reactionCounts = ReactionDialogAdapter.this.message.getReactionCounts();
            if (reactionCounts != null && reactionCounts.containsKey(key)) {
                this.tv_count.setText((CharSequence)String.valueOf(reactionCounts.get(key)));
            } else {
                this.tv_count.setText((CharSequence)"");
            }
        }

        public void onClick(View v) {
            String type = (String)ReactionDialogAdapter.this.reactionTypes.keySet().toArray()[this.getLayoutPosition()];
            List ownReactions = ReactionDialogAdapter.this.message.getOwnReactions();
            boolean isReacted = false;
            for (Reaction ownReaction : ownReactions) {
                String reactionType = ownReaction.getType();
                if (!type.equals(reactionType)) continue;
                isReacted = true;
                break;
            }
            if (isReacted) {
                this.deleteReaction(v, type);
            } else {
                this.sendReaction(v, type);
            }
        }

        private void sendReaction(View view, String type) {
            ReactionDialogAdapter.this.clickListener.onClick(view);
            Reaction reaction = new Reaction();
            reaction.setMessageId(ReactionDialogAdapter.this.message.getId());
            reaction.setType(type);
            if (!ReactionDialogAdapter.this.cid.equals("")) {
                ChatDomain.instance().getUseCases().getSendReaction().invoke(ReactionDialogAdapter.this.cid, reaction).enqueue(reactionResult -> Unit.INSTANCE);
            }
        }

        private void deleteReaction(View view, String type) {
            ReactionDialogAdapter.this.clickListener.onClick(view);
            Reaction reaction = new Reaction();
            reaction.setMessageId(ReactionDialogAdapter.this.message.getId());
            reaction.setType(type);
            if (!ReactionDialogAdapter.this.cid.equals("")) {
                ChatDomain.instance().getUseCases().getDeleteReaction().invoke(ReactionDialogAdapter.this.cid, reaction).enqueue(reactionResult -> Unit.INSTANCE);
            }
        }
    }
}

