/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter.viewholder.message.configurators;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.Space;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.ReactionListItemAdapter;
import com.getstream.sdk.chat.adapter.viewholder.message.ExtensionsKt;
import com.getstream.sdk.chat.adapter.viewholder.message.configurators.Configurator;
import com.getstream.sdk.chat.adapter.viewholder.message.configurators.ReactionConfigurator;
import com.getstream.sdk.chat.databinding.StreamItemMessageBinding;
import com.getstream.sdk.chat.utils.UiUtils;
import com.getstream.sdk.chat.utils.extensions.ConstraintLayoutKt;
import com.getstream.sdk.chat.view.MessageListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Message;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.defaults.drawabletoolbox.DrawableBuilder;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/ReactionConfigurator;", "Lcom/getstream/sdk/chat/adapter/viewholder/message/configurators/Configurator;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;", "context", "Landroid/content/Context;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "channel", "Lio/getstream/chat/android/client/models/Channel;", "reactionViewClickListener", "Lcom/getstream/sdk/chat/view/MessageListView$ReactionViewClickListener;", "configParamsReadIndicator", "Lkotlin/Function1;", "Lcom/getstream/sdk/chat/adapter/MessageListItem$MessageItem;", "", "(Lcom/getstream/sdk/chat/databinding/StreamItemMessageBinding;Landroid/content/Context;Lcom/getstream/sdk/chat/view/MessageListViewStyle;Lio/getstream/chat/android/client/models/Channel;Lcom/getstream/sdk/chat/view/MessageListView$ReactionViewClickListener;Lkotlin/jvm/functions/Function1;)V", "configParamsReactionRecyclerView", "messageItem", "configParamsReactionSpace", "configParamsReactionTail", "configReactionView", "configStyleReactionView", "configure", "stream-chat-android_release"})
public final class ReactionConfigurator
implements Configurator {
    private final StreamItemMessageBinding binding;
    private final Context context;
    private final MessageListViewStyle style;
    private final Channel channel;
    private final MessageListView.ReactionViewClickListener reactionViewClickListener;
    private final Function1<MessageListItem.MessageItem, Unit> configParamsReadIndicator;

    @Override
    public void configure(@NotNull MessageListItem.MessageItem messageItem) {
        Intrinsics.checkNotNullParameter((Object)messageItem, (String)"messageItem");
        this.configReactionView(messageItem);
        this.configParamsReactionSpace(messageItem);
        this.configParamsReactionTail(messageItem);
        this.configParamsReactionRecyclerView(messageItem);
    }

    private final void configReactionView(MessageListItem.MessageItem messageItem) {
        Message message = messageItem.getMessage();
        if (ExtensionsKt.isDeleted(message) || ExtensionsKt.isFailed(message) || !this.style.isReactionEnabled() || !this.channel.getConfig().isReactionsEnabled() || message.getReactionCounts().isEmpty()) {
            RecyclerView recyclerView = this.binding.reactionsRecyclerView;
            Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.reactionsRecyclerView");
            recyclerView.setVisibility(8);
            ImageView imageView = this.binding.ivTail;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivTail");
            imageView.setVisibility(8);
            Space space = this.binding.spaceReactionTail;
            Intrinsics.checkNotNullExpressionValue((Object)space, (String)"binding.spaceReactionTail");
            space.setVisibility(8);
            return;
        }
        this.configStyleReactionView(messageItem);
        RecyclerView recyclerView = this.binding.reactionsRecyclerView;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.reactionsRecyclerView");
        recyclerView.setVisibility(0);
        ImageView imageView = this.binding.ivTail;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivTail");
        imageView.setVisibility(0);
        Space space = this.binding.spaceReactionTail;
        Intrinsics.checkNotNullExpressionValue((Object)space, (String)"binding.spaceReactionTail");
        space.setVisibility(0);
        RecyclerView recyclerView2 = this.binding.reactionsRecyclerView;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"binding.reactionsRecyclerView");
        recyclerView2.setAdapter((RecyclerView.Adapter)new ReactionListItemAdapter(this.context, message.getReactionCounts(), UiUtils.getReactionTypes(), this.style));
        this.binding.reactionsRecyclerView.setOnTouchListener(new View.OnTouchListener(this, message){
            final /* synthetic */ ReactionConfigurator this$0;
            final /* synthetic */ Message $message;

            public final boolean onTouch(@Nullable View $noName_0, @NotNull MotionEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getAction() == 1) {
                    ReactionConfigurator.access$getReactionViewClickListener$p(this.this$0).onReactionViewClick(this.$message);
                }
                return false;
            }
            {
                this.this$0 = reactionConfigurator2;
                this.$message = message;
            }
        });
    }

    private final void configStyleReactionView(MessageListItem.MessageItem messageItem) {
        if (this.style.getReactionViewBgDrawable() == -1) {
            RecyclerView recyclerView = this.binding.reactionsRecyclerView;
            Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.reactionsRecyclerView");
            recyclerView.setBackground(new DrawableBuilder().rectangle().rounded().solidColor(this.style.getReactionViewBgColor()).solidColorPressed(Integer.valueOf(-3355444)).build());
            this.binding.ivTail.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)(messageItem.isMine() ? R.drawable.stream_tail_outgoing : R.drawable.stream_tail_incoming)));
            ImageView imageView = this.binding.ivTail;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivTail");
            DrawableCompat.setTint((Drawable)imageView.getDrawable(), (int)this.style.getReactionViewBgColor());
        } else {
            int drawable2 = this.style.getReactionViewBgDrawable();
            RecyclerView recyclerView = this.binding.reactionsRecyclerView;
            Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.reactionsRecyclerView");
            recyclerView.setBackground(ContextCompat.getDrawable((Context)this.context, (int)drawable2));
            ImageView imageView = this.binding.ivTail;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivTail");
            imageView.setVisibility(8);
        }
    }

    private final void configParamsReactionSpace(MessageListItem.MessageItem messageItem) {
        ImageView imageView = this.binding.ivTail;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivTail");
        if (imageView.getVisibility() != 0) {
            return;
        }
        ConstraintLayout constraintLayout = this.binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
        ConstraintLayoutKt.updateConstraints((ConstraintLayout)constraintLayout, (Function1)configParamsReactionSpace.1.INSTANCE);
        Space space = this.binding.spaceReactionTail;
        Intrinsics.checkNotNullExpressionValue((Object)space, (String)"binding.spaceReactionTail");
        ViewGroup.LayoutParams layoutParams = space.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)layoutParams;
        int activeContentViewResId = ExtensionsKt.getActiveContentViewResId(messageItem.getMessage(), this.binding);
        if (messageItem.isMine()) {
            params.endToStart = activeContentViewResId;
        } else {
            params.startToEnd = activeContentViewResId;
        }
        Space space2 = this.binding.spaceReactionTail;
        Intrinsics.checkNotNullExpressionValue((Object)space2, (String)"binding.spaceReactionTail");
        space2.setLayoutParams((ViewGroup.LayoutParams)params);
        this.binding.reactionsRecyclerView.post(new Runnable(this, params){
            final /* synthetic */ ReactionConfigurator this$0;
            final /* synthetic */ ConstraintLayout.LayoutParams $params;

            public final void run() {
                RecyclerView recyclerView = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).reactionsRecyclerView;
                Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.reactionsRecyclerView");
                this.$params.width = recyclerView.getHeight() / 3;
                Space space = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).spaceReactionTail;
                Intrinsics.checkNotNullExpressionValue((Object)space, (String)"binding.spaceReactionTail");
                space.setLayoutParams((ViewGroup.LayoutParams)this.$params);
            }
            {
                this.this$0 = reactionConfigurator2;
                this.$params = layoutParams;
            }
        });
    }

    private final void configParamsReactionTail(MessageListItem.MessageItem messageItem) {
        ImageView imageView = this.binding.ivTail;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivTail");
        if (imageView.getVisibility() != 0) {
            return;
        }
        ConstraintLayout constraintLayout = this.binding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
        ConstraintLayoutKt.updateConstraints((ConstraintLayout)constraintLayout, (Function1)configParamsReactionTail.1.INSTANCE);
        ImageView imageView2 = this.binding.ivTail;
        Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.ivTail");
        ViewGroup.LayoutParams layoutParams = imageView2.getLayoutParams();
        if (layoutParams == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
        }
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)layoutParams;
        if (messageItem.isMine()) {
            Space space = this.binding.spaceReactionTail;
            Intrinsics.checkNotNullExpressionValue((Object)space, (String)"binding.spaceReactionTail");
            params.startToStart = space.getId();
        } else {
            Space space = this.binding.spaceReactionTail;
            Intrinsics.checkNotNullExpressionValue((Object)space, (String)"binding.spaceReactionTail");
            params.endToEnd = space.getId();
        }
        this.binding.reactionsRecyclerView.post(new Runnable(this, params){
            final /* synthetic */ ReactionConfigurator this$0;
            final /* synthetic */ ConstraintLayout.LayoutParams $params;

            public final void run() {
                RecyclerView recyclerView = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).reactionsRecyclerView;
                Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.reactionsRecyclerView");
                this.$params.height = recyclerView.getHeight();
                RecyclerView recyclerView2 = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).reactionsRecyclerView;
                Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"binding.reactionsRecyclerView");
                this.$params.width = recyclerView2.getHeight();
                RecyclerView recyclerView3 = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).reactionsRecyclerView;
                Intrinsics.checkNotNullExpressionValue((Object)recyclerView3, (String)"binding.reactionsRecyclerView");
                this.$params.topMargin = recyclerView3.getHeight() / 3;
                ImageView imageView = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).ivTail;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivTail");
                imageView.setLayoutParams((ViewGroup.LayoutParams)this.$params);
            }
            {
                this.this$0 = reactionConfigurator2;
                this.$params = layoutParams;
            }
        });
    }

    private final void configParamsReactionRecyclerView(MessageListItem.MessageItem messageItem) {
        RecyclerView recyclerView = this.binding.reactionsRecyclerView;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.reactionsRecyclerView");
        if (recyclerView.getVisibility() != 0) {
            return;
        }
        RecyclerView recyclerView2 = this.binding.reactionsRecyclerView;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"binding.reactionsRecyclerView");
        recyclerView2.setVisibility(4);
        ImageView imageView = this.binding.ivTail;
        Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivTail");
        imageView.setVisibility(4);
        this.binding.reactionsRecyclerView.post(new Runnable(this, messageItem){
            final /* synthetic */ ReactionConfigurator this$0;
            final /* synthetic */ MessageListItem.MessageItem $messageItem;

            public final void run() {
                RecyclerView recyclerView = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).reactionsRecyclerView;
                Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.reactionsRecyclerView");
                if (recyclerView.getVisibility() == 8) {
                    return;
                }
                ConstraintLayout constraintLayout = ReactionConfigurator.access$getBinding$p(this.this$0).getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.root");
                ConstraintLayoutKt.updateConstraints((ConstraintLayout)constraintLayout, (Function1)configParamsReactionRecyclerView.1.INSTANCE);
                RecyclerView recyclerView2 = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).reactionsRecyclerView;
                Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"binding.reactionsRecyclerView");
                View $this$updateLayoutParams$iv = (View)recyclerView2;
                boolean $i$f$updateLayoutParamsTyped = false;
                ViewGroup.LayoutParams layoutParams = $this$updateLayoutParams$iv.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("null cannot be cast to non-null type androidx.constraintlayout.widget.ConstraintLayout.LayoutParams");
                }
                ViewGroup.LayoutParams params$iv = (ViewGroup.LayoutParams)((ConstraintLayout.LayoutParams)layoutParams);
                ConstraintLayout.LayoutParams $this$updateLayoutParams = (ConstraintLayout.LayoutParams)params$iv;
                boolean bl = false;
                Collection collection = this.$messageItem.getMessage().getAttachments();
                boolean bl2 = false;
                if (!collection.isEmpty()) {
                    if (this.$messageItem.isMine()) {
                        $this$updateLayoutParams.startToStart = R.id.space_reaction_tail;
                    } else {
                        $this$updateLayoutParams.endToEnd = R.id.space_reaction_tail;
                    }
                } else {
                    int reactionMargin = ReactionConfigurator.access$getContext$p(this.this$0).getResources().getDimensionPixelSize(R.dimen.stream_reaction_margin);
                    TextView textView = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).tvText;
                    Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.tvText");
                    int n = textView.getWidth() + reactionMargin;
                    RecyclerView recyclerView3 = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).reactionsRecyclerView;
                    Intrinsics.checkNotNullExpressionValue((Object)recyclerView3, (String)"binding.reactionsRecyclerView");
                    if (n < recyclerView3.getWidth()) {
                        if (this.$messageItem.isMine()) {
                            $this$updateLayoutParams.endToEnd = R.id.tv_text;
                        } else {
                            $this$updateLayoutParams.startToStart = R.id.tv_text;
                        }
                    } else if (this.$messageItem.isMine()) {
                        $this$updateLayoutParams.startToStart = R.id.space_reaction_tail;
                    } else {
                        $this$updateLayoutParams.endToEnd = R.id.space_reaction_tail;
                    }
                }
                $this$updateLayoutParams$iv.setLayoutParams(params$iv);
                RecyclerView recyclerView4 = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).reactionsRecyclerView;
                Intrinsics.checkNotNullExpressionValue((Object)recyclerView4, (String)"binding.reactionsRecyclerView");
                boolean value$iv = true;
                View $this$isVisible$iv = (View)recyclerView4;
                boolean $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                ImageView imageView = ReactionConfigurator.access$getBinding$p((ReactionConfigurator)this.this$0).ivTail;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivTail");
                value$iv = true;
                $this$isVisible$iv = (View)imageView;
                $i$f$setVisible = false;
                $this$isVisible$iv.setVisibility(0);
                ReactionConfigurator.access$getConfigParamsReadIndicator$p(this.this$0).invoke((Object)this.$messageItem);
            }
            {
                this.this$0 = reactionConfigurator2;
                this.$messageItem = messageItem;
            }
        });
    }

    public ReactionConfigurator(@NotNull StreamItemMessageBinding binding, @NotNull Context context, @NotNull MessageListViewStyle style, @NotNull Channel channel, @NotNull MessageListView.ReactionViewClickListener reactionViewClickListener2, @NotNull Function1<? super MessageListItem.MessageItem, Unit> configParamsReadIndicator2) {
        Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)reactionViewClickListener2, (String)"reactionViewClickListener");
        Intrinsics.checkNotNullParameter(configParamsReadIndicator2, (String)"configParamsReadIndicator");
        this.binding = binding;
        this.context = context;
        this.style = style;
        this.channel = channel;
        this.reactionViewClickListener = reactionViewClickListener2;
        this.configParamsReadIndicator = configParamsReadIndicator2;
    }

    public static final /* synthetic */ MessageListView.ReactionViewClickListener access$getReactionViewClickListener$p(ReactionConfigurator $this) {
        return $this.reactionViewClickListener;
    }

    public static final /* synthetic */ StreamItemMessageBinding access$getBinding$p(ReactionConfigurator $this) {
        return $this.binding;
    }

    public static final /* synthetic */ Context access$getContext$p(ReactionConfigurator $this) {
        return $this.context;
    }

    public static final /* synthetic */ Function1 access$getConfigParamsReadIndicator$p(ReactionConfigurator $this) {
        return $this.configParamsReadIndicator;
    }
}

