/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.utils;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.utils.Utils;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CaptureController {
    private static Uri imageUri;
    private static Uri videoUri;

    public static Intent getTakePictureIntent(Context context) {
        File newFile = new File(CaptureController.getFolderPath(true, context), "IMG_" + CaptureController.getFileName() + ".jpg");
        imageUri = Uri.fromFile((File)newFile);
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        ContentValues values = new ContentValues();
        values.put("title", "New Picture");
        values.put("description", "From your Camera");
        takePictureIntent.putExtra("output", (Parcelable)imageUri);
        return takePictureIntent;
    }

    public static Intent getTakeVideoIntent(Context context) {
        File newFile = new File(CaptureController.getFolderPath(false, context), "VID_" + CaptureController.getFileName() + ".mp4");
        videoUri = Uri.fromFile((File)newFile);
        Intent takeVideoIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        ContentValues values = new ContentValues();
        values.put("title", "New Video");
        values.put("description", "From your Camera");
        takeVideoIntent.putExtra("output", (Parcelable)videoUri);
        return takeVideoIntent;
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private static String getFileName() {
        return new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date().getTime());
    }

    private static String getFolderPath(boolean isImage, Context context) {
        String appName = Utils.getApplicationName((Context)context);
        File f1 = new File(Environment.getExternalStorageDirectory() + "/" + appName, context.getString(isImage ? R.string.stream_image : R.string.stream_video));
        if (!f1.exists()) {
            f1.mkdirs();
        }
        return f1.getAbsolutePath();
    }

    @Nullable
    public static File getCaptureFile(boolean isImage) {
        return CaptureController.getFileFromUri(isImage ? imageUri : videoUri);
    }

    @Nullable
    public static File getFileFromUri(Uri uri) {
        String path = uri.getPath();
        if (path == null) {
            return null;
        }
        return new File(path);
    }
}

