/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.DrawableRes;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.DefaultBubbleHelper;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.AttachmentViewHolderFactory;
import com.getstream.sdk.chat.adapter.ListenerContainer;
import com.getstream.sdk.chat.adapter.ListenerContainerImpl;
import com.getstream.sdk.chat.adapter.MessageListItem;
import com.getstream.sdk.chat.adapter.MessageListItemAdapter;
import com.getstream.sdk.chat.adapter.MessageViewHolderFactory;
import com.getstream.sdk.chat.databinding.StreamMessageListViewBinding;
import com.getstream.sdk.chat.enums.GiphyAction;
import com.getstream.sdk.chat.navigation.ChatNavigator;
import com.getstream.sdk.chat.navigation.destinations.AttachmentDestination;
import com.getstream.sdk.chat.navigation.destinations.ChatDestination;
import com.getstream.sdk.chat.utils.DateFormatter;
import com.getstream.sdk.chat.utils.StartStopBuffer;
import com.getstream.sdk.chat.view.EndlessScrollListener;
import com.getstream.sdk.chat.view.MessageListView;
import com.getstream.sdk.chat.view.MessageListViewStyle;
import com.getstream.sdk.chat.view.dialog.MessageMoreActionDialog;
import com.getstream.sdk.chat.view.dialog.ReadUsersDialog;
import com.getstream.sdk.chat.view.messages.MessageListItemWrapper;
import io.getstream.chat.android.client.logger.ChatLogger;
import io.getstream.chat.android.client.logger.TaggedLogger;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.ChannelUserRead;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u009a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b9\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u00002\u00020\u0001:\u001e\u00b3\u0001\u00b4\u0001\u00b5\u0001\u00b6\u0001\u00b7\u0001\u00b8\u0001\u00b9\u0001\u00ba\u0001\u00bb\u0001\u00bc\u0001\u00bd\u0001\u00be\u0001\u00bf\u0001\u00c0\u0001\u00c1\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010f\u001a\u0002062\u0006\u0010g\u001a\u00020\u0006H\u0002J.\u0010h\u001a\u0002062\u0006\u0010i\u001a\u0002092\u0006\u0010j\u001a\u00020%2\f\u0010k\u001a\b\u0012\u0004\u0012\u00020<0l2\u0006\u0010m\u001a\u00020\tH\u0002J\u000e\u0010n\u001a\u0002062\u0006\u0010j\u001a\u00020%J\b\u0010o\u001a\u00020\tH\u0002J\u0010\u0010p\u001a\u0002062\u0006\u0010j\u001a\u00020%H\u0002J\u0006\u0010q\u001a\u000206J\u0006\u0010r\u001a\u000206J\u001a\u0010s\u001a\u0002062\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010t\u001a\u0004\u0018\u00010\u0006H\u0002J\u0016\u0010s\u001a\u0002062\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\b\u0010u\u001a\u000206H\u0002J\b\u0010v\u001a\u000206H\u0002J\b\u0010w\u001a\u000206H\u0002J\b\u0010x\u001a\u000206H\u0002J\b\u0010y\u001a\u000206H\u0002J\b\u0010z\u001a\u000206H\u0002J\b\u0010{\u001a\u000206H\u0002J\b\u0010|\u001a\u00020\tH\u0002J\u001a\u0010}\u001a\u0002062\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\u0006\u0010~\u001a\u000206J\u000f\u0010\u007f\u001a\u0002062\u0007\u0010\u0080\u0001\u001a\u00020TJ\u0012\u0010\u0081\u0001\u001a\u0002092\u0007\u0010\u0082\u0001\u001a\u00020\tH\u0002J\u0012\u0010\u0083\u0001\u001a\u0002062\t\u0010\u0084\u0001\u001a\u0004\u0018\u00010\fJ\u000f\u0010\u0085\u0001\u001a\u0002062\u0006\u0010\u001d\u001a\u00020\u001eJ\u000f\u0010\u0086\u0001\u001a\u0002062\u0006\u0010!\u001a\u00020\"J\u001b\u0010\u0087\u0001\u001a\u0002062\u0007\u0010\u0088\u0001\u001a\u0002012\t\b\u0002\u0010\u0089\u0001\u001a\u00020+J\u0015\u0010\u008a\u0001\u001a\u0002062\f\u00104\u001a\b\u0012\u0004\u0012\u00020605J\u0015\u0010\u008b\u0001\u001a\u0002062\f\u0010:\u001a\b\u0012\u0004\u0012\u00020605J\u0010\u0010\u008c\u0001\u001a\u0002062\u0007\u0010\u008d\u0001\u001a\u000209J\u001b\u0010\u008e\u0001\u001a\u0002062\u0007\u0010\u0088\u0001\u001a\u0002012\t\b\u0002\u0010\u0089\u0001\u001a\u00020+J\u0012\u0010\u008f\u0001\u001a\u0002062\t\u0010\u0090\u0001\u001a\u0004\u0018\u00010\u0010J\u000f\u0010\u0091\u0001\u001a\u0002062\u0006\u0010I\u001a\u00020JJ\u0011\u0010\u0092\u0001\u001a\u0002062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0012\u0010\u0093\u0001\u001a\u0002062\t\u0010\u0094\u0001\u001a\u0004\u0018\u00010\u0012J\u0012\u0010\u0095\u0001\u001a\u0002062\t\u0010\u0096\u0001\u001a\u0004\u0018\u00010\u0014J\u000f\u0010\u0097\u0001\u001a\u0002062\u0006\u0010K\u001a\u00020LJ\u000f\u0010\u0098\u0001\u001a\u0002062\u0006\u0010M\u001a\u00020NJ\u001b\u0010\u0099\u0001\u001a\u0002062\u0012\u0010R\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SJ\u001b\u0010\u009a\u0001\u001a\u0002062\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SJ\u001b\u0010\u009b\u0001\u001a\u0002062\u0012\u0010V\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SJ\u001b\u0010\u009c\u0001\u001a\u0002062\u0012\u0010W\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SJ!\u0010\u009d\u0001\u001a\u0002062\u0018\u0010X\u001a\u0014\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u0002060YJ\u001b\u0010\u009e\u0001\u001a\u0002062\u0012\u0010[\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SJ\u001b\u0010\u009f\u0001\u001a\u0002062\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SJ\u0012\u0010\u00a0\u0001\u001a\u0002062\t\u0010\u00a1\u0001\u001a\u0004\u0018\u00010\u0016J\u0012\u0010\u00a2\u0001\u001a\u0002062\t\u0010\u00a3\u0001\u001a\u0004\u0018\u00010\u0018J\u0013\u0010\u00a4\u0001\u001a\u0002062\n\u0010\u00a5\u0001\u001a\u0005\u0018\u00010\u00a6\u0001J\u0012\u0010\u00a7\u0001\u001a\u0002062\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\tJ\u000f\u0010\u00a9\u0001\u001a\u0002062\u0006\u0010]\u001a\u00020^J\u0013\u0010\u00aa\u0001\u001a\u0002062\n\u0010\u00a5\u0001\u001a\u0005\u0018\u00010\u00a6\u0001J\u0012\u0010\u00ab\u0001\u001a\u0002062\t\b\u0001\u0010\u00a8\u0001\u001a\u00020\tJ\u0012\u0010\u00ac\u0001\u001a\u0002062\t\u0010\u00ad\u0001\u001a\u0004\u0018\u00010\u001aJ\u0011\u0010\u00ae\u0001\u001a\u0002062\u0006\u0010K\u001a\u00020LH\u0007J\u0007\u0010\u00af\u0001\u001a\u000206J\u0007\u0010\u00b0\u0001\u001a\u000206J\u0014\u0010\u00b1\u0001\u001a\u0002062\t\u0010\u00b2\u0001\u001a\u0004\u0018\u00010<H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010*\u001a\u00020+8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010/\u001a\u0004\b,\u0010-R\u000e\u00100\u001a\u000201X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020605X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020605X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010;\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010<X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u000201X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u000203X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u000209X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020JX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020LX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020NX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010O\u001a\u0004\u0018\u00010PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u0004\u0018\u00010PX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010R\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010U\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010V\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010W\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SX\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010X\u001a\u0014\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u00020Z\u0012\u0004\u0012\u0002060YX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010[\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020T\u0012\u0004\u0012\u0002060SX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010]\u001a\u00020^X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020`X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010a\u001a\u000209X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bb\u0010c\"\u0004\bd\u0010e\u00a8\u0006\u00c2\u0001"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "DEFAULT_ATTACHMENT_CLICK_LISTENER", "Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;", "DEFAULT_GIPHY_SEND_LISTENER", "Lcom/getstream/sdk/chat/view/MessageListView$GiphySendListener;", "DEFAULT_MESSAGE_CLICK_LISTENER", "Lcom/getstream/sdk/chat/view/MessageListView$MessageClickListener;", "DEFAULT_MESSAGE_LONG_CLICK_LISTENER", "Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;", "DEFAULT_MESSAGE_RETRY_LISTENER", "Lcom/getstream/sdk/chat/view/MessageListView$MessageRetryListener;", "DEFAULT_REACTION_VIEW_CLICK_LISTENER", "Lcom/getstream/sdk/chat/view/MessageListView$ReactionViewClickListener;", "DEFAULT_READ_STATE_CLICK_LISTENER", "Lcom/getstream/sdk/chat/view/MessageListView$ReadStateClickListener;", "DEFAULT_USER_CLICK_LISTENER", "Lcom/getstream/sdk/chat/view/MessageListView$UserClickListener;", "adapter", "Lcom/getstream/sdk/chat/adapter/MessageListItemAdapter;", "attachmentViewHolderFactory", "Lcom/getstream/sdk/chat/adapter/AttachmentViewHolderFactory;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamMessageListViewBinding;", "bubbleHelper", "Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;", "buffer", "Lcom/getstream/sdk/chat/utils/StartStopBuffer;", "Lcom/getstream/sdk/chat/view/messages/MessageListItemWrapper;", "channel", "Lio/getstream/chat/android/client/models/Channel;", "currentUser", "Lio/getstream/chat/android/client/models/User;", "defaultChildLayoutParams", "Landroid/widget/FrameLayout$LayoutParams;", "getDefaultChildLayoutParams", "()Landroid/widget/FrameLayout$LayoutParams;", "defaultChildLayoutParams$delegate", "Lkotlin/Lazy;", "emptyStateView", "Landroid/view/View;", "emptyStateViewContainer", "Landroid/view/ViewGroup;", "endRegionReachedHandler", "Lkotlin/Function0;", "", "firstVisiblePosition", "hasScrolledUp", "", "lastMessageReadHandler", "lastSeenMessageInChannel", "Lcom/getstream/sdk/chat/adapter/MessageListItem;", "lastSeenMessageInThread", "layoutManager", "Landroidx/recyclerview/widget/LinearLayoutManager;", "listenerContainer", "Lcom/getstream/sdk/chat/adapter/ListenerContainer;", "loadMoreListener", "Lcom/getstream/sdk/chat/view/EndlessScrollListener;", "loadingView", "loadingViewContainer", "lockScrollUp", "logger", "Lio/getstream/chat/android/client/logger/TaggedLogger;", "messageDateFormatter", "Lcom/getstream/sdk/chat/utils/DateFormatter;", "messageViewHolderFactory", "Lcom/getstream/sdk/chat/adapter/MessageViewHolderFactory;", "newMessagesBehaviour", "Lcom/getstream/sdk/chat/view/MessageListView$NewMessagesBehaviour;", "newMessagesTextPlural", "", "newMessagesTextSingle", "onMessageDeleteHandler", "Lkotlin/Function1;", "Lio/getstream/chat/android/client/models/Message;", "onMessageEditHandler", "onMessageFlagHandler", "onMessageRetryHandler", "onSendGiphyHandler", "Lkotlin/Function2;", "Lcom/getstream/sdk/chat/enums/GiphyAction;", "onStartThreadHandler", "onStartThreadListener", "scrollButtonBehaviour", "Lcom/getstream/sdk/chat/view/MessageListView$ScrollButtonBehaviour;", "style", "Lcom/getstream/sdk/chat/view/MessageListViewStyle;", "unseenButtonEnabled", "getUnseenButtonEnabled", "()Z", "setUnseenButtonEnabled", "(Z)V", "configureAttributes", "attributeSet", "continueMessageAdd", "startThreadMode", "listItem", "entities", "", "oldSize", "displayNewMessage", "getLastSeenMessagePosition", "handleNewWrapper", "hideEmptyStateView", "hideLoadingView", "init", "attr", "initAdapter", "initEmptyStateView", "initLoadingView", "initRecyclerView", "initScrollButtonBehaviour", "initUnseenMessagesButton", "initUnseenMessagesView", "lastPosition", "parseAttr", "scrollToBottom", "scrollToMessage", "message", "scrolledBottom", "delta", "setAttachmentClickListener", "attachmentClickListener", "setAttachmentViewHolderFactory", "setBubbleHelper", "setEmptyStateView", "view", "layoutParams", "setEndRegionReachedHandler", "setLastMessageReadHandler", "setLoadingMore", "loadingMore", "setLoadingView", "setMessageClickListener", "messageClickListener", "setMessageDateFormatter", "setMessageListItemAdapter", "setMessageLongClickListener", "messageLongClickListener", "setMessageRetryListener", "messageRetryListener", "setMessageViewHolderFactory", "setNewMessagesBehaviour", "setOnMessageDeleteHandler", "setOnMessageEditHandler", "setOnMessageFlagHandler", "setOnMessageRetryHandler", "setOnSendGiphyHandler", "setOnStartThreadHandler", "setOnStartThreadListener", "setReactionViewClickListener", "reactionViewClickListener", "setReadStateClickListener", "readStateClickListener", "setScrollButtonBackground", "drawable", "Landroid/graphics/drawable/Drawable;", "setScrollButtonBackgroundResource", "backgroundRes", "setScrollButtonBehaviour", "setScrollButtonIcon", "setScrollButtonIconResource", "setUserClickListener", "userClickListener", "setViewHolderFactory", "showEmptyStateView", "showLoadingView", "updateLastSeen", "messageListItem", "AttachmentClickListener", "BubbleHelper", "DefaultScrollButtonBehaviour", "GiphySendListener", "HeaderAvatarGroupClickListener", "HeaderOptionsClickListener", "MessageClickListener", "MessageLongClickListener", "MessageLongClickListenerView", "MessageRetryListener", "NewMessagesBehaviour", "ReactionViewClickListener", "ReadStateClickListener", "ScrollButtonBehaviour", "UserClickListener", "stream-chat-android_release"})
public final class MessageListView
extends ConstraintLayout {
    private int firstVisiblePosition;
    private MessageListViewStyle style;
    private StreamMessageListViewBinding binding;
    private String newMessagesTextSingle;
    private String newMessagesTextPlural;
    private NewMessagesBehaviour newMessagesBehaviour;
    private ScrollButtonBehaviour scrollButtonBehaviour;
    private final StartStopBuffer<MessageListItemWrapper> buffer;
    private MessageListItemAdapter adapter;
    private LinearLayoutManager layoutManager;
    private View loadingView;
    private ViewGroup loadingViewContainer;
    private View emptyStateView;
    private ViewGroup emptyStateViewContainer;
    private MessageListItem lastSeenMessageInChannel;
    private MessageListItem lastSeenMessageInThread;
    private final Lazy defaultChildLayoutParams$delegate;
    private boolean unseenButtonEnabled;
    private boolean hasScrolledUp;
    private Function0<Unit> endRegionReachedHandler;
    private Function0<Unit> lastMessageReadHandler;
    private Function1<? super Message, Unit> onMessageEditHandler;
    private Function1<? super Message, Unit> onMessageDeleteHandler;
    private Function1<? super Message, Unit> onStartThreadHandler;
    private Function1<? super Message, Unit> onStartThreadListener;
    private Function1<? super Message, Unit> onMessageFlagHandler;
    private Function2<? super Message, ? super GiphyAction, Unit> onSendGiphyHandler;
    private Function1<? super Message, Unit> onMessageRetryHandler;
    private EndlessScrollListener loadMoreListener;
    private Channel channel;
    private User currentUser;
    private boolean lockScrollUp;
    private final TaggedLogger logger;
    private final MessageClickListener DEFAULT_MESSAGE_CLICK_LISTENER;
    private final MessageLongClickListener DEFAULT_MESSAGE_LONG_CLICK_LISTENER;
    private final MessageRetryListener DEFAULT_MESSAGE_RETRY_LISTENER;
    private final AttachmentClickListener DEFAULT_ATTACHMENT_CLICK_LISTENER;
    private final ReactionViewClickListener DEFAULT_REACTION_VIEW_CLICK_LISTENER;
    private final UserClickListener DEFAULT_USER_CLICK_LISTENER;
    private final ReadStateClickListener DEFAULT_READ_STATE_CLICK_LISTENER;
    private final GiphySendListener DEFAULT_GIPHY_SEND_LISTENER;
    private final ListenerContainer listenerContainer;
    private DateFormatter messageDateFormatter;
    private BubbleHelper bubbleHelper;
    private AttachmentViewHolderFactory attachmentViewHolderFactory;
    private MessageViewHolderFactory messageViewHolderFactory;

    private final FrameLayout.LayoutParams getDefaultChildLayoutParams() {
        Lazy lazy = this.defaultChildLayoutParams$delegate;
        MessageListView messageListView = this;
        Object var3_3 = null;
        boolean bl = false;
        return (FrameLayout.LayoutParams)lazy.getValue();
    }

    public final boolean getUnseenButtonEnabled() {
        return this.unseenButtonEnabled;
    }

    public final void setUnseenButtonEnabled(boolean bl) {
        this.unseenButtonEnabled = bl;
    }

    private final void init(Context context, AttributeSet attr) {
        Context $this$inflater$iv = context;
        boolean $i$f$getInflater = false;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)$this$inflater$iv);
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"LayoutInflater.from(this)");
        StreamMessageListViewBinding streamMessageListViewBinding = StreamMessageListViewBinding.inflate(layoutInflater, (ViewGroup)this, true);
        Intrinsics.checkNotNullExpressionValue((Object)streamMessageListViewBinding, (String)"StreamMessageListViewBin\u2026ext.inflater, this, true)");
        this.binding = streamMessageListViewBinding;
        this.initRecyclerView();
        this.initUnseenMessagesButton();
        this.initUnseenMessagesView();
        this.initLoadingView();
        this.initEmptyStateView();
        if (attr != null) {
            this.configureAttributes(attr);
        }
        this.initScrollButtonBehaviour();
        this.hasScrolledUp = false;
        this.buffer.subscribe((Function1)new Function1<MessageListItemWrapper, Unit>(this){

            public final void invoke(@NotNull MessageListItemWrapper p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                MessageListView.access$handleNewWrapper((MessageListView)((Object)this.receiver), p1);
            }
        });
        this.buffer.active();
    }

    private final void initLoadingView() {
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        ProgressBar progressBar = streamMessageListViewBinding.defaultLoadingView;
        Intrinsics.checkNotNullExpressionValue((Object)progressBar, (String)"binding.defaultLoadingView");
        this.loadingView = (View)progressBar;
        StreamMessageListViewBinding streamMessageListViewBinding2 = this.binding;
        if (streamMessageListViewBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        FrameLayout frameLayout = streamMessageListViewBinding2.loadingViewContainer;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.loadingViewContainer");
        this.loadingViewContainer = (ViewGroup)frameLayout;
    }

    private final void initEmptyStateView() {
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView = streamMessageListViewBinding.defaultEmptyStateView;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.defaultEmptyStateView");
        this.emptyStateView = (View)textView;
        StreamMessageListViewBinding streamMessageListViewBinding2 = this.binding;
        if (streamMessageListViewBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        FrameLayout frameLayout = streamMessageListViewBinding2.emptyStateViewContainer;
        Intrinsics.checkNotNullExpressionValue((Object)frameLayout, (String)"binding.emptyStateViewContainer");
        this.emptyStateViewContainer = (ViewGroup)frameLayout;
    }

    private final void initScrollButtonBehaviour() {
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        ConstraintLayout constraintLayout = streamMessageListViewBinding.scrollBottomBtn;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.scrollBottomBtn");
        ViewGroup viewGroup = (ViewGroup)constraintLayout;
        StreamMessageListViewBinding streamMessageListViewBinding2 = this.binding;
        if (streamMessageListViewBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView = streamMessageListViewBinding2.newMessagesTV;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.newMessagesTV");
        this.scrollButtonBehaviour = new DefaultScrollButtonBehaviour(viewGroup, textView, this.newMessagesTextSingle, this.newMessagesTextPlural, false, 16, null);
    }

    private final void initRecyclerView() {
        LinearLayoutManager $this$apply;
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
        boolean bl = false;
        boolean bl2 = false;
        LinearLayoutManager linearLayoutManager2 = linearLayoutManager;
        MessageListView messageListView = this;
        boolean bl3 = false;
        $this$apply.setStackFromEnd(true);
        Unit unit = Unit.INSTANCE;
        messageListView.layoutManager = linearLayoutManager;
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        linearLayoutManager = streamMessageListViewBinding.chatMessagesRV;
        bl = false;
        bl2 = false;
        $this$apply = linearLayoutManager;
        boolean bl4 = false;
        LinearLayoutManager linearLayoutManager3 = this.layoutManager;
        if (linearLayoutManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutManager");
        }
        $this$apply.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager3);
        $this$apply.setHasFixedSize(true);
        $this$apply.setItemViewCacheSize(20);
    }

    private final void initUnseenMessagesButton() {
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        streamMessageListViewBinding.scrollBottomBtn.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ MessageListView this$0;

            public final void onClick(View it) {
                MessageListView.access$getBinding$p((MessageListView)this.this$0).chatMessagesRV.scrollToPosition(MessageListView.access$lastPosition(this.this$0));
            }
            {
                this.this$0 = messageListView;
            }
        });
    }

    private final void initUnseenMessagesView() {
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView = streamMessageListViewBinding.newMessagesTV;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.newMessagesTV");
        textView.setVisibility(8);
    }

    private final void parseAttr(Context context, AttributeSet attrs) {
        this.style = new MessageListViewStyle(context, attrs);
    }

    private final void configureAttributes(AttributeSet attributeSet) {
        TypedArray tArray = this.getContext().obtainStyledAttributes(attributeSet, R.styleable.MessageListView);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int n = tArray.getInteger(R.styleable.MessageListView_streamLoadMoreThreshold, context.getResources().getInteger(R.integer.stream_load_more_threshold));
        boolean bl = false;
        boolean bl2 = false;
        int loadMoreThreshold = n;
        boolean bl3 = false;
        this.loadMoreListener = new EndlessScrollListener(loadMoreThreshold, (Function0)new Function0<Unit>(this){
            final /* synthetic */ MessageListView this$0;
            {
                this.this$0 = messageListView;
                super(0);
            }

            public final void invoke() {
                MessageListView.access$getEndRegionReachedHandler$p(this.this$0).invoke();
            }
        });
        int backgroundRes = tArray.getResourceId(R.styleable.MessageListView_streamScrollButtonBackground, R.drawable.stream_shape_round);
        this.unseenButtonEnabled = tArray.getBoolean(R.styleable.MessageListView_streamDefaultScrollButtonEnabled, true);
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        streamMessageListViewBinding.scrollBottomBtn.setBackgroundResource(backgroundRes);
        if (!this.unseenButtonEnabled) {
            StreamMessageListViewBinding streamMessageListViewBinding2 = this.binding;
            if (streamMessageListViewBinding2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            }
            ConstraintLayout constraintLayout = streamMessageListViewBinding2.scrollBottomBtn;
            Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.scrollBottomBtn");
            constraintLayout.setVisibility(8);
        }
        this.newMessagesTextSingle = tArray.getString(R.styleable.MessageListView_streamNewMessagesTextSingle);
        this.newMessagesTextPlural = tArray.getString(R.styleable.MessageListView_streamNewMessagesTextPlural);
        this.newMessagesBehaviour = NewMessagesBehaviour.Companion.parseValue(tArray.getInt(R.styleable.MessageListView_streamNewMessagesBehaviour, NewMessagesBehaviour.COUNT_UPDATE.getValue$stream_chat_android_release()));
        int arrowIconRes = tArray.getResourceId(R.styleable.MessageListView_streamButtonIcon, R.drawable.stream_bottom_arrow);
        ImageView scrollButtonArrow = (ImageView)this.findViewById(R.id.scrollIconIV);
        scrollButtonArrow.setImageResource(arrowIconRes);
        CharSequence charSequence = tArray.getText(R.styleable.MessageListView_streamMessagesEmptyStateLabelText);
        if (charSequence != null) {
            CharSequence charSequence2 = charSequence;
            boolean bl4 = false;
            boolean bl5 = false;
            CharSequence emptyStateText = charSequence2;
            boolean bl6 = false;
            View view = this.emptyStateView;
            if (view == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"emptyStateView");
            }
            View view2 = view;
            boolean bl7 = false;
            boolean bl8 = false;
            View it = view2;
            boolean bl9 = false;
            if (it instanceof TextView) {
                ((TextView)it).setText(emptyStateText);
            }
        }
        tArray.recycle();
    }

    private final int lastPosition() {
        MessageListItemAdapter messageListItemAdapter = this.adapter;
        if (messageListItemAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        return messageListItemAdapter.getItemCount() - 1;
    }

    public final void setLoadingMore(boolean loadingMore) {
        if (loadingMore) {
            EndlessScrollListener endlessScrollListener = this.loadMoreListener;
            if (endlessScrollListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadMoreListener");
            }
            endlessScrollListener.disablePagination();
        } else {
            EndlessScrollListener endlessScrollListener = this.loadMoreListener;
            if (endlessScrollListener == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"loadMoreListener");
            }
            endlessScrollListener.enablePagination();
        }
    }

    public final void scrollToMessage(@NotNull Message message) {
        block6: {
            MessageListItem targetListItem;
            Object v2;
            block5: {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                MessageListItemAdapter messageListItemAdapter = this.adapter;
                if (messageListItemAdapter == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                }
                List list = messageListItemAdapter.getCurrentList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"adapter.currentList");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MessageListItem it = (MessageListItem)element$iv;
                    boolean bl = false;
                    if (!(it instanceof MessageListItem.MessageItem && Intrinsics.areEqual((Object)((MessageListItem.MessageItem)it).getMessage().getId(), (Object)message.getId()))) continue;
                    v2 = element$iv;
                    break block5;
                }
                v2 = null;
            }
            MessageListItem messageListItem = targetListItem = (MessageListItem)v2;
            if (messageListItem == null) break block6;
            MessageListItem messageListItem2 = messageListItem;
            boolean bl = false;
            boolean bl2 = false;
            MessageListItem it = messageListItem2;
            boolean bl3 = false;
            MessageListItemAdapter messageListItemAdapter = this.adapter;
            if (messageListItemAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            }
            int position = messageListItemAdapter.getCurrentList().indexOf(it);
            StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
            if (streamMessageListViewBinding == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            }
            RecyclerView recyclerView = streamMessageListViewBinding.chatMessagesRV;
            Intrinsics.checkNotNullExpressionValue((Object)recyclerView, (String)"binding.chatMessagesRV");
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager != null) {
                layoutManager.scrollToPosition(position);
            }
        }
    }

    private final void setMessageListItemAdapter(MessageListItemAdapter adapter) {
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        RecyclerView recyclerView = streamMessageListViewBinding.chatMessagesRV;
        EndlessScrollListener endlessScrollListener = this.loadMoreListener;
        if (endlessScrollListener == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadMoreListener");
        }
        recyclerView.addOnScrollListener((RecyclerView.OnScrollListener)endlessScrollListener);
        StreamMessageListViewBinding streamMessageListViewBinding2 = this.binding;
        if (streamMessageListViewBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        streamMessageListViewBinding2.chatMessagesRV.addOnScrollListener(new RecyclerView.OnScrollListener(this, adapter){
            final /* synthetic */ MessageListView this$0;
            final /* synthetic */ MessageListItemAdapter $adapter;

            public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                List list = this.$adapter.getCurrentList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"adapter.currentList");
                List currentList = CollectionsKt.toList((Iterable)list);
                if (MessageListView.access$getLayoutManager$li(this.this$0) == null || currentList.isEmpty()) {
                    return;
                }
                int currentFirstVisible = MessageListView.access$getLayoutManager$p(this.this$0).findFirstVisibleItemPosition();
                int currentLastVisible = MessageListView.access$getLayoutManager$p(this.this$0).findLastVisibleItemPosition();
                MessageListView.access$setHasScrolledUp$p(this.this$0, currentLastVisible < MessageListView.access$lastPosition(this.this$0));
                MessageListView.access$setFirstVisiblePosition$p(this.this$0, currentFirstVisible);
                int n = MessageListView.access$getLastSeenMessagePosition(this.this$0);
                int n2 = 0;
                n = Math.max(currentLastVisible, n);
                n2 = currentList.size();
                boolean bl = false;
                int realLastVisibleMessage = Math.min(n, n2);
                MessageListView.access$updateLastSeen(this.this$0, (MessageListItem)currentList.get(realLastVisibleMessage));
                int unseenItems = this.$adapter.getItemCount() - 1 - realLastVisibleMessage;
                MessageListView.access$getScrollButtonBehaviour$p(this.this$0).onUnreadMessageCountChanged(unseenItems);
                if (MessageListView.access$getHasScrolledUp$p(this.this$0)) {
                    MessageListView.access$getScrollButtonBehaviour$p(this.this$0).userScrolledUp();
                } else {
                    MessageListView.access$getScrollButtonBehaviour$p(this.this$0).userScrolledToTheBottom();
                }
            }
            {
                this.this$0 = this$0;
                this.$adapter = $captured_local_variable$1;
            }
        });
        this.addOnLayoutChangeListener(new View.OnLayoutChangeListener(this){
            final /* synthetic */ MessageListView this$0;

            public final void onLayoutChange(View $noName_0, int $noName_1, int $noName_2, int $noName_3, int bottom, int $noName_5, int $noName_6, int $noName_7, int oldBottom) {
                if (bottom < oldBottom) {
                    MessageListView.access$setLockScrollUp$p(this.this$0, true);
                    this.this$0.postDelayed(new Runnable(this){
                        final /* synthetic */ setMessageListItemAdapter.2 this$0;

                        public final void run() {
                            MessageListView.access$setLockScrollUp$p(this.this$0.this$0, false);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }, 500L);
                }
            }
            {
                this.this$0 = messageListView;
            }
        });
        StreamMessageListViewBinding streamMessageListViewBinding3 = this.binding;
        if (streamMessageListViewBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        RecyclerView recyclerView2 = streamMessageListViewBinding3.chatMessagesRV;
        Intrinsics.checkNotNullExpressionValue((Object)recyclerView2, (String)"binding.chatMessagesRV");
        recyclerView2.setAdapter((RecyclerView.Adapter)adapter);
    }

    public final void init(@NotNull Channel channel, @NotNull User currentUser) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        this.currentUser = currentUser;
        this.channel = channel;
        this.initAdapter();
    }

    private final void initAdapter() {
        if (!(this.attachmentViewHolderFactory != null)) {
            this.attachmentViewHolderFactory = new AttachmentViewHolderFactory();
        }
        if (!(this.messageViewHolderFactory != null)) {
            this.messageViewHolderFactory = new MessageViewHolderFactory();
        }
        if (!(this.bubbleHelper != null)) {
            MessageListViewStyle messageListViewStyle = this.style;
            if (messageListViewStyle == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"style");
            }
            BubbleHelper bubbleHelper = DefaultBubbleHelper.initDefaultBubbleHelper(messageListViewStyle, this.getContext());
            Intrinsics.checkNotNullExpressionValue((Object)bubbleHelper, (String)"DefaultBubbleHelper.init\u2026bleHelper(style, context)");
            this.bubbleHelper = bubbleHelper;
        }
        if (!(this.messageDateFormatter != null)) {
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.messageDateFormatter = DateFormatter.Companion.from(context);
        }
        AttachmentViewHolderFactory attachmentViewHolderFactory = this.attachmentViewHolderFactory;
        if (attachmentViewHolderFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachmentViewHolderFactory");
        }
        attachmentViewHolderFactory.setListenerContainer(this.listenerContainer);
        AttachmentViewHolderFactory attachmentViewHolderFactory2 = this.attachmentViewHolderFactory;
        if (attachmentViewHolderFactory2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachmentViewHolderFactory");
        }
        BubbleHelper bubbleHelper = this.bubbleHelper;
        if (bubbleHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bubbleHelper");
        }
        attachmentViewHolderFactory2.setBubbleHelper(bubbleHelper);
        MessageViewHolderFactory messageViewHolderFactory = this.messageViewHolderFactory;
        if (messageViewHolderFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageViewHolderFactory");
        }
        messageViewHolderFactory.setListenerContainer(this.listenerContainer);
        MessageViewHolderFactory messageViewHolderFactory2 = this.messageViewHolderFactory;
        if (messageViewHolderFactory2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageViewHolderFactory");
        }
        AttachmentViewHolderFactory attachmentViewHolderFactory3 = this.attachmentViewHolderFactory;
        if (attachmentViewHolderFactory3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachmentViewHolderFactory");
        }
        messageViewHolderFactory2.setAttachmentViewHolderFactory(attachmentViewHolderFactory3);
        MessageViewHolderFactory messageViewHolderFactory3 = this.messageViewHolderFactory;
        if (messageViewHolderFactory3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageViewHolderFactory");
        }
        BubbleHelper bubbleHelper2 = this.bubbleHelper;
        if (bubbleHelper2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bubbleHelper");
        }
        messageViewHolderFactory3.setBubbleHelper(bubbleHelper2);
        MessageViewHolderFactory messageViewHolderFactory4 = this.messageViewHolderFactory;
        if (messageViewHolderFactory4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageViewHolderFactory");
        }
        DateFormatter dateFormatter = this.messageDateFormatter;
        if (dateFormatter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageDateFormatter");
        }
        messageViewHolderFactory4.setMessageDateFormatter(dateFormatter);
        Channel channel = this.channel;
        if (channel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
        }
        MessageViewHolderFactory messageViewHolderFactory5 = this.messageViewHolderFactory;
        if (messageViewHolderFactory5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageViewHolderFactory");
        }
        MessageListViewStyle messageListViewStyle = this.style;
        if (messageListViewStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
        }
        MessageListItemAdapter messageListItemAdapter = this.adapter = new MessageListItemAdapter(channel, messageViewHolderFactory5, messageListViewStyle);
        if (messageListItemAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        messageListItemAdapter.setHasStableIds(true);
        MessageListItemAdapter messageListItemAdapter2 = this.adapter;
        if (messageListItemAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        this.setMessageListItemAdapter(messageListItemAdapter2);
    }

    public final void setLoadingView(@NotNull View view, @NotNull FrameLayout.LayoutParams layoutParams) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"layoutParams");
        ViewGroup viewGroup = this.loadingViewContainer;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadingViewContainer");
        }
        View view2 = this.loadingView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadingView");
        }
        viewGroup.removeView(view2);
        this.loadingView = view;
        ViewGroup viewGroup2 = this.loadingViewContainer;
        if (viewGroup2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadingViewContainer");
        }
        View view3 = this.loadingView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadingView");
        }
        viewGroup2.addView(view3, (ViewGroup.LayoutParams)layoutParams);
    }

    public static /* synthetic */ void setLoadingView$default(MessageListView messageListView, View view, FrameLayout.LayoutParams layoutParams, int n, Object object) {
        if ((n & 2) != 0) {
            layoutParams = messageListView.getDefaultChildLayoutParams();
        }
        messageListView.setLoadingView(view, layoutParams);
    }

    public final void showLoadingView() {
        ViewGroup viewGroup = this.loadingViewContainer;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadingViewContainer");
        }
        boolean value$iv = true;
        View $this$isVisible$iv = (View)viewGroup;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
    }

    public final void hideLoadingView() {
        ViewGroup viewGroup = this.loadingViewContainer;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadingViewContainer");
        }
        boolean value$iv = false;
        View $this$isVisible$iv = (View)viewGroup;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
    }

    public final void setEmptyStateView(@NotNull View view, @NotNull FrameLayout.LayoutParams layoutParams) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)layoutParams, (String)"layoutParams");
        ViewGroup viewGroup = this.emptyStateViewContainer;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emptyStateViewContainer");
        }
        View view2 = this.emptyStateView;
        if (view2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emptyStateView");
        }
        viewGroup.removeView(view2);
        this.emptyStateView = view;
        ViewGroup viewGroup2 = this.emptyStateViewContainer;
        if (viewGroup2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emptyStateViewContainer");
        }
        View view3 = this.emptyStateView;
        if (view3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emptyStateView");
        }
        viewGroup2.addView(view3, (ViewGroup.LayoutParams)layoutParams);
    }

    public static /* synthetic */ void setEmptyStateView$default(MessageListView messageListView, View view, FrameLayout.LayoutParams layoutParams, int n, Object object) {
        if ((n & 2) != 0) {
            layoutParams = messageListView.getDefaultChildLayoutParams();
        }
        messageListView.setEmptyStateView(view, layoutParams);
    }

    public final void showEmptyStateView() {
        ViewGroup viewGroup = this.emptyStateViewContainer;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emptyStateViewContainer");
        }
        boolean value$iv = true;
        View $this$isVisible$iv = (View)viewGroup;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(0);
    }

    public final void hideEmptyStateView() {
        ViewGroup viewGroup = this.emptyStateViewContainer;
        if (viewGroup == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"emptyStateViewContainer");
        }
        boolean value$iv = false;
        View $this$isVisible$iv = (View)viewGroup;
        boolean $i$f$setVisible = false;
        $this$isVisible$iv.setVisibility(8);
    }

    public final void setScrollButtonBehaviour(@NotNull ScrollButtonBehaviour scrollButtonBehaviour) {
        Intrinsics.checkNotNullParameter((Object)scrollButtonBehaviour, (String)"scrollButtonBehaviour");
        this.scrollButtonBehaviour = scrollButtonBehaviour;
    }

    public final void setNewMessagesBehaviour(@NotNull NewMessagesBehaviour newMessagesBehaviour) {
        Intrinsics.checkNotNullParameter((Object)((Object)newMessagesBehaviour), (String)"newMessagesBehaviour");
        this.newMessagesBehaviour = newMessagesBehaviour;
    }

    public final void setScrollButtonBackgroundResource(@DrawableRes int backgroundRes) {
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        streamMessageListViewBinding.scrollBottomBtn.setBackgroundResource(backgroundRes);
    }

    public final void setScrollButtonBackground(@Nullable Drawable drawable2) {
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        ConstraintLayout constraintLayout = streamMessageListViewBinding.scrollBottomBtn;
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"binding.scrollBottomBtn");
        constraintLayout.setBackground(drawable2);
    }

    public final void setScrollButtonIconResource(@DrawableRes int backgroundRes) {
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        streamMessageListViewBinding.scrollIconIV.setImageResource(backgroundRes);
    }

    public final void setScrollButtonIcon(@Nullable Drawable drawable2) {
        StreamMessageListViewBinding streamMessageListViewBinding = this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        streamMessageListViewBinding.scrollIconIV.setImageDrawable(drawable2);
    }

    public final void setAttachmentViewHolderFactory(@NotNull AttachmentViewHolderFactory attachmentViewHolderFactory) {
        Intrinsics.checkNotNullParameter((Object)attachmentViewHolderFactory, (String)"attachmentViewHolderFactory");
        boolean bl = !(this.adapter != null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Adapter was already initialized, please set AttachmentViewHolderFactory first";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.attachmentViewHolderFactory = attachmentViewHolderFactory;
    }

    public final void setMessageViewHolderFactory(@NotNull MessageViewHolderFactory messageViewHolderFactory) {
        Intrinsics.checkNotNullParameter((Object)messageViewHolderFactory, (String)"messageViewHolderFactory");
        boolean bl = !(this.adapter != null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Adapter was already initialized, please set MessageViewHolderFactory first";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.messageViewHolderFactory = messageViewHolderFactory;
    }

    @Deprecated(message="Use the more explicit setMessageViewHolderFactory method instead.", level=DeprecationLevel.WARNING, replaceWith=@ReplaceWith(imports={}, expression="setMessageViewHolderFactory(messageViewHolderFactory)"))
    public final void setViewHolderFactory(@NotNull MessageViewHolderFactory messageViewHolderFactory) {
        Intrinsics.checkNotNullParameter((Object)messageViewHolderFactory, (String)"messageViewHolderFactory");
        this.setMessageViewHolderFactory(messageViewHolderFactory);
    }

    public final void setBubbleHelper(@NotNull BubbleHelper bubbleHelper) {
        Intrinsics.checkNotNullParameter((Object)bubbleHelper, (String)"bubbleHelper");
        boolean bl = !(this.adapter != null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Adapter was already initialized; please set BubbleHelper first";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.bubbleHelper = bubbleHelper;
    }

    public final void setMessageDateFormatter(@NotNull DateFormatter messageDateFormatter) {
        Intrinsics.checkNotNullParameter((Object)messageDateFormatter, (String)"messageDateFormatter");
        boolean bl = !(this.adapter != null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Adapter was already initialized; please set DateFormatter first";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        this.messageDateFormatter = messageDateFormatter;
    }

    public final void displayNewMessage(@NotNull MessageListItemWrapper listItem) {
        Intrinsics.checkNotNullParameter((Object)listItem, (String)"listItem");
        this.buffer.enqueueData((Object)listItem);
    }

    public final void scrollToBottom() {
        LinearLayoutManager linearLayoutManager = this.layoutManager;
        if (linearLayoutManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutManager");
        }
        MessageListItemAdapter messageListItemAdapter = this.adapter;
        if (messageListItemAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        linearLayoutManager.scrollToPosition(messageListItemAdapter.getItemCount() - 1);
    }

    private final void handleNewWrapper(MessageListItemWrapper listItem) {
        this.buffer.hold();
        List entities = listItem.getItems();
        MessageListItemAdapter messageListItemAdapter = this.adapter;
        if (messageListItemAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        boolean startThreadMode = !messageListItemAdapter.isThread() && listItem.isThread();
        MessageListItemAdapter messageListItemAdapter2 = this.adapter;
        if (messageListItemAdapter2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        messageListItemAdapter2.setThread(listItem.isThread());
        MessageListItemAdapter messageListItemAdapter3 = this.adapter;
        if (messageListItemAdapter3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        int oldSize = messageListItemAdapter3.getItemCount();
        MessageListItemAdapter messageListItemAdapter4 = this.adapter;
        if (messageListItemAdapter4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        messageListItemAdapter4.submitList(entities, new Runnable(this, startThreadMode, listItem, entities, oldSize){
            final /* synthetic */ MessageListView this$0;
            final /* synthetic */ boolean $startThreadMode;
            final /* synthetic */ MessageListItemWrapper $listItem;
            final /* synthetic */ List $entities;
            final /* synthetic */ int $oldSize;

            public final void run() {
                MessageListView.access$continueMessageAdd(this.this$0, this.$startThreadMode, this.$listItem, this.$entities, this.$oldSize);
            }
            {
                this.this$0 = messageListView;
                this.$startThreadMode = bl;
                this.$listItem = messageListItemWrapper;
                this.$entities = list;
                this.$oldSize = n;
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    private final void continueMessageAdd(boolean startThreadMode, MessageListItemWrapper listItem, List<? extends MessageListItem> entities, int oldSize) {
        block20: {
            block19: {
                v0 = this.adapter;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                }
                newSize = v0.getItemCount();
                sizeGrewBy = newSize - oldSize;
                if (startThreadMode) {
                    v1 = this.layoutManager;
                    if (v1 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"layoutManager");
                    }
                    v1.scrollToPosition(0);
                    this.buffer.active();
                    return;
                }
                if (listItem.isTyping() && this.scrolledBottom(sizeGrewBy + 2) && !this.hasScrolledUp) {
                    v2 = this.adapter;
                    if (v2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                    }
                    newPosition = v2.getItemCount() - 1;
                    v3 = this.layoutManager;
                    if (v3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"layoutManager");
                    }
                    v3.scrollToPosition(newPosition);
                    this.buffer.active();
                    return;
                }
                if (!listItem.getHasNewMessages()) {
                    this.logger.logI("no Scroll no new message");
                    this.buffer.active();
                    return;
                }
                if (oldSize != 0 || newSize == 0) break block19;
                v4 = this.adapter;
                if (v4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                }
                newPosition = v4.getItemCount() - 1;
                v5 = this.layoutManager;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutManager");
                }
                v5.scrollToPosition(newPosition);
                var8_10 = StringCompanionObject.INSTANCE;
                var9_12 = "Scroll: First load scrolling down to bottom %d";
                var10_15 = new Object[]{newPosition};
                var11_18 = false;
                v6 = String.format(var9_12, Arrays.copyOf(var10_15, var10_15.length));
                Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"java.lang.String.format(format, *args)");
                this.logger.logI(v6);
                this.lastMessageReadHandler.invoke();
                break block20;
            }
            if (newSize == 0) {
                this.buffer.active();
                return;
            }
            v7 = this.adapter;
            if (v7 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            }
            newPosition = v7.getItemCount() - 1;
            v8 = this.layoutManager;
            if (v8 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"layoutManager");
            }
            layoutSize = v8.getItemCount();
            var9_13 = StringCompanionObject.INSTANCE;
            var10_16 = "Scroll: Moving down to %d, layout has %d elements";
            var11_19 = new Object[]{newPosition, layoutSize};
            var12_20 = false;
            v9 = String.format(var10_16, Arrays.copyOf(var11_19, var11_19.length));
            Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"java.lang.String.format(format, *args)");
            this.logger.logI(v9);
            v10 = CollectionsKt.lastOrNull(entities);
            if (!(v10 instanceof MessageListItem.MessageItem)) {
                v10 = null;
            }
            v11 = (MessageListItem.MessageItem)v10;
            v12 = isMine = v11 != null ? v11.isMine() : false;
            if (isMine || !this.hasScrolledUp) ** GOTO lbl-1000
            v13 = this.newMessagesBehaviour;
            if (v13 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"newMessagesBehaviour");
            }
            if (v13 == NewMessagesBehaviour.SCROLL_TO_BOTTOM) lbl-1000:
            // 2 sources

            {
                v14 = this.layoutManager;
                if (v14 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"layoutManager");
                }
                v15 = this.adapter;
                if (v15 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
                }
                v14.scrollToPosition(v15.getItemCount() - 1);
            } else {
                unseenItems = newSize - this.getLastSeenMessagePosition() - 1;
                v16 = this.scrollButtonBehaviour;
                if (v16 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"scrollButtonBehaviour");
                }
                v16.onUnreadMessageCountChanged(unseenItems);
            }
            this.lastMessageReadHandler.invoke();
        }
        this.buffer.active();
    }

    private final boolean scrolledBottom(int delta) {
        return this.getLastSeenMessagePosition() + delta >= this.lastPosition();
    }

    private final int getLastSeenMessagePosition() {
        int n;
        block7: {
            MessageListItem messageListItem;
            boolean bl;
            MessageListItemAdapter messageListItemAdapter = this.adapter;
            if (messageListItemAdapter == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            }
            if (bl = messageListItemAdapter.isThread()) {
                messageListItem = this.lastSeenMessageInThread;
            } else if (!bl) {
                messageListItem = this.lastSeenMessageInChannel;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Long lastMessageId = messageListItem != null ? Long.valueOf(messageListItem.getStableId()) : null;
            MessageListItemAdapter messageListItemAdapter2 = this.adapter;
            if (messageListItemAdapter2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
            }
            List list = messageListItemAdapter2.getCurrentList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"adapter.currentList");
            List $this$indexOfLast$iv = list;
            boolean $i$f$indexOfLast = false;
            ListIterator iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                MessageListItem message = (MessageListItem)iterator$iv.previous();
                boolean bl2 = false;
                MessageListItem messageListItem2 = message;
                if (!Intrinsics.areEqual((Object)(messageListItem2 != null ? Long.valueOf(messageListItem2.getStableId()) : null), (Object)lastMessageId)) continue;
                n = iterator$iv.nextIndex();
                break block7;
            }
            n = -1;
        }
        return n;
    }

    private final void updateLastSeen(MessageListItem messageListItem) {
        Unit unit;
        boolean bl;
        MessageListItemAdapter messageListItemAdapter = this.adapter;
        if (messageListItemAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        if (bl = messageListItemAdapter.isThread()) {
            this.lastSeenMessageInThread = messageListItem;
            unit = Unit.INSTANCE;
        } else if (!bl) {
            this.lastSeenMessageInChannel = messageListItem;
            unit = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Unit $this$exhaustive$iv = unit;
        boolean $i$f$getExhaustive = false;
    }

    public final void setMessageClickListener(@Nullable MessageClickListener messageClickListener2) {
        MessageClickListener messageClickListener3 = messageClickListener2;
        if (messageClickListener3 == null) {
            messageClickListener3 = this.DEFAULT_MESSAGE_CLICK_LISTENER;
        }
        this.listenerContainer.setMessageClickListener(messageClickListener3);
    }

    public final void setMessageLongClickListener(@Nullable MessageLongClickListener messageLongClickListener2) {
        MessageLongClickListener messageLongClickListener3 = messageLongClickListener2;
        if (messageLongClickListener3 == null) {
            messageLongClickListener3 = this.DEFAULT_MESSAGE_LONG_CLICK_LISTENER;
        }
        this.listenerContainer.setMessageLongClickListener(messageLongClickListener3);
    }

    public final void setMessageRetryListener(@Nullable MessageRetryListener messageRetryListener2) {
        MessageRetryListener messageRetryListener3 = messageRetryListener2;
        if (messageRetryListener3 == null) {
            messageRetryListener3 = this.DEFAULT_MESSAGE_RETRY_LISTENER;
        }
        this.listenerContainer.setMessageRetryListener(messageRetryListener3);
    }

    public final void setAttachmentClickListener(@Nullable AttachmentClickListener attachmentClickListener2) {
        AttachmentClickListener attachmentClickListener3 = attachmentClickListener2;
        if (attachmentClickListener3 == null) {
            attachmentClickListener3 = this.DEFAULT_ATTACHMENT_CLICK_LISTENER;
        }
        this.listenerContainer.setAttachmentClickListener(attachmentClickListener3);
    }

    public final void setReactionViewClickListener(@Nullable ReactionViewClickListener reactionViewClickListener2) {
        ReactionViewClickListener reactionViewClickListener3 = reactionViewClickListener2;
        if (reactionViewClickListener3 == null) {
            reactionViewClickListener3 = this.DEFAULT_REACTION_VIEW_CLICK_LISTENER;
        }
        this.listenerContainer.setReactionViewClickListener(reactionViewClickListener3);
    }

    public final void setUserClickListener(@Nullable UserClickListener userClickListener2) {
        UserClickListener userClickListener3 = userClickListener2;
        if (userClickListener3 == null) {
            userClickListener3 = this.DEFAULT_USER_CLICK_LISTENER;
        }
        this.listenerContainer.setUserClickListener(userClickListener3);
    }

    public final void setReadStateClickListener(@Nullable ReadStateClickListener readStateClickListener2) {
        ReadStateClickListener readStateClickListener3 = readStateClickListener2;
        if (readStateClickListener3 == null) {
            readStateClickListener3 = this.DEFAULT_READ_STATE_CLICK_LISTENER;
        }
        this.listenerContainer.setReadStateClickListener(readStateClickListener3);
    }

    public final void setEndRegionReachedHandler(@NotNull Function0<Unit> endRegionReachedHandler2) {
        Intrinsics.checkNotNullParameter(endRegionReachedHandler2, (String)"endRegionReachedHandler");
        this.endRegionReachedHandler = endRegionReachedHandler2;
    }

    public final void setLastMessageReadHandler(@NotNull Function0<Unit> lastMessageReadHandler2) {
        Intrinsics.checkNotNullParameter(lastMessageReadHandler2, (String)"lastMessageReadHandler");
        this.lastMessageReadHandler = lastMessageReadHandler2;
    }

    public final void setOnMessageEditHandler(@NotNull Function1<? super Message, Unit> onMessageEditHandler2) {
        Intrinsics.checkNotNullParameter(onMessageEditHandler2, (String)"onMessageEditHandler");
        this.onMessageEditHandler = onMessageEditHandler2;
    }

    public final void setOnMessageDeleteHandler(@NotNull Function1<? super Message, Unit> onMessageDeleteHandler2) {
        Intrinsics.checkNotNullParameter(onMessageDeleteHandler2, (String)"onMessageDeleteHandler");
        this.onMessageDeleteHandler = onMessageDeleteHandler2;
    }

    public final void setOnStartThreadHandler(@NotNull Function1<? super Message, Unit> onStartThreadHandler2) {
        Intrinsics.checkNotNullParameter(onStartThreadHandler2, (String)"onStartThreadHandler");
        this.onStartThreadHandler = onStartThreadHandler2;
    }

    public final void setOnMessageFlagHandler(@NotNull Function1<? super Message, Unit> onMessageFlagHandler2) {
        Intrinsics.checkNotNullParameter(onMessageFlagHandler2, (String)"onMessageFlagHandler");
        this.onMessageFlagHandler = onMessageFlagHandler2;
    }

    public final void setOnSendGiphyHandler(@NotNull Function2<? super Message, ? super GiphyAction, Unit> onSendGiphyHandler2) {
        Intrinsics.checkNotNullParameter(onSendGiphyHandler2, (String)"onSendGiphyHandler");
        this.onSendGiphyHandler = onSendGiphyHandler2;
    }

    public final void setOnMessageRetryHandler(@NotNull Function1<? super Message, Unit> onMessageRetryHandler2) {
        Intrinsics.checkNotNullParameter(onMessageRetryHandler2, (String)"onMessageRetryHandler");
        this.onMessageRetryHandler = onMessageRetryHandler2;
    }

    public final void setOnStartThreadListener(@NotNull Function1<? super Message, Unit> onStartThreadListener2) {
        Intrinsics.checkNotNullParameter(onStartThreadListener2, (String)"onStartThreadListener");
        this.onStartThreadListener = onStartThreadListener2;
    }

    public MessageListView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.buffer = new StartStopBuffer();
        this.defaultChildLayoutParams$delegate = LazyKt.lazy((Function0)defaultChildLayoutParams.2.INSTANCE);
        this.unseenButtonEnabled = true;
        this.endRegionReachedHandler = endRegionReachedHandler.1.INSTANCE;
        this.lastMessageReadHandler = lastMessageReadHandler.1.INSTANCE;
        this.onMessageEditHandler = onMessageEditHandler.1.INSTANCE;
        this.onMessageDeleteHandler = onMessageDeleteHandler.1.INSTANCE;
        this.onStartThreadHandler = onStartThreadHandler.1.INSTANCE;
        this.onStartThreadListener = onStartThreadListener.1.INSTANCE;
        this.onMessageFlagHandler = onMessageFlagHandler.1.INSTANCE;
        this.onSendGiphyHandler = onSendGiphyHandler.1.INSTANCE;
        this.onMessageRetryHandler = onMessageRetryHandler.1.INSTANCE;
        this.lockScrollUp = true;
        this.logger = ChatLogger.Companion.get((Object)"MessageListView");
        this.DEFAULT_MESSAGE_CLICK_LISTENER = new MessageClickListener(this){
            final /* synthetic */ MessageListView this$0;

            public final void onMessageClick(@NotNull Message message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                if (message.getReplyCount() > 0) {
                    MessageListView.access$getOnStartThreadHandler$p(this.this$0).invoke((Object)message);
                    MessageListView.access$getOnStartThreadListener$p(this.this$0).invoke((Object)message);
                }
            }
            {
                this.this$0 = messageListView;
            }
        };
        this.DEFAULT_MESSAGE_LONG_CLICK_LISTENER = new MessageLongClickListener(this){
            final /* synthetic */ MessageListView this$0;

            public final void onMessageLongClick(@NotNull Message message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Context context = this.this$0.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                new MessageMoreActionDialog(context, MessageListView.access$getChannel$p(this.this$0), message, MessageListView.access$getCurrentUser$p(this.this$0), MessageListView.access$getStyle$p(this.this$0), (Function1<? super Message, Unit>)MessageListView.access$getOnMessageEditHandler$p(this.this$0), (Function1<? super Message, Unit>)MessageListView.access$getOnMessageDeleteHandler$p(this.this$0), (Function1<? super Message, Unit>)((Function1)new Function1<Message, Unit>(this){
                    final /* synthetic */ DEFAULT_MESSAGE_LONG_CLICK_LISTENER.1 this$0;

                    public final void invoke(@NotNull Message m) {
                        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
                        MessageListView.access$getOnStartThreadHandler$p(this.this$0.this$0).invoke((Object)m);
                        MessageListView.access$getOnStartThreadListener$p(this.this$0.this$0).invoke((Object)m);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), (Function1<? super Message, Unit>)MessageListView.access$getOnMessageFlagHandler$p(this.this$0)).show();
            }
            {
                this.this$0 = messageListView;
            }
        };
        this.DEFAULT_MESSAGE_RETRY_LISTENER = new MessageRetryListener(this){
            final /* synthetic */ MessageListView this$0;

            public final void onRetryMessage(@NotNull Message message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                MessageListView.access$getOnMessageRetryHandler$p(this.this$0).invoke((Object)message);
            }
            {
                this.this$0 = messageListView;
            }
        };
        this.DEFAULT_ATTACHMENT_CLICK_LISTENER = new AttachmentClickListener(this){
            final /* synthetic */ MessageListView this$0;

            public final void onAttachmentClick(@NotNull Message message, @NotNull Attachment attachment) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
                ChatNavigator chatNavigator = ChatUI.Companion.instance().getNavigator();
                Context context = this.this$0.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                chatNavigator.navigate((ChatDestination)new AttachmentDestination(message, attachment, context));
            }
            {
                this.this$0 = messageListView;
            }
        };
        this.DEFAULT_REACTION_VIEW_CLICK_LISTENER = new ReactionViewClickListener(this){
            final /* synthetic */ MessageListView this$0;

            public final void onReactionViewClick(@NotNull Message message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Context context = this.this$0.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
                new MessageMoreActionDialog(context, MessageListView.access$getChannel$p(this.this$0), message, MessageListView.access$getCurrentUser$p(this.this$0), MessageListView.access$getStyle$p(this.this$0), (Function1<? super Message, Unit>)MessageListView.access$getOnMessageEditHandler$p(this.this$0), (Function1<? super Message, Unit>)MessageListView.access$getOnMessageDeleteHandler$p(this.this$0), (Function1<? super Message, Unit>)MessageListView.access$getOnStartThreadHandler$p(this.this$0), (Function1<? super Message, Unit>)MessageListView.access$getOnMessageFlagHandler$p(this.this$0)).show();
            }
            {
                this.this$0 = messageListView;
            }
        };
        this.DEFAULT_USER_CLICK_LISTENER = DEFAULT_USER_CLICK_LISTENER.1.INSTANCE;
        this.DEFAULT_READ_STATE_CLICK_LISTENER = new ReadStateClickListener(this){
            final /* synthetic */ MessageListView this$0;

            public final void onReadStateClick(@NotNull List<ChannelUserRead> reads) {
                Intrinsics.checkNotNullParameter(reads, (String)"reads");
                new ReadUsersDialog(this.this$0.getContext()).setReads(reads).setStyle(MessageListView.access$getStyle$p(this.this$0)).show();
            }
            {
                this.this$0 = messageListView;
            }
        };
        this.DEFAULT_GIPHY_SEND_LISTENER = new GiphySendListener(this){
            final /* synthetic */ MessageListView this$0;

            public final void onGiphySend(@NotNull Message message, @NotNull GiphyAction action) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                MessageListView.access$getOnSendGiphyHandler$p(this.this$0).invoke((Object)message, (Object)action);
            }
            {
                this.this$0 = messageListView;
            }
        };
        this.listenerContainer = new ListenerContainerImpl(this.DEFAULT_MESSAGE_CLICK_LISTENER, this.DEFAULT_MESSAGE_LONG_CLICK_LISTENER, this.DEFAULT_MESSAGE_RETRY_LISTENER, this.DEFAULT_ATTACHMENT_CLICK_LISTENER, this.DEFAULT_REACTION_VIEW_CLICK_LISTENER, this.DEFAULT_USER_CLICK_LISTENER, this.DEFAULT_READ_STATE_CLICK_LISTENER, this.DEFAULT_GIPHY_SEND_LISTENER);
        this.init(context, null);
    }

    public MessageListView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        this.buffer = new StartStopBuffer();
        this.defaultChildLayoutParams$delegate = LazyKt.lazy((Function0)defaultChildLayoutParams.2.INSTANCE);
        this.unseenButtonEnabled = true;
        this.endRegionReachedHandler = endRegionReachedHandler.1.INSTANCE;
        this.lastMessageReadHandler = lastMessageReadHandler.1.INSTANCE;
        this.onMessageEditHandler = onMessageEditHandler.1.INSTANCE;
        this.onMessageDeleteHandler = onMessageDeleteHandler.1.INSTANCE;
        this.onStartThreadHandler = onStartThreadHandler.1.INSTANCE;
        this.onStartThreadListener = onStartThreadListener.1.INSTANCE;
        this.onMessageFlagHandler = onMessageFlagHandler.1.INSTANCE;
        this.onSendGiphyHandler = onSendGiphyHandler.1.INSTANCE;
        this.onMessageRetryHandler = onMessageRetryHandler.1.INSTANCE;
        this.lockScrollUp = true;
        this.logger = ChatLogger.Companion.get((Object)"MessageListView");
        this.DEFAULT_MESSAGE_CLICK_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_MESSAGE_LONG_CLICK_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_MESSAGE_RETRY_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_ATTACHMENT_CLICK_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_REACTION_VIEW_CLICK_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_USER_CLICK_LISTENER = DEFAULT_USER_CLICK_LISTENER.1.INSTANCE;
        this.DEFAULT_READ_STATE_CLICK_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_GIPHY_SEND_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.listenerContainer = new ListenerContainerImpl(this.DEFAULT_MESSAGE_CLICK_LISTENER, this.DEFAULT_MESSAGE_LONG_CLICK_LISTENER, this.DEFAULT_MESSAGE_RETRY_LISTENER, this.DEFAULT_ATTACHMENT_CLICK_LISTENER, this.DEFAULT_REACTION_VIEW_CLICK_LISTENER, this.DEFAULT_USER_CLICK_LISTENER, this.DEFAULT_READ_STATE_CLICK_LISTENER, this.DEFAULT_GIPHY_SEND_LISTENER);
        this.parseAttr(context, attrs);
        this.init(context, attrs);
    }

    public MessageListView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyle);
        this.buffer = new StartStopBuffer();
        this.defaultChildLayoutParams$delegate = LazyKt.lazy((Function0)defaultChildLayoutParams.2.INSTANCE);
        this.unseenButtonEnabled = true;
        this.endRegionReachedHandler = endRegionReachedHandler.1.INSTANCE;
        this.lastMessageReadHandler = lastMessageReadHandler.1.INSTANCE;
        this.onMessageEditHandler = onMessageEditHandler.1.INSTANCE;
        this.onMessageDeleteHandler = onMessageDeleteHandler.1.INSTANCE;
        this.onStartThreadHandler = onStartThreadHandler.1.INSTANCE;
        this.onStartThreadListener = onStartThreadListener.1.INSTANCE;
        this.onMessageFlagHandler = onMessageFlagHandler.1.INSTANCE;
        this.onSendGiphyHandler = onSendGiphyHandler.1.INSTANCE;
        this.onMessageRetryHandler = onMessageRetryHandler.1.INSTANCE;
        this.lockScrollUp = true;
        this.logger = ChatLogger.Companion.get((Object)"MessageListView");
        this.DEFAULT_MESSAGE_CLICK_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_MESSAGE_LONG_CLICK_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_MESSAGE_RETRY_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_ATTACHMENT_CLICK_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_REACTION_VIEW_CLICK_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_USER_CLICK_LISTENER = DEFAULT_USER_CLICK_LISTENER.1.INSTANCE;
        this.DEFAULT_READ_STATE_CLICK_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.DEFAULT_GIPHY_SEND_LISTENER = new /* invalid duplicate definition of identical inner class */;
        this.listenerContainer = new ListenerContainerImpl(this.DEFAULT_MESSAGE_CLICK_LISTENER, this.DEFAULT_MESSAGE_LONG_CLICK_LISTENER, this.DEFAULT_MESSAGE_RETRY_LISTENER, this.DEFAULT_ATTACHMENT_CLICK_LISTENER, this.DEFAULT_REACTION_VIEW_CLICK_LISTENER, this.DEFAULT_USER_CLICK_LISTENER, this.DEFAULT_READ_STATE_CLICK_LISTENER, this.DEFAULT_GIPHY_SEND_LISTENER);
        this.parseAttr(context, attrs);
        this.init(context, attrs);
    }

    public static final /* synthetic */ void access$handleNewWrapper(MessageListView $this, MessageListItemWrapper listItem) {
        $this.handleNewWrapper(listItem);
    }

    public static final /* synthetic */ StreamMessageListViewBinding access$getBinding$p(MessageListView $this) {
        StreamMessageListViewBinding streamMessageListViewBinding = $this.binding;
        if (streamMessageListViewBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        return streamMessageListViewBinding;
    }

    public static final /* synthetic */ void access$setBinding$p(MessageListView $this, StreamMessageListViewBinding streamMessageListViewBinding) {
        $this.binding = streamMessageListViewBinding;
    }

    public static final /* synthetic */ int access$lastPosition(MessageListView $this) {
        return $this.lastPosition();
    }

    public static final /* synthetic */ Function0 access$getEndRegionReachedHandler$p(MessageListView $this) {
        return $this.endRegionReachedHandler;
    }

    public static final /* synthetic */ void access$setEndRegionReachedHandler$p(MessageListView $this, Function0 function0) {
        $this.endRegionReachedHandler = function0;
    }

    public static final /* synthetic */ LinearLayoutManager access$getLayoutManager$p(MessageListView $this) {
        LinearLayoutManager linearLayoutManager = $this.layoutManager;
        if (linearLayoutManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"layoutManager");
        }
        return linearLayoutManager;
    }

    public static final /* synthetic */ void access$setLayoutManager$p(MessageListView $this, LinearLayoutManager linearLayoutManager) {
        $this.layoutManager = linearLayoutManager;
    }

    public static final /* synthetic */ LinearLayoutManager access$getLayoutManager$li(MessageListView $this) {
        return $this.layoutManager;
    }

    public static final /* synthetic */ void access$setLayoutManager$li(MessageListView $this, LinearLayoutManager linearLayoutManager) {
        $this.layoutManager = linearLayoutManager;
    }

    public static final /* synthetic */ boolean access$getHasScrolledUp$p(MessageListView $this) {
        return $this.hasScrolledUp;
    }

    public static final /* synthetic */ void access$setHasScrolledUp$p(MessageListView $this, boolean bl) {
        $this.hasScrolledUp = bl;
    }

    public static final /* synthetic */ int access$getFirstVisiblePosition$p(MessageListView $this) {
        return $this.firstVisiblePosition;
    }

    public static final /* synthetic */ void access$setFirstVisiblePosition$p(MessageListView $this, int n) {
        $this.firstVisiblePosition = n;
    }

    public static final /* synthetic */ int access$getLastSeenMessagePosition(MessageListView $this) {
        return $this.getLastSeenMessagePosition();
    }

    public static final /* synthetic */ void access$updateLastSeen(MessageListView $this, MessageListItem messageListItem) {
        $this.updateLastSeen(messageListItem);
    }

    public static final /* synthetic */ ScrollButtonBehaviour access$getScrollButtonBehaviour$p(MessageListView $this) {
        ScrollButtonBehaviour scrollButtonBehaviour = $this.scrollButtonBehaviour;
        if (scrollButtonBehaviour == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scrollButtonBehaviour");
        }
        return scrollButtonBehaviour;
    }

    public static final /* synthetic */ void access$setScrollButtonBehaviour$p(MessageListView $this, ScrollButtonBehaviour scrollButtonBehaviour) {
        $this.scrollButtonBehaviour = scrollButtonBehaviour;
    }

    public static final /* synthetic */ boolean access$getLockScrollUp$p(MessageListView $this) {
        return $this.lockScrollUp;
    }

    public static final /* synthetic */ void access$setLockScrollUp$p(MessageListView $this, boolean bl) {
        $this.lockScrollUp = bl;
    }

    public static final /* synthetic */ AttachmentViewHolderFactory access$getAttachmentViewHolderFactory$p(MessageListView $this) {
        AttachmentViewHolderFactory attachmentViewHolderFactory = $this.attachmentViewHolderFactory;
        if (attachmentViewHolderFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"attachmentViewHolderFactory");
        }
        return attachmentViewHolderFactory;
    }

    public static final /* synthetic */ void access$setAttachmentViewHolderFactory$p(MessageListView $this, AttachmentViewHolderFactory attachmentViewHolderFactory) {
        $this.attachmentViewHolderFactory = attachmentViewHolderFactory;
    }

    public static final /* synthetic */ MessageViewHolderFactory access$getMessageViewHolderFactory$p(MessageListView $this) {
        MessageViewHolderFactory messageViewHolderFactory = $this.messageViewHolderFactory;
        if (messageViewHolderFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageViewHolderFactory");
        }
        return messageViewHolderFactory;
    }

    public static final /* synthetic */ void access$setMessageViewHolderFactory$p(MessageListView $this, MessageViewHolderFactory messageViewHolderFactory) {
        $this.messageViewHolderFactory = messageViewHolderFactory;
    }

    public static final /* synthetic */ BubbleHelper access$getBubbleHelper$p(MessageListView $this) {
        BubbleHelper bubbleHelper = $this.bubbleHelper;
        if (bubbleHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bubbleHelper");
        }
        return bubbleHelper;
    }

    public static final /* synthetic */ void access$setBubbleHelper$p(MessageListView $this, BubbleHelper bubbleHelper) {
        $this.bubbleHelper = bubbleHelper;
    }

    public static final /* synthetic */ DateFormatter access$getMessageDateFormatter$p(MessageListView $this) {
        DateFormatter dateFormatter = $this.messageDateFormatter;
        if (dateFormatter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"messageDateFormatter");
        }
        return dateFormatter;
    }

    public static final /* synthetic */ void access$setMessageDateFormatter$p(MessageListView $this, DateFormatter dateFormatter) {
        $this.messageDateFormatter = dateFormatter;
    }

    public static final /* synthetic */ MessageListItemAdapter access$getAdapter$p(MessageListView $this) {
        MessageListItemAdapter messageListItemAdapter = $this.adapter;
        if (messageListItemAdapter == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"adapter");
        }
        return messageListItemAdapter;
    }

    public static final /* synthetic */ void access$setAdapter$p(MessageListView $this, MessageListItemAdapter messageListItemAdapter) {
        $this.adapter = messageListItemAdapter;
    }

    public static final /* synthetic */ void access$continueMessageAdd(MessageListView $this, boolean startThreadMode, MessageListItemWrapper listItem, List entities, int oldSize) {
        $this.continueMessageAdd(startThreadMode, listItem, entities, oldSize);
    }

    public static final /* synthetic */ Function1 access$getOnStartThreadHandler$p(MessageListView $this) {
        return $this.onStartThreadHandler;
    }

    public static final /* synthetic */ void access$setOnStartThreadHandler$p(MessageListView $this, Function1 function1) {
        $this.onStartThreadHandler = function1;
    }

    public static final /* synthetic */ Function1 access$getOnStartThreadListener$p(MessageListView $this) {
        return $this.onStartThreadListener;
    }

    public static final /* synthetic */ void access$setOnStartThreadListener$p(MessageListView $this, Function1 function1) {
        $this.onStartThreadListener = function1;
    }

    public static final /* synthetic */ Channel access$getChannel$p(MessageListView $this) {
        Channel channel = $this.channel;
        if (channel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"channel");
        }
        return channel;
    }

    public static final /* synthetic */ void access$setChannel$p(MessageListView $this, Channel channel) {
        $this.channel = channel;
    }

    public static final /* synthetic */ User access$getCurrentUser$p(MessageListView $this) {
        User user = $this.currentUser;
        if (user == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"currentUser");
        }
        return user;
    }

    public static final /* synthetic */ void access$setCurrentUser$p(MessageListView $this, User user) {
        $this.currentUser = user;
    }

    public static final /* synthetic */ MessageListViewStyle access$getStyle$p(MessageListView $this) {
        MessageListViewStyle messageListViewStyle = $this.style;
        if (messageListViewStyle == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"style");
        }
        return messageListViewStyle;
    }

    public static final /* synthetic */ void access$setStyle$p(MessageListView $this, MessageListViewStyle messageListViewStyle) {
        $this.style = messageListViewStyle;
    }

    public static final /* synthetic */ Function1 access$getOnMessageEditHandler$p(MessageListView $this) {
        return $this.onMessageEditHandler;
    }

    public static final /* synthetic */ void access$setOnMessageEditHandler$p(MessageListView $this, Function1 function1) {
        $this.onMessageEditHandler = function1;
    }

    public static final /* synthetic */ Function1 access$getOnMessageDeleteHandler$p(MessageListView $this) {
        return $this.onMessageDeleteHandler;
    }

    public static final /* synthetic */ void access$setOnMessageDeleteHandler$p(MessageListView $this, Function1 function1) {
        $this.onMessageDeleteHandler = function1;
    }

    public static final /* synthetic */ Function1 access$getOnMessageFlagHandler$p(MessageListView $this) {
        return $this.onMessageFlagHandler;
    }

    public static final /* synthetic */ void access$setOnMessageFlagHandler$p(MessageListView $this, Function1 function1) {
        $this.onMessageFlagHandler = function1;
    }

    public static final /* synthetic */ Function1 access$getOnMessageRetryHandler$p(MessageListView $this) {
        return $this.onMessageRetryHandler;
    }

    public static final /* synthetic */ void access$setOnMessageRetryHandler$p(MessageListView $this, Function1 function1) {
        $this.onMessageRetryHandler = function1;
    }

    public static final /* synthetic */ Function2 access$getOnSendGiphyHandler$p(MessageListView $this) {
        return $this.onSendGiphyHandler;
    }

    public static final /* synthetic */ void access$setOnSendGiphyHandler$p(MessageListView $this, Function2 function2) {
        $this.onSendGiphyHandler = function2;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$HeaderAvatarGroupClickListener;", "", "onHeaderAvatarGroupClick", "", "channel", "Lio/getstream/chat/android/client/models/Channel;", "stream-chat-android_release"})
    public static interface HeaderAvatarGroupClickListener {
        public void onHeaderAvatarGroupClick(@NotNull Channel var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$HeaderOptionsClickListener;", "", "onHeaderOptionsClick", "", "channel", "Lio/getstream/chat/android/client/models/Channel;", "stream-chat-android_release"})
    public static interface HeaderOptionsClickListener {
        public void onHeaderOptionsClick(@NotNull Channel var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$MessageClickListener;", "", "onMessageClick", "", "message", "Lio/getstream/chat/android/client/models/Message;", "stream-chat-android_release"})
    public static interface MessageClickListener {
        public void onMessageClick(@NotNull Message var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$MessageRetryListener;", "", "onRetryMessage", "", "message", "Lio/getstream/chat/android/client/models/Message;", "stream-chat-android_release"})
    public static interface MessageRetryListener {
        public void onRetryMessage(@NotNull Message var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListener;", "", "onMessageLongClick", "", "message", "Lio/getstream/chat/android/client/models/Message;", "stream-chat-android_release"})
    public static interface MessageLongClickListener {
        public void onMessageLongClick(@NotNull Message var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$MessageLongClickListenerView;", "", "onMessageLongClick2", "", "message", "Lio/getstream/chat/android/client/models/Message;", "view", "Landroid/view/View;", "stream-chat-android_release"})
    public static interface MessageLongClickListenerView {
        public void onMessageLongClick2(@NotNull Message var1, @NotNull View var2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$AttachmentClickListener;", "", "onAttachmentClick", "", "message", "Lio/getstream/chat/android/client/models/Message;", "attachment", "Lio/getstream/chat/android/client/models/Attachment;", "stream-chat-android_release"})
    public static interface AttachmentClickListener {
        public void onAttachmentClick(@NotNull Message var1, @NotNull Attachment var2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$GiphySendListener;", "", "onGiphySend", "", "message", "Lio/getstream/chat/android/client/models/Message;", "action", "Lcom/getstream/sdk/chat/enums/GiphyAction;", "stream-chat-android_release"})
    public static interface GiphySendListener {
        public void onGiphySend(@NotNull Message var1, @NotNull GiphyAction var2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$UserClickListener;", "", "onUserClick", "", "user", "Lio/getstream/chat/android/client/models/User;", "stream-chat-android_release"})
    public static interface UserClickListener {
        public void onUserClick(@NotNull User var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&\u00a8\u0006\u0007"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$ReadStateClickListener;", "", "onReadStateClick", "", "reads", "", "Lio/getstream/chat/android/client/models/ChannelUserRead;", "stream-chat-android_release"})
    public static interface ReadStateClickListener {
        public void onReadStateClick(@NotNull List<ChannelUserRead> var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$ReactionViewClickListener;", "", "onReactionViewClick", "", "message", "Lio/getstream/chat/android/client/models/Message;", "stream-chat-android_release"})
    public static interface ReactionViewClickListener {
        public void onReactionViewClick(@NotNull Message var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J.\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH&J&\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH&J&\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH&\u00a8\u0006\u000f"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$BubbleHelper;", "", "getDrawableForAttachment", "Landroid/graphics/drawable/Drawable;", "message", "Lio/getstream/chat/android/client/models/Message;", "mine", "", "positions", "", "Lcom/getstream/sdk/chat/adapter/MessageListItem$Position;", "attachment", "Lio/getstream/chat/android/client/models/Attachment;", "getDrawableForAttachmentDescription", "getDrawableForMessage", "stream-chat-android_release"})
    public static interface BubbleHelper {
        @NotNull
        public Drawable getDrawableForMessage(@NotNull Message var1, boolean var2, @NotNull List<? extends MessageListItem.Position> var3);

        @NotNull
        public Drawable getDrawableForAttachment(@NotNull Message var1, boolean var2, @NotNull List<? extends MessageListItem.Position> var3, @NotNull Attachment var4);

        @NotNull
        public Drawable getDrawableForAttachmentDescription(@NotNull Message var1, boolean var2, @NotNull List<? extends MessageListItem.Position> var3);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\u0001\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\tB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\n"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$NewMessagesBehaviour;", "", "value", "", "(Ljava/lang/String;II)V", "getValue$stream_chat_android_release", "()I", "SCROLL_TO_BOTTOM", "COUNT_UPDATE", "Companion", "stream-chat-android_release"})
    public static final class NewMessagesBehaviour
    extends Enum<NewMessagesBehaviour> {
        public static final /* enum */ NewMessagesBehaviour SCROLL_TO_BOTTOM;
        public static final /* enum */ NewMessagesBehaviour COUNT_UPDATE;
        private static final /* synthetic */ NewMessagesBehaviour[] $VALUES;
        private final int value;
        @NotNull
        public static final Companion Companion;

        static {
            NewMessagesBehaviour[] newMessagesBehaviourArray = new NewMessagesBehaviour[2];
            NewMessagesBehaviour[] newMessagesBehaviourArray2 = newMessagesBehaviourArray;
            newMessagesBehaviourArray[0] = SCROLL_TO_BOTTOM = new NewMessagesBehaviour(0);
            newMessagesBehaviourArray[1] = COUNT_UPDATE = new NewMessagesBehaviour(1);
            $VALUES = newMessagesBehaviourArray;
            Companion = new Companion(null);
        }

        public final int getValue$stream_chat_android_release() {
            return this.value;
        }

        private NewMessagesBehaviour(int value) {
            this.value = value;
        }

        public static NewMessagesBehaviour[] values() {
            return (NewMessagesBehaviour[])$VALUES.clone();
        }

        public static NewMessagesBehaviour valueOf(String string2) {
            return Enum.valueOf(NewMessagesBehaviour.class, string2);
        }

        @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$NewMessagesBehaviour$Companion;", "", "()V", "parseValue", "Lcom/getstream/sdk/chat/view/MessageListView$NewMessagesBehaviour;", "value", "", "stream-chat-android_release"})
        public static final class Companion {
            @NotNull
            public final NewMessagesBehaviour parseValue(int value) {
                NewMessagesBehaviour newMessagesBehaviour;
                block2: {
                    NewMessagesBehaviour[] newMessagesBehaviourArray = NewMessagesBehaviour.values();
                    boolean bl = false;
                    NewMessagesBehaviour[] newMessagesBehaviourArray2 = newMessagesBehaviourArray;
                    boolean bl2 = false;
                    NewMessagesBehaviour[] newMessagesBehaviourArray3 = newMessagesBehaviourArray2;
                    int n = newMessagesBehaviourArray3.length;
                    for (int i = 0; i < n; ++i) {
                        NewMessagesBehaviour newMessagesBehaviour2;
                        NewMessagesBehaviour behaviour = newMessagesBehaviour2 = newMessagesBehaviourArray3[i];
                        boolean bl3 = false;
                        if (!(behaviour.getValue$stream_chat_android_release() == value)) continue;
                        newMessagesBehaviour = newMessagesBehaviour2;
                        break block2;
                    }
                    newMessagesBehaviour = null;
                }
                if (newMessagesBehaviour == null) {
                    throw (Throwable)new IllegalArgumentException("Unknown behaviour type. It must be either SCROLL_TO_BOTTOM (int 0) or COUNT_UPDATE (int 1)");
                }
                return newMessagesBehaviour;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&J\b\u0010\u0007\u001a\u00020\u0003H&\u00a8\u0006\b"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$ScrollButtonBehaviour;", "", "onUnreadMessageCountChanged", "", "count", "", "userScrolledToTheBottom", "userScrolledUp", "stream-chat-android_release"})
    public static interface ScrollButtonBehaviour {
        public void userScrolledUp();

        public void userScrolledToTheBottom();

        public void onUnreadMessageCountChanged(int var1);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/getstream/sdk/chat/view/MessageListView$DefaultScrollButtonBehaviour;", "Lcom/getstream/sdk/chat/view/MessageListView$ScrollButtonBehaviour;", "unseenBottomBtn", "Landroid/view/ViewGroup;", "newMessagesTextTV", "Landroid/widget/TextView;", "newMessagesTextSingle", "", "newMessagesTextPlural", "isButtonEnabled", "", "(Landroid/view/ViewGroup;Landroid/widget/TextView;Ljava/lang/String;Ljava/lang/String;Z)V", "formatNewMessagesText", "unseenItems", "", "onUnreadMessageCountChanged", "", "count", "userScrolledToTheBottom", "userScrolledUp", "stream-chat-android_release"})
    public static final class DefaultScrollButtonBehaviour
    implements ScrollButtonBehaviour {
        private final ViewGroup unseenBottomBtn;
        private final TextView newMessagesTextTV;
        private final String newMessagesTextSingle;
        private final String newMessagesTextPlural;
        private boolean isButtonEnabled;

        @Override
        public void userScrolledUp() {
            if (!this.unseenBottomBtn.isShown()) {
                this.unseenBottomBtn.setVisibility(0);
            }
        }

        @Override
        public void userScrolledToTheBottom() {
            if (this.unseenBottomBtn.isShown()) {
                this.unseenBottomBtn.setVisibility(8);
            }
        }

        @Override
        public void onUnreadMessageCountChanged(int count) {
            if (count <= 0) {
                this.newMessagesTextTV.setVisibility(8);
            } else if (this.isButtonEnabled) {
                this.newMessagesTextTV.setVisibility(0);
                this.newMessagesTextTV.setText((CharSequence)this.formatNewMessagesText(count));
            }
        }

        private final String formatNewMessagesText(int unseenItems) {
            String string2;
            Function1<String, String> $fun$createText$1 = new Function1<String, String>(unseenItems){
                final /* synthetic */ int $unseenItems;

                @NotNull
                public final String invoke(@Nullable String formatString) {
                    String string2;
                    String string3 = formatString;
                    if (string3 == null) {
                        string2 = String.valueOf(this.$unseenItems);
                    } else {
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        Object[] objectArray = new Object[]{this.$unseenItems};
                        boolean bl = false;
                        String string4 = String.format(formatString, Arrays.copyOf(objectArray, objectArray.length));
                        string2 = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                    }
                    return string2;
                }
                {
                    this.$unseenItems = n;
                    super(1);
                }
            };
            switch (unseenItems) {
                case 1: {
                    string2 = $fun$createText$1.invoke(this.newMessagesTextSingle);
                    break;
                }
                default: {
                    string2 = $fun$createText$1.invoke(this.newMessagesTextPlural);
                }
            }
            return string2;
        }

        public DefaultScrollButtonBehaviour(@NotNull ViewGroup unseenBottomBtn, @NotNull TextView newMessagesTextTV, @Nullable String newMessagesTextSingle, @Nullable String newMessagesTextPlural, boolean isButtonEnabled) {
            Intrinsics.checkNotNullParameter((Object)unseenBottomBtn, (String)"unseenBottomBtn");
            Intrinsics.checkNotNullParameter((Object)newMessagesTextTV, (String)"newMessagesTextTV");
            this.unseenBottomBtn = unseenBottomBtn;
            this.newMessagesTextTV = newMessagesTextTV;
            this.newMessagesTextSingle = newMessagesTextSingle;
            this.newMessagesTextPlural = newMessagesTextPlural;
            this.isButtonEnabled = isButtonEnabled;
        }

        public /* synthetic */ DefaultScrollButtonBehaviour(ViewGroup viewGroup, TextView textView, String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                bl = true;
            }
            this(viewGroup, textView, string2, string3, bl);
        }
    }
}

