/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.databinding.StreamItemSelectPhotoBinding;
import com.getstream.sdk.chat.images.ViewExtensionsKt;
import com.getstream.sdk.chat.model.AttachmentMetaData;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B:\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012#\b\u0002\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0007\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0011\u001a\u00020\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0013H\u0016J\u0018\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0013H\u0016J\u000e\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0005J\u0014\u0010\u001d\u001a\u00020\u000b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R5\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006#"}, d2={"Lcom/getstream/sdk/chat/adapter/MediaAttachmentAdapter;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lcom/getstream/sdk/chat/adapter/MediaAttachmentAdapter$MyViewHolder;", "attachments", "", "Lcom/getstream/sdk/chat/model/AttachmentMetaData;", "listener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "attachmentMetaData", "", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "getListener", "()Lkotlin/jvm/functions/Function1;", "setListener", "(Lkotlin/jvm/functions/Function1;)V", "clear", "getItemCount", "", "onBindViewHolder", "holder", "position", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "selectAttachment", "attachment", "setAttachments", "toggleSelection", "isSelected", "", "unselectAttachment", "MyViewHolder", "stream-chat-android_release"})
public final class MediaAttachmentAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    private List<AttachmentMetaData> attachments;
    @NotNull
    private Function1<? super AttachmentMetaData, Unit> listener;

    @NotNull
    public MyViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        StreamItemSelectPhotoBinding streamItemSelectPhotoBinding = StreamItemSelectPhotoBinding.inflate(LayoutInflater.from((Context)parent.getContext()), parent, false);
        Intrinsics.checkNotNullExpressionValue((Object)streamItemSelectPhotoBinding, (String)"StreamItemSelectPhotoBin\u2026      false\n            )");
        return new MyViewHolder(streamItemSelectPhotoBinding, this.listener);
    }

    public void onBindViewHolder(@NotNull MyViewHolder holder, int position) {
        Intrinsics.checkNotNullParameter((Object)((Object)holder), (String)"holder");
        holder.bind(this.attachments.get(position));
    }

    public int getItemCount() {
        return this.attachments.size();
    }

    public final void setAttachments(@NotNull List<AttachmentMetaData> attachments2) {
        Intrinsics.checkNotNullParameter(attachments2, (String)"attachments");
        this.attachments = attachments2;
        this.notifyDataSetChanged();
    }

    public final void selectAttachment(@NotNull AttachmentMetaData attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        this.toggleSelection(attachment, true);
    }

    public final void unselectAttachment(@NotNull AttachmentMetaData attachment) {
        Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
        this.toggleSelection(attachment, false);
    }

    private final void toggleSelection(AttachmentMetaData attachment, boolean isSelected) {
        int index = this.attachments.indexOf(attachment);
        if (index != -1) {
            this.attachments.get(index).setSelected(isSelected);
            this.notifyItemChanged(index);
        }
    }

    public final void clear() {
        this.attachments = CollectionsKt.emptyList();
        this.notifyDataSetChanged();
    }

    @NotNull
    public final Function1<AttachmentMetaData, Unit> getListener() {
        return this.listener;
    }

    public final void setListener(@NotNull Function1<? super AttachmentMetaData, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.listener = function1;
    }

    public MediaAttachmentAdapter(@NotNull List<AttachmentMetaData> attachments2, @NotNull Function1<? super AttachmentMetaData, Unit> listener) {
        Intrinsics.checkNotNullParameter(attachments2, (String)"attachments");
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.attachments = attachments2;
        this.listener = listener;
    }

    public /* synthetic */ MediaAttachmentAdapter(List list, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 2) != 0) {
            function1 = 1.INSTANCE;
        }
        this(list, (Function1<? super AttachmentMetaData, Unit>)function1);
    }

    public MediaAttachmentAdapter() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B0\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012!\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0004\u001a\u001d\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0007\u0012\b\b\b\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/getstream/sdk/chat/adapter/MediaAttachmentAdapter$MyViewHolder;", "Landroidx/recyclerview/widget/RecyclerView$ViewHolder;", "binding", "Lcom/getstream/sdk/chat/databinding/StreamItemSelectPhotoBinding;", "listener", "Lkotlin/Function1;", "Lcom/getstream/sdk/chat/model/AttachmentMetaData;", "Lkotlin/ParameterName;", "name", "attachmentMetaData", "", "(Lcom/getstream/sdk/chat/databinding/StreamItemSelectPhotoBinding;Lkotlin/jvm/functions/Function1;)V", "bind", "attachment", "stream-chat-android_release"})
    public static final class MyViewHolder
    extends RecyclerView.ViewHolder {
        private final StreamItemSelectPhotoBinding binding;
        private final Function1<AttachmentMetaData, Unit> listener;

        public final void bind(@NotNull AttachmentMetaData attachment) {
            Intrinsics.checkNotNullParameter((Object)attachment, (String)"attachment");
            if (Intrinsics.areEqual((Object)attachment.getType(), (Object)"video")) {
                ImageView imageView = this.binding.ivMedia;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivMedia");
                ViewExtensionsKt.loadVideoThumbnail$default((ImageView)imageView, (Uri)attachment.getUri(), (Integer)R.drawable.stream_placeholder, null, null, null, (int)28, null);
            } else {
                ImageView imageView = this.binding.ivMedia;
                Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivMedia");
                ViewExtensionsKt.load$default((ImageView)imageView, (Object)attachment.getUri(), (Integer)R.drawable.stream_placeholder, null, null, null, (int)28, null);
            }
            ImageView imageView = this.binding.ivSelectMark;
            Intrinsics.checkNotNullExpressionValue((Object)imageView, (String)"binding.ivSelectMark");
            boolean value$iv = attachment.isSelected();
            View $this$isVisible$iv = (View)imageView;
            boolean $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
            ImageView imageView2 = this.binding.ivLargeFileMark;
            Intrinsics.checkNotNullExpressionValue((Object)imageView2, (String)"binding.ivLargeFileMark");
            value$iv = attachment.getSize() > 0x1400000L;
            $this$isVisible$iv = (View)imageView2;
            $i$f$setVisible = false;
            $this$isVisible$iv.setVisibility(value$iv ? 0 : 8);
            this.itemView.setOnClickListener(new View.OnClickListener(this, attachment){
                final /* synthetic */ MyViewHolder this$0;
                final /* synthetic */ AttachmentMetaData $attachment;

                public final void onClick(View it) {
                    MyViewHolder.access$getListener$p(this.this$0).invoke((Object)this.$attachment);
                }
                {
                    this.this$0 = myViewHolder;
                    this.$attachment = attachmentMetaData;
                }
            });
        }

        public MyViewHolder(@NotNull StreamItemSelectPhotoBinding binding, @NotNull Function1<? super AttachmentMetaData, Unit> listener) {
            Intrinsics.checkNotNullParameter((Object)binding, (String)"binding");
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            super((View)binding.getRoot());
            this.binding = binding;
            this.listener = listener;
        }

        public static final /* synthetic */ Function1 access$getListener$p(MyViewHolder $this) {
            return $this.listener;
        }
    }
}

