/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.view.messageinput;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.style.TextStyle;
import com.getstream.sdk.chat.view.messages.AvatarStyle;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010E\u001a\u0004\u0018\u00010\u00132\u0006\u0010F\u001a\u000201J\u0010\u0010G\u001a\u0004\u0018\u00010\u00132\u0006\u0010H\u001a\u000201J\u0006\u0010I\u001a\u00020/J \u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020\b2\u0006\u0010M\u001a\u00020\b2\u0006\u0010N\u001a\u00020\bH\u0002J2\u0010O\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010L\u001a\u00020\b2\b\b\u0001\u0010M\u001a\u00020\b2\b\b\u0001\u0010N\u001a\u00020\b2\b\b\u0001\u0010P\u001a\u00020\bH\u0002J\u0006\u0010Q\u001a\u000201J\u000e\u0010R\u001a\u00020S2\u0006\u0010Q\u001a\u000201R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0015\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010(\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\rR\u000e\u0010*\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010+\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\rR\u0010\u0010-\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00103R\u0010\u00106\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00107\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\rR\u001a\u00109\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010!\"\u0004\b;\u0010#R\u0011\u0010<\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00103R\u000e\u0010=\u001a\u00020/X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010@\u001a\n B*\u0004\u0018\u00010A0AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010C\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u00103\u00a8\u0006T"}, d2={"Lcom/getstream/sdk/chat/view/messageinput/MessageInputStyle;", "", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "attachmentButtonDefaultIconColor", "", "attachmentButtonDefaultIconDisabledColor", "attachmentButtonDefaultIconPressedColor", "attachmentButtonHeight", "getAttachmentButtonHeight", "()I", "attachmentButtonIcon", "attachmentButtonSelectedIconColor", "attachmentButtonWidth", "getAttachmentButtonWidth", "attachmentCloseButtonBackground", "Landroid/graphics/drawable/Drawable;", "getAttachmentCloseButtonBackground", "()Landroid/graphics/drawable/Drawable;", "avatarStyle", "Lcom/getstream/sdk/chat/view/messages/AvatarStyle;", "getAvatarStyle", "()Lcom/getstream/sdk/chat/view/messages/AvatarStyle;", "inputBackground", "getInputBackground", "setInputBackground", "(Landroid/graphics/drawable/Drawable;)V", "inputBackgroundText", "Lcom/getstream/sdk/chat/style/TextStyle;", "getInputBackgroundText", "()Lcom/getstream/sdk/chat/style/TextStyle;", "setInputBackgroundText", "(Lcom/getstream/sdk/chat/style/TextStyle;)V", "inputButtonDefaultIconColor", "inputButtonDefaultIconDisabledColor", "inputButtonDefaultIconPressedColor", "inputButtonEditIconColor", "inputButtonHeight", "getInputButtonHeight", "inputButtonIcon", "inputButtonWidth", "getInputButtonWidth", "inputEditBackground", "inputHint", "", "inputScrollbarEnabled", "", "getInputScrollbarEnabled", "()Z", "inputScrollbarFadingEnabled", "getInputScrollbarFadingEnabled", "inputSelectedBackground", "inputSendAlsoToChannelTextColor", "getInputSendAlsoToChannelTextColor", "inputText", "getInputText", "setInputText", "isShowAttachmentButton", "permissionSetKey", "prefs", "Landroid/content/SharedPreferences;", "res", "Landroid/content/res/Resources;", "kotlin.jvm.PlatformType", "sendAlsoToChannelCheckboxEnabled", "getSendAlsoToChannelCheckboxEnabled", "getAttachmentButtonIcon", "isSelected", "getInputButtonIcon", "isEdit", "getInputHint", "getMessageInputStyleColorList", "Landroid/content/res/ColorStateList;", "normalColor", "pressedColor", "disabledColor", "getSelector", "shape", "passedPermissionCheck", "setCheckPermissions", "", "stream-chat-android_release"})
public final class MessageInputStyle {
    @NotNull
    private TextStyle inputText;
    @NotNull
    private TextStyle inputBackgroundText;
    private final boolean isShowAttachmentButton;
    private final int inputButtonWidth;
    private final int inputButtonHeight;
    private final int attachmentButtonWidth;
    private final int attachmentButtonHeight;
    @Nullable
    private final Drawable attachmentCloseButtonBackground;
    private final int inputSendAlsoToChannelTextColor;
    private final boolean sendAlsoToChannelCheckboxEnabled;
    private final boolean inputScrollbarEnabled;
    private final boolean inputScrollbarFadingEnabled;
    private String inputHint;
    private final int attachmentButtonIcon;
    private final int attachmentButtonDefaultIconColor;
    private final int attachmentButtonDefaultIconPressedColor;
    private final int attachmentButtonDefaultIconDisabledColor;
    private final int attachmentButtonSelectedIconColor;
    private final int inputButtonIcon;
    private final int inputButtonDefaultIconColor;
    private final int inputButtonEditIconColor;
    private final int inputButtonDefaultIconPressedColor;
    private final int inputButtonDefaultIconDisabledColor;
    private final Resources res;
    @Nullable
    private Drawable inputBackground;
    private Drawable inputSelectedBackground;
    private Drawable inputEditBackground;
    @NotNull
    private final AvatarStyle avatarStyle;
    private final SharedPreferences prefs;
    private final String permissionSetKey;
    private final Context context;

    @NotNull
    public final TextStyle getInputText() {
        return this.inputText;
    }

    public final void setInputText(@NotNull TextStyle textStyle) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"<set-?>");
        this.inputText = textStyle;
    }

    @NotNull
    public final TextStyle getInputBackgroundText() {
        return this.inputBackgroundText;
    }

    public final void setInputBackgroundText(@NotNull TextStyle textStyle) {
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"<set-?>");
        this.inputBackgroundText = textStyle;
    }

    public final boolean isShowAttachmentButton() {
        return this.isShowAttachmentButton;
    }

    public final int getInputButtonWidth() {
        return this.inputButtonWidth;
    }

    public final int getInputButtonHeight() {
        return this.inputButtonHeight;
    }

    public final int getAttachmentButtonWidth() {
        return this.attachmentButtonWidth;
    }

    public final int getAttachmentButtonHeight() {
        return this.attachmentButtonHeight;
    }

    @Nullable
    public final Drawable getAttachmentCloseButtonBackground() {
        return this.attachmentCloseButtonBackground;
    }

    public final int getInputSendAlsoToChannelTextColor() {
        return this.inputSendAlsoToChannelTextColor;
    }

    public final boolean getSendAlsoToChannelCheckboxEnabled() {
        return this.sendAlsoToChannelCheckboxEnabled;
    }

    public final boolean getInputScrollbarEnabled() {
        return this.inputScrollbarEnabled;
    }

    public final boolean getInputScrollbarFadingEnabled() {
        return this.inputScrollbarFadingEnabled;
    }

    @Nullable
    public final Drawable getInputBackground() {
        return this.inputBackground;
    }

    public final void setInputBackground(@Nullable Drawable drawable2) {
        this.inputBackground = drawable2;
    }

    @NotNull
    public final AvatarStyle getAvatarStyle() {
        return this.avatarStyle;
    }

    private final Drawable getSelector(@ColorInt int normalColor, @ColorInt int pressedColor, @ColorInt int disabledColor, @DrawableRes int shape) {
        Drawable drawable2;
        Drawable drawable3 = ContextCompat.getDrawable((Context)this.context, (int)shape);
        if (drawable3 != null) {
            Drawable drawable4 = drawable3;
            boolean bl = false;
            boolean bl2 = false;
            Drawable drawable5 = drawable4;
            boolean bl3 = false;
            Drawable drawable6 = DrawableCompat.wrap((Drawable)drawable5).mutate();
            Intrinsics.checkNotNullExpressionValue((Object)drawable6, (String)"DrawableCompat.wrap(drawable).mutate()");
            Drawable drawableCompat = drawable6;
            DrawableCompat.setTintList((Drawable)drawableCompat, (ColorStateList)this.getMessageInputStyleColorList(normalColor, pressedColor, disabledColor));
            drawable2 = drawableCompat;
        } else {
            drawable2 = null;
        }
        return drawable2;
    }

    public final void setCheckPermissions(boolean passedPermissionCheck) {
        this.prefs.edit().putBoolean(this.permissionSetKey, passedPermissionCheck).apply();
    }

    public final boolean passedPermissionCheck() {
        return this.prefs.getBoolean(this.permissionSetKey, false);
    }

    private final ColorStateList getMessageInputStyleColorList(int normalColor, int pressedColor, int disabledColor) {
        return new ColorStateList((int[][])new int[][]{{16842910, -16842919}, {16842910, 16842919}, {-16842910}}, new int[]{normalColor, pressedColor, disabledColor});
    }

    @Nullable
    public final Drawable getAttachmentButtonIcon(boolean isSelected) {
        return this.attachmentButtonIcon == -1 ? this.getSelector(isSelected ? this.attachmentButtonSelectedIconColor : this.attachmentButtonDefaultIconColor, this.attachmentButtonDefaultIconPressedColor, this.attachmentButtonDefaultIconDisabledColor, R.drawable.stream_ic_add_attachment) : ContextCompat.getDrawable((Context)this.context, (int)this.attachmentButtonIcon);
    }

    @Nullable
    public final Drawable getInputButtonIcon(boolean isEdit) {
        return this.inputButtonIcon == -1 ? this.getSelector(isEdit ? this.inputButtonEditIconColor : this.inputButtonDefaultIconColor, this.inputButtonDefaultIconPressedColor, this.inputButtonDefaultIconDisabledColor, R.drawable.stream_ic_send) : ContextCompat.getDrawable((Context)this.context, (int)this.inputButtonIcon);
    }

    @NotNull
    public final String getInputHint() {
        String string2;
        if (TextUtils.isEmpty((CharSequence)this.inputHint)) {
            String string3 = this.context.getString(R.string.stream_input_hint);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.string.stream_input_hint)");
        } else {
            string2 = this.inputHint;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public MessageInputStyle(@NotNull Context context, @Nullable AttributeSet attrs) {
        void $this$apply;
        String it;
        boolean bl;
        boolean bl2;
        String string2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.inputHint = "";
        this.res = this.context.getResources();
        this.permissionSetKey = "permissionSetKey";
        TypedArray typedArray = this.context.obtainStyledAttributes(attrs, R.styleable.MessageInputView);
        boolean bl3 = false;
        boolean bl4 = false;
        TypedArray $this$run = typedArray;
        boolean bl5 = false;
        this.isShowAttachmentButton = $this$run.getBoolean(R.styleable.MessageInputView_streamShowAttachmentButton, true);
        this.attachmentButtonIcon = $this$run.getResourceId(R.styleable.MessageInputView_streamAttachmentButtonIcon, -1);
        this.attachmentButtonDefaultIconColor = $this$run.getColor(R.styleable.MessageInputView_streamAttachmentButtonDefaultIconColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_gray_dark));
        this.attachmentButtonDefaultIconPressedColor = $this$run.getColor(R.styleable.MessageInputView_streamAttachmentButtonDefaultIconPressedColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_white));
        this.attachmentButtonDefaultIconDisabledColor = $this$run.getColor(R.styleable.MessageInputView_streamAttachmentButtonDefaultIconDisabledColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_gray_light));
        this.attachmentButtonSelectedIconColor = $this$run.getColor(R.styleable.MessageInputView_streamAttachmentButtonSelectedIconColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_black));
        this.attachmentButtonWidth = $this$run.getDimensionPixelSize(R.styleable.MessageInputView_streamAttachmentButtonWidth, this.res.getDimensionPixelSize(R.dimen.stream_attachment_button_width));
        this.attachmentButtonHeight = $this$run.getDimensionPixelSize(R.styleable.MessageInputView_streamAttachmentButtonHeight, this.res.getDimensionPixelSize(R.dimen.stream_attachment_button_height));
        Drawable drawable2 = $this$run.getDrawable(R.styleable.MessageInputView_streamAttachmentCloseButtonBackground);
        if (drawable2 == null) {
            drawable2 = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.stream_button_close);
        }
        this.attachmentCloseButtonBackground = drawable2;
        this.inputButtonIcon = $this$run.getResourceId(R.styleable.MessageInputView_streamInputButtonIcon, -1);
        this.inputButtonDefaultIconColor = $this$run.getColor(R.styleable.MessageInputView_streamInputButtonDefaultIconColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_input_message_send_button));
        this.inputButtonEditIconColor = $this$run.getColor(R.styleable.MessageInputView_streamInputButtonEditIconColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_input_message_box_stroke_edit));
        this.inputButtonDefaultIconPressedColor = $this$run.getColor(R.styleable.MessageInputView_streamInputButtonDefaultIconPressedColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_white));
        this.inputButtonDefaultIconDisabledColor = $this$run.getColor(R.styleable.MessageInputView_streamInputButtonDefaultIconDisabledColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_gray_dark));
        this.inputButtonWidth = $this$run.getDimensionPixelSize(R.styleable.MessageInputView_streamInputButtonWidth, this.res.getDimensionPixelSize(R.dimen.stream_input_button_width));
        this.inputButtonHeight = $this$run.getDimensionPixelSize(R.styleable.MessageInputView_streamInputButtonHeight, this.res.getDimensionPixelSize(R.dimen.stream_input_button_height));
        String string3 = $this$run.getString(R.styleable.MessageInputView_streamInputHint);
        if (string3 != null) {
            string2 = string3;
            bl2 = false;
            bl = false;
            it = string2;
            boolean bl6 = false;
            String string4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it");
            this.inputHint = string4;
        }
        TypedArray typedArray2 = $this$run;
        Intrinsics.checkNotNullExpressionValue((Object)typedArray2, (String)"this");
        string2 = new TextStyle.Builder(typedArray2);
        bl2 = false;
        bl = false;
        it = string2;
        MessageInputStyle messageInputStyle = this;
        boolean bl7 = false;
        $this$apply.size(R.styleable.MessageInputView_streamInputTextSize, this.res.getDimensionPixelSize(R.dimen.stream_input_text_size));
        $this$apply.color(R.styleable.MessageInputView_streamInputTextColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_black));
        $this$apply.hintColor(R.styleable.MessageInputView_streamInputHintColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_gray_dark));
        $this$apply.font(R.styleable.MessageInputView_streamInputTextFontAssets, R.styleable.MessageInputView_streamInputTextFont);
        $this$apply.style(R.styleable.MessageInputView_streamInputTextStyle, 0);
        Unit unit = Unit.INSTANCE;
        messageInputStyle.inputText = string2.build();
        this.inputScrollbarEnabled = $this$run.getBoolean(R.styleable.MessageInputView_streamInputScrollbarEnabled, false);
        this.inputScrollbarFadingEnabled = $this$run.getBoolean(R.styleable.MessageInputView_streamInputScrollbarFadingEnabled, false);
        Drawable drawable3 = this.context.getDrawable($this$run.getResourceId(R.styleable.MessageInputView_streamInputBackground, R.drawable.stream_round_message_composer));
        if (drawable3 != null) {
            string2 = drawable3;
            bl2 = false;
            bl = false;
            it = string2;
            boolean bl8 = false;
            this.inputBackground = it;
        }
        Drawable drawable4 = this.context.getDrawable($this$run.getResourceId(R.styleable.MessageInputView_streamInputSelectedBackground, R.drawable.stream_round_message_composer_select));
        if (drawable4 != null) {
            string2 = drawable4;
            bl2 = false;
            bl = false;
            it = string2;
            boolean bl9 = false;
            this.inputSelectedBackground = it;
        }
        Drawable drawable5 = this.context.getDrawable($this$run.getResourceId(R.styleable.MessageInputView_streamInputEditBackground, R.drawable.stream_round_message_composer_edit));
        if (drawable5 != null) {
            string2 = drawable5;
            bl2 = false;
            bl = false;
            it = string2;
            boolean bl10 = false;
            this.inputEditBackground = it;
        }
        string2 = new TextStyle.Builder($this$run);
        bl2 = false;
        bl = false;
        it = string2;
        messageInputStyle = this;
        boolean bl11 = false;
        $this$apply.size(R.styleable.MessageInputView_streamInputBackgroundTextSize, this.res.getDimensionPixelSize(R.dimen.stream_input_text_size));
        $this$apply.color(R.styleable.MessageInputView_streamInputBackgroundTextColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_black));
        $this$apply.font(R.styleable.MessageInputView_streamInputBackgroundTextFontAssets, R.styleable.MessageInputView_streamInputBackgroundTextFont);
        $this$apply.style(R.styleable.MessageInputView_streamInputBackgroundTextStyle, 0);
        unit = Unit.INSTANCE;
        messageInputStyle.inputBackgroundText = string2.build();
        this.avatarStyle = AvatarStyle.Builder.avatarInitialText$default(new AvatarStyle.Builder($this$run, this.context).avatarWidth(R.styleable.MessageInputView_streamAvatarWidth, R.dimen.stream_message_avatar_width).avatarHeight(R.styleable.MessageInputView_streamAvatarHeight, R.dimen.stream_message_avatar_height).avatarBorderColor(R.styleable.MessageInputView_streamAvatarBorderColor, -1).avatarBackgroundColor(R.styleable.MessageInputView_streamAvatarBackGroundColor, ContextCompat.getColor((Context)this.context, (int)R.color.stream_gray_dark)), R.styleable.MessageInputView_streamAvatarTextSize, R.dimen.stream_channel_initials, R.styleable.MessageInputView_streamAvatarTextColor, -1, R.styleable.MessageInputView_streamAvatarTextFontAssets, R.styleable.MessageInputView_streamAvatarTextFont, R.styleable.MessageInputView_streamAvatarTextStyle, 0, 128, null).build();
        this.inputSendAlsoToChannelTextColor = $this$run.getColor(R.styleable.MessageInputView_streamSendAlsoToChannel, ContextCompat.getColor((Context)this.context, (int)R.color.stream_input_message_send_to_channel_checkbox));
        SharedPreferences sharedPreferences = this.context.getSharedPreferences("MessageInputStyle", 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026ODE_PRIVATE\n            )");
        this.prefs = sharedPreferences;
        this.sendAlsoToChannelCheckboxEnabled = $this$run.getBoolean(R.styleable.MessageInputView_streamShowSendAlsoToChannelCheckbox, true);
        $this$run.recycle();
    }
}

