/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.adapter;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.getstream.sdk.chat.ChatUI;
import com.getstream.sdk.chat.R;
import com.getstream.sdk.chat.adapter.BaseChannelListItemViewHolder;
import com.getstream.sdk.chat.adapter.ChannelItemPayloadDiff;
import com.getstream.sdk.chat.utils.DateFormatter;
import com.getstream.sdk.chat.utils.DateFormatterKt;
import com.getstream.sdk.chat.utils.StringUtility;
import com.getstream.sdk.chat.utils.extensions.ChannelUtils;
import com.getstream.sdk.chat.utils.extensions.MemberUtils;
import com.getstream.sdk.chat.view.AvatarView;
import com.getstream.sdk.chat.view.ReadStateView;
import com.getstream.sdk.chat.view.channels.ChannelListView;
import com.getstream.sdk.chat.view.channels.ChannelListViewStyle;
import io.getstream.chat.android.client.models.Attachment;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Message;
import io.getstream.chat.android.client.models.User;
import io.getstream.chat.android.livedata.ChatDomain;
import java.util.Date;
import java.util.List;

public class ChannelListItemViewHolder
extends BaseChannelListItemViewHolder {
    protected TextView tv_name;
    protected TextView tv_last_message;
    protected TextView tv_date;
    protected ReadStateView read_state;
    protected AvatarView avatarView;
    protected ImageView iv_attachment_type;
    protected View click_area;
    protected ChannelListView.UserClickListener userClickListener;
    protected ChannelListView.ChannelClickListener channelClickListener;
    protected ChannelListView.ChannelClickListener channelLongClickListener;
    protected ChannelListViewStyle style;
    protected DateFormatter defaultDateFormatter;

    public ChannelListItemViewHolder(@NonNull View itemView) {
        super(itemView);
        this.defaultDateFormatter = DateFormatter.from((Context)this.itemView.getContext());
        this.findReferences();
    }

    @Override
    public void setUserClickListener(ChannelListView.UserClickListener l) {
        this.userClickListener = l;
    }

    @Override
    public void setChannelClickListener(ChannelListView.ChannelClickListener l) {
        this.channelClickListener = l;
    }

    @Override
    public void setChannelLongClickListener(ChannelListView.ChannelClickListener l) {
        this.channelLongClickListener = l;
    }

    protected void findReferences() {
        this.tv_name = (TextView)this.itemView.findViewById(R.id.tv_name);
        this.tv_last_message = (TextView)this.itemView.findViewById(R.id.tv_last_message);
        this.iv_attachment_type = (ImageView)this.itemView.findViewById(R.id.iv_attachment_type);
        this.tv_date = (TextView)this.itemView.findViewById(R.id.tv_date);
        this.click_area = this.itemView.findViewById(R.id.click_area);
        this.avatarView = (AvatarView)this.itemView.findViewById(R.id.avatar_group);
        this.read_state = (ReadStateView)this.itemView.findViewById(R.id.read_state);
    }

    @Override
    public void setStyle(ChannelListViewStyle style) {
        this.style = style;
    }

    @Override
    public void bind(@NonNull Channel channel, int position, @NonNull ChannelItemPayloadDiff diff) {
        if (diff.getName()) {
            this.configChannelName(channel);
        }
        if (diff.getAvatarView()) {
            this.configAvatarView(channel);
        }
        if (diff.getLastMessage()) {
            this.configLastMessage(channel);
        }
        if (diff.getLastMessageDate()) {
            this.configLastMessageDate(channel);
        }
        if (diff.getReadState()) {
            this.configReadState(channel);
        }
        this.configClickListeners(channel);
        this.applyStyle(channel);
    }

    protected void configChannelName(Channel channel) {
        String channelName = ChannelUtils.getChannelNameOrMembers(channel);
        this.tv_name.setText((CharSequence)(!TextUtils.isEmpty((CharSequence)channelName) ? channelName : this.style.getChannelWithoutNameText()));
    }

    protected void configAvatarView(Channel channel) {
        List<User> otherUsers = MemberUtils.getOtherUsers(channel.getMembers());
        this.avatarView.setChannelAndLastActiveUsers(channel, otherUsers, this.style.getAvatarStyle());
        this.avatarView.setOnClickListener(view -> {
            if (otherUsers.size() == 1 && this.userClickListener != null) {
                this.userClickListener.onUserClick((User)otherUsers.get(0));
            } else if (this.channelClickListener != null) {
                this.channelClickListener.onClick(channel);
            }
        });
    }

    @SuppressLint(value={"ResourceType"})
    protected void configLastMessage(Channel channel) {
        Message lastMessage = ChannelUtils.computeLastMessage(channel);
        this.iv_attachment_type.setVisibility(8);
        if (lastMessage == null) {
            this.tv_last_message.setText((CharSequence)"");
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)lastMessage.getText())) {
            String text = StringUtility.getDeletedOrMentionedText(lastMessage);
            ChatUI.instance().getMarkdown().setText(this.tv_last_message, text);
            return;
        }
        if (lastMessage.getAttachments().isEmpty()) {
            this.tv_last_message.setText((CharSequence)"");
            return;
        }
        Attachment attachment = (Attachment)lastMessage.getAttachments().get(0);
        if (attachment.getType() != null) {
            int attachmentType;
            String lastMessageText;
            Context context = this.iv_attachment_type.getContext();
            this.iv_attachment_type.setVisibility(0);
            switch (attachment.getType()) {
                case "image": {
                    lastMessageText = context.getResources().getString(R.string.stream_last_message_attachment_photo);
                    attachmentType = R.drawable.stream_ic_image;
                    break;
                }
                case "file": {
                    if (attachment.getMimeType() != null && attachment.getMimeType().contains("video")) {
                        lastMessageText = context.getResources().getString(R.string.stream_last_message_attachment_video);
                        attachmentType = R.drawable.stream_ic_video;
                        break;
                    }
                    lastMessageText = !TextUtils.isEmpty((CharSequence)attachment.getTitle()) ? attachment.getTitle() : attachment.getFallback();
                    attachmentType = R.drawable.stream_ic_file;
                    break;
                }
                case "giphy": {
                    lastMessageText = context.getResources().getString(R.string.stream_last_message_attachment_giphy);
                    attachmentType = R.drawable.stream_ic_gif;
                    break;
                }
                default: {
                    lastMessageText = !TextUtils.isEmpty((CharSequence)attachment.getTitle()) ? attachment.getTitle() : attachment.getFallback();
                    attachmentType = R.drawable.stream_ic_file;
                }
            }
            this.tv_last_message.setText((CharSequence)lastMessageText);
            this.iv_attachment_type.setImageDrawable(ContextCompat.getDrawable((Context)context, (int)attachmentType));
        }
    }

    protected void configLastMessageDate(Channel channel) {
        String date = DateFormatterKt.formatDate((DateFormatter)this.defaultDateFormatter, (Date)channel.getLastMessageAt());
        this.tv_date.setText((CharSequence)date);
    }

    protected void configReadState(Channel channel) {
        List lastMessageReads = channel.getRead();
        this.read_state.setReads(lastMessageReads, true, this.style.getReadStateStyle(), this.style.getAvatarStyle());
    }

    protected void configClickListeners(Channel channel) {
        this.click_area.setOnClickListener(view -> {
            if (this.channelClickListener != null) {
                this.channelClickListener.onClick(channel);
            }
        });
        this.click_area.setOnLongClickListener(view -> {
            if (this.channelLongClickListener != null) {
                this.channelLongClickListener.onClick(channel);
            }
            return true;
        });
    }

    protected void applyStyle(Channel channel) {
        this.tv_name.setTextSize(0, (float)this.style.getChannelTitleText().getSize());
        this.tv_last_message.setTextSize(0, (float)this.style.getLastMessage().getSize());
        this.tv_date.setTextSize(0, (float)this.style.getChannelTitleText().getSize());
        User currentUser = ChatDomain.instance().getCurrentUser();
        String currentUserId = currentUser.getId();
        Message lastMessage = ChannelUtils.computeLastMessage(channel);
        boolean outgoing = lastMessage != null && lastMessage.getUser().getId().equals(currentUserId);
        boolean readLastMessage = ChannelUtils.readLastMessage(channel);
        if (readLastMessage || outgoing) {
            this.applyReadStyle();
        } else {
            this.applyUnreadStyle();
        }
    }

    protected void applyReadStyle() {
        this.style.getChannelTitleText().apply(this.tv_name);
        this.style.getLastMessage().apply(this.tv_last_message);
        this.style.getLastMessageDateText().apply(this.tv_date);
        if (this.iv_attachment_type.getDrawable() != null) {
            DrawableCompat.setTint((Drawable)this.iv_attachment_type.getDrawable(), (int)this.style.getLastMessage().getColor());
        }
    }

    protected void applyUnreadStyle() {
        this.style.getChannelTitleUnreadText().apply(this.tv_name);
        this.style.getLastMessageUnread().apply(this.tv_last_message);
        this.style.getLastMessageDateUnreadText().apply(this.tv_date);
        if (this.iv_attachment_type.getDrawable() != null) {
            DrawableCompat.setTint((Drawable)this.iv_attachment_type.getDrawable(), (int)this.style.getLastMessageUnread().getColor());
        }
    }
}

