/*
 * Decompiled with CFR 0.152.
 */
package com.getstream.sdk.chat.viewmodel.channels;

import androidx.arch.core.util.Function;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import io.getstream.chat.android.client.ChatClient;
import io.getstream.chat.android.client.api.models.QuerySort;
import io.getstream.chat.android.client.call.Call;
import io.getstream.chat.android.client.models.Channel;
import io.getstream.chat.android.client.models.Filters;
import io.getstream.chat.android.client.models.TypingEvent;
import io.getstream.chat.android.client.utils.FilterObject;
import io.getstream.chat.android.client.utils.Result;
import io.getstream.chat.android.livedata.ChatDomain;
import io.getstream.chat.android.livedata.controller.QueryChannelsController;
import io.getstream.chat.android.livedata.usecase.QueryChannels;
import io.getstream.chat.android.livedata.usecase.QueryChannelsLoadMore;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 (2\u00020\u0001:\u0004()*+B3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bJ\u000e\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bJ\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u001bH\u0002J!\u0010$\u001a\u00020\u001b2\u0017\u0010%\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0&\u00a2\u0006\u0002\b'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0010\u00a8\u0006,"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel;", "Landroidx/lifecycle/ViewModel;", "chatDomain", "Lio/getstream/chat/android/livedata/ChatDomain;", "filter", "Lio/getstream/chat/android/client/utils/FilterObject;", "sort", "Lio/getstream/chat/android/client/api/models/QuerySort;", "Lio/getstream/chat/android/client/models/Channel;", "limit", "", "(Lio/getstream/chat/android/livedata/ChatDomain;Lio/getstream/chat/android/client/utils/FilterObject;Lio/getstream/chat/android/client/api/models/QuerySort;I)V", "paginationState", "Landroidx/lifecycle/LiveData;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$PaginationState;", "getPaginationState", "()Landroidx/lifecycle/LiveData;", "paginationStateMerger", "Landroidx/lifecycle/MediatorLiveData;", "state", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "getState", "stateMerger", "typingEvents", "Lio/getstream/chat/android/client/models/TypingEvent;", "getTypingEvents", "deleteChannel", "", "channel", "hideChannel", "leaveChannel", "markAllRead", "onEvent", "event", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event;", "requestMoreChannels", "setPaginationState", "reducer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "Companion", "Event", "PaginationState", "State", "stream-chat-android_release"})
public final class ChannelsViewModel
extends ViewModel {
    private final MediatorLiveData<State> stateMerger;
    @NotNull
    private final LiveData<State> state;
    private final MediatorLiveData<PaginationState> paginationStateMerger;
    @NotNull
    private final LiveData<PaginationState> paginationState;
    private final ChatDomain chatDomain;
    private final FilterObject filter;
    private final QuerySort<Channel> sort;
    private final int limit;
    @JvmField
    @NotNull
    public static final QuerySort<Channel> DEFAULT_SORT;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final LiveData<State> getState() {
        return this.state;
    }

    @NotNull
    public final LiveData<TypingEvent> getTypingEvents() {
        return this.chatDomain.getTypingUpdates();
    }

    @NotNull
    public final LiveData<PaginationState> getPaginationState() {
        return this.paginationState;
    }

    public final void onEvent(@NotNull Event event) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Event event2 = event;
        if (event2 instanceof Event.ReachedEndOfList) {
            this.requestMoreChannels();
            unit = Unit.INSTANCE;
        } else if (event2 instanceof Event.LogoutClicked) {
            ChatClient.Companion.instance().disconnect();
            this.stateMerger.postValue((Object)State.NavigateToLoginScreen.INSTANCE);
            unit = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Unit $this$exhaustive$iv = unit;
        boolean $i$f$getExhaustive = false;
    }

    public final void leaveChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.chatDomain.getUseCases().getLeaveChannel().invoke(channel.getCid()).enqueue();
    }

    public final void deleteChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.chatDomain.getUseCases().getDeleteChannel().invoke(channel.getCid()).enqueue();
    }

    public final void hideChannel(@NotNull Channel channel) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.chatDomain.getUseCases().getHideChannel().invoke(channel.getCid(), true).enqueue();
    }

    public final void markAllRead() {
        this.chatDomain.getUseCases().getMarkAllRead().invoke().enqueue();
    }

    private final void requestMoreChannels() {
        QueryChannelsLoadMore.DefaultImpls.invoke$default((QueryChannelsLoadMore)this.chatDomain.getUseCases().getQueryChannelsLoadMore(), (FilterObject)this.filter, this.sort, (int)0, (int)0, (int)12, null).enqueue();
    }

    private final void setPaginationState(Function1<? super PaginationState, PaginationState> reducer) {
        PaginationState paginationState = (PaginationState)this.paginationStateMerger.getValue();
        if (paginationState == null) {
            paginationState = new PaginationState(false, false, 3, null);
        }
        Intrinsics.checkNotNullExpressionValue((Object)paginationState, (String)"paginationStateMerger.value ?: PaginationState()");
        this.paginationStateMerger.setValue(reducer.invoke((Object)paginationState));
    }

    public ChannelsViewModel(@NotNull ChatDomain chatDomain, @NotNull FilterObject filter, @NotNull QuerySort<Channel> sort, int limit) {
        Intrinsics.checkNotNullParameter((Object)chatDomain, (String)"chatDomain");
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Intrinsics.checkNotNullParameter(sort, (String)"sort");
        this.chatDomain = chatDomain;
        this.filter = filter;
        this.sort = sort;
        this.limit = limit;
        this.stateMerger = new MediatorLiveData();
        this.state = (LiveData)this.stateMerger;
        this.paginationStateMerger = new MediatorLiveData();
        LiveData liveData = Transformations.distinctUntilChanged((LiveData)((LiveData)this.paginationStateMerger));
        Intrinsics.checkNotNullExpressionValue((Object)liveData, (String)"Transformations.distinct\u2026ed(paginationStateMerger)");
        this.paginationState = liveData;
        this.stateMerger.setValue((Object)State.Loading.INSTANCE);
        QueryChannels.DefaultImpls.invoke$default((QueryChannels)this.chatDomain.getUseCases().getQueryChannels(), (FilterObject)this.filter, this.sort, (int)this.limit, (int)0, (int)8, null).enqueue((Call.Callback)new Call.Callback<QueryChannelsController>(){

            public final void onResult(@NotNull Result<QueryChannelsController> queryChannelsControllerResult) {
                Intrinsics.checkNotNullParameter(queryChannelsControllerResult, (String)"queryChannelsControllerResult");
                if (queryChannelsControllerResult.isSuccess()) {
                    QueryChannelsController queryChannelsController = (QueryChannelsController)queryChannelsControllerResult.data();
                    stateMerger.addSource(Transformations.map((LiveData)queryChannelsController.getChannelsState(), (Function)1.INSTANCE), (Observer)new Observer<State>(){

                        public final void onChanged(State state) {
                            stateMerger.setValue((Object)state);
                        }
                    });
                    paginationStateMerger.addSource(queryChannelsController.getLoadingMore(), (Observer)new Observer<Boolean>(){

                        public final void onChanged(final Boolean loadingMore) {
                            this.setPaginationState((Function1<? super PaginationState, PaginationState>)((Function1)new Function1<PaginationState, PaginationState>(){

                                @NotNull
                                public final PaginationState invoke(@NotNull PaginationState $this$setPaginationState) {
                                    Intrinsics.checkNotNullParameter((Object)$this$setPaginationState, (String)"$receiver");
                                    Boolean bl = loadingMore;
                                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"loadingMore");
                                    return PaginationState.copy$default($this$setPaginationState, bl, false, 2, null);
                                }
                            }));
                        }
                    });
                    paginationStateMerger.addSource(queryChannelsController.getEndOfChannels(), (Observer)new Observer<Boolean>(){

                        public final void onChanged(final Boolean endOfChannels) {
                            this.setPaginationState((Function1<? super PaginationState, PaginationState>)((Function1)new Function1<PaginationState, PaginationState>(){

                                @NotNull
                                public final PaginationState invoke(@NotNull PaginationState $this$setPaginationState) {
                                    Intrinsics.checkNotNullParameter((Object)$this$setPaginationState, (String)"$receiver");
                                    Boolean bl = endOfChannels;
                                    Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"endOfChannels");
                                    return PaginationState.copy$default($this$setPaginationState, false, bl, 1, null);
                                }
                            }));
                        }
                    });
                } else {
                    stateMerger.postValue((Object)State.NoChannelsAvailable.INSTANCE);
                }
            }
        });
    }

    public /* synthetic */ ChannelsViewModel(ChatDomain chatDomain, FilterObject filterObject, QuerySort querySort, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            chatDomain = ChatDomain.Companion.instance();
        }
        if ((n2 & 2) != 0) {
            filterObject = Filters.and((FilterObject[])new FilterObject[]{Filters.eq((String)"type", (Object)"messaging"), Filters.in((String)"members", (List)CollectionsKt.listOf((Object)chatDomain.getCurrentUser().getId())), Filters.ne((String)"draft", (Object)true)});
        }
        if ((n2 & 4) != 0) {
            querySort = DEFAULT_SORT;
        }
        if ((n2 & 8) != 0) {
            n = 30;
        }
        this(chatDomain, filterObject, querySort, n);
    }

    public ChannelsViewModel() {
        this(null, null, null, 0, 15, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$descByName$iv$iv;
        void this_$iv;
        Companion = new Companion(null);
        QuerySort.Companion companion = QuerySort.Companion;
        String fieldName$iv = "last_updated";
        boolean $i$f$desc = false;
        QuerySort querySort = new QuerySort();
        void this_$iv$iv = this_$iv;
        boolean $i$f$descByName = false;
        DEFAULT_SORT = $this$descByName$iv$iv.desc(fieldName$iv, Reflection.getOrCreateKotlinClass(Channel.class));
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0004\u0007\b\t\n\u00a8\u0006\u000b"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "", "()V", "Loading", "NavigateToLoginScreen", "NoChannelsAvailable", "Result", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$Loading;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$Result;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$NoChannelsAvailable;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$NavigateToLoginScreen;", "stream-chat-android_release"})
    public static abstract class State {
        private State() {
        }

        public /* synthetic */ State(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$Loading;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "()V", "stream-chat-android_release"})
        public static final class Loading
        extends State {
            @NotNull
            public static final Loading INSTANCE;

            private Loading() {
                super(null);
            }

            static {
                Loading loading;
                INSTANCE = loading = new Loading();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$Result;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "channels", "", "Lio/getstream/chat/android/client/models/Channel;", "(Ljava/util/List;)V", "getChannels", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "stream-chat-android_release"})
        public static final class Result
        extends State {
            @NotNull
            private final List<Channel> channels;

            @NotNull
            public final List<Channel> getChannels() {
                return this.channels;
            }

            public Result(@NotNull List<Channel> channels) {
                Intrinsics.checkNotNullParameter(channels, (String)"channels");
                super(null);
                this.channels = channels;
            }

            @NotNull
            public final List<Channel> component1() {
                return this.channels;
            }

            @NotNull
            public final Result copy(@NotNull List<Channel> channels) {
                Intrinsics.checkNotNullParameter(channels, (String)"channels");
                return new Result(channels);
            }

            public static /* synthetic */ Result copy$default(Result result, List list, int n, Object object) {
                if ((n & 1) != 0) {
                    list = result.channels;
                }
                return result.copy(list);
            }

            @NotNull
            public String toString() {
                return "Result(channels=" + this.channels + ")";
            }

            public int hashCode() {
                List<Channel> list = this.channels;
                return list != null ? ((Object)list).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Result)) break block3;
                        Result result = (Result)object;
                        if (!Intrinsics.areEqual(this.channels, result.channels)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$NoChannelsAvailable;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "()V", "stream-chat-android_release"})
        public static final class NoChannelsAvailable
        extends State {
            @NotNull
            public static final NoChannelsAvailable INSTANCE;

            private NoChannelsAvailable() {
                super(null);
            }

            static {
                NoChannelsAvailable noChannelsAvailable;
                INSTANCE = noChannelsAvailable = new NoChannelsAvailable();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State$NavigateToLoginScreen;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$State;", "()V", "stream-chat-android_release"})
        public static final class NavigateToLoginScreen
        extends State {
            @NotNull
            public static final NavigateToLoginScreen INSTANCE;

            private NavigateToLoginScreen() {
                super(null);
            }

            static {
                NavigateToLoginScreen navigateToLoginScreen;
                INSTANCE = navigateToLoginScreen = new NavigateToLoginScreen();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$PaginationState;", "", "loadingMore", "", "endOfChannels", "(ZZ)V", "getEndOfChannels", "()Z", "getLoadingMore", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "stream-chat-android_release"})
    public static final class PaginationState {
        private final boolean loadingMore;
        private final boolean endOfChannels;

        public final boolean getLoadingMore() {
            return this.loadingMore;
        }

        public final boolean getEndOfChannels() {
            return this.endOfChannels;
        }

        public PaginationState(boolean loadingMore, boolean endOfChannels) {
            this.loadingMore = loadingMore;
            this.endOfChannels = endOfChannels;
        }

        public /* synthetic */ PaginationState(boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            this(bl, bl2);
        }

        public PaginationState() {
            this(false, false, 3, null);
        }

        public final boolean component1() {
            return this.loadingMore;
        }

        public final boolean component2() {
            return this.endOfChannels;
        }

        @NotNull
        public final PaginationState copy(boolean loadingMore, boolean endOfChannels) {
            return new PaginationState(loadingMore, endOfChannels);
        }

        public static /* synthetic */ PaginationState copy$default(PaginationState paginationState, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = paginationState.loadingMore;
            }
            if ((n & 2) != 0) {
                bl2 = paginationState.endOfChannels;
            }
            return paginationState.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "PaginationState(loadingMore=" + this.loadingMore + ", endOfChannels=" + this.endOfChannels + ")";
        }

        public int hashCode() {
            int n = this.loadingMore ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int n2 = n * 31;
            int n3 = this.endOfChannels ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            return n2 + n3;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof PaginationState)) break block3;
                    PaginationState paginationState = (PaginationState)object;
                    if (this.loadingMore != paginationState.loadingMore || this.endOfChannels != paginationState.endOfChannels) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event;", "", "()V", "LogoutClicked", "ReachedEndOfList", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event$ReachedEndOfList;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event$LogoutClicked;", "stream-chat-android_release"})
    public static abstract class Event {
        private Event() {
        }

        public /* synthetic */ Event(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event$ReachedEndOfList;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event;", "()V", "stream-chat-android_release"})
        public static final class ReachedEndOfList
        extends Event {
            @NotNull
            public static final ReachedEndOfList INSTANCE;

            private ReachedEndOfList() {
                super(null);
            }

            static {
                ReachedEndOfList reachedEndOfList;
                INSTANCE = reachedEndOfList = new ReachedEndOfList();
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event$LogoutClicked;", "Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Event;", "()V", "stream-chat-android_release"})
        public static final class LogoutClicked
        extends Event {
            @NotNull
            public static final LogoutClicked INSTANCE;

            private LogoutClicked() {
                super(null);
            }

            static {
                LogoutClicked logoutClicked;
                INSTANCE = logoutClicked = new LogoutClicked();
            }
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/getstream/sdk/chat/viewmodel/channels/ChannelsViewModel$Companion;", "", "()V", "DEFAULT_SORT", "Lio/getstream/chat/android/client/api/models/QuerySort;", "Lio/getstream/chat/android/client/models/Channel;", "stream-chat-android_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

